/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.integration.tx.api.fence.store.db.sql;

public class CommonFenceStoreSqls {
    public static final String LOCAL_TCC_LOG_PLACEHOLD = " #local_tcc_log# ";
    public static final String PRAMETER_PLACEHOLD = " #PRAMETER_PLACEHOLD# ";
    protected static final String INSERT_LOCAL_TCC_LOG = "insert into  #local_tcc_log#  (xid, branch_id, action_name, status, gmt_create, gmt_modified)  values (?, ?, ?, ?, ?, ?) ";
    protected static final String QUERY_BY_BRANCH_ID_AND_XID = "select xid, branch_id, status, gmt_create, gmt_modified from  #local_tcc_log#  where xid = ? and branch_id = ? for update";
    protected static final String QUERY_END_STATUS_BY_DATE = "select xid, branch_id, status, gmt_create, gmt_modified  from  #local_tcc_log#  where  gmt_modified < ?  and status in (2 , 3 , 4)";
    protected static final String ORACLE_QUERY_LIMIT = " and ROWNUM <= ? ";
    protected static final String NONE_ORACLE_QUERY_LIMIT = " limit ? ";
    protected static final String UPDATE_STATUS_BY_BRANCH_ID_AND_XID = "update  #local_tcc_log#  set status = ?, gmt_modified = ? where xid = ? and  branch_id = ? and status = ? ";
    protected static final String DELETE_BY_BRANCH_ID_AND_XID = "delete from  #local_tcc_log#  where xid = ? and  branch_id = ? ";
    protected static final String DELETE_BY_BRANCH_XIDS = "delete from  #local_tcc_log#  where xid in ( #PRAMETER_PLACEHOLD# )";
    protected static final String DELETE_BY_DATE_AND_STATUS = "delete from  #local_tcc_log#  where gmt_modified < ?  and status in (2 , 3 , 4)";

    private CommonFenceStoreSqls() {
        throw new IllegalStateException("Utility class");
    }

    public static String getInsertLocalTCCLogSQL(String localTccTable) {
        return INSERT_LOCAL_TCC_LOG.replace(LOCAL_TCC_LOG_PLACEHOLD, localTccTable);
    }

    public static String getQuerySQLByBranchIdAndXid(String localTccTable) {
        return QUERY_BY_BRANCH_ID_AND_XID.replace(LOCAL_TCC_LOG_PLACEHOLD, localTccTable);
    }

    public static String getQueryEndStatusSQLByDate(String localTccTable, boolean isOracle) {
        StringBuilder querySQLTemplate = new StringBuilder(QUERY_END_STATUS_BY_DATE);
        if (isOracle) {
            querySQLTemplate.append(ORACLE_QUERY_LIMIT);
        } else {
            querySQLTemplate.append(NONE_ORACLE_QUERY_LIMIT);
        }
        return querySQLTemplate.toString().replace(LOCAL_TCC_LOG_PLACEHOLD, localTccTable);
    }

    public static String getUpdateStatusSQLByBranchIdAndXid(String localTccTable) {
        return UPDATE_STATUS_BY_BRANCH_ID_AND_XID.replace(LOCAL_TCC_LOG_PLACEHOLD, localTccTable);
    }

    public static String getDeleteSQLByBranchIdAndXid(String localTccTable) {
        return DELETE_BY_BRANCH_ID_AND_XID.replace(LOCAL_TCC_LOG_PLACEHOLD, localTccTable);
    }

    public static String getDeleteSQLByXids(String localTccTable, String paramsPlaceHolder) {
        return DELETE_BY_BRANCH_XIDS.replace(LOCAL_TCC_LOG_PLACEHOLD, localTccTable).replace(PRAMETER_PLACEHOLD, paramsPlaceHolder);
    }
}

