/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.integration.dubbo.alibaba;

import com.alibaba.dubbo.common.extension.Activate;
import com.alibaba.dubbo.rpc.Filter;
import com.alibaba.dubbo.rpc.Invocation;
import com.alibaba.dubbo.rpc.Invoker;
import com.alibaba.dubbo.rpc.Result;
import com.alibaba.dubbo.rpc.RpcContext;
import com.alibaba.dubbo.rpc.RpcException;
import org.apache.seata.core.constants.DubboConstants;
import org.apache.seata.core.context.RootContext;
import org.apache.seata.core.model.BranchType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Activate(group={"consumer"}, order=100)
public class AlibabaDubboTransactionConsumerFilter
implements Filter {
    private static final Logger LOGGER = LoggerFactory.getLogger(AlibabaDubboTransactionConsumerFilter.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result invoke(Invoker<?> invoker, Invocation invocation) throws RpcException {
        if (!DubboConstants.ALIBABADUBBO) {
            return invoker.invoke(invocation);
        }
        String xid = RootContext.getXID();
        BranchType branchType = RootContext.getBranchType();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("consumer xid in RootContext[{}], branchType in RootContext[{}]", (Object)xid, (Object)branchType);
        }
        if (xid != null) {
            RpcContext.getContext().setAttachment("TX_XID", xid);
            RpcContext.getContext().setAttachment("TX_BRANCH_TYPE", branchType.name());
        }
        try {
            Result result = invoker.invoke(invocation);
            return result;
        }
        finally {
            RpcContext.getContext().removeAttachment("TX_XID");
            RpcContext.getContext().removeAttachment("TX_BRANCH_TYPE");
        }
    }
}

