/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.discovery.registry.namingserver;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.http.HttpEntity;
import org.apache.http.StatusLine;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.entity.ContentType;
import org.apache.http.util.EntityUtils;
import org.apache.seata.common.metadata.Node;
import org.apache.seata.common.metadata.namingserver.Instance;
import org.apache.seata.common.metadata.namingserver.MetaResponse;
import org.apache.seata.common.thread.NamedThreadFactory;
import org.apache.seata.common.util.CollectionUtils;
import org.apache.seata.common.util.HttpClientUtil;
import org.apache.seata.common.util.NetUtil;
import org.apache.seata.common.util.StringUtils;
import org.apache.seata.config.Configuration;
import org.apache.seata.config.ConfigurationFactory;
import org.apache.seata.discovery.registry.RegistryService;
import org.apache.seata.discovery.registry.namingserver.NamingListener;
import org.apache.seata.discovery.registry.namingserver.NamingRegistryException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NamingserverRegistryServiceImpl
implements RegistryService<NamingListener> {
    private static final Logger LOGGER = LoggerFactory.getLogger(NamingserverRegistryServiceImpl.class);
    public static volatile NamingserverRegistryServiceImpl instance;
    private static final String NAMESPACE_KEY = "namespace";
    private static final String VGROUP_KEY = "vGroup";
    private static final String CLIENT_TERM_KEY = "clientTerm";
    private static final String DEFAULT_NAMESPACE = "public";
    private static final String NAMING_SERVICE_URL_KEY = "server-addr";
    private static final String FILE_ROOT_REGISTRY = "registry";
    private static final String FILE_CONFIG_SPLIT_CHAR = ".";
    private static final String REGISTRY_TYPE = "seata";
    private static final String HTTP_PREFIX = "http://";
    private static final String TIME_OUT_KEY = "timeout";
    private static final String HEART_BEAT_KEY = "heartbeat-period";
    private static int healthcheckPeriod;
    private static final int PULL_PERIOD = 30000;
    private static final int LONG_POLL_TIME_OUT_PERIOD = 28000;
    private static final int THREAD_POOL_NUM = 1;
    private static final int HEALTH_CHECK_THRESHOLD = 1;
    private volatile long term = 0L;
    private static final ObjectMapper OBJECT_MAPPER;
    private volatile boolean isSubscribed = false;
    private static final Configuration FILE_CONFIG;
    private String namingServerAddressCache;
    private static ConcurrentMap<String, AtomicInteger> AVAILABLE_NAMINGSERVER_MAP;
    private static final ConcurrentMap<String, List<InetSocketAddress>> VGROUP_ADDRESS_MAP;
    private static final ConcurrentMap<String, List<NamingListener>> LISTENER_SERVICE_MAP;
    protected final ScheduledExecutorService executorService = new ScheduledThreadPoolExecutor(1, new NamedThreadFactory("seata-namingser-scheduled", 1, true));
    private final ExecutorService notifierExecutor = new ThreadPoolExecutor(1, 1, Integer.MAX_VALUE, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), new NamedThreadFactory("serviceNamingNotifier", 1));

    private NamingserverRegistryServiceImpl() {
        OBJECT_MAPPER.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        String heartBeatKey = String.join((CharSequence)FILE_CONFIG_SPLIT_CHAR, FILE_ROOT_REGISTRY, REGISTRY_TYPE, HEART_BEAT_KEY);
        healthcheckPeriod = FILE_CONFIG.getInt(heartBeatKey, healthcheckPeriod);
        List<String> urlList = this.getNamingAddrs();
        this.checkAvailableNamingAddr(urlList);
        this.executorService.scheduleAtFixedRate(() -> this.checkAvailableNamingAddr(urlList), healthcheckPeriod, healthcheckPeriod, TimeUnit.MILLISECONDS);
    }

    private void checkAvailableNamingAddr(List<String> urlList) {
        for (String url : urlList) {
            AtomicInteger unHealthCount = AVAILABLE_NAMINGSERVER_MAP.computeIfAbsent(url, value -> new AtomicInteger(0));
            boolean isHealthy = this.doHealthCheck(url);
            int unHealthCountBefore = unHealthCount.get();
            if (!isHealthy) {
                unHealthCount.incrementAndGet();
            } else {
                unHealthCount.set(0);
                AVAILABLE_NAMINGSERVER_MAP.put(url, unHealthCount);
            }
            int unHealthCountAfter = unHealthCount.get();
            if (!Objects.equals(unHealthCountAfter, 0) && unHealthCountAfter == 1) {
                LOGGER.error("naming server node go offline {}", (Object)url);
            }
            if (Objects.equals(unHealthCountAfter, unHealthCountBefore) || unHealthCountAfter != 0) continue;
            LOGGER.info("naming server node go online {}", (Object)url);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static NamingserverRegistryServiceImpl getInstance() {
        if (instance != null) return instance;
        Class<NamingserverRegistryServiceImpl> clazz = NamingserverRegistryServiceImpl.class;
        synchronized (NamingserverRegistryServiceImpl.class) {
            if (instance != null) return instance;
            instance = new NamingserverRegistryServiceImpl();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    @Override
    public void register(InetSocketAddress address) throws Exception {
        NetUtil.validAddress(address);
        Instance instance = Instance.getInstance();
        instance.setTransaction(new Node.Endpoint(address.getAddress().getHostAddress(), address.getPort(), "netty"));
        instance.setTimestamp(System.currentTimeMillis());
        this.doRegister(instance, this.getNamingAddrs());
    }

    public void doRegister(Instance instance, List<String> urlList) {
        for (String urlSuffix : urlList) {
            if (AVAILABLE_NAMINGSERVER_MAP.computeIfAbsent(urlSuffix, value -> new AtomicInteger(0)).get() >= 1) continue;
            String url = HTTP_PREFIX + urlSuffix + "/naming/v1/register?";
            String namespace = instance.getNamespace();
            String clusterName = instance.getClusterName();
            String unit = instance.getUnit();
            String jsonBody = instance.toJsonString(OBJECT_MAPPER);
            String params = "namespace=" + namespace + "&clusterName=" + clusterName + "&unit=" + unit;
            url = url + params;
            HashMap<String, String> header = new HashMap<String, String>();
            header.put("Content-Type", ContentType.APPLICATION_JSON.getMimeType());
            try {
                CloseableHttpResponse response = HttpClientUtil.doPost(url, jsonBody, header, 3000);
                Throwable throwable = null;
                try {
                    int statusCode = response.getStatusLine().getStatusCode();
                    if (statusCode == 200) {
                        if (!LOGGER.isDebugEnabled()) continue;
                        LOGGER.debug("instance has been registered successfully:{}", (Object)statusCode);
                        continue;
                    }
                    LOGGER.warn("instance has been registered unsuccessfully:{}", (Object)statusCode);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (response == null) continue;
                    if (throwable != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    response.close();
                }
            }
            catch (Exception e) {
                LOGGER.error("instance has been registered failed in namingserver {}", (Object)url);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean doHealthCheck(String url) {
        url = HTTP_PREFIX + url + "/naming/v1/health";
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("Content-Type", ContentType.APPLICATION_JSON.getMimeType());
        try (CloseableHttpResponse response = HttpClientUtil.doGet(url, null, header, 3000);){
            int statusCode = response.getStatusLine().getStatusCode();
            boolean bl = statusCode == 200;
            return bl;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public void unregister(InetSocketAddress address) {
        NetUtil.validAddress(address);
        Instance instance = Instance.getInstance();
        instance.setTransaction(new Node.Endpoint(address.getAddress().getHostAddress(), address.getPort(), "netty"));
        for (String urlSuffix : this.getNamingAddrs()) {
            String url = HTTP_PREFIX + urlSuffix + "/naming/v1/unregister?";
            String unit = instance.getUnit();
            String jsonBody = instance.toJsonString(OBJECT_MAPPER);
            String params = "unit=" + unit;
            params = params + "&clusterName=" + instance.getClusterName();
            params = params + "&namespace=" + instance.getNamespace();
            url = url + params;
            HashMap<String, String> header = new HashMap<String, String>();
            header.put("Content-Type", ContentType.APPLICATION_JSON.getMimeType());
            try {
                CloseableHttpResponse response = HttpClientUtil.doPost(url, jsonBody, header, 3000);
                Throwable throwable = null;
                try {
                    int statusCode = response.getStatusLine().getStatusCode();
                    if (statusCode == 200) {
                        LOGGER.info("instance has been unregistered successfully:{}", (Object)statusCode);
                        continue;
                    }
                    LOGGER.warn("instance has been unregistered unsuccessfully:{}", (Object)statusCode);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (response == null) continue;
                    if (throwable != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    response.close();
                }
            }
            catch (Exception e) {
                LOGGER.error("instance has been unregistered failed in namingserver {}", (Object)url, (Object)e);
            }
        }
    }

    @Override
    public void subscribe(String cluster, NamingListener listener) throws Exception {
    }

    public void subscribe(NamingListener listener, String vGroup) throws Exception {
        LISTENER_SERVICE_MAP.computeIfAbsent(vGroup, key -> new ArrayList()).add(listener);
        this.isSubscribed = true;
        this.notifierExecutor.execute(() -> {
            long currentTime = System.currentTimeMillis();
            while (this.isSubscribed) {
                try {
                    boolean needFetch;
                    boolean bl = needFetch = System.currentTimeMillis() - currentTime > 30000L;
                    if (!needFetch) {
                        needFetch = this.watch(vGroup);
                    }
                    if (!needFetch) continue;
                    for (NamingListener namingListener : (List)LISTENER_SERVICE_MAP.get(vGroup)) {
                        try {
                            namingListener.onEvent(vGroup);
                        }
                        catch (Exception e) {
                            LOGGER.warn("vGroup {} onEvent wrong {}", (Object)vGroup, (Object)e);
                            try {
                                TimeUnit.SECONDS.sleep(1L);
                            }
                            catch (InterruptedException interruptedException) {}
                        }
                    }
                    this.namingServerAddressCache = null;
                    currentTime = System.currentTimeMillis();
                }
                catch (Exception ex) {
                    LOGGER.error("watch failed! ", (Throwable)ex);
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (Exception exception) {}
                }
            }
        });
        Runtime.getRuntime().addShutdownHook(new Thread(this.notifierExecutor::shutdown));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean watch(String vGroup) {
        String namingAddr = this.getNamingAddr();
        String clientAddr = NetUtil.getLocalHost();
        StringBuilder watchAddrBuilder = new StringBuilder(HTTP_PREFIX).append(namingAddr).append("/naming/v1/watch?").append(VGROUP_KEY).append("=").append(vGroup).append("&").append(CLIENT_TERM_KEY).append("=").append(this.term).append("&").append(TIME_OUT_KEY).append("=").append(28000).append("&clientAddr=").append(clientAddr);
        String watchAddr = watchAddrBuilder.toString();
        try (CloseableHttpResponse response = HttpClientUtil.doPost(watchAddr, (String)null, null, 30000);){
            if (response == null) return false;
            StatusLine statusLine = response.getStatusLine();
            boolean bl = statusLine != null && statusLine.getStatusCode() == 200;
            return bl;
        }
        catch (Exception e) {
            LOGGER.error("watch failed: {}", (Object)e.getMessage());
            try {
                TimeUnit.SECONDS.sleep(1L);
                return false;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return false;
    }

    @Override
    public void unsubscribe(String cluster, NamingListener listener) throws Exception {
    }

    public void unsubscribe(NamingListener listener, String vGroup) throws Exception {
        List listeners = (List)LISTENER_SERVICE_MAP.get(vGroup);
        if (listeners != null) {
            listeners.remove(listener);
            if (listeners.isEmpty()) {
                LISTENER_SERVICE_MAP.remove(vGroup);
            }
        }
        this.isSubscribed = false;
    }

    public void unsubscribe(String vGroup) throws Exception {
        LISTENER_SERVICE_MAP.remove(vGroup);
        this.isSubscribed = false;
    }

    @Override
    public List<InetSocketAddress> lookup(String key) throws Exception {
        if (!this.isSubscribed) {
            this.refreshGroup(key);
            this.subscribe((String vGroup) -> {
                try {
                    this.refreshGroup(vGroup);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }, key);
        }
        return (List)VGROUP_ADDRESS_MAP.get(key);
    }

    public List<InetSocketAddress> refreshGroup(String vGroup) throws IOException {
        HashMap<String, String> paraMap = new HashMap<String, String>();
        String namingAddr = this.getNamingAddr();
        paraMap.put(VGROUP_KEY, vGroup);
        paraMap.put(NAMESPACE_KEY, this.getNamespace());
        String url = HTTP_PREFIX + namingAddr + "/naming/v1/discovery";
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("Content-Type", ContentType.APPLICATION_JSON.getMimeType());
        try (CloseableHttpResponse response = HttpClientUtil.doGet(url, paraMap, header, 3000);){
            if (response == null) {
                throw new NamingRegistryException("cannot lookup server list in vgroup: " + vGroup);
            }
            String jsonResponse = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF-8");
            MetaResponse metaResponse = (MetaResponse)OBJECT_MAPPER.readValue(jsonResponse, (TypeReference)new TypeReference<MetaResponse>(){});
            List<InetSocketAddress> newAddressList = metaResponse.getClusterList().stream().flatMap(cluster -> cluster.getUnitData().stream()).flatMap(unit -> unit.getNamingInstanceList().stream()).map(namingInstance -> new InetSocketAddress(namingInstance.getTransaction().getHost(), namingInstance.getTransaction().getPort())).collect(Collectors.toList());
            if (metaResponse.getTerm() > 0L) {
                this.term = metaResponse.getTerm();
            }
            VGROUP_ADDRESS_MAP.put(vGroup, newAddressList);
            this.removeOfflineAddressesIfNecessary(vGroup, vGroup, newAddressList);
        }
        catch (IOException e) {
            LOGGER.error(e.getMessage());
            throw new RemoteException();
        }
        return (List)VGROUP_ADDRESS_MAP.get(vGroup);
    }

    @Override
    public void close() throws Exception {
    }

    @Override
    public String getServiceGroup(String key) {
        return RegistryService.super.getServiceGroup(key);
    }

    public String getNamespace() {
        String namespaceKey = String.join((CharSequence)FILE_CONFIG_SPLIT_CHAR, FILE_ROOT_REGISTRY, REGISTRY_TYPE, NAMESPACE_KEY);
        String namespace = FILE_CONFIG.getConfig(namespaceKey);
        if (StringUtils.isBlank(namespace)) {
            namespace = DEFAULT_NAMESPACE;
        }
        return namespace;
    }

    @Override
    public List<InetSocketAddress> aliveLookup(String transactionServiceGroup) {
        Map clusterAddressMap = CURRENT_ADDRESS_MAP.computeIfAbsent(transactionServiceGroup, k -> new ConcurrentHashMap());
        List inetSocketAddresses = (List)clusterAddressMap.get(transactionServiceGroup);
        if (CollectionUtils.isNotEmpty(inetSocketAddresses)) {
            return inetSocketAddresses;
        }
        return clusterAddressMap.values().stream().filter(CollectionUtils::isNotEmpty).findAny().orElse(Collections.emptyList());
    }

    @Override
    public List<InetSocketAddress> refreshAliveLookup(String transactionServiceGroup, List<InetSocketAddress> aliveAddress) {
        Map clusterAddressMap = CURRENT_ADDRESS_MAP.computeIfAbsent(transactionServiceGroup, key -> new ConcurrentHashMap());
        return clusterAddressMap.put(transactionServiceGroup, aliveAddress);
    }

    public String getNamingAddr() {
        if (this.namingServerAddressCache != null) {
            return this.namingServerAddressCache;
        }
        HashMap<String, AtomicInteger> availableNamingserverMap = new HashMap<String, AtomicInteger>(AVAILABLE_NAMINGSERVER_MAP);
        ArrayList<String> availableNamingserverList = new ArrayList<String>();
        for (Map.Entry entry : availableNamingserverMap.entrySet()) {
            String namingServerAddress = (String)entry.getKey();
            Integer numberOfFailures = ((AtomicInteger)entry.getValue()).get();
            if (numberOfFailures >= 1) continue;
            availableNamingserverList.add(namingServerAddress);
        }
        if (availableNamingserverList.isEmpty()) {
            throw new NamingRegistryException("no available namingserver address!");
        }
        this.namingServerAddressCache = (String)availableNamingserverList.get(ThreadLocalRandom.current().nextInt(availableNamingserverList.size()));
        return this.namingServerAddressCache;
    }

    public List<String> getNamingAddrs() {
        String namingAddrsKey = String.join((CharSequence)FILE_CONFIG_SPLIT_CHAR, FILE_ROOT_REGISTRY, REGISTRY_TYPE, NAMING_SERVICE_URL_KEY);
        String urlListStr = FILE_CONFIG.getConfig(namingAddrsKey);
        if (urlListStr.isEmpty()) {
            throw new NamingRegistryException("Naming server url can not be null!");
        }
        return Arrays.stream(urlListStr.split(",")).collect(Collectors.toList());
    }

    static {
        healthcheckPeriod = 5000;
        OBJECT_MAPPER = new ObjectMapper();
        FILE_CONFIG = ConfigurationFactory.CURRENT_FILE_INSTANCE;
        AVAILABLE_NAMINGSERVER_MAP = new ConcurrentHashMap<String, AtomicInteger>();
        VGROUP_ADDRESS_MAP = new ConcurrentHashMap<String, List<InetSocketAddress>>();
        LISTENER_SERVICE_MAP = new ConcurrentHashMap<String, List<NamingListener>>();
    }
}

