/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.common.exception;

import java.text.MessageFormat;
import java.util.HashSet;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.seata.common.exception.AbstractRemoteResourceBundle;
import org.apache.seata.common.exception.ErrorCode;
import org.apache.seata.common.exception.SeataRuntimeException;
import org.apache.seata.common.loader.EnhancedServiceLoader;

public class ResourceBundleUtil {
    private static final Locale LOCALE = new Locale("en", "US");
    private static final ResourceBundleUtil INSTANCE = new ResourceBundleUtil("error/ErrorCode", LOCALE);
    private ResourceBundle localBundle;
    private AbstractRemoteResourceBundle remoteBundle;
    public static final String DEFAULT_PLACEHOLDER_PREFIX = "${";
    public static final String DEFAULT_PLACEHOLDER_SUFFIX = "}";

    public static ResourceBundleUtil getInstance() {
        return INSTANCE;
    }

    public ResourceBundleUtil(String bundleName, Locale local) {
        this.localBundle = ResourceBundle.getBundle(bundleName, local);
        try {
            this.remoteBundle = EnhancedServiceLoader.load(AbstractRemoteResourceBundle.class);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public String getMessage(String key, String ... params) {
        if (StringUtils.isBlank((String)key)) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(this.getFormattedMessage(key));
        String msg = this.parseStringValue(sb.toString(), new HashSet<String>());
        if (params == null || params.length == 0) {
            return msg;
        }
        if (StringUtils.isBlank((String)msg)) {
            return msg;
        }
        return MessageFormat.format(msg, params);
    }

    public String getMessage(String key, int code, String type, String ... params) {
        if (StringUtils.isBlank((String)key)) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(this.getFormattedMessage("ERR_PREFIX")).append(" ").append(this.getFormattedMessage(key)).append(" ").append(this.getFormattedMessage("ERR_POSTFIX"));
        String msg = sb.toString();
        msg = this.parseStringValue(msg, new HashSet<String>());
        msg = StringUtils.replace((String)msg, (String)"{code}", (String)String.valueOf(code));
        msg = StringUtils.replace((String)msg, (String)"{type}", (String)String.valueOf(type));
        msg = StringUtils.replace((String)msg, (String)"{key}", (String)key);
        if (params == null || params.length == 0) {
            return msg;
        }
        if (StringUtils.isBlank((String)msg)) {
            return msg;
        }
        return MessageFormat.format(msg, params);
    }

    protected String getFormattedMessage(String key) {
        String value = "";
        if (this.remoteBundle != null && this.remoteBundle.containsKey(key)) {
            value = this.remoteBundle.getString(key);
        }
        if (StringUtils.isEmpty((String)value)) {
            value = this.localBundle.getString(key);
        }
        return value;
    }

    protected String parseStringValue(String strVal, Set<String> visitedPlaceholders) {
        StringBuffer buf = new StringBuffer(strVal);
        int startIndex = strVal.indexOf(DEFAULT_PLACEHOLDER_PREFIX);
        while (startIndex != -1) {
            int endIndex = this.findPlaceholderEndIndex(buf, startIndex);
            if (endIndex != -1) {
                String placeholder = buf.substring(startIndex + DEFAULT_PLACEHOLDER_PREFIX.length(), endIndex);
                if (!visitedPlaceholders.add(placeholder)) {
                    throw new SeataRuntimeException(ErrorCode.ERR_CONFIG, "Duplicate placeholders exist '" + placeholder + "' in bundle.");
                }
                placeholder = this.parseStringValue(placeholder, visitedPlaceholders);
                try {
                    String propVal = this.resolvePlaceholder(placeholder);
                    if (propVal == null) {
                        throw new SeataRuntimeException(ErrorCode.ERR_CONFIG, "Could not resolve placeholder '" + placeholder + "'");
                    }
                    propVal = this.parseStringValue(propVal, visitedPlaceholders);
                    buf.replace(startIndex, endIndex + DEFAULT_PLACEHOLDER_SUFFIX.length(), propVal);
                    startIndex = buf.indexOf(DEFAULT_PLACEHOLDER_PREFIX, startIndex + propVal.length());
                }
                catch (Exception ex) {
                    throw new SeataRuntimeException(ErrorCode.ERR_CONFIG, "Could not resolve placeholder '" + placeholder + "'");
                }
                visitedPlaceholders.remove(placeholder);
                continue;
            }
            startIndex = -1;
        }
        return buf.toString();
    }

    private int findPlaceholderEndIndex(CharSequence buf, int startIndex) {
        int index = startIndex + DEFAULT_PLACEHOLDER_PREFIX.length();
        int withinNestedPlaceholder = 0;
        while (index < buf.length()) {
            if (this.matchSubString(buf, index, DEFAULT_PLACEHOLDER_SUFFIX)) {
                if (withinNestedPlaceholder > 0) {
                    --withinNestedPlaceholder;
                    index += DEFAULT_PLACEHOLDER_SUFFIX.length();
                    continue;
                }
                return index;
            }
            if (this.matchSubString(buf, index, DEFAULT_PLACEHOLDER_PREFIX)) {
                ++withinNestedPlaceholder;
                index += DEFAULT_PLACEHOLDER_PREFIX.length();
                continue;
            }
            ++index;
        }
        return -1;
    }

    private boolean matchSubString(CharSequence str, int index, CharSequence substring) {
        for (int j = 0; j < substring.length(); ++j) {
            int i = index + j;
            if (i < str.length() && str.charAt(i) == substring.charAt(j)) continue;
            return false;
        }
        return true;
    }

    private String resolvePlaceholder(String placeholder) {
        return this.getFormattedMessage(placeholder);
    }
}

