/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.spring.config;

import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.rocketmq.client.exception.MQClientException;
import org.apache.rocketmq.remoting.RPCHook;
import org.apache.rocketmq.spring.annotation.RocketMQTransactionListener;
import org.apache.rocketmq.spring.config.TransactionHandler;
import org.apache.rocketmq.spring.config.TransactionHandlerRegistry;
import org.apache.rocketmq.spring.core.RocketMQLocalTransactionListener;
import org.apache.rocketmq.spring.support.RocketMQUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.Ordered;
import org.springframework.core.annotation.AnnotationUtils;

public class RocketMQTransactionAnnotationProcessor
implements BeanPostProcessor,
Ordered,
ApplicationContextAware {
    private static final Logger log = LoggerFactory.getLogger(RocketMQTransactionAnnotationProcessor.class);
    private ApplicationContext applicationContext;
    private final Set<Class<?>> nonProcessedClasses = Collections.newSetFromMap(new ConcurrentHashMap(64));
    private TransactionHandlerRegistry transactionHandlerRegistry;

    public RocketMQTransactionAnnotationProcessor(TransactionHandlerRegistry transactionHandlerRegistry) {
        this.transactionHandlerRegistry = transactionHandlerRegistry;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        if (!this.nonProcessedClasses.contains(bean.getClass())) {
            Class targetClass = AopUtils.getTargetClass((Object)bean);
            RocketMQTransactionListener listener = (RocketMQTransactionListener)AnnotationUtils.findAnnotation((Class)targetClass, RocketMQTransactionListener.class);
            this.nonProcessedClasses.add(bean.getClass());
            if (listener == null) {
                log.trace("No @RocketMQTransactionListener annotations found on bean type: {}", bean.getClass());
            } else {
                try {
                    this.processTransactionListenerAnnotation(listener, bean);
                }
                catch (MQClientException e) {
                    log.error("Failed to process annotation " + listener, (Throwable)e);
                    throw new BeanCreationException("Failed to process annotation " + listener, (Throwable)e);
                }
            }
        }
        return bean;
    }

    private void processTransactionListenerAnnotation(RocketMQTransactionListener listener, Object bean) throws MQClientException {
        if (this.transactionHandlerRegistry == null) {
            throw new MQClientException("Bad usage of @RocketMQTransactionListener, the class must work with RocketMQTemplate", null);
        }
        if (!RocketMQLocalTransactionListener.class.isAssignableFrom(bean.getClass())) {
            throw new MQClientException("Bad usage of @RocketMQTransactionListener, the class must implement interface RocketMQLocalTransactionListener", null);
        }
        TransactionHandler transactionHandler = new TransactionHandler();
        transactionHandler.setBeanFactory((BeanFactory)this.applicationContext.getAutowireCapableBeanFactory());
        transactionHandler.setName(this.applicationContext.getEnvironment().resolvePlaceholders(listener.txProducerGroup()));
        transactionHandler.setBeanName(bean.getClass().getName());
        transactionHandler.setListener((RocketMQLocalTransactionListener)bean);
        transactionHandler.setCheckExecutor(listener.corePoolSize(), listener.maximumPoolSize(), listener.keepAliveTime(), listener.blockingQueueSize());
        RPCHook rpcHook = RocketMQUtil.getRPCHookByAkSk(this.applicationContext.getEnvironment(), listener.accessKey(), listener.secretKey());
        if (Objects.nonNull(rpcHook)) {
            transactionHandler.setRpcHook(rpcHook);
        } else {
            log.debug("Access-key or secret-key not configure in " + listener + ".");
        }
        this.transactionHandlerRegistry.registerTransactionHandler(transactionHandler);
    }

    public int getOrder() {
        return Integer.MAX_VALUE;
    }
}

