/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.client.trace;

import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.rocketmq.client.AccessChannel;
import org.apache.rocketmq.client.common.ThreadLocalIndex;
import org.apache.rocketmq.client.exception.MQClientException;
import org.apache.rocketmq.client.impl.consumer.DefaultMQPushConsumerImpl;
import org.apache.rocketmq.client.impl.producer.DefaultMQProducerImpl;
import org.apache.rocketmq.client.impl.producer.TopicPublishInfo;
import org.apache.rocketmq.client.producer.DefaultMQProducer;
import org.apache.rocketmq.client.producer.MessageQueueSelector;
import org.apache.rocketmq.client.producer.SendCallback;
import org.apache.rocketmq.client.producer.SendResult;
import org.apache.rocketmq.client.trace.TraceContext;
import org.apache.rocketmq.client.trace.TraceDataEncoder;
import org.apache.rocketmq.client.trace.TraceDispatcher;
import org.apache.rocketmq.client.trace.TraceTransferBean;
import org.apache.rocketmq.common.ThreadFactoryImpl;
import org.apache.rocketmq.common.UtilAll;
import org.apache.rocketmq.common.message.Message;
import org.apache.rocketmq.common.message.MessageQueue;
import org.apache.rocketmq.logging.org.slf4j.Logger;
import org.apache.rocketmq.logging.org.slf4j.LoggerFactory;
import org.apache.rocketmq.remoting.RPCHook;

public class AsyncTraceDispatcher
implements TraceDispatcher {
    private static final Logger log = LoggerFactory.getLogger(AsyncTraceDispatcher.class);
    private static final AtomicInteger COUNTER = new AtomicInteger();
    private static final short MAX_MSG_KEY_SIZE = 22767;
    private final int queueSize;
    private final int batchSize;
    private final int maxMsgSize;
    private final long pollingTimeMil;
    private final long waitTimeThresholdMil;
    private final DefaultMQProducer traceProducer;
    private final ThreadPoolExecutor traceExecutor;
    private AtomicLong discardCount;
    private Thread worker;
    private final ArrayBlockingQueue<TraceContext> traceContextQueue;
    private final HashMap<String, TraceDataSegment> taskQueueByTopic;
    private ArrayBlockingQueue<Runnable> appenderQueue;
    private volatile Thread shutDownHook;
    private volatile boolean stopped = false;
    private DefaultMQProducerImpl hostProducer;
    private DefaultMQPushConsumerImpl hostConsumer;
    private volatile ThreadLocalIndex sendWhichQueue = new ThreadLocalIndex();
    private String dispatcherId = UUID.randomUUID().toString();
    private volatile String traceTopicName;
    private AtomicBoolean isStarted = new AtomicBoolean(false);
    private volatile AccessChannel accessChannel = AccessChannel.LOCAL;
    private String group;
    private TraceDispatcher.Type type;
    private String namespaceV2;

    public AsyncTraceDispatcher(String group, TraceDispatcher.Type type, String traceTopicName, RPCHook rpcHook) {
        this.queueSize = 2048;
        this.batchSize = 100;
        this.maxMsgSize = 128000;
        this.pollingTimeMil = 100L;
        this.waitTimeThresholdMil = 500L;
        this.discardCount = new AtomicLong(0L);
        this.traceContextQueue = new ArrayBlockingQueue(1024);
        this.taskQueueByTopic = new HashMap();
        this.group = group;
        this.type = type;
        this.appenderQueue = new ArrayBlockingQueue(this.queueSize);
        this.traceTopicName = !UtilAll.isBlank((String)traceTopicName) ? traceTopicName : "RMQ_SYS_TRACE_TOPIC";
        this.traceExecutor = new ThreadPoolExecutor(10, 20, 60000L, TimeUnit.MILLISECONDS, this.appenderQueue, (ThreadFactory)new ThreadFactoryImpl("MQTraceSendThread_"));
        this.traceProducer = this.getAndCreateTraceProducer(rpcHook);
    }

    public AccessChannel getAccessChannel() {
        return this.accessChannel;
    }

    public void setAccessChannel(AccessChannel accessChannel) {
        this.accessChannel = accessChannel;
    }

    public String getTraceTopicName() {
        return this.traceTopicName;
    }

    public void setTraceTopicName(String traceTopicName) {
        this.traceTopicName = traceTopicName;
    }

    public DefaultMQProducer getTraceProducer() {
        return this.traceProducer;
    }

    public DefaultMQProducerImpl getHostProducer() {
        return this.hostProducer;
    }

    public void setHostProducer(DefaultMQProducerImpl hostProducer) {
        this.hostProducer = hostProducer;
    }

    public DefaultMQPushConsumerImpl getHostConsumer() {
        return this.hostConsumer;
    }

    public void setHostConsumer(DefaultMQPushConsumerImpl hostConsumer) {
        this.hostConsumer = hostConsumer;
    }

    public String getNamespaceV2() {
        return this.namespaceV2;
    }

    public void setNamespaceV2(String namespaceV2) {
        this.namespaceV2 = namespaceV2;
    }

    @Override
    public void start(String nameSrvAddr, AccessChannel accessChannel) throws MQClientException {
        if (this.isStarted.compareAndSet(false, true)) {
            this.traceProducer.setNamesrvAddr(nameSrvAddr);
            this.traceProducer.setInstanceName("PID_CLIENT_INNER_TRACE_PRODUCER_" + nameSrvAddr);
            this.traceProducer.setNamespaceV2(this.namespaceV2);
            this.traceProducer.setEnableTrace(false);
            this.traceProducer.start();
        }
        this.accessChannel = accessChannel;
        this.worker = new Thread((Runnable)new AsyncRunnable(), "MQ-AsyncTraceDispatcher-Thread-" + this.dispatcherId);
        this.worker.setDaemon(true);
        this.worker.start();
        this.registerShutDownHook();
    }

    private DefaultMQProducer getAndCreateTraceProducer(RPCHook rpcHook) {
        DefaultMQProducer traceProducerInstance = this.traceProducer;
        if (traceProducerInstance == null) {
            traceProducerInstance = new DefaultMQProducer(rpcHook);
            traceProducerInstance.setProducerGroup(this.genGroupNameForTrace());
            traceProducerInstance.setSendMsgTimeout(5000);
            traceProducerInstance.setVipChannelEnabled(false);
            traceProducerInstance.setMaxMessageSize(this.maxMsgSize);
        }
        return traceProducerInstance;
    }

    private String genGroupNameForTrace() {
        return "_INNER_TRACE_PRODUCER-" + this.group + "-" + (Object)((Object)this.type) + "-" + COUNTER.incrementAndGet();
    }

    @Override
    public boolean append(Object ctx) {
        boolean result = this.traceContextQueue.offer((TraceContext)ctx);
        if (!result) {
            log.info("buffer full" + this.discardCount.incrementAndGet() + " ,context is " + ctx);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() {
        long end = System.currentTimeMillis() + 500L;
        while (System.currentTimeMillis() <= end) {
            Serializable serializable = this.taskQueueByTopic;
            synchronized (serializable) {
                for (TraceDataSegment taskInfo : this.taskQueueByTopic.values()) {
                    taskInfo.sendAllData();
                }
            }
            serializable = this.traceContextQueue;
            synchronized (serializable) {
                if (this.traceContextQueue.size() == 0 && this.appenderQueue.size() == 0) {
                    break;
                }
            }
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException e) {
                // empty catch block
                break;
            }
        }
        log.info("------end trace send " + this.traceContextQueue.size() + "   " + this.appenderQueue.size());
    }

    @Override
    public void shutdown() {
        this.stopped = true;
        this.flush();
        this.traceExecutor.shutdown();
        if (this.isStarted.get()) {
            this.traceProducer.shutdown();
        }
        this.removeShutdownHook();
    }

    public void registerShutDownHook() {
        if (this.shutDownHook == null) {
            this.shutDownHook = new Thread(new Runnable(){
                private volatile boolean hasShutdown = false;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    1 var1_1 = this;
                    synchronized (var1_1) {
                        if (!this.hasShutdown) {
                            AsyncTraceDispatcher.this.flush();
                        }
                    }
                }
            }, "ShutdownHookMQTrace");
            Runtime.getRuntime().addShutdownHook(this.shutDownHook);
        }
    }

    public void removeShutdownHook() {
        if (this.shutDownHook != null) {
            try {
                Runtime.getRuntime().removeShutdownHook(this.shutDownHook);
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
    }

    class AsyncDataSendTask
    implements Runnable {
        private final String traceTopicName;
        private final String regionId;
        private final List<TraceTransferBean> traceTransferBeanList;

        public AsyncDataSendTask(String traceTopicName, String regionId, List<TraceTransferBean> traceTransferBeanList) {
            this.traceTopicName = traceTopicName;
            this.regionId = regionId;
            this.traceTransferBeanList = traceTransferBeanList;
        }

        @Override
        public void run() {
            StringBuilder buffer = new StringBuilder(1024);
            HashSet<String> keySet = new HashSet<String>();
            for (TraceTransferBean bean : this.traceTransferBeanList) {
                keySet.addAll(bean.getTransKey());
                buffer.append(bean.getTransData());
            }
            this.sendTraceDataByMQ(keySet, buffer.toString(), this.traceTopicName);
        }

        private void sendTraceDataByMQ(Set<String> keySet, final String data, String traceTopic) {
            Message message = new Message(traceTopic, data.getBytes(StandardCharsets.UTF_8));
            message.setKeys(keySet);
            try {
                Set<String> traceBrokerSet = this.tryGetMessageQueueBrokerSet(AsyncTraceDispatcher.this.traceProducer.getDefaultMQProducerImpl(), traceTopic);
                SendCallback callback = new SendCallback(){

                    @Override
                    public void onSuccess(SendResult sendResult) {
                    }

                    @Override
                    public void onException(Throwable e) {
                        log.error("send trace data failed, the traceData is {}", (Object)data, (Object)e);
                    }
                };
                if (traceBrokerSet.isEmpty()) {
                    AsyncTraceDispatcher.this.traceProducer.send(message, callback, 5000L);
                } else {
                    AsyncTraceDispatcher.this.traceProducer.send(message, new MessageQueueSelector(){

                        @Override
                        public MessageQueue select(List<MessageQueue> mqs, Message msg, Object arg) {
                            Set brokerSet = (Set)arg;
                            ArrayList<MessageQueue> filterMqs = new ArrayList<MessageQueue>();
                            for (MessageQueue queue : mqs) {
                                if (!brokerSet.contains(queue.getBrokerName())) continue;
                                filterMqs.add(queue);
                            }
                            int index = AsyncTraceDispatcher.this.sendWhichQueue.incrementAndGet();
                            int pos = index % filterMqs.size();
                            return (MessageQueue)filterMqs.get(pos);
                        }
                    }, traceBrokerSet, callback);
                }
            }
            catch (Exception e) {
                log.error("send trace data failed, the traceData is {}", (Object)data, (Object)e);
            }
        }

        private Set<String> tryGetMessageQueueBrokerSet(DefaultMQProducerImpl producer, String topic) {
            HashSet<String> brokerSet = new HashSet<String>();
            TopicPublishInfo topicPublishInfo = (TopicPublishInfo)producer.getTopicPublishInfoTable().get(topic);
            if (null == topicPublishInfo || !topicPublishInfo.ok()) {
                producer.getTopicPublishInfoTable().putIfAbsent(topic, new TopicPublishInfo());
                producer.getMqClientFactory().updateTopicRouteInfoFromNameServer(topic);
                topicPublishInfo = (TopicPublishInfo)producer.getTopicPublishInfoTable().get(topic);
            }
            if (topicPublishInfo.isHaveTopicRouterInfo() || topicPublishInfo.ok()) {
                for (MessageQueue queue : topicPublishInfo.getMessageQueueList()) {
                    brokerSet.add(queue.getBrokerName());
                }
            }
            return brokerSet;
        }
    }

    class TraceDataSegment {
        private long firstBeanAddTime;
        private int currentMsgSize;
        private int currentMsgKeySize;
        private final String traceTopicName;
        private final String regionId;
        private final List<TraceTransferBean> traceTransferBeanList = new ArrayList<TraceTransferBean>();

        TraceDataSegment(String traceTopicName, String regionId) {
            this.traceTopicName = traceTopicName;
            this.regionId = regionId;
        }

        public void addTraceTransferBean(TraceTransferBean traceTransferBean) {
            this.initFirstBeanAddTime();
            this.traceTransferBeanList.add(traceTransferBean);
            this.currentMsgSize += traceTransferBean.getTransData().length();
            this.currentMsgKeySize = traceTransferBean.getTransKey().stream().reduce(this.currentMsgKeySize, (acc, x) -> acc + x.length(), Integer::sum);
            if (this.currentMsgSize >= AsyncTraceDispatcher.this.traceProducer.getMaxMessageSize() - 10000 || this.currentMsgKeySize >= 22767) {
                ArrayList<TraceTransferBean> dataToSend = new ArrayList<TraceTransferBean>(this.traceTransferBeanList);
                AsyncDataSendTask asyncDataSendTask = new AsyncDataSendTask(this.traceTopicName, this.regionId, dataToSend);
                AsyncTraceDispatcher.this.traceExecutor.submit(asyncDataSendTask);
                this.clear();
            }
        }

        public void sendAllData() {
            if (this.traceTransferBeanList.isEmpty()) {
                return;
            }
            ArrayList<TraceTransferBean> dataToSend = new ArrayList<TraceTransferBean>(this.traceTransferBeanList);
            AsyncDataSendTask asyncDataSendTask = new AsyncDataSendTask(this.traceTopicName, this.regionId, dataToSend);
            AsyncTraceDispatcher.this.traceExecutor.submit(asyncDataSendTask);
            this.clear();
        }

        private void initFirstBeanAddTime() {
            if (this.firstBeanAddTime == 0L) {
                this.firstBeanAddTime = System.currentTimeMillis();
            }
        }

        private void clear() {
            this.firstBeanAddTime = 0L;
            this.currentMsgSize = 0;
            this.currentMsgKeySize = 0;
            this.traceTransferBeanList.clear();
        }
    }

    class AsyncRunnable
    implements Runnable {
        private boolean stopped;

        AsyncRunnable() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!this.stopped) {
                ArrayBlockingQueue arrayBlockingQueue = AsyncTraceDispatcher.this.traceContextQueue;
                synchronized (arrayBlockingQueue) {
                    long endTime = System.currentTimeMillis() + AsyncTraceDispatcher.this.pollingTimeMil;
                    while (System.currentTimeMillis() < endTime) {
                        try {
                            TraceContext traceContext = (TraceContext)AsyncTraceDispatcher.this.traceContextQueue.poll(endTime - System.currentTimeMillis(), TimeUnit.MILLISECONDS);
                            if (traceContext == null || traceContext.getTraceBeans().isEmpty()) continue;
                            String traceTopicName = this.getTraceTopicName(traceContext.getRegionId());
                            TraceDataSegment traceDataSegment = (TraceDataSegment)AsyncTraceDispatcher.this.taskQueueByTopic.get(traceTopicName);
                            if (traceDataSegment == null) {
                                traceDataSegment = new TraceDataSegment(traceTopicName, traceContext.getRegionId());
                                AsyncTraceDispatcher.this.taskQueueByTopic.put(traceTopicName, traceDataSegment);
                            }
                            TraceTransferBean traceTransferBean = TraceDataEncoder.encoderFromContextBean(traceContext);
                            traceDataSegment.addTraceTransferBean(traceTransferBean);
                        }
                        catch (InterruptedException ignore) {
                            log.debug("traceContextQueue#poll exception");
                        }
                    }
                    this.sendDataByTimeThreshold();
                    if (AsyncTraceDispatcher.this.stopped) {
                        this.stopped = true;
                    }
                }
            }
        }

        private void sendDataByTimeThreshold() {
            long now = System.currentTimeMillis();
            for (TraceDataSegment taskInfo : AsyncTraceDispatcher.this.taskQueueByTopic.values()) {
                if (now - taskInfo.firstBeanAddTime < AsyncTraceDispatcher.this.waitTimeThresholdMil) continue;
                taskInfo.sendAllData();
            }
        }

        private String getTraceTopicName(String regionId) {
            AccessChannel accessChannel = AsyncTraceDispatcher.this.getAccessChannel();
            if (AccessChannel.CLOUD == accessChannel) {
                return "rmq_sys_TRACE_DATA_" + regionId;
            }
            return AsyncTraceDispatcher.this.getTraceTopicName();
        }
    }
}

