/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.client.latency;

import org.apache.rocketmq.client.ClientConfig;
import org.apache.rocketmq.client.impl.producer.TopicPublishInfo;
import org.apache.rocketmq.client.latency.LatencyFaultTolerance;
import org.apache.rocketmq.client.latency.LatencyFaultToleranceImpl;
import org.apache.rocketmq.client.latency.Resolver;
import org.apache.rocketmq.client.latency.ServiceDetector;
import org.apache.rocketmq.common.message.MessageQueue;

public class MQFaultStrategy {
    private LatencyFaultTolerance<String> latencyFaultTolerance;
    private volatile boolean sendLatencyFaultEnable;
    private volatile boolean startDetectorEnable;
    private long[] latencyMax = new long[]{50L, 100L, 550L, 1800L, 3000L, 5000L, 15000L};
    private long[] notAvailableDuration = new long[]{0L, 0L, 2000L, 5000L, 6000L, 10000L, 30000L};
    private ThreadLocal<BrokerFilter> threadBrokerFilter = new ThreadLocal<BrokerFilter>(){

        @Override
        protected BrokerFilter initialValue() {
            return new BrokerFilter();
        }
    };
    private TopicPublishInfo.QueueFilter reachableFilter = new TopicPublishInfo.QueueFilter(){

        @Override
        public boolean filter(MessageQueue mq) {
            return MQFaultStrategy.this.latencyFaultTolerance.isReachable(mq.getBrokerName());
        }
    };
    private TopicPublishInfo.QueueFilter availableFilter = new TopicPublishInfo.QueueFilter(){

        @Override
        public boolean filter(MessageQueue mq) {
            return MQFaultStrategy.this.latencyFaultTolerance.isAvailable(mq.getBrokerName());
        }
    };

    public MQFaultStrategy(ClientConfig cc, Resolver fetcher, ServiceDetector serviceDetector) {
        this.latencyFaultTolerance = new LatencyFaultToleranceImpl(fetcher, serviceDetector);
        this.latencyFaultTolerance.setDetectInterval(cc.getDetectInterval());
        this.latencyFaultTolerance.setDetectTimeout(cc.getDetectTimeout());
        this.setStartDetectorEnable(cc.isStartDetectorEnable());
        this.setSendLatencyFaultEnable(cc.isSendLatencyEnable());
    }

    public MQFaultStrategy(ClientConfig cc, LatencyFaultTolerance<String> tolerance) {
        this.setStartDetectorEnable(cc.isStartDetectorEnable());
        this.setSendLatencyFaultEnable(cc.isSendLatencyEnable());
        this.latencyFaultTolerance = tolerance;
        this.latencyFaultTolerance.setDetectInterval(cc.getDetectInterval());
        this.latencyFaultTolerance.setDetectTimeout(cc.getDetectTimeout());
    }

    public long[] getNotAvailableDuration() {
        return this.notAvailableDuration;
    }

    public TopicPublishInfo.QueueFilter getAvailableFilter() {
        return this.availableFilter;
    }

    public TopicPublishInfo.QueueFilter getReachableFilter() {
        return this.reachableFilter;
    }

    public ThreadLocal<BrokerFilter> getThreadBrokerFilter() {
        return this.threadBrokerFilter;
    }

    public void setNotAvailableDuration(long[] notAvailableDuration) {
        this.notAvailableDuration = notAvailableDuration;
    }

    public long[] getLatencyMax() {
        return this.latencyMax;
    }

    public void setLatencyMax(long[] latencyMax) {
        this.latencyMax = latencyMax;
    }

    public boolean isSendLatencyFaultEnable() {
        return this.sendLatencyFaultEnable;
    }

    public void setSendLatencyFaultEnable(boolean sendLatencyFaultEnable) {
        this.sendLatencyFaultEnable = sendLatencyFaultEnable;
    }

    public boolean isStartDetectorEnable() {
        return this.startDetectorEnable;
    }

    public void setStartDetectorEnable(boolean startDetectorEnable) {
        this.startDetectorEnable = startDetectorEnable;
        this.latencyFaultTolerance.setStartDetectorEnable(startDetectorEnable);
    }

    public void startDetector() {
        this.latencyFaultTolerance.startDetector();
    }

    public void shutdown() {
        this.latencyFaultTolerance.shutdown();
    }

    public MessageQueue selectOneMessageQueue(TopicPublishInfo tpInfo, String lastBrokerName, boolean resetIndex) {
        BrokerFilter brokerFilter = this.threadBrokerFilter.get();
        brokerFilter.setLastBrokerName(lastBrokerName);
        if (this.sendLatencyFaultEnable) {
            MessageQueue mq;
            if (resetIndex) {
                tpInfo.resetIndex();
            }
            if ((mq = tpInfo.selectOneMessageQueue(this.availableFilter, brokerFilter)) != null) {
                return mq;
            }
            mq = tpInfo.selectOneMessageQueue(this.reachableFilter, brokerFilter);
            if (mq != null) {
                return mq;
            }
            return tpInfo.selectOneMessageQueue();
        }
        MessageQueue mq = tpInfo.selectOneMessageQueue(brokerFilter);
        if (mq != null) {
            return mq;
        }
        return tpInfo.selectOneMessageQueue();
    }

    public void updateFaultItem(String brokerName, long currentLatency, boolean isolation, boolean reachable) {
        if (this.sendLatencyFaultEnable) {
            long duration = this.computeNotAvailableDuration(isolation ? 10000L : currentLatency);
            this.latencyFaultTolerance.updateFaultItem(brokerName, currentLatency, duration, reachable);
        }
    }

    private long computeNotAvailableDuration(long currentLatency) {
        for (int i = this.latencyMax.length - 1; i >= 0; --i) {
            if (currentLatency < this.latencyMax[i]) continue;
            return this.notAvailableDuration[i];
        }
        return 0L;
    }

    public static class BrokerFilter
    implements TopicPublishInfo.QueueFilter {
        private String lastBrokerName;

        public void setLastBrokerName(String lastBrokerName) {
            this.lastBrokerName = lastBrokerName;
        }

        @Override
        public boolean filter(MessageQueue mq) {
            if (this.lastBrokerName != null) {
                return !mq.getBrokerName().equals(this.lastBrokerName);
            }
            return true;
        }
    }
}

