/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.metadata.api;

import java.io.IOException;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;

public class MetadataStoreException
extends IOException {
    public MetadataStoreException(Throwable t) {
        super(t);
    }

    public MetadataStoreException(String msg) {
        super(msg);
    }

    public MetadataStoreException(String msg, Throwable t) {
        super(msg, t);
    }

    public static MetadataStoreException unwrap(Throwable t) {
        if (t instanceof MetadataStoreException) {
            return (MetadataStoreException)t;
        }
        if (t instanceof RuntimeException) {
            throw (RuntimeException)t;
        }
        if (t instanceof InterruptedException) {
            return new MetadataStoreException(t);
        }
        if (!(t instanceof ExecutionException) && !(t instanceof CompletionException)) {
            return new MetadataStoreException(t);
        }
        Throwable cause = t.getCause();
        String msg = cause.getMessage();
        if (cause instanceof NotFoundException) {
            return new NotFoundException(msg);
        }
        if (cause instanceof AlreadyExistsException) {
            return new AlreadyExistsException(msg);
        }
        if (cause instanceof BadVersionException) {
            return new BadVersionException(msg);
        }
        if (cause instanceof ContentDeserializationException) {
            return new ContentDeserializationException(msg);
        }
        if (cause instanceof InvalidImplementationException) {
            return new InvalidImplementationException(msg);
        }
        if (cause instanceof LockBusyException) {
            return new LockBusyException(msg);
        }
        return new MetadataStoreException(t);
    }

    public static MetadataStoreException wrap(Throwable t) {
        if (t instanceof MetadataStoreException) {
            return (MetadataStoreException)t;
        }
        return new MetadataStoreException(t);
    }

    public static class NotFoundException
    extends MetadataStoreException {
        public NotFoundException() {
            super((Throwable)null);
        }

        public NotFoundException(Throwable t) {
            super(t);
        }

        public NotFoundException(String msg) {
            super(msg);
        }
    }

    public static class AlreadyExistsException
    extends MetadataStoreException {
        public AlreadyExistsException(Throwable t) {
            super(t);
        }

        public AlreadyExistsException(String msg) {
            super(msg);
        }
    }

    public static class BadVersionException
    extends MetadataStoreException {
        public BadVersionException(Throwable t) {
            super(t);
        }

        public BadVersionException(String msg) {
            super(msg);
        }
    }

    public static class ContentDeserializationException
    extends MetadataStoreException {
        public ContentDeserializationException(String msg, Throwable t) {
            super(msg, t);
        }

        public ContentDeserializationException(Throwable t) {
            super(t);
        }

        public ContentDeserializationException(String msg) {
            super(msg);
        }
    }

    public static class InvalidImplementationException
    extends MetadataStoreException {
        public InvalidImplementationException() {
            super((Throwable)null);
        }

        public InvalidImplementationException(Throwable t) {
            super(t);
        }

        public InvalidImplementationException(String msg) {
            super(msg);
        }
    }

    public static class LockBusyException
    extends MetadataStoreException {
        public LockBusyException() {
            super((Throwable)null);
        }

        public LockBusyException(Throwable t) {
            super(t);
        }

        public LockBusyException(String msg) {
            super(msg);
        }
    }

    public static class InvalidPathException
    extends MetadataStoreException {
        public InvalidPathException(String path) {
            super("Path(" + path + ") is invalid");
        }
    }

    public static class AlreadyClosedException
    extends MetadataStoreException {
        public AlreadyClosedException(Throwable t) {
            super(t);
        }

        public AlreadyClosedException(String msg) {
            super(msg);
        }
    }
}

