/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.instance;

import java.util.Map;
import java.util.Optional;
import org.apache.pulsar.client.api.Message;
import org.apache.pulsar.client.api.Schema;
import org.apache.pulsar.functions.api.Record;
import org.apache.pulsar.functions.instance.AbstractSinkRecord;

public class OutputRecordSinkRecord<T>
extends AbstractSinkRecord<T> {
    private final Record<T> sinkRecord;

    OutputRecordSinkRecord(Record<T> sourceRecord, Record<T> sinkRecord) {
        super(sourceRecord);
        this.sinkRecord = sinkRecord;
    }

    public Optional<String> getKey() {
        return this.sinkRecord.getKey();
    }

    public T getValue() {
        return (T)this.sinkRecord.getValue();
    }

    public Optional<String> getPartitionId() {
        return this.sinkRecord.getPartitionId();
    }

    public Optional<Integer> getPartitionIndex() {
        return this.sinkRecord.getPartitionIndex();
    }

    public Optional<Long> getRecordSequence() {
        return this.sinkRecord.getRecordSequence();
    }

    public Map<String, String> getProperties() {
        return this.sinkRecord.getProperties();
    }

    public Optional<String> getDestinationTopic() {
        return this.sinkRecord.getDestinationTopic();
    }

    public Schema<T> getSchema() {
        return OutputRecordSinkRecord.getRecordSchema(this.sinkRecord);
    }

    public Optional<Long> getEventTime() {
        return this.sinkRecord.getEventTime();
    }

    public Optional<Message<T>> getMessage() {
        return this.sinkRecord.getMessage();
    }

    @Override
    public boolean shouldAlwaysSetMessageProperties() {
        return true;
    }

    @Override
    public boolean shouldSetSchema() {
        return true;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OutputRecordSinkRecord)) {
            return false;
        }
        OutputRecordSinkRecord other = (OutputRecordSinkRecord)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Record<T> this$sinkRecord = this.sinkRecord;
        Record<T> other$sinkRecord = other.sinkRecord;
        return !(this$sinkRecord == null ? other$sinkRecord != null : !this$sinkRecord.equals(other$sinkRecord));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof OutputRecordSinkRecord;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Record<T> $sinkRecord = this.sinkRecord;
        result = result * 59 + ($sinkRecord == null ? 43 : $sinkRecord.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "OutputRecordSinkRecord(sinkRecord=" + this.sinkRecord + ")";
    }
}

