/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl;

import io.netty.channel.ChannelHandlerContext;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Pattern;
import org.apache.pulsar.client.api.PulsarClientException;
import org.apache.pulsar.client.impl.BackoffBuilder;
import org.apache.pulsar.client.impl.ClientCnx;
import org.apache.pulsar.client.impl.ConnectionHandler;
import org.apache.pulsar.client.impl.HandlerState;
import org.apache.pulsar.client.impl.PatternMultiTopicsConsumerImpl;
import org.apache.pulsar.client.impl.PulsarClientImpl;
import org.apache.pulsar.common.api.proto.BaseCommand;
import org.apache.pulsar.common.api.proto.CommandWatchTopicUpdate;
import org.apache.pulsar.common.naming.NamespaceName;
import org.apache.pulsar.common.protocol.Commands;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TopicListWatcher
extends HandlerState
implements ConnectionHandler.Connection {
    private static final Logger log = LoggerFactory.getLogger(TopicListWatcher.class);
    private static final AtomicLongFieldUpdater<TopicListWatcher> CREATE_WATCHER_DEADLINE_UPDATER = AtomicLongFieldUpdater.newUpdater(TopicListWatcher.class, "createWatcherDeadline");
    private final PatternMultiTopicsConsumerImpl.TopicsChangedListener topicsChangeListener;
    private final String name;
    private final ConnectionHandler connectionHandler;
    private final Pattern topicsPattern;
    private final long watcherId;
    private volatile long createWatcherDeadline = 0L;
    private final NamespaceName namespace;
    private String topicsHash;
    private final CompletableFuture<TopicListWatcher> watcherFuture;
    private final List<Throwable> previousExceptions = new CopyOnWriteArrayList<Throwable>();
    private final AtomicReference<ClientCnx> clientCnxUsedForWatcherRegistration = new AtomicReference();

    public TopicListWatcher(PatternMultiTopicsConsumerImpl.TopicsChangedListener topicsChangeListener, PulsarClientImpl client, Pattern topicsPattern, long watcherId, NamespaceName namespace, String topicsHash, CompletableFuture<TopicListWatcher> watcherFuture) {
        super(client, null);
        this.topicsChangeListener = topicsChangeListener;
        this.name = "Watcher(" + topicsPattern + ")";
        this.connectionHandler = new ConnectionHandler(this, new BackoffBuilder().setInitialTime(client.getConfiguration().getInitialBackoffIntervalNanos(), TimeUnit.NANOSECONDS).setMax(client.getConfiguration().getMaxBackoffIntervalNanos(), TimeUnit.NANOSECONDS).setMandatoryStop(0L, TimeUnit.MILLISECONDS).create(), this);
        this.topicsPattern = topicsPattern;
        this.watcherId = watcherId;
        this.namespace = namespace;
        this.topicsHash = topicsHash;
        this.watcherFuture = watcherFuture;
        this.connectionHandler.grabCnx();
    }

    @Override
    public void connectionFailed(PulsarClientException exception) {
        boolean nonRetriableError;
        boolean bl = nonRetriableError = !PulsarClientException.isRetriableError((Throwable)exception);
        if (nonRetriableError) {
            exception.setPreviousExceptions(this.previousExceptions);
            if (this.watcherFuture.completeExceptionally(exception)) {
                this.setState(HandlerState.State.Failed);
                log.info("[{}] Watcher creation failed for {} with non-retriable error {}", new Object[]{this.topic, this.name, exception});
                this.deregisterFromClientCnx();
            }
        } else {
            this.previousExceptions.add(exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void connectionOpened(ClientCnx cnx) {
        this.previousExceptions.clear();
        if (this.getState() == HandlerState.State.Closing || this.getState() == HandlerState.State.Closed) {
            this.setState(HandlerState.State.Closed);
            this.deregisterFromClientCnx();
            return;
        }
        log.info("[{}][{}] Creating topic list watcher on cnx {}, watcherId {}", new Object[]{this.topic, this.getHandlerName(), cnx.ctx().channel(), this.watcherId});
        long requestId = this.client.newRequestId();
        CREATE_WATCHER_DEADLINE_UPDATER.compareAndSet(this, 0L, System.currentTimeMillis() + this.client.getConfiguration().getOperationTimeoutMs());
        TopicListWatcher topicListWatcher = this;
        synchronized (topicListWatcher) {
            this.setClientCnx(cnx);
            BaseCommand watchRequest = Commands.newWatchTopicList((long)requestId, (long)this.watcherId, (String)this.namespace.toString(), (String)this.topicsPattern.pattern(), (String)this.topicsHash);
            ((CompletableFuture)cnx.newWatchTopicList(watchRequest, requestId).thenAccept(response -> {
                TopicListWatcher topicListWatcher = this;
                synchronized (topicListWatcher) {
                    if (!this.changeToReadyState()) {
                        this.setState(HandlerState.State.Closed);
                        this.deregisterFromClientCnx();
                        cnx.channel().close();
                        return;
                    }
                }
                this.connectionHandler.resetBackoff();
                this.watcherFuture.complete(this);
            })).exceptionally(e -> {
                this.deregisterFromClientCnx();
                if (this.getState() == HandlerState.State.Closing || this.getState() == HandlerState.State.Closed) {
                    cnx.channel().close();
                    return null;
                }
                log.warn("[{}][{}] Failed to subscribe to topic on {}", new Object[]{this.topic, this.getHandlerName(), cnx.channel().remoteAddress()});
                if (e.getCause() instanceof PulsarClientException && PulsarClientException.isRetriableError((Throwable)e.getCause()) && System.currentTimeMillis() < CREATE_WATCHER_DEADLINE_UPDATER.get(this)) {
                    this.reconnectLater(e.getCause());
                } else if (!this.watcherFuture.isDone()) {
                    this.setState(HandlerState.State.Failed);
                    this.watcherFuture.completeExceptionally(PulsarClientException.wrap((Throwable)e, (String)String.format("Failed to create topic list watcher %swhen connecting to the broker", this.getHandlerName())));
                } else {
                    this.reconnectLater(e.getCause());
                }
                return null;
            });
        }
    }

    @Override
    String getHandlerName() {
        return this.name;
    }

    public boolean isConnected() {
        return this.getClientCnx() != null && this.getState() == HandlerState.State.Ready;
    }

    public ClientCnx getClientCnx() {
        return this.connectionHandler.cnx();
    }

    public CompletableFuture<Void> closeAsync() {
        CompletableFuture<Void> closeFuture = new CompletableFuture<Void>();
        if (this.getState() == HandlerState.State.Closing || this.getState() == HandlerState.State.Closed) {
            closeFuture.complete(null);
            return closeFuture;
        }
        if (!this.isConnected()) {
            log.info("[{}] [{}] Closed watcher (not connected)", (Object)this.topic, (Object)this.getHandlerName());
            this.setState(HandlerState.State.Closed);
            this.deregisterFromClientCnx();
            closeFuture.complete(null);
            return closeFuture;
        }
        this.setState(HandlerState.State.Closing);
        long requestId = this.client.newRequestId();
        ClientCnx cnx = this.cnx();
        if (null == cnx) {
            this.cleanupAtClose(closeFuture, null);
        } else {
            BaseCommand cmd = Commands.newWatchTopicListClose((long)this.watcherId, (long)requestId);
            cnx.newWatchTopicListClose(cmd, requestId).handle((v, exception) -> {
                boolean ignoreException;
                ChannelHandlerContext ctx = cnx.ctx();
                boolean bl = ignoreException = ctx == null || !ctx.channel().isActive();
                if (ignoreException && exception != null) {
                    log.debug("Exception ignored in closing watcher", exception);
                }
                this.cleanupAtClose(closeFuture, ignoreException ? null : exception);
                return null;
            });
        }
        return closeFuture;
    }

    ClientCnx cnx() {
        return this.connectionHandler.cnx();
    }

    public void connectionClosed(ClientCnx clientCnx) {
        this.connectionHandler.connectionClosed(clientCnx);
    }

    void setClientCnx(ClientCnx clientCnx) {
        ClientCnx previousClientCnx;
        if (clientCnx != null) {
            this.connectionHandler.setClientCnx(clientCnx);
            clientCnx.registerTopicListWatcher(this.watcherId, this);
        }
        if ((previousClientCnx = this.clientCnxUsedForWatcherRegistration.getAndSet(clientCnx)) != null && previousClientCnx != clientCnx) {
            previousClientCnx.removeTopicListWatcher(this.watcherId);
        }
    }

    void deregisterFromClientCnx() {
        this.setClientCnx(null);
    }

    void reconnectLater(Throwable exception) {
        this.connectionHandler.reconnectLater(exception);
    }

    private void cleanupAtClose(CompletableFuture<Void> closeFuture, Throwable exception) {
        log.info("[{}] Closed topic list watcher", (Object)this.getHandlerName());
        this.setState(HandlerState.State.Closed);
        this.deregisterFromClientCnx();
        if (exception != null) {
            closeFuture.completeExceptionally(exception);
        } else {
            closeFuture.complete(null);
        }
    }

    public void handleCommandWatchTopicUpdate(CommandWatchTopicUpdate update) {
        List added;
        List deleted = update.getDeletedTopicsList();
        if (!deleted.isEmpty()) {
            this.topicsChangeListener.onTopicsRemoved(deleted);
        }
        if (!(added = update.getNewTopicsList()).isEmpty()) {
            this.topicsChangeListener.onTopicsAdded(added);
        }
    }
}

