/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.kafka.compat;

import java.util.Properties;
import org.apache.pulsar.client.api.ProducerBuilder;
import org.apache.pulsar.client.api.PulsarClient;

public class PulsarProducerKafkaConfig {
    public static final String PRODUCER_NAME = "pulsar.producer.name";
    public static final String INITIAL_SEQUENCE_ID = "pulsar.producer.initial.sequence.id";
    public static final String MAX_PENDING_MESSAGES = "pulsar.producer.max.pending.messages";
    public static final String MAX_PENDING_MESSAGES_ACROSS_PARTITIONS = "pulsar.producer.max.pending.messages.across.partitions";
    public static final String BATCHING_ENABLED = "pulsar.producer.batching.enabled";
    public static final String BATCHING_MAX_MESSAGES = "pulsar.producer.batching.max.messages";

    public static ProducerBuilder<byte[]> getProducerBuilder(PulsarClient client, Properties properties) {
        ProducerBuilder producerBuilder = client.newProducer();
        if (properties.containsKey(PRODUCER_NAME)) {
            producerBuilder.producerName(properties.getProperty(PRODUCER_NAME));
        }
        if (properties.containsKey(INITIAL_SEQUENCE_ID)) {
            producerBuilder.initialSequenceId(Long.parseLong(properties.getProperty(INITIAL_SEQUENCE_ID)));
        }
        if (properties.containsKey(MAX_PENDING_MESSAGES)) {
            producerBuilder.maxPendingMessages(Integer.parseInt(properties.getProperty(MAX_PENDING_MESSAGES)));
        }
        if (properties.containsKey(MAX_PENDING_MESSAGES_ACROSS_PARTITIONS)) {
            producerBuilder.maxPendingMessagesAcrossPartitions(Integer.parseInt(properties.getProperty(MAX_PENDING_MESSAGES_ACROSS_PARTITIONS)));
        }
        producerBuilder.enableBatching(Boolean.parseBoolean(properties.getProperty(BATCHING_ENABLED, "true")));
        if (properties.containsKey(BATCHING_MAX_MESSAGES)) {
            producerBuilder.batchingMaxMessages(Integer.parseInt(properties.getProperty(BATCHING_MAX_MESSAGES)));
        }
        return producerBuilder;
    }
}

