/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.kafka.compat;

import java.util.concurrent.ThreadLocalRandom;
import org.apache.pulsar.client.api.HashingScheme;
import org.apache.pulsar.client.api.Message;
import org.apache.pulsar.client.api.TopicMetadata;
import org.apache.pulsar.client.impl.RoundRobinPartitionMessageRouterImpl;

public class KafkaMessageRouter
extends RoundRobinPartitionMessageRouterImpl {
    public static final String PARTITION_ID = "pulsar.partition.id";

    public KafkaMessageRouter(long maxBatchingDelayMs) {
        super(HashingScheme.JavaStringHash, ThreadLocalRandom.current().nextInt(), true, maxBatchingDelayMs);
    }

    public int choosePartition(Message<?> msg, TopicMetadata metadata) {
        if (msg.hasProperty(PARTITION_ID)) {
            return Integer.parseInt(msg.getProperty(PARTITION_ID));
        }
        return super.choosePartition(msg, metadata);
    }
}

