/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.transaction.buffer;

import com.google.common.annotations.Beta;
import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.apache.bookkeeper.mledger.Position;
import org.apache.bookkeeper.mledger.impl.PositionImpl;
import org.apache.pulsar.broker.transaction.buffer.TransactionBufferReader;
import org.apache.pulsar.broker.transaction.buffer.TransactionMeta;
import org.apache.pulsar.client.api.transaction.TxnID;
import org.apache.pulsar.common.policies.data.TransactionBufferStats;
import org.apache.pulsar.common.policies.data.TransactionInBufferStats;

@Beta
public interface TransactionBuffer {
    public CompletableFuture<TransactionMeta> getTransactionMeta(TxnID var1);

    public CompletableFuture<Position> appendBufferToTxn(TxnID var1, long var2, ByteBuf var4);

    public CompletableFuture<TransactionBufferReader> openTransactionBufferReader(TxnID var1, long var2);

    public CompletableFuture<Void> commitTxn(TxnID var1, long var2);

    public CompletableFuture<Void> abortTxn(TxnID var1, long var2);

    public CompletableFuture<Void> purgeTxns(List<Long> var1);

    public CompletableFuture<Void> clearSnapshot();

    public CompletableFuture<Void> closeAsync();

    public boolean isTxnAborted(TxnID var1);

    public void syncMaxReadPositionForNormalPublish(PositionImpl var1);

    public PositionImpl getMaxReadPosition();

    public TransactionInBufferStats getTransactionInBufferStats(TxnID var1);

    public TransactionBufferStats getStats(boolean var1);

    public CompletableFuture<Void> checkIfTBRecoverCompletely(boolean var1);
}

