/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.loadbalance.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.pulsar.broker.ServiceConfiguration;
import org.apache.pulsar.broker.loadbalance.LoadData;
import org.apache.pulsar.broker.loadbalance.ModularLoadManagerStrategy;
import org.apache.pulsar.policies.data.loadbalancer.BrokerData;
import org.apache.pulsar.policies.data.loadbalancer.BundleData;
import org.apache.pulsar.policies.data.loadbalancer.LocalBrokerData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LeastResourceUsageWithWeight
implements ModularLoadManagerStrategy {
    private static final Logger log = LoggerFactory.getLogger(LeastResourceUsageWithWeight.class);
    private static final double MAX_RESOURCE_USAGE = 1.0;
    private final ArrayList<String> bestBrokers = new ArrayList();
    private final Map<String, Double> brokerAvgResourceUsageWithWeight = new HashMap<String, Double>();

    private double getMaxResourceUsageWithWeight(String broker, BrokerData brokerData, ServiceConfiguration conf) {
        double overloadThreshold = (double)conf.getLoadBalancerBrokerOverloadedThresholdPercentage() / 100.0;
        double maxUsageWithWeight = this.updateAndGetMaxResourceUsageWithWeight(broker, brokerData, conf);
        if (maxUsageWithWeight > overloadThreshold) {
            LocalBrokerData localData = brokerData.getLocalData();
            log.warn("Broker {} is overloaded, max resource usage with weight percentage: {}%, CPU: {}%, MEMORY: {}%, DIRECT MEMORY: {}%, BANDWIDTH IN: {}%, BANDWIDTH OUT: {}%, CPU weight: {}, MEMORY weight: {}, DIRECT MEMORY weight: {}, BANDWIDTH IN weight: {}, BANDWIDTH OUT weight: {}", new Object[]{broker, maxUsageWithWeight * 100.0, Float.valueOf(localData.getCpu().percentUsage()), Float.valueOf(localData.getMemory().percentUsage()), Float.valueOf(localData.getDirectMemory().percentUsage()), Float.valueOf(localData.getBandwidthIn().percentUsage()), Float.valueOf(localData.getBandwidthOut().percentUsage()), conf.getLoadBalancerCPUResourceWeight(), conf.getLoadBalancerMemoryResourceWeight(), conf.getLoadBalancerDirectMemoryResourceWeight(), conf.getLoadBalancerBandwithInResourceWeight(), conf.getLoadBalancerBandwithOutResourceWeight()});
        }
        if (log.isDebugEnabled()) {
            log.debug("Broker {} has max resource usage with weight percentage: {}%", (Object)brokerData.getLocalData().getWebServiceUrl(), (Object)(maxUsageWithWeight * 100.0));
        }
        return maxUsageWithWeight;
    }

    private double updateAndGetMaxResourceUsageWithWeight(String broker, BrokerData brokerData, ServiceConfiguration conf) {
        double historyPercentage = conf.getLoadBalancerHistoryResourcePercentage();
        Double historyUsage = this.brokerAvgResourceUsageWithWeight.get(broker);
        double resourceUsage = brokerData.getLocalData().getMaxResourceUsageWithWeight(conf.getLoadBalancerCPUResourceWeight(), conf.getLoadBalancerMemoryResourceWeight(), conf.getLoadBalancerDirectMemoryResourceWeight(), conf.getLoadBalancerBandwithInResourceWeight(), conf.getLoadBalancerBandwithOutResourceWeight());
        historyUsage = historyUsage == null ? resourceUsage : historyUsage * historyPercentage + (1.0 - historyPercentage) * resourceUsage;
        if (log.isDebugEnabled()) {
            log.debug("Broker {} get max resource usage with weight: {}, history resource percentage: {}%, CPU weight: {}, MEMORY weight: {}, DIRECT MEMORY weight: {}, BANDWIDTH IN weight: {}, BANDWIDTH OUT weight: {} ", new Object[]{broker, historyUsage, historyPercentage, conf.getLoadBalancerCPUResourceWeight(), conf.getLoadBalancerMemoryResourceWeight(), conf.getLoadBalancerDirectMemoryResourceWeight(), conf.getLoadBalancerBandwithInResourceWeight(), conf.getLoadBalancerBandwithOutResourceWeight()});
        }
        this.brokerAvgResourceUsageWithWeight.put(broker, historyUsage);
        return historyUsage;
    }

    @Override
    public Optional<String> selectBroker(Set<String> candidates, BundleData bundleToAssign, LoadData loadData, ServiceConfiguration conf) {
        if (candidates.isEmpty()) {
            log.info("There are no available brokers as candidates at this point for bundle: {}", (Object)bundleToAssign);
            return Optional.empty();
        }
        this.bestBrokers.clear();
        double totalUsage = 0.0;
        for (String broker2 : candidates) {
            BrokerData brokerData = loadData.getBrokerData().get(broker2);
            double usageWithWeight = this.getMaxResourceUsageWithWeight(broker2, brokerData, conf);
            totalUsage += usageWithWeight;
        }
        double avgUsage = totalUsage / (double)candidates.size();
        double diffThreshold = (double)conf.getLoadBalancerAverageResourceUsageDifferenceThresholdPercentage() / 100.0;
        candidates.forEach(broker -> {
            Double avgResUsage = this.brokerAvgResourceUsageWithWeight.getOrDefault(broker, 1.0);
            if (avgResUsage + diffThreshold <= avgUsage) {
                this.bestBrokers.add((String)broker);
            }
        });
        if (this.bestBrokers.isEmpty()) {
            log.warn("Assign randomly as all {} brokers are overloaded.", (Object)candidates.size());
            this.bestBrokers.addAll(candidates);
        }
        if (log.isDebugEnabled()) {
            log.debug("Selected {} best brokers: {} from candidate brokers: {}", new Object[]{this.bestBrokers.size(), this.bestBrokers, candidates});
        }
        return Optional.of(this.bestBrokers.get(ThreadLocalRandom.current().nextInt(this.bestBrokers.size())));
    }
}

