/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.delayed;

import com.google.common.base.Preconditions;
import java.io.IOException;
import org.apache.pulsar.broker.ServiceConfiguration;
import org.apache.pulsar.broker.delayed.DelayedDeliveryTrackerFactory;

public final class DelayedDeliveryTrackerLoader {
    public static DelayedDeliveryTrackerFactory loadDelayedDeliveryTrackerFactory(ServiceConfiguration conf) throws IOException {
        try {
            Class<?> factoryClass = Class.forName(conf.getDelayedDeliveryTrackerFactoryClassName());
            Object obj = factoryClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            Preconditions.checkArgument((boolean)(obj instanceof DelayedDeliveryTrackerFactory), (Object)("The factory has to be an instance of " + DelayedDeliveryTrackerFactory.class.getName()));
            DelayedDeliveryTrackerFactory factory = (DelayedDeliveryTrackerFactory)obj;
            factory.initialize(conf);
            return factory;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    private DelayedDeliveryTrackerLoader() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

