/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.admin.v1;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.concurrent.CompletableFuture;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.Suspended;
import javax.ws.rs.core.Response;
import org.apache.pulsar.broker.admin.impl.ResourceQuotasBase;
import org.apache.pulsar.common.policies.data.ResourceQuota;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/resource-quotas")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@Api(value="/resource-quotas", description="Quota admin APIs", tags={"resource-quotas"}, hidden=true)
public class ResourceQuotas
extends ResourceQuotasBase {
    private static final Logger log = LoggerFactory.getLogger(ResourceQuotas.class);

    @GET
    @Path(value="/{property}/{cluster}/{namespace}/{bundle}")
    @ApiOperation(hidden=true, value="Get resource quota of a namespace bundle.")
    @ApiResponses(value={@ApiResponse(code=307, message="Current broker doesn't serve the namespace"), @ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Namespace does not exist")})
    public void getNamespaceBundleResourceQuota(@Suspended AsyncResponse response, @PathParam(value="property") String property, @PathParam(value="cluster") String cluster, @PathParam(value="namespace") String namespace, @PathParam(value="bundle") String bundleRange) {
        this.validateNamespaceName(property, cluster, namespace);
        ((CompletableFuture)this.internalGetNamespaceBundleResourceQuota(bundleRange).thenAccept(arg_0 -> ((AsyncResponse)response).resume(arg_0))).exceptionally(ex -> {
            log.error("[{}] Failed to get namespace bundle resource quota {}", new Object[]{this.clientAppId(), this.namespaceName, ex});
            ResourceQuotas.resumeAsyncResponseExceptionally(response, ex);
            return null;
        });
    }

    @POST
    @Path(value="/{property}/{cluster}/{namespace}/{bundle}")
    @ApiOperation(hidden=true, value="Set resource quota on a namespace.")
    @ApiResponses(value={@ApiResponse(code=307, message="Current broker doesn't serve the namespace"), @ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=409, message="Concurrent modification")})
    public void setNamespaceBundleResourceQuota(@Suspended AsyncResponse response, @PathParam(value="property") String property, @PathParam(value="cluster") String cluster, @PathParam(value="namespace") String namespace, @PathParam(value="bundle") String bundleRange, ResourceQuota quota) {
        this.validateNamespaceName(property, cluster, namespace);
        ((CompletableFuture)this.internalSetNamespaceBundleResourceQuota(bundleRange, quota).thenAccept(__ -> {
            log.info("[{}] Successfully set resource quota for namespace bundle {}", (Object)this.clientAppId(), (Object)bundleRange);
            response.resume((Object)Response.noContent().build());
        })).exceptionally(ex -> {
            log.error("[{}] Failed to set namespace resource quota for bundle {}", new Object[]{this.clientAppId(), bundleRange, ex});
            ResourceQuotas.resumeAsyncResponseExceptionally(response, ex);
            return null;
        });
    }

    @DELETE
    @Path(value="/{property}/{cluster}/{namespace}/{bundle}")
    @ApiOperation(hidden=true, value="Remove resource quota for a namespace.")
    @ApiResponses(value={@ApiResponse(code=307, message="Current broker doesn't serve the namespace"), @ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=409, message="Concurrent modification")})
    public void removeNamespaceBundleResourceQuota(@Suspended AsyncResponse response, @PathParam(value="property") String property, @PathParam(value="cluster") String cluster, @PathParam(value="namespace") String namespace, @PathParam(value="bundle") String bundleRange) {
        this.validateNamespaceName(property, cluster, namespace);
        ((CompletableFuture)this.internalRemoveNamespaceBundleResourceQuota(bundleRange).thenAccept(__ -> {
            log.info("[{}] Successfully remove namespace bundle resource quota {}", (Object)this.clientAppId(), (Object)bundleRange);
            response.resume((Object)Response.noContent().build());
        })).exceptionally(ex -> {
            log.error("[{}] Failed to remove namespace bundle resource quota {}", new Object[]{this.clientAppId(), bundleRange, ex});
            ResourceQuotas.resumeAsyncResponseExceptionally(response, ex);
            return null;
        });
    }
}

