/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.authorization;

import java.io.Closeable;
import java.io.IOException;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.apache.commons.lang3.StringUtils;
import org.apache.pulsar.broker.ServiceConfiguration;
import org.apache.pulsar.broker.authentication.AuthenticationDataSource;
import org.apache.pulsar.broker.cache.ConfigurationCacheService;
import org.apache.pulsar.broker.resources.PulsarResources;
import org.apache.pulsar.common.naming.NamespaceName;
import org.apache.pulsar.common.naming.TopicName;
import org.apache.pulsar.common.policies.data.AuthAction;
import org.apache.pulsar.common.policies.data.NamespaceOperation;
import org.apache.pulsar.common.policies.data.PolicyName;
import org.apache.pulsar.common.policies.data.PolicyOperation;
import org.apache.pulsar.common.policies.data.TenantInfo;
import org.apache.pulsar.common.policies.data.TenantOperation;
import org.apache.pulsar.common.policies.data.TopicOperation;
import org.apache.pulsar.common.util.FutureUtil;
import org.apache.pulsar.common.util.RestException;

public interface AuthorizationProvider
extends Closeable {
    default public CompletableFuture<Boolean> isSuperUser(String role, AuthenticationDataSource authenticationData, ServiceConfiguration serviceConfiguration) {
        Set<String> superUserRoles = serviceConfiguration.getSuperUserRoles();
        return CompletableFuture.completedFuture(role != null && superUserRoles.contains(role));
    }

    @Deprecated
    default public CompletableFuture<Boolean> isSuperUser(String role, ServiceConfiguration serviceConfiguration) {
        Set<String> superUserRoles = serviceConfiguration.getSuperUserRoles();
        return CompletableFuture.completedFuture(role != null && superUserRoles.contains(role));
    }

    default public CompletableFuture<Boolean> isTenantAdmin(String tenant, String role, TenantInfo tenantInfo, AuthenticationDataSource authenticationData) {
        return CompletableFuture.completedFuture(role != null && tenantInfo.getAdminRoles() != null && tenantInfo.getAdminRoles().contains(role));
    }

    @Deprecated
    default public void initialize(ServiceConfiguration conf, ConfigurationCacheService configCache) throws IOException {
    }

    default public void initialize(ServiceConfiguration conf, PulsarResources pulsarResources) throws IOException {
        this.initialize(conf, (ConfigurationCacheService)null);
    }

    public CompletableFuture<Boolean> canProduceAsync(TopicName var1, String var2, AuthenticationDataSource var3);

    public CompletableFuture<Boolean> canConsumeAsync(TopicName var1, String var2, AuthenticationDataSource var3, String var4);

    public CompletableFuture<Boolean> canLookupAsync(TopicName var1, String var2, AuthenticationDataSource var3);

    public CompletableFuture<Boolean> allowFunctionOpsAsync(NamespaceName var1, String var2, AuthenticationDataSource var3);

    public CompletableFuture<Boolean> allowSourceOpsAsync(NamespaceName var1, String var2, AuthenticationDataSource var3);

    public CompletableFuture<Boolean> allowSinkOpsAsync(NamespaceName var1, String var2, AuthenticationDataSource var3);

    public CompletableFuture<Void> grantPermissionAsync(NamespaceName var1, Set<AuthAction> var2, String var3, String var4);

    public CompletableFuture<Void> grantSubscriptionPermissionAsync(NamespaceName var1, String var2, Set<String> var3, String var4);

    public CompletableFuture<Void> revokeSubscriptionPermissionAsync(NamespaceName var1, String var2, String var3, String var4);

    public CompletableFuture<Void> grantPermissionAsync(TopicName var1, Set<AuthAction> var2, String var3, String var4);

    @Deprecated
    default public CompletableFuture<Boolean> allowTenantOperationAsync(String tenantName, String originalRole, String role, TenantOperation operation, AuthenticationDataSource authData) {
        return this.allowTenantOperationAsync(tenantName, StringUtils.isBlank((CharSequence)originalRole) ? role : originalRole, operation, authData);
    }

    @Deprecated
    default public Boolean allowTenantOperation(String tenantName, String originalRole, String role, TenantOperation operation, AuthenticationDataSource authData) {
        try {
            return this.allowTenantOperationAsync(tenantName, originalRole, role, operation, authData).get();
        }
        catch (InterruptedException e) {
            throw new RestException((Throwable)e);
        }
        catch (ExecutionException e) {
            throw new RestException(e.getCause());
        }
    }

    default public CompletableFuture<Boolean> allowTenantOperationAsync(String tenantName, String role, TenantOperation operation, AuthenticationDataSource authData) {
        return FutureUtil.failedFuture((Throwable)new IllegalStateException(String.format("allowTenantOperation(%s) on tenant %s is not supported by the Authorization provider you are using.", operation.toString(), tenantName)));
    }

    default public Boolean allowTenantOperation(String tenantName, String role, TenantOperation operation, AuthenticationDataSource authData) {
        try {
            return this.allowTenantOperationAsync(tenantName, role, operation, authData).get();
        }
        catch (InterruptedException e) {
            throw new RestException((Throwable)e);
        }
        catch (ExecutionException e) {
            throw new RestException(e.getCause());
        }
    }

    default public CompletableFuture<Boolean> allowNamespaceOperationAsync(NamespaceName namespaceName, String role, NamespaceOperation operation, AuthenticationDataSource authData) {
        return FutureUtil.failedFuture((Throwable)new IllegalStateException("NamespaceOperation [" + operation.name() + "] is not supported by the Authorization provider you are using."));
    }

    default public Boolean allowNamespaceOperation(NamespaceName namespaceName, String role, NamespaceOperation operation, AuthenticationDataSource authData) {
        try {
            return this.allowNamespaceOperationAsync(namespaceName, role, operation, authData).get();
        }
        catch (InterruptedException e) {
            throw new RestException((Throwable)e);
        }
        catch (ExecutionException e) {
            throw new RestException(e.getCause());
        }
    }

    @Deprecated
    default public CompletableFuture<Boolean> allowNamespaceOperationAsync(NamespaceName namespaceName, String originalRole, String role, NamespaceOperation operation, AuthenticationDataSource authData) {
        return this.allowNamespaceOperationAsync(namespaceName, StringUtils.isBlank((CharSequence)originalRole) ? role : originalRole, operation, authData);
    }

    @Deprecated
    default public Boolean allowNamespaceOperation(NamespaceName namespaceName, String originalRole, String role, NamespaceOperation operation, AuthenticationDataSource authData) {
        try {
            return this.allowNamespaceOperationAsync(namespaceName, originalRole, role, operation, authData).get();
        }
        catch (InterruptedException e) {
            throw new RestException((Throwable)e);
        }
        catch (ExecutionException e) {
            throw new RestException(e.getCause());
        }
    }

    default public CompletableFuture<Boolean> allowNamespacePolicyOperationAsync(NamespaceName namespaceName, PolicyName policy, PolicyOperation operation, String role, AuthenticationDataSource authData) {
        return FutureUtil.failedFuture((Throwable)new IllegalStateException("NamespacePolicyOperation  [" + policy.name() + "/" + operation.name() + "] is not supported by is not supported by the Authorization provider you are using."));
    }

    default public Boolean allowNamespacePolicyOperation(NamespaceName namespaceName, PolicyName policy, PolicyOperation operation, String role, AuthenticationDataSource authData) {
        try {
            return this.allowNamespacePolicyOperationAsync(namespaceName, policy, operation, role, authData).get();
        }
        catch (InterruptedException e) {
            throw new RestException((Throwable)e);
        }
        catch (ExecutionException e) {
            throw new RestException(e.getCause());
        }
    }

    @Deprecated
    default public CompletableFuture<Boolean> allowNamespacePolicyOperationAsync(NamespaceName namespaceName, PolicyName policy, PolicyOperation operation, String originalRole, String role, AuthenticationDataSource authData) {
        return this.allowNamespacePolicyOperationAsync(namespaceName, policy, operation, StringUtils.isBlank((CharSequence)originalRole) ? role : originalRole, authData);
    }

    @Deprecated
    default public Boolean allowNamespacePolicyOperation(NamespaceName namespaceName, PolicyName policy, PolicyOperation operation, String originalRole, String role, AuthenticationDataSource authData) {
        try {
            return this.allowNamespacePolicyOperationAsync(namespaceName, policy, operation, originalRole, role, authData).get();
        }
        catch (InterruptedException e) {
            throw new RestException((Throwable)e);
        }
        catch (ExecutionException e) {
            throw new RestException(e.getCause());
        }
    }

    default public CompletableFuture<Boolean> allowTopicOperationAsync(TopicName topic, String role, TopicOperation operation, AuthenticationDataSource authData) {
        return FutureUtil.failedFuture((Throwable)new IllegalStateException("TopicOperation [" + operation.name() + "] is not supported by the Authorizationprovider you are using."));
    }

    default public Boolean allowTopicOperation(TopicName topicName, String role, TopicOperation operation, AuthenticationDataSource authData) {
        try {
            return this.allowTopicOperationAsync(topicName, role, operation, authData).get();
        }
        catch (InterruptedException e) {
            throw new RestException((Throwable)e);
        }
        catch (ExecutionException e) {
            throw new RestException(e.getCause());
        }
    }

    @Deprecated
    default public CompletableFuture<Boolean> allowTopicOperationAsync(TopicName topic, String originalRole, String role, TopicOperation operation, AuthenticationDataSource authData) {
        return this.allowTopicOperationAsync(topic, StringUtils.isBlank((CharSequence)originalRole) ? role : originalRole, operation, authData);
    }

    @Deprecated
    default public Boolean allowTopicOperation(TopicName topicName, String originalRole, String role, TopicOperation operation, AuthenticationDataSource authData) {
        try {
            return this.allowTopicOperationAsync(topicName, originalRole, role, operation, authData).get();
        }
        catch (InterruptedException e) {
            throw new RestException((Throwable)e);
        }
        catch (ExecutionException e) {
            throw new RestException(e.getCause());
        }
    }

    default public CompletableFuture<Boolean> allowTopicPolicyOperationAsync(TopicName topic, String role, PolicyName policy, PolicyOperation operation, AuthenticationDataSource authData) {
        return FutureUtil.failedFuture((Throwable)new IllegalStateException("TopicPolicyOperation [" + policy.name() + "/" + operation.name() + "] is not supported by the Authorization provider you are using."));
    }

    default public Boolean allowTopicPolicyOperation(TopicName topicName, String role, PolicyName policy, PolicyOperation operation, AuthenticationDataSource authData) {
        try {
            return this.allowTopicPolicyOperationAsync(topicName, role, policy, operation, authData).get();
        }
        catch (InterruptedException e) {
            throw new RestException((Throwable)e);
        }
        catch (ExecutionException e) {
            throw new RestException(e.getCause());
        }
    }
}

