/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hslf.record;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.poi.hslf.record.RecordAtom;
import org.apache.poi.hslf.record.RecordTypes;
import org.apache.poi.util.LittleEndian;

public class ExObjListAtom
extends RecordAtom {
    private byte[] _header = new byte[8];
    private byte[] _data;

    protected ExObjListAtom() {
        this._data = new byte[4];
        LittleEndian.putShort((byte[])this._header, (int)2, (short)((short)this.getRecordType()));
        LittleEndian.putInt((byte[])this._header, (int)4, (int)this._data.length);
    }

    protected ExObjListAtom(byte[] source, int start, int len) {
        System.arraycopy(source, start, this._header, 0, 8);
        this._data = new byte[len - 8];
        System.arraycopy(source, start + 8, this._data, 0, len - 8);
        if (this._data.length < 4) {
            throw new IllegalArgumentException("The length of the data for a ExObjListAtom must be at least 4 bytes, but was only " + this._data.length);
        }
    }

    public long getObjectIDSeed() {
        return LittleEndian.getUInt((byte[])this._data, (int)0);
    }

    public void setObjectIDSeed(int seed) {
        LittleEndian.putInt((byte[])this._data, (int)0, (int)seed);
    }

    @Override
    public long getRecordType() {
        return RecordTypes.ExObjListAtom.typeID;
    }

    @Override
    public void writeOut(OutputStream out) throws IOException {
        out.write(this._header);
        out.write(this._data);
    }
}

