/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.model.fileset.mappers;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.shared.model.fileset.mappers.FileNameMapper;

public class RegexpPatternMapper
implements FileNameMapper {
    private Pattern fromPattern;
    private String toReplaceExpression;

    @Override
    public void setFrom(String from) {
        this.fromPattern = Pattern.compile(from);
    }

    @Override
    public void setTo(String to) {
        this.toReplaceExpression = to;
    }

    @Override
    public String mapFileName(String sourceFileName) {
        Matcher matcher = this.fromPattern.matcher(sourceFileName);
        if (!matcher.find()) {
            return sourceFileName;
        }
        return matcher.replaceFirst(this.toReplaceExpression);
    }
}

