/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.perforce.command.changelog;

import java.io.File;
import java.util.Date;
import org.apache.maven.scm.ScmBranch;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.command.changelog.AbstractChangeLogCommand;
import org.apache.maven.scm.command.changelog.ChangeLogScmResult;
import org.apache.maven.scm.command.changelog.ChangeLogSet;
import org.apache.maven.scm.provider.ScmProviderRepository;
import org.apache.maven.scm.provider.perforce.PerforceScmProvider;
import org.apache.maven.scm.provider.perforce.command.PerforceCommand;
import org.apache.maven.scm.provider.perforce.command.changelog.PerforceChangeLogConsumer;
import org.apache.maven.scm.provider.perforce.repository.PerforceScmProviderRepository;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.StreamConsumer;

public class PerforceChangeLogCommand
extends AbstractChangeLogCommand
implements PerforceCommand {
    protected ChangeLogScmResult executeChangeLogCommand(ScmProviderRepository repo, ScmFileSet fileSet, Date startDate, Date endDate, ScmBranch branch, String datePattern) throws ScmException {
        PerforceChangeLogConsumer consumer;
        Commandline cl;
        block5: {
            if (branch != null && StringUtils.isNotEmpty((String)branch.getName())) {
                throw new ScmException("This SCM doesn't support branches.");
            }
            PerforceScmProviderRepository p4repo = (PerforceScmProviderRepository)repo;
            String clientspec = PerforceScmProvider.getClientspecName(this.getLogger(), p4repo, fileSet.getBasedir());
            cl = PerforceChangeLogCommand.createCommandLine(p4repo, fileSet.getBasedir(), clientspec);
            String location = PerforceScmProvider.getRepoPath(this.getLogger(), p4repo, fileSet.getBasedir());
            consumer = new PerforceChangeLogConsumer(location, startDate, endDate, datePattern, this.getLogger());
            try {
                CommandLineUtils.StringStreamConsumer err;
                int exitCode;
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug(PerforceScmProvider.clean("Executing " + cl.toString()));
                }
                if ((exitCode = CommandLineUtils.executeCommandLine((Commandline)cl, (StreamConsumer)consumer, (StreamConsumer)(err = new CommandLineUtils.StringStreamConsumer()))) != 0) {
                    String cmdLine = CommandLineUtils.toString((String[])cl.getCommandline());
                    StringBuffer msg = new StringBuffer("Exit code: " + exitCode + " - " + err.getOutput());
                    msg.append('\n');
                    msg.append("Command line was:" + cmdLine);
                    throw new CommandLineException(msg.toString());
                }
            }
            catch (CommandLineException e) {
                if (!this.getLogger().isErrorEnabled()) break block5;
                this.getLogger().error("CommandLineException " + e.getMessage(), (Throwable)e);
            }
        }
        return new ChangeLogScmResult(cl.toString(), new ChangeLogSet(consumer.getModifications(), startDate, endDate));
    }

    public static Commandline createCommandLine(PerforceScmProviderRepository repo, File workingDirectory, String clientspec) {
        Commandline command = PerforceScmProvider.createP4Command(repo, workingDirectory);
        if (clientspec != null) {
            command.createArg().setValue("-c");
            command.createArg().setValue(clientspec);
        }
        command.createArg().setValue("filelog");
        command.createArg().setValue("-t");
        command.createArg().setValue("-l");
        command.createArg().setValue("...");
        return command;
    }
}

