/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.surefire;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolutionResult;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.artifact.resolver.filter.ExcludesArtifactFilter;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.surefire.booter.ForkConfiguration;
import org.apache.maven.surefire.booter.SurefireBooter;
import org.apache.maven.surefire.booter.SurefireBooterForkException;
import org.apache.maven.surefire.booter.SurefireExecutionException;
import org.codehaus.plexus.util.StringUtils;

public class SurefirePlugin
extends AbstractMojo {
    private boolean skip;
    private boolean skipExec;
    private boolean testFailureIgnore;
    private File basedir;
    private File classesDirectory;
    private File testClassesDirectory;
    private List classpathElements;
    private File reportsDirectory;
    private File testSourceDirectory;
    private String test;
    private List includes;
    private List excludes;
    private ArtifactRepository localRepository;
    private Properties systemProperties;
    private Map pluginArtifactMap;
    private Map projectArtifactMap;
    private boolean printSummary;
    private String reportFormat;
    private boolean useFile;
    private boolean redirectTestOutputToFile;
    private String forkMode;
    private String jvm;
    private String argLine;
    private Map environmentVariables = new HashMap();
    private File workingDirectory;
    private boolean childDelegation;
    private String groups;
    private String excludedGroups;
    private File[] suiteXmlFiles;
    private int threadCount;
    private boolean parallel;
    private boolean trimStackTrace;
    private ArtifactResolver artifactResolver;
    private ArtifactFactory artifactFactory;
    private List remoteRepositories;
    private ArtifactMetadataSource metadataSource;
    private static final String BRIEF_REPORT_FORMAT = "brief";
    private static final String PLAIN_REPORT_FORMAT = "plain";
    private Properties originalSystemProperties;
    private boolean disableXmlReport;
    private boolean useSystemClassLoader;
    static /* synthetic */ Class class$org$apache$maven$surefire$report$ForkingConsoleReporter;
    static /* synthetic */ Class class$org$apache$maven$surefire$report$ConsoleReporter;
    static /* synthetic */ Class class$org$apache$maven$surefire$report$BriefFileReporter;
    static /* synthetic */ Class class$org$apache$maven$surefire$report$FileReporter;
    static /* synthetic */ Class class$org$apache$maven$surefire$report$BriefConsoleReporter;
    static /* synthetic */ Class class$org$apache$maven$surefire$report$DetailedConsoleReporter;
    static /* synthetic */ Class class$org$apache$maven$surefire$report$XMLReporter;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.verifyParameters()) {
            boolean success;
            SurefireBooter surefireBooter = this.constructSurefireBooter();
            this.getLog().info((CharSequence)("Surefire report directory: " + this.reportsDirectory));
            try {
                success = surefireBooter.run();
            }
            catch (SurefireBooterForkException e) {
                throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
            }
            catch (SurefireExecutionException e) {
                throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
            }
            if (this.originalSystemProperties != null) {
                System.setProperties(this.originalSystemProperties);
            }
            if (!success) {
                String msg = "There are test failures.";
                if (this.testFailureIgnore) {
                    this.getLog().error((CharSequence)msg);
                } else {
                    throw new MojoFailureException(msg);
                }
            }
        }
    }

    private boolean verifyParameters() throws MojoFailureException {
        if (this.skip || this.skipExec) {
            this.getLog().info((CharSequence)"Tests are skipped.");
            return false;
        }
        if (!this.testClassesDirectory.exists()) {
            this.getLog().info((CharSequence)"No tests to run.");
            return false;
        }
        if (this.parallel && this.threadCount < 1) {
            throw new MojoFailureException("Must have at least one thread in parallel mode");
        }
        if (this.useSystemClassLoader && "never".equals(this.forkMode)) {
            this.getLog().warn((CharSequence)"useSystemClassloader=true setting has no effect when not forking");
        }
        return true;
    }

    private SurefireBooter constructSurefireBooter() throws MojoExecutionException, MojoFailureException {
        Artifact testNgArtifact;
        Artifact junitArtifact;
        SurefireBooter surefireBooter = new SurefireBooter();
        Artifact surefireArtifact = (Artifact)this.pluginArtifactMap.get("org.apache.maven.surefire:surefire-booter");
        if (surefireArtifact == null) {
            throw new MojoExecutionException("Unable to locate surefire-booter in the list of plugin artifacts");
        }
        surefireArtifact.isSnapshot();
        try {
            this.addArtifact(surefireBooter, surefireArtifact);
            junitArtifact = (Artifact)this.projectArtifactMap.get("junit:junit");
            testNgArtifact = (Artifact)this.projectArtifactMap.get("org.testng:testng");
            if (testNgArtifact != null) {
                this.addArtifact(surefireBooter, testNgArtifact);
                VersionRange range = VersionRange.createFromVersionSpec((String)"[4.7,)");
                if (!range.containsVersion(testNgArtifact.getSelectedVersion())) {
                    throw new MojoFailureException("TestNG support requires version 4.7 or above. You have declared version " + testNgArtifact.getVersion());
                }
                this.addProvider(surefireBooter, "surefire-testng", surefireArtifact.getBaseVersion(), testNgArtifact);
            } else if (junitArtifact != null && junitArtifact.getBaseVersion().startsWith("4")) {
                this.addProvider(surefireBooter, "surefire-junit4", surefireArtifact.getBaseVersion(), null);
            } else {
                this.addProvider(surefireBooter, "surefire-junit", surefireArtifact.getBaseVersion(), null);
            }
        }
        catch (ArtifactNotFoundException e) {
            throw new MojoExecutionException("Unable to locate required surefire provider dependency: " + e.getMessage(), (Exception)((Object)e));
        }
        catch (InvalidVersionSpecificationException e) {
            throw new MojoExecutionException("Error determining the TestNG version requested: " + e.getMessage(), (Exception)((Object)e));
        }
        catch (ArtifactResolutionException e) {
            throw new MojoExecutionException("Error to resolving surefire provider dependency: " + e.getMessage(), (Exception)((Object)e));
        }
        if (this.suiteXmlFiles != null && this.suiteXmlFiles.length > 0) {
            if (testNgArtifact == null) {
                throw new MojoExecutionException("suiteXmlFiles is configured, but there is no TestNG dependency");
            }
            for (int i = 0; i < this.suiteXmlFiles.length; ++i) {
                File file = this.suiteXmlFiles[i];
                if (!file.exists()) continue;
                surefireBooter.addTestSuite("org.apache.maven.surefire.testng.TestNGXmlTestSuite", new Object[]{file, this.testSourceDirectory.getAbsolutePath()});
            }
        } else {
            ArrayList<Object> excludes;
            ArrayList<String> includes;
            if (this.test != null) {
                includes = new ArrayList<String>();
                excludes = new ArrayList();
                String[] testRegexes = StringUtils.split((String)this.test, (String)",");
                for (int i = 0; i < testRegexes.length; ++i) {
                    includes.add("**/" + testRegexes[i] + ".java");
                }
            } else {
                includes = this.includes;
                excludes = this.excludes;
                if (includes == null || includes.size() == 0) {
                    includes = new ArrayList<String>(Arrays.asList("**/Test*.java", "**/*Test.java", "**/*TestCase.java"));
                }
                if (excludes == null || excludes.size() == 0) {
                    excludes = new ArrayList<String>(Arrays.asList("**/Abstract*Test.java", "**/Abstract*TestCase.java", "**/*$*"));
                }
            }
            if (testNgArtifact != null) {
                surefireBooter.addTestSuite("org.apache.maven.surefire.testng.TestNGDirectoryTestSuite", new Object[]{this.testClassesDirectory, includes, excludes, this.groups, this.excludedGroups, this.parallel, new Integer(this.threadCount), this.testSourceDirectory.getAbsolutePath()});
            } else {
                String junitDirectoryTestSuite = junitArtifact.getBaseVersion().startsWith("4") ? "org.apache.maven.surefire.junit4.JUnit4DirectoryTestSuite" : "org.apache.maven.surefire.junit.JUnitDirectoryTestSuite";
                surefireBooter.addTestSuite(junitDirectoryTestSuite, new Object[]{this.testClassesDirectory, includes, excludes});
            }
        }
        this.getLog().debug((CharSequence)"Test Classpath :");
        Iterator i = this.classpathElements.iterator();
        while (i.hasNext()) {
            String classpathElement = (String)i.next();
            this.getLog().debug((CharSequence)("  " + classpathElement));
            surefireBooter.addClassPathUrl(classpathElement);
        }
        ForkConfiguration fork = new ForkConfiguration();
        fork.setForkMode(this.forkMode);
        this.processSystemProperties(!fork.isForking());
        if (this.getLog().isDebugEnabled()) {
            this.showMap(this.systemProperties, "system property");
        }
        if (fork.isForking()) {
            fork.setSystemProperties(this.systemProperties);
            if (this.jvm == null || "".equals(this.jvm)) {
                this.jvm = System.getProperty("java.home") + File.separator + "bin" + File.separator + "java";
                this.getLog().debug((CharSequence)("Using JVM: " + this.jvm));
            }
            fork.setJvmExecutable(this.jvm);
            if (this.workingDirectory != null) {
                fork.setWorkingDirectory(this.workingDirectory);
            } else {
                fork.setWorkingDirectory(this.basedir);
            }
            fork.setArgLine(this.argLine);
            fork.setEnvironmentVariables(this.environmentVariables);
            if (this.getLog().isDebugEnabled()) {
                this.showMap(this.environmentVariables, "environment variable");
                fork.setDebug(true);
            }
        }
        surefireBooter.setRedirectTestOutputToFile(this.redirectTestOutputToFile);
        surefireBooter.setForkConfiguration(fork);
        surefireBooter.setChildDelegation(this.childDelegation);
        surefireBooter.setReportsDirectory(this.reportsDirectory);
        surefireBooter.setUseSystemClassLoader(this.useSystemClassLoader);
        this.addReporters(surefireBooter, fork.isForking());
        return surefireBooter;
    }

    private void showMap(Map map, String setting) {
        Iterator i = map.keySet().iterator();
        while (i.hasNext()) {
            String key = (String)i.next();
            String value = (String)map.get(key);
            this.getLog().debug((CharSequence)("Setting " + setting + " [" + key + "]=[" + value + "]"));
        }
    }

    private void addProvider(SurefireBooter surefireBooter, String provider, String version, Artifact filteredArtifact) throws ArtifactNotFoundException, ArtifactResolutionException {
        Artifact providerArtifact = this.artifactFactory.createDependencyArtifact("org.apache.maven.surefire", provider, VersionRange.createFromVersion((String)version), "jar", null, "test");
        ArtifactResolutionResult result = this.resolveArtifact(filteredArtifact, providerArtifact);
        Iterator i = result.getArtifacts().iterator();
        while (i.hasNext()) {
            Artifact artifact = (Artifact)i.next();
            this.getLog().debug((CharSequence)("Adding to surefire test classpath: " + artifact.getFile().getAbsolutePath()));
            surefireBooter.addSurefireClassPathUrl(artifact.getFile().getAbsolutePath());
        }
    }

    private ArtifactResolutionResult resolveArtifact(Artifact filteredArtifact, Artifact providerArtifact) throws ArtifactResolutionException, ArtifactNotFoundException {
        ExcludesArtifactFilter filter = null;
        if (filteredArtifact != null) {
            filter = new ExcludesArtifactFilter(Collections.singletonList(filteredArtifact.getGroupId() + ":" + filteredArtifact.getArtifactId()));
        }
        Artifact originatingArtifact = this.artifactFactory.createBuildArtifact("dummy", "dummy", "1.0", "jar");
        return this.artifactResolver.resolveTransitively(Collections.singleton(providerArtifact), originatingArtifact, this.localRepository, this.remoteRepositories, this.metadataSource, (ArtifactFilter)filter);
    }

    private void addArtifact(SurefireBooter surefireBooter, Artifact surefireArtifact) throws ArtifactNotFoundException, ArtifactResolutionException {
        ArtifactResolutionResult result = this.resolveArtifact(null, surefireArtifact);
        Iterator i = result.getArtifacts().iterator();
        while (i.hasNext()) {
            Artifact artifact = (Artifact)i.next();
            this.getLog().debug((CharSequence)("Adding to surefire booter test classpath: " + artifact.getFile().getAbsolutePath()));
            surefireBooter.addSurefireBootClassPathUrl(artifact.getFile().getAbsolutePath());
        }
    }

    protected void processSystemProperties(boolean setInSystem) {
        if (this.systemProperties == null) {
            this.systemProperties = new Properties();
        }
        this.originalSystemProperties = (Properties)System.getProperties().clone();
        this.systemProperties.setProperty("basedir", this.basedir.getAbsolutePath());
        this.systemProperties.setProperty("localRepository", this.localRepository.getBasedir());
        if (setInSystem) {
            Iterator<Object> iter = this.systemProperties.keySet().iterator();
            while (iter.hasNext()) {
                String key = (String)iter.next();
                String value = this.systemProperties.getProperty(key);
                System.setProperty(key, value);
            }
        }
    }

    private void addReporters(SurefireBooter surefireBooter, boolean forking) {
        Boolean trimStackTrace = this.trimStackTrace;
        if (this.useFile) {
            if (this.printSummary) {
                if (forking) {
                    surefireBooter.addReport((class$org$apache$maven$surefire$report$ForkingConsoleReporter == null ? (class$org$apache$maven$surefire$report$ForkingConsoleReporter = SurefirePlugin.class$("org.apache.maven.surefire.report.ForkingConsoleReporter")) : class$org$apache$maven$surefire$report$ForkingConsoleReporter).getName(), new Object[]{trimStackTrace});
                } else {
                    surefireBooter.addReport((class$org$apache$maven$surefire$report$ConsoleReporter == null ? (class$org$apache$maven$surefire$report$ConsoleReporter = SurefirePlugin.class$("org.apache.maven.surefire.report.ConsoleReporter")) : class$org$apache$maven$surefire$report$ConsoleReporter).getName(), new Object[]{trimStackTrace});
                }
            }
            if (BRIEF_REPORT_FORMAT.equals(this.reportFormat)) {
                surefireBooter.addReport((class$org$apache$maven$surefire$report$BriefFileReporter == null ? (class$org$apache$maven$surefire$report$BriefFileReporter = SurefirePlugin.class$("org.apache.maven.surefire.report.BriefFileReporter")) : class$org$apache$maven$surefire$report$BriefFileReporter).getName(), new Object[]{this.reportsDirectory, trimStackTrace});
            } else if (PLAIN_REPORT_FORMAT.equals(this.reportFormat)) {
                surefireBooter.addReport((class$org$apache$maven$surefire$report$FileReporter == null ? (class$org$apache$maven$surefire$report$FileReporter = SurefirePlugin.class$("org.apache.maven.surefire.report.FileReporter")) : class$org$apache$maven$surefire$report$FileReporter).getName(), new Object[]{this.reportsDirectory, trimStackTrace});
            }
        } else if (BRIEF_REPORT_FORMAT.equals(this.reportFormat)) {
            surefireBooter.addReport((class$org$apache$maven$surefire$report$BriefConsoleReporter == null ? (class$org$apache$maven$surefire$report$BriefConsoleReporter = SurefirePlugin.class$("org.apache.maven.surefire.report.BriefConsoleReporter")) : class$org$apache$maven$surefire$report$BriefConsoleReporter).getName(), new Object[]{trimStackTrace});
        } else if (PLAIN_REPORT_FORMAT.equals(this.reportFormat)) {
            surefireBooter.addReport((class$org$apache$maven$surefire$report$DetailedConsoleReporter == null ? (class$org$apache$maven$surefire$report$DetailedConsoleReporter = SurefirePlugin.class$("org.apache.maven.surefire.report.DetailedConsoleReporter")) : class$org$apache$maven$surefire$report$DetailedConsoleReporter).getName(), new Object[]{trimStackTrace});
        }
        if (!this.disableXmlReport) {
            surefireBooter.addReport((class$org$apache$maven$surefire$report$XMLReporter == null ? (class$org$apache$maven$surefire$report$XMLReporter = SurefirePlugin.class$("org.apache.maven.surefire.report.XMLReporter")) : class$org$apache$maven$surefire$report$XMLReporter).getName(), new Object[]{this.reportsDirectory, trimStackTrace});
        }
    }

    public boolean isSkipExec() {
        return this.skipExec;
    }

    public void setSkipExec(boolean skipExec) {
        this.skipExec = skipExec;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

