/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.report.projectinfo.dependencies;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.shared.dependency.tree.DependencyNode;
import org.apache.maven.shared.dependency.tree.traversal.DependencyNodeVisitor;

public class DependencyVersionMap
implements DependencyNodeVisitor {
    private boolean uniqueVersions;
    private Map<String, List<DependencyNode>> idsToNode = new HashMap<String, List<DependencyNode>>();

    public void setUniqueVersions(boolean uniqueVersions) {
        this.uniqueVersions = uniqueVersions;
    }

    public boolean visit(DependencyNode node) {
        this.addDependency(node);
        return !this.containsConflicts(node);
    }

    public boolean endVisit(DependencyNode node) {
        return true;
    }

    public List<List<DependencyNode>> getConflictedVersionNumbers() {
        ArrayList<List<DependencyNode>> output = new ArrayList<List<DependencyNode>>();
        for (List<DependencyNode> nodes : this.idsToNode.values()) {
            if (!this.containsConflicts(nodes)) continue;
            output.add(nodes);
        }
        return output;
    }

    private void addDependency(DependencyNode node) {
        String key = this.constructKey(node);
        List<DependencyNode> nodes = this.idsToNode.get(key);
        if (nodes == null) {
            nodes = new ArrayList<DependencyNode>();
            this.idsToNode.put(key, nodes);
        }
        nodes.add(node);
    }

    private String constructKey(DependencyNode node) {
        return this.constructKey(node.getArtifact());
    }

    private String constructKey(Artifact artifact) {
        return artifact.getGroupId() + ":" + artifact.getArtifactId();
    }

    private String getVersion(Artifact artifact) {
        return this.uniqueVersions ? artifact.getVersion() : artifact.getBaseVersion();
    }

    private boolean containsConflicts(DependencyNode node) {
        return this.containsConflicts(node.getArtifact());
    }

    private boolean containsConflicts(Artifact artifact) {
        return this.containsConflicts(this.idsToNode.get(this.constructKey(artifact)));
    }

    private boolean containsConflicts(List<DependencyNode> nodes) {
        String version = null;
        for (DependencyNode node : nodes) {
            if (version == null) {
                version = this.getVersion(node.getArtifact());
                continue;
            }
            if (version.compareTo(this.getVersion(node.getArtifact())) == 0) continue;
            return true;
        }
        return false;
    }
}

