/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.jxr;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.maven.plugin.jxr.AbstractJxrReport;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Mojo(name="test-jxr")
public class JxrTestReport
extends AbstractJxrReport {
    @Parameter(defaultValue="${project.testCompileSourceRoots}", required=true, readonly=true)
    private List<String> sourceDirs;
    @Parameter(defaultValue="${project.reporting.outputDirectory}/xref-test")
    private String destDir;
    @Parameter(defaultValue="${project.reporting.outputDirectory}/testapidocs")
    private File testJavadocDir;

    @Override
    protected List<String> getSourceRoots() {
        ArrayList<String> l = new ArrayList<String>();
        if (!"pom".equals(this.getProject().getPackaging().toLowerCase())) {
            l.addAll(this.sourceDirs);
        }
        if (this.getProject().getExecutionProject() != null && !"pom".equals(this.getProject().getExecutionProject().getPackaging().toLowerCase())) {
            l.addAll(this.getProject().getExecutionProject().getTestCompileSourceRoots());
        }
        return l;
    }

    @Override
    protected List<String> getSourceRoots(MavenProject project) {
        ArrayList<String> l = new ArrayList<String>();
        if (project.getExecutionProject() != null && !"pom".equals(project.getExecutionProject().getPackaging().toLowerCase())) {
            l.addAll(project.getExecutionProject().getTestCompileSourceRoots());
        }
        return l;
    }

    @Override
    protected String getDestinationDirectory() {
        return this.destDir;
    }

    public String getDescription(Locale locale) {
        return this.getBundle(locale).getString("report.xref.test.description");
    }

    public String getName(Locale locale) {
        return this.getBundle(locale).getString("report.xref.test.name");
    }

    public String getOutputName() {
        return "xref-test/index";
    }

    @Override
    protected File getJavadocDir() {
        return this.testJavadocDir;
    }

    public void setReportOutputDirectory(File reportOutputDirectory) {
        this.destDir = reportOutputDirectory != null && !reportOutputDirectory.getAbsolutePath().endsWith("xref-test") ? new File(reportOutputDirectory, "xref-test").getAbsolutePath() : reportOutputDirectory.getAbsolutePath();
    }
}

