/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.javadoc;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.apache.maven.archiver.MavenArchiveConfiguration;
import org.apache.maven.archiver.MavenArchiver;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.javadoc.AbstractJavadocMojo;
import org.apache.maven.project.MavenProjectHelper;
import org.apache.maven.reporting.MavenReportException;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.jar.JarArchiver;
import org.codehaus.plexus.archiver.jar.ManifestException;

public class JavadocJar
extends AbstractJavadocMojo {
    private static final String[] DEFAULT_INCLUDES = new String[]{"**/**"};
    private static final String[] DEFAULT_EXCLUDES = new String[]{DEBUG_JAVADOC_SCRIPT_NAME, "options", "packages", "argfile", "files"};
    private MavenProjectHelper projectHelper;
    private JarArchiver jarArchiver;
    private File destDir;
    private String jarOutputDirectory;
    private String finalName;
    private boolean attach;
    private MavenArchiveConfiguration archive = new MavenArchiveConfiguration();
    private File defaultManifestFile;
    private boolean useDefaultManifestFile;

    public void execute() throws MojoExecutionException {
        ArtifactHandler artifactHandler;
        if (this.skip) {
            this.getLog().info((CharSequence)"Skipping javadoc generation");
            return;
        }
        File innerDestDir = this.destDir;
        if (innerDestDir == null) {
            innerDestDir = new File(this.getOutputDirectory());
        }
        if (!("pom".equals(this.project.getPackaging().toLowerCase(Locale.ENGLISH)) && this.isAggregator() || "java".equals((artifactHandler = this.project.getArtifact().getArtifactHandler()).getLanguage()))) {
            if (this.getLog().isInfoEnabled()) {
                this.getLog().info((CharSequence)"Not executing Javadoc as the project is not a Java classpath-capable package");
            }
            return;
        }
        try {
            this.executeReport(Locale.getDefault());
            if (innerDestDir.exists()) {
                File outputFile = this.generateArchive(innerDestDir, this.finalName + "-" + this.getClassifier() + ".jar");
                if (!this.attach) {
                    if (this.getLog().isInfoEnabled()) {
                        this.getLog().info((CharSequence)"NOT adding javadoc to attached artifacts list.");
                    }
                } else {
                    this.projectHelper.attachArtifact(this.project, "javadoc", this.getClassifier(), outputFile);
                }
            }
        }
        catch (ArchiverException e) {
            if (this.failOnError) {
                throw new MojoExecutionException("ArchiverException: Error while creating archive:" + e.getMessage(), (Exception)((Object)e));
            }
            this.getLog().error((CharSequence)("ArchiverException: Error while creating archive:" + e.getMessage()), (Throwable)e);
        }
        catch (IOException e) {
            if (this.failOnError) {
                throw new MojoExecutionException("IOException: Error while creating archive:" + e.getMessage(), (Exception)e);
            }
            this.getLog().error((CharSequence)("IOException: Error while creating archive:" + e.getMessage()), (Throwable)e);
        }
        catch (MavenReportException e) {
            if (this.failOnError) {
                throw new MojoExecutionException("MavenReportException: Error while creating archive:" + e.getMessage(), (Exception)((Object)e));
            }
            this.getLog().error((CharSequence)("MavenReportException: Error while creating archive:" + e.getMessage()), (Throwable)e);
        }
        catch (RuntimeException e) {
            if (this.failOnError) {
                throw e;
            }
            this.getLog().error((CharSequence)e.getMessage(), (Throwable)e);
        }
    }

    protected String getClassifier() {
        return "javadoc";
    }

    private File generateArchive(File javadocFiles, String jarFileName) throws ArchiverException, IOException {
        File javadocJar = new File(this.jarOutputDirectory, jarFileName);
        if (javadocJar.exists()) {
            javadocJar.delete();
        }
        MavenArchiver archiver = new MavenArchiver();
        archiver.setArchiver(this.jarArchiver);
        archiver.setOutputFile(javadocJar);
        File contentDirectory = javadocFiles;
        if (!contentDirectory.exists()) {
            this.getLog().warn((CharSequence)"JAR will be empty - no content was marked for inclusion!");
        } else {
            archiver.getArchiver().addDirectory(contentDirectory, DEFAULT_INCLUDES, DEFAULT_EXCLUDES);
        }
        List resources = this.project.getBuild().getResources();
        Iterator i = resources.iterator();
        while (i.hasNext()) {
            Resource r = (Resource)i.next();
            if (!r.getDirectory().endsWith("maven-shared-archive-resources")) continue;
            archiver.getArchiver().addDirectory(new File(r.getDirectory()));
        }
        if (this.useDefaultManifestFile && this.defaultManifestFile.exists() && this.archive.getManifestFile() == null) {
            this.getLog().info((CharSequence)("Adding existing MANIFEST to archive. Found under: " + this.defaultManifestFile.getPath()));
            this.archive.setManifestFile(this.defaultManifestFile);
        }
        try {
            this.archive.setAddMavenDescriptor(false);
            archiver.createArchive(this.project, this.archive);
        }
        catch (ManifestException e) {
            throw new ArchiverException("ManifestException: " + e.getMessage(), (Throwable)e);
        }
        catch (DependencyResolutionRequiredException e) {
            throw new ArchiverException("DependencyResolutionRequiredException: " + e.getMessage(), (Throwable)e);
        }
        return javadocJar;
    }
}

