/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.javadoc;

import com.thoughtworks.qdox.JavaDocBuilder;
import com.thoughtworks.qdox.model.AbstractInheritableJavaEntity;
import com.thoughtworks.qdox.model.AbstractJavaEntity;
import com.thoughtworks.qdox.model.Annotation;
import com.thoughtworks.qdox.model.DocletTag;
import com.thoughtworks.qdox.model.JavaClass;
import com.thoughtworks.qdox.model.JavaField;
import com.thoughtworks.qdox.model.JavaMethod;
import com.thoughtworks.qdox.model.JavaParameter;
import com.thoughtworks.qdox.model.Type;
import com.thoughtworks.qdox.model.TypeVariable;
import com.thoughtworks.qdox.parser.ParseException;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.ClassUtils;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.javadoc.JavadocUtil;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.settings.Settings;
import org.apache.maven.shared.invoker.MavenInvocationException;
import org.codehaus.plexus.components.interactivity.InputHandler;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.ReaderFactory;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.WriterFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractFixJavadocMojo
extends AbstractMojo {
    private static final String EOL = System.getProperty("line.separator");
    private static final String AUTHOR_TAG = "author";
    private static final String VERSION_TAG = "version";
    private static final String SINCE_TAG = "since";
    private static final String PARAM_TAG = "param";
    private static final String RETURN_TAG = "return";
    private static final String THROWS_TAG = "throws";
    private static final String LINK_TAG = "link";
    private static final String INHERITED_TAG = "{@inheritDoc}";
    private static final String START_JAVADOC = "/**";
    private static final String END_JAVADOC = "*/";
    private static final String SEPARATOR_JAVADOC = " * ";
    private static final String INHERITED_JAVADOC = "/** {@inheritDoc} */";
    private static final String FIX_TAGS_ALL = "all";
    private static final String LEVEL_PUBLIC = "public";
    private static final String LEVEL_PROTECTED = "protected";
    private static final String LEVEL_PACKAGE = "package";
    private static final String LEVEL_PRIVATE = "private";
    private static final String CLIRR_MAVEN_PLUGIN_GROUPID = "org.codehaus.mojo";
    private static final String CLIRR_MAVEN_PLUGIN_ARTIFACTID = "clirr-maven-plugin";
    private static final String CLIRR_MAVEN_PLUGIN_VERSION = "2.2.2";
    private static final String CLIRR_MAVEN_PLUGIN_GOAL = "check";
    public static final String JAVA_FILES = "**\\/*.java";
    public static final String DEFAULT_VERSION_VALUE = "$Id: $Id";
    @Component
    private InputHandler inputHandler;
    @Parameter(property="comparisonVersion", defaultValue="(,${project.version})")
    private String comparisonVersion;
    @Parameter(property="defaultAuthor")
    private String defaultAuthor;
    @Parameter(property="defaultSince", defaultValue="${project.version}")
    private String defaultSince;
    @Parameter(property="defaultVersion", defaultValue="$Id: $Id")
    private String defaultVersion = "$Id: $";
    @Parameter(property="encoding", defaultValue="${project.build.sourceEncoding}")
    private String encoding;
    @Parameter(property="excludes")
    private String excludes;
    @Parameter(property="fixTags", defaultValue="all")
    private String fixTags;
    @Parameter(property="fixClassComment", defaultValue="true")
    private boolean fixClassComment;
    @Parameter(property="fixFieldComment", defaultValue="true")
    private boolean fixFieldComment;
    @Parameter(property="fixMethodComment", defaultValue="true")
    private boolean fixMethodComment;
    @Parameter(property="force")
    private boolean force;
    @Parameter(property="ignoreClirr", defaultValue="false")
    protected boolean ignoreClirr;
    @Parameter(property="includes", defaultValue="**\\/*.java")
    private String includes;
    @Parameter(property="level", defaultValue="protected")
    private String level;
    @Parameter(property="localRepository")
    private ArtifactRepository localRepository;
    @Parameter(property="outputDirectory", defaultValue="${project.build.sourceDirectory}")
    private File outputDirectory;
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;
    @Parameter(defaultValue="${settings}", readonly=true, required=true)
    private Settings settings;
    private ClassLoader projectClassLoader;
    private String[] fixTagsSplitted;
    private List<String> clirrNewClasses;
    private Map<String, List<String>> clirrNewMethods;
    private List<String> sinceClasses;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (!(this.fixClassComment || this.fixFieldComment || this.fixMethodComment)) {
            this.getLog().info((CharSequence)"Specified to NOT fix classes, fields and methods. Nothing to do.");
            return;
        }
        this.init();
        if (this.fixTagsSplitted.length == 0) {
            this.getLog().info((CharSequence)"No fix tag specified. Nothing to do.");
            return;
        }
        if (!this.preCheck()) {
            return;
        }
        try {
            this.executeClirr();
        }
        catch (MavenInvocationException e) {
            if (this.getLog().isDebugEnabled()) {
                this.getLog().error((CharSequence)("MavenInvocationException: " + e.getMessage()), (Throwable)e);
            } else {
                this.getLog().error((CharSequence)("MavenInvocationException: " + e.getMessage()));
            }
            this.getLog().info((CharSequence)"Clirr is ignored.");
        }
        try {
            JavaClass[] javaClasses = this.getQdoxClasses();
            if (javaClasses != null) {
                for (JavaClass javaClass : javaClasses) {
                    this.processFix(javaClass);
                }
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("IOException: " + e.getMessage(), (Exception)e);
        }
    }

    protected String getArtifactType(MavenProject p) {
        return p.getArtifact().getType();
    }

    protected List<String> getProjectSourceRoots(MavenProject p) {
        return p.getCompileSourceRoots() == null ? Collections.emptyList() : new LinkedList(p.getCompileSourceRoots());
    }

    protected List<String> getCompileClasspathElements(MavenProject p) throws DependencyResolutionRequiredException {
        return p.getCompileClasspathElements() == null ? Collections.emptyList() : new LinkedList(p.getCompileClasspathElements());
    }

    protected static String getJavaMethodAsString(JavaMethod javaMethod) {
        return javaMethod.getParentClass().getFullyQualifiedName() + "#" + javaMethod.getCallSignature();
    }

    private void init() {
        int i;
        if (StringUtils.isEmpty((String)this.defaultAuthor)) {
            this.defaultAuthor = System.getProperty("user.name");
        }
        if ((i = this.defaultSince.indexOf("-SNAPSHOT")) != -1) {
            this.defaultSince = this.defaultSince.substring(0, i);
        }
        if (!FIX_TAGS_ALL.equalsIgnoreCase(this.fixTags.trim())) {
            String[] split = StringUtils.split((String)this.fixTags, (String)",");
            LinkedList<String> filtered = new LinkedList<String>();
            for (String aSplit : split) {
                String s = aSplit.trim();
                if (JavadocUtil.equalsIgnoreCase(s, FIX_TAGS_ALL, AUTHOR_TAG, VERSION_TAG, SINCE_TAG, PARAM_TAG, THROWS_TAG, LINK_TAG, RETURN_TAG)) {
                    filtered.add(s);
                    continue;
                }
                if (!this.getLog().isWarnEnabled()) continue;
                this.getLog().warn((CharSequence)("Unrecognized '" + s + "' for fixTags parameter. Ignored it!"));
            }
            this.fixTags = StringUtils.join(filtered.iterator(), (String)",");
        }
        this.fixTagsSplitted = StringUtils.split((String)this.fixTags, (String)",");
        if (StringUtils.isEmpty((String)this.encoding)) {
            if (this.getLog().isWarnEnabled()) {
                this.getLog().warn((CharSequence)("File encoding has not been set, using platform encoding " + ReaderFactory.FILE_ENCODING + ", i.e. build is platform dependent!"));
            }
            this.encoding = ReaderFactory.FILE_ENCODING;
        }
        this.level = this.level.trim();
        if (!JavadocUtil.equalsIgnoreCase(this.level, LEVEL_PUBLIC, LEVEL_PROTECTED, LEVEL_PACKAGE, LEVEL_PRIVATE)) {
            if (this.getLog().isWarnEnabled()) {
                this.getLog().warn((CharSequence)("Unrecognized '" + this.level + "' for level parameter, using 'protected' level."));
            }
            this.level = LEVEL_PROTECTED;
        }
    }

    /*
     * Exception decompiling
     */
    private boolean preCheck() throws MojoExecutionException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[DOLOOP]], but top level block is 0[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private File getProjectSourceDirectory() {
        return new File(this.project.getBuild().getSourceDirectory());
    }

    private void executeClirr() throws MavenInvocationException {
        if (this.ignoreClirr) {
            this.getLog().info((CharSequence)"Clirr is ignored.");
            return;
        }
        String clirrGoal = AbstractFixJavadocMojo.getFullClirrGoal();
        File clirrTextOutputFile = FileUtils.createTempFile((String)"clirr", (String)".txt", (File)new File(this.project.getBuild().getDirectory()));
        Properties properties = new Properties();
        properties.put("textOutputFile", clirrTextOutputFile.getAbsolutePath());
        properties.put("comparisonVersion", this.comparisonVersion);
        properties.put("failOnError", "false");
        File invokerDir = new File(this.project.getBuild().getDirectory(), "invoker");
        invokerDir.mkdirs();
        File invokerLogFile = FileUtils.createTempFile((String)CLIRR_MAVEN_PLUGIN_ARTIFACTID, (String)".txt", (File)invokerDir);
        new File(this.project.getBuild().getDirectory(), "invoker-clirr-maven-plugin.txt");
        JavadocUtil.invokeMaven(this.getLog(), new File(this.localRepository.getBasedir()), this.project.getFile(), Collections.singletonList(clirrGoal), properties, invokerLogFile);
        try {
            if (invokerLogFile.exists()) {
                String invokerLogContent = StringUtils.unifyLineSeparators((String)FileUtils.fileRead((File)invokerLogFile, (String)"UTF-8"));
                String artifactNotFoundMsg = "Unable to find a previous version of the project in the repository";
                if (invokerLogContent.contains("Unable to find a previous version of the project in the repository")) {
                    this.getLog().warn((CharSequence)"No previous artifact has been deployed, Clirr is ignored.");
                    return;
                }
            }
        }
        catch (IOException e) {
            this.getLog().debug((CharSequence)("IOException: " + e.getMessage()));
        }
        try {
            this.parseClirrTextOutputFile(clirrTextOutputFile);
        }
        catch (IOException e) {
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)("IOException: " + e.getMessage()), (Throwable)e);
            }
            this.getLog().info((CharSequence)("IOException when parsing Clirr output '" + clirrTextOutputFile.getAbsolutePath() + "', Clirr is ignored."));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseClirrTextOutputFile(File clirrTextOutputFile) throws IOException {
        if (!clirrTextOutputFile.exists()) {
            if (this.getLog().isInfoEnabled()) {
                this.getLog().info((CharSequence)("No Clirr output file '" + clirrTextOutputFile.getAbsolutePath() + "' exists, Clirr is ignored."));
            }
            return;
        }
        if (this.getLog().isInfoEnabled()) {
            this.getLog().info((CharSequence)("Clirr output file was created: " + clirrTextOutputFile.getAbsolutePath()));
        }
        this.clirrNewClasses = new LinkedList<String>();
        this.clirrNewMethods = new LinkedHashMap<String, List<String>>();
        BufferedReader input = null;
        Reader reader = null;
        try {
            String line;
            reader = ReaderFactory.newReader((File)clirrTextOutputFile, (String)"UTF-8");
            input = new BufferedReader(reader);
            while ((line = input.readLine()) != null) {
                int code;
                String[] split = StringUtils.split((String)line, (String)":");
                if (split.length != 4) {
                    if (!this.getLog().isDebugEnabled()) continue;
                    this.getLog().debug((CharSequence)("Unable to parse the clirr line: " + line));
                    continue;
                }
                try {
                    code = Integer.parseInt(split[1].trim());
                }
                catch (NumberFormatException e) {
                    if (!this.getLog().isDebugEnabled()) continue;
                    this.getLog().debug((CharSequence)("Unable to parse the clirr line: " + line));
                    continue;
                }
                switch (code) {
                    case 7011: {
                        String[] splits2;
                        List<String> list = this.clirrNewMethods.get(split[2].trim());
                        if (list == null) {
                            list = new ArrayList<String>();
                        }
                        if ((splits2 = StringUtils.split((String)split[3].trim(), (String)"'")).length != 3) break;
                        list.add(splits2[1].trim());
                        this.clirrNewMethods.put(split[2].trim(), list);
                        break;
                    }
                    case 7012: {
                        String[] splits2;
                        List<String> list = this.clirrNewMethods.get(split[2].trim());
                        if (list == null) {
                            list = new ArrayList<String>();
                        }
                        if ((splits2 = StringUtils.split((String)split[3].trim(), (String)"'")).length != 3) break;
                        list.add(splits2[1].trim());
                        this.clirrNewMethods.put(split[2].trim(), list);
                        break;
                    }
                    case 8000: {
                        this.clirrNewClasses.add(split[2].trim());
                        break;
                    }
                }
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly((Reader)reader);
            IOUtils.closeQuietly(input);
            throw throwable;
        }
        IOUtils.closeQuietly((Reader)reader);
        IOUtils.closeQuietly((Reader)input);
        if (this.clirrNewClasses.isEmpty() && this.clirrNewMethods.isEmpty()) {
            this.getLog().info((CharSequence)"Clirr NOT found API differences.");
        } else {
            this.getLog().info((CharSequence)"Clirr found API differences, i.e. new classes/interfaces or methods.");
        }
    }

    private boolean fixTag(String tag) {
        if (this.fixTagsSplitted.length == 1 && this.fixTagsSplitted[0].equals(FIX_TAGS_ALL)) {
            return true;
        }
        for (String aFixTagsSplitted : this.fixTagsSplitted) {
            if (!aFixTagsSplitted.trim().equals(tag)) continue;
            return true;
        }
        return false;
    }

    private JavaClass[] getQdoxClasses() throws IOException, MojoExecutionException {
        if ("pom".equalsIgnoreCase(this.project.getPackaging())) {
            this.getLog().warn((CharSequence)"This project has 'pom' packaging, no Java sources is available.");
            return null;
        }
        LinkedList javaFiles = new LinkedList();
        for (String sourceRoot : this.getProjectSourceRoots(this.project)) {
            File f = new File(sourceRoot);
            if (f.isDirectory()) {
                javaFiles.addAll(FileUtils.getFiles((File)f, (String)this.includes, (String)this.excludes, (boolean)true));
                continue;
            }
            if (!this.getLog().isWarnEnabled()) continue;
            this.getLog().warn((CharSequence)(f + " doesn't exist. Ignored it."));
        }
        JavaDocBuilder builder = new JavaDocBuilder();
        builder.getClassLibrary().addClassLoader(this.getProjectClassLoader());
        builder.setEncoding(this.encoding);
        for (File f : javaFiles) {
            if (!f.getAbsolutePath().toLowerCase(Locale.ENGLISH).endsWith(".java") && this.getLog().isWarnEnabled()) {
                this.getLog().warn((CharSequence)("'" + f + "' is not a Java file. Ignored it."));
                continue;
            }
            try {
                builder.addSource(f);
            }
            catch (ParseException e) {
                if (!this.getLog().isWarnEnabled()) continue;
                this.getLog().warn((CharSequence)("QDOX ParseException: " + e.getMessage() + ". Can't fix it."));
            }
        }
        return builder.getClasses();
    }

    private ClassLoader getProjectClassLoader() throws MojoExecutionException {
        if (this.projectClassLoader == null) {
            List<String> classPath;
            try {
                classPath = this.getCompileClasspathElements(this.project);
            }
            catch (DependencyResolutionRequiredException e) {
                throw new MojoExecutionException("DependencyResolutionRequiredException: " + e.getMessage(), (Exception)((Object)e));
            }
            ArrayList<URL> urls = new ArrayList<URL>(classPath.size());
            for (String filename : classPath) {
                try {
                    urls.add(new File(filename).toURL());
                }
                catch (MalformedURLException e) {
                    throw new MojoExecutionException("MalformedURLException: " + e.getMessage(), (Exception)e);
                }
            }
            this.projectClassLoader = new URLClassLoader(urls.toArray(new URL[urls.size()]), null);
        }
        return this.projectClassLoader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processFix(JavaClass javaClass) throws IOException, MojoExecutionException {
        if (javaClass.isInner()) {
            return;
        }
        File javaFile = new File(javaClass.getSource().getURL().getFile());
        String originalContent = StringUtils.unifyLineSeparators((String)FileUtils.fileRead((File)javaFile, (String)this.encoding));
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)("Fixing " + javaClass.getFullyQualifiedName()));
        }
        StringWriter stringWriter = new StringWriter();
        BufferedReader reader = null;
        try {
            String line;
            reader = new BufferedReader(new StringReader(originalContent));
            int lineNumber = 0;
            while ((line = reader.readLine()) != null) {
                int i;
                ++lineNumber;
                String indent = AbstractFixJavadocMojo.autodetectIndentation(line);
                if (javaClass.getComment() == null && javaClass.getAnnotations() != null && javaClass.getAnnotations().length != 0) {
                    if (lineNumber == javaClass.getAnnotations()[0].getLineNumber()) {
                        this.fixClassComment(stringWriter, originalContent, javaClass, indent);
                        this.takeCareSingleComment(stringWriter, originalContent, (AbstractInheritableJavaEntity)javaClass);
                    }
                } else if (lineNumber == javaClass.getLineNumber()) {
                    this.fixClassComment(stringWriter, originalContent, javaClass, indent);
                    this.takeCareSingleComment(stringWriter, originalContent, (AbstractInheritableJavaEntity)javaClass);
                }
                if (javaClass.getFields() != null) {
                    for (i = 0; i < javaClass.getFields().length; ++i) {
                        JavaField field = javaClass.getFields()[i];
                        if (lineNumber != field.getLineNumber()) continue;
                        this.fixFieldComment(stringWriter, javaClass, field, indent);
                    }
                }
                if (javaClass.getMethods() != null) {
                    for (i = 0; i < javaClass.getMethods().length; ++i) {
                        JavaMethod method = javaClass.getMethods()[i];
                        if (lineNumber != method.getLineNumber()) continue;
                        this.fixMethodComment(stringWriter, originalContent, method, indent);
                        this.takeCareSingleComment(stringWriter, originalContent, (AbstractInheritableJavaEntity)method);
                    }
                }
                stringWriter.write(line);
                stringWriter.write(EOL);
            }
        }
        catch (Throwable throwable) {
            IOUtil.close(reader);
            throw throwable;
        }
        IOUtil.close((Reader)reader);
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)("Saving " + javaClass.getFullyQualifiedName()));
        }
        if (this.outputDirectory != null && !this.outputDirectory.getAbsolutePath().equals(this.getProjectSourceDirectory().getAbsolutePath())) {
            String path = StringUtils.replace((String)javaFile.getAbsolutePath().replaceAll("\\\\", "/"), (String)this.project.getBuild().getSourceDirectory().replaceAll("\\\\", "/"), (String)"");
            javaFile = new File(this.outputDirectory, path);
            javaFile.getParentFile().mkdirs();
        }
        AbstractFixJavadocMojo.writeFile(javaFile, this.encoding, stringWriter.toString());
    }

    private void takeCareSingleComment(StringWriter stringWriter, String originalContent, AbstractInheritableJavaEntity entity) throws IOException {
        if (entity.getComment() == null) {
            return;
        }
        String javadocComment = AbstractFixJavadocMojo.trimRight(AbstractFixJavadocMojo.extractOriginalJavadoc(originalContent, (AbstractJavaEntity)entity));
        String extraComment = javadocComment.substring(javadocComment.indexOf(END_JAVADOC) + END_JAVADOC.length());
        if (StringUtils.isNotEmpty((String)extraComment)) {
            if (extraComment.contains(EOL)) {
                stringWriter.write(extraComment.substring(extraComment.indexOf(EOL) + EOL.length()));
            } else {
                stringWriter.write(extraComment);
            }
            stringWriter.write(EOL);
        }
    }

    private void fixClassComment(StringWriter stringWriter, String originalContent, JavaClass javaClass, String indent) throws MojoExecutionException, IOException {
        if (!this.fixClassComment) {
            return;
        }
        if (!this.isInLevel(javaClass.getModifiers())) {
            return;
        }
        if (javaClass.getComment() == null) {
            this.addDefaultClassComment(stringWriter, javaClass, indent);
            return;
        }
        this.updateEntityComment(stringWriter, originalContent, (AbstractInheritableJavaEntity)javaClass, indent);
    }

    private boolean isInLevel(String[] modifiers) {
        List<String> modifiersAsList = Arrays.asList(modifiers);
        if (LEVEL_PUBLIC.equalsIgnoreCase(this.level.trim())) {
            return modifiersAsList.contains(LEVEL_PUBLIC);
        }
        if (LEVEL_PROTECTED.equalsIgnoreCase(this.level.trim())) {
            return modifiersAsList.contains(LEVEL_PUBLIC) || modifiersAsList.contains(LEVEL_PROTECTED);
        }
        if (LEVEL_PACKAGE.equalsIgnoreCase(this.level.trim())) {
            return !modifiersAsList.contains(LEVEL_PRIVATE);
        }
        return true;
    }

    private void addDefaultClassComment(StringWriter stringWriter, JavaClass javaClass, String indent) {
        StringBuilder sb = new StringBuilder();
        sb.append(indent).append(START_JAVADOC);
        sb.append(EOL);
        sb.append(indent).append(SEPARATOR_JAVADOC);
        sb.append(AbstractFixJavadocMojo.getDefaultClassJavadocComment(javaClass));
        sb.append(EOL);
        this.appendSeparator(sb, indent);
        this.appendDefaultAuthorTag(sb, indent);
        this.appendDefaultVersionTag(sb, indent);
        if (this.fixTag(SINCE_TAG)) {
            if (!this.ignoreClirr) {
                if (this.isNewClassFromLastVersion(javaClass)) {
                    this.appendDefaultSinceTag(sb, indent);
                }
            } else {
                this.appendDefaultSinceTag(sb, indent);
                this.addSinceClasses(javaClass);
            }
        }
        sb.append(indent).append(" ").append(END_JAVADOC);
        sb.append(EOL);
        stringWriter.write(sb.toString());
    }

    private void fixFieldComment(StringWriter stringWriter, JavaClass javaClass, JavaField field, String indent) throws IOException {
        if (!this.fixFieldComment) {
            return;
        }
        if (!(javaClass.isInterface() || this.isInLevel(field.getModifiers()) && field.isStatic())) {
            return;
        }
        if (field.getComment() == null) {
            this.addDefaultFieldComment(stringWriter, field, indent);
            return;
        }
    }

    private void addDefaultFieldComment(StringWriter stringWriter, JavaField field, String indent) throws IOException {
        StringBuilder sb = new StringBuilder();
        sb.append(indent).append(START_JAVADOC).append(" ");
        sb.append("Constant <code>").append(field.getName());
        if (StringUtils.isNotEmpty((String)field.getInitializationExpression())) {
            String qualifiedName = field.getType().getJavaClass().getFullyQualifiedName();
            if (qualifiedName.equals(Byte.TYPE.toString()) || qualifiedName.equals(Short.TYPE.toString()) || qualifiedName.equals(Integer.TYPE.toString()) || qualifiedName.equals(Long.TYPE.toString()) || qualifiedName.equals(Float.TYPE.toString()) || qualifiedName.equals(Double.TYPE.toString()) || qualifiedName.equals(Boolean.TYPE.toString()) || qualifiedName.equals(Character.TYPE.toString())) {
                sb.append("=");
                sb.append(field.getInitializationExpression().trim());
            }
            if (qualifiedName.equals(String.class.getName())) {
                String[] lines;
                StringBuilder value = new StringBuilder();
                for (String line : lines = AbstractFixJavadocMojo.getLines(field.getInitializationExpression())) {
                    StringTokenizer token = new StringTokenizer(line.trim(), "\"\n\r");
                    while (token.hasMoreTokens()) {
                        String s = token.nextToken();
                        if (s.trim().equals("+")) continue;
                        if (s.trim().endsWith("\\")) {
                            s = s + "\"";
                        }
                        value.append(s);
                    }
                }
                sb.append("=\"");
                if (value.length() < 40) {
                    sb.append(value.toString()).append("\"");
                } else {
                    sb.append(value.toString().substring(0, 39)).append("\"{trunked}");
                }
            }
        }
        sb.append("</code> ").append(END_JAVADOC);
        sb.append(EOL);
        stringWriter.write(sb.toString());
    }

    private void fixMethodComment(StringWriter stringWriter, String originalContent, JavaMethod javaMethod, String indent) throws MojoExecutionException, IOException {
        if (!this.fixMethodComment) {
            return;
        }
        if (!javaMethod.getParentClass().isInterface() && !this.isInLevel(javaMethod.getModifiers())) {
            return;
        }
        if (javaMethod.getComment() == null) {
            this.addDefaultMethodComment(stringWriter, javaMethod, indent);
            return;
        }
        this.updateEntityComment(stringWriter, originalContent, (AbstractInheritableJavaEntity)javaMethod, indent);
    }

    private void addDefaultMethodComment(StringWriter stringWriter, JavaMethod javaMethod, String indent) throws MojoExecutionException {
        int i;
        StringBuilder sb = new StringBuilder();
        if (this.isInherited(javaMethod)) {
            sb.append(indent).append(INHERITED_JAVADOC);
            sb.append(EOL);
            stringWriter.write(sb.toString());
            return;
        }
        sb.append(indent).append(START_JAVADOC);
        sb.append(EOL);
        sb.append(indent).append(SEPARATOR_JAVADOC);
        sb.append(AbstractFixJavadocMojo.getDefaultMethodJavadocComment(javaMethod));
        sb.append(EOL);
        boolean separatorAdded = false;
        if (this.fixTag(PARAM_TAG)) {
            if (javaMethod.getParameters() != null) {
                for (i = 0; i < javaMethod.getParameters().length; ++i) {
                    JavaParameter javaParameter = javaMethod.getParameters()[i];
                    separatorAdded = this.appendDefaultParamTag(sb, indent, separatorAdded, javaParameter);
                }
            }
            if (javaMethod.getTypeParameters() != null) {
                for (i = 0; i < javaMethod.getTypeParameters().length; ++i) {
                    TypeVariable typeParam = javaMethod.getTypeParameters()[i];
                    separatorAdded = this.appendDefaultParamTag(sb, indent, separatorAdded, typeParam);
                }
            }
        }
        if (this.fixTag(RETURN_TAG) && javaMethod.getReturns() != null && !javaMethod.getReturns().isVoid()) {
            separatorAdded = this.appendDefaultReturnTag(sb, indent, separatorAdded, javaMethod);
        }
        if (this.fixTag(THROWS_TAG) && javaMethod.getExceptions() != null && javaMethod.getExceptions().length > 0) {
            for (i = 0; i < javaMethod.getExceptions().length; ++i) {
                Type exception = javaMethod.getExceptions()[i];
                separatorAdded = this.appendDefaultThrowsTag(sb, indent, separatorAdded, exception);
            }
        }
        if (this.fixTag(SINCE_TAG) && this.isNewMethodFromLastRevision(javaMethod)) {
            separatorAdded = this.appendDefaultSinceTag(sb, indent, separatorAdded);
        }
        sb.append(indent).append(" ").append(END_JAVADOC);
        sb.append(EOL);
        stringWriter.write(sb.toString());
    }

    private void updateEntityComment(StringWriter stringWriter, String originalContent, AbstractInheritableJavaEntity entity, String indent) throws MojoExecutionException, IOException {
        String s = stringWriter.toString();
        int i = s.lastIndexOf(START_JAVADOC);
        if (i != -1) {
            String tmp = s.substring(0, i);
            if (tmp.lastIndexOf(EOL) != -1) {
                tmp = tmp.substring(0, tmp.lastIndexOf(EOL));
            }
            stringWriter.getBuffer().delete(0, stringWriter.getBuffer().length());
            stringWriter.write(tmp);
            stringWriter.write(EOL);
        }
        this.updateJavadocComment(stringWriter, originalContent, entity, indent);
    }

    private void updateJavadocComment(StringWriter stringWriter, String originalContent, AbstractInheritableJavaEntity entity, String indent) throws MojoExecutionException, IOException {
        JavaMethod javaMethod;
        if (entity.getComment() == null && (entity.getTags() == null || entity.getTags().length == 0)) {
            return;
        }
        boolean isJavaMethod = false;
        if (entity instanceof JavaMethod) {
            isJavaMethod = true;
        }
        StringBuilder sb = new StringBuilder();
        if (isJavaMethod && this.isInherited(javaMethod = (JavaMethod)entity)) {
            if (StringUtils.isEmpty((String)javaMethod.getComment())) {
                sb.append(indent).append(INHERITED_JAVADOC);
                sb.append(EOL);
                stringWriter.write(sb.toString());
                return;
            }
            String javadoc = AbstractFixJavadocMojo.getJavadocComment(originalContent, (AbstractJavaEntity)javaMethod);
            if (AbstractFixJavadocMojo.hasInheritedTag(javadoc) && (javaMethod.getTags() == null || javaMethod.getTags().length == 0)) {
                sb.append(indent).append(INHERITED_JAVADOC);
                sb.append(EOL);
                stringWriter.write(sb.toString());
                return;
            }
            if (javadoc.contains(START_JAVADOC)) {
                javadoc = javadoc.substring(javadoc.indexOf(START_JAVADOC) + START_JAVADOC.length());
            }
            if (javadoc.contains(END_JAVADOC)) {
                javadoc = javadoc.substring(0, javadoc.indexOf(END_JAVADOC));
            }
            sb.append(indent).append(START_JAVADOC);
            sb.append(EOL);
            if (!javadoc.contains(INHERITED_TAG)) {
                sb.append(indent).append(SEPARATOR_JAVADOC).append(INHERITED_TAG);
                sb.append(EOL);
                this.appendSeparator(sb, indent);
            }
            javadoc = AbstractFixJavadocMojo.removeLastEmptyJavadocLines(javadoc);
            javadoc = AbstractFixJavadocMojo.alignIndentationJavadocLines(javadoc, indent);
            sb.append(javadoc);
            sb.append(EOL);
            if (javaMethod.getTags() != null) {
                for (int i = 0; i < javaMethod.getTags().length; ++i) {
                    DocletTag docletTag = javaMethod.getTags()[i];
                    if (JavadocUtil.equals(docletTag.getName(), PARAM_TAG, RETURN_TAG, THROWS_TAG)) continue;
                    String s = this.getJavadocComment(originalContent, entity, docletTag);
                    s = AbstractFixJavadocMojo.removeLastEmptyJavadocLines(s);
                    s = AbstractFixJavadocMojo.alignIndentationJavadocLines(s, indent);
                    sb.append(s);
                    sb.append(EOL);
                }
            }
            sb.append(indent).append(" ").append(END_JAVADOC);
            sb.append(EOL);
            if (AbstractFixJavadocMojo.hasInheritedTag(sb.toString().trim())) {
                sb = new StringBuilder();
                sb.append(indent).append(INHERITED_JAVADOC);
                sb.append(EOL);
                stringWriter.write(sb.toString());
                return;
            }
            stringWriter.write(sb.toString());
            return;
        }
        sb.append(indent).append(START_JAVADOC);
        sb.append(EOL);
        if (StringUtils.isNotEmpty((String)entity.getComment())) {
            this.updateJavadocComment(sb, originalContent, entity, indent);
        } else {
            this.addDefaultJavadocComment(sb, entity, indent, isJavaMethod);
        }
        if (entity.getTags() != null && entity.getTags().length > 0) {
            this.updateJavadocTags(sb, originalContent, entity, indent, isJavaMethod);
        } else {
            this.addDefaultJavadocTags(sb, entity, indent, isJavaMethod);
        }
        sb = new StringBuilder(AbstractFixJavadocMojo.removeLastEmptyJavadocLines(sb.toString())).append(EOL);
        sb.append(indent).append(" ").append(END_JAVADOC);
        sb.append(EOL);
        stringWriter.write(sb.toString());
    }

    private void updateJavadocComment(StringBuilder sb, String originalContent, AbstractInheritableJavaEntity entity, String indent) throws IOException {
        String[] lines;
        String comment = AbstractFixJavadocMojo.getJavadocComment(originalContent, (AbstractJavaEntity)entity);
        comment = AbstractFixJavadocMojo.removeLastEmptyJavadocLines(comment);
        if ((comment = AbstractFixJavadocMojo.alignIndentationJavadocLines(comment, indent)).contains(START_JAVADOC)) {
            comment = comment.substring(comment.indexOf(START_JAVADOC) + START_JAVADOC.length());
            comment = indent + SEPARATOR_JAVADOC + comment.trim();
        }
        if (comment.contains(END_JAVADOC)) {
            comment = comment.substring(0, comment.indexOf(END_JAVADOC));
        }
        if (this.fixTag(LINK_TAG)) {
            comment = AbstractFixJavadocMojo.replaceLinkTags(comment, entity);
        }
        for (String line : lines = AbstractFixJavadocMojo.getLines(comment)) {
            sb.append(indent).append(" ").append(line.trim());
            sb.append(EOL);
        }
    }

    private static String replaceLinkTags(String comment, AbstractInheritableJavaEntity entity) {
        StringBuilder resolvedComment = new StringBuilder();
        Matcher linktagMatcher = Pattern.compile("\\{@link\\s").matcher(comment);
        int startIndex = 0;
        while (linktagMatcher.find()) {
            int startName = linktagMatcher.end();
            resolvedComment.append(comment.substring(startIndex, startName));
            int endName = comment.indexOf("}", startName);
            if (endName >= 0) {
                String link = comment.substring(startName, endName);
                int hashIndex = link.indexOf(35);
                String name = hashIndex >= 0 ? link.substring(0, hashIndex) : link;
                if (StringUtils.isNotBlank((String)name)) {
                    String typeName = entity instanceof JavaClass ? ((JavaClass)entity).resolveType(name.trim()) : entity.getParentClass().resolveType(name.trim());
                    typeName = typeName == null ? name.trim() : typeName.replaceAll("\\$", ".");
                    resolvedComment.append(typeName);
                }
                if (hashIndex >= 0) {
                    resolvedComment.append(link.substring(hashIndex).trim());
                }
                startIndex = endName;
                continue;
            }
            startIndex = startName;
        }
        resolvedComment.append(comment.substring(startIndex));
        return resolvedComment.toString();
    }

    private void addDefaultJavadocComment(StringBuilder sb, AbstractInheritableJavaEntity entity, String indent, boolean isJavaMethod) {
        sb.append(indent).append(SEPARATOR_JAVADOC);
        if (isJavaMethod) {
            sb.append(AbstractFixJavadocMojo.getDefaultMethodJavadocComment((JavaMethod)entity));
        } else {
            sb.append(AbstractFixJavadocMojo.getDefaultClassJavadocComment((JavaClass)entity));
        }
        sb.append(EOL);
    }

    private void updateJavadocTags(StringBuilder sb, String originalContent, AbstractInheritableJavaEntity entity, String indent, boolean isJavaMethod) throws IOException, MojoExecutionException {
        this.appendSeparator(sb, indent);
        JavaEntityTags javaEntityTags = this.parseJavadocTags(originalContent, entity, indent, isJavaMethod);
        this.updateJavadocTags(sb, entity, isJavaMethod, javaEntityTags);
        this.addMissingJavadocTags(sb, entity, indent, isJavaMethod, javaEntityTags);
    }

    private JavaEntityTags parseJavadocTags(String originalContent, AbstractInheritableJavaEntity entity, String indent, boolean isJavaMethod) throws IOException {
        JavaEntityTags javaEntityTags = new JavaEntityTags(entity, isJavaMethod);
        for (int i = 0; i < entity.getTags().length; ++i) {
            DocletTag docletTag = entity.getTags()[i];
            String originalJavadocTag = this.getJavadocComment(originalContent, entity, docletTag);
            originalJavadocTag = AbstractFixJavadocMojo.removeLastEmptyJavadocLines(originalJavadocTag);
            originalJavadocTag = AbstractFixJavadocMojo.alignIndentationJavadocLines(originalJavadocTag, indent);
            javaEntityTags.getNamesTags().add(docletTag.getName());
            if (isJavaMethod) {
                String[] params = docletTag.getParameters();
                if (params.length < 1) continue;
                params = AbstractFixJavadocMojo.fixQdox173(params);
                String paramName = params[0];
                if (docletTag.getName().equals(PARAM_TAG)) {
                    javaEntityTags.putJavadocParamTag(paramName, originalJavadocTag);
                    continue;
                }
                if (docletTag.getName().equals(RETURN_TAG)) {
                    javaEntityTags.setJavadocReturnTag(originalJavadocTag);
                    continue;
                }
                if (docletTag.getName().equals(THROWS_TAG)) {
                    javaEntityTags.putJavadocThrowsTag(paramName, originalJavadocTag);
                    continue;
                }
                javaEntityTags.getUnknownTags().add(originalJavadocTag);
                continue;
            }
            javaEntityTags.getUnknownTags().add(originalJavadocTag);
        }
        return javaEntityTags;
    }

    private void updateJavadocTags(StringBuilder sb, AbstractInheritableJavaEntity entity, boolean isJavaMethod, JavaEntityTags javaEntityTags) {
        for (int i = 0; i < entity.getTags().length; ++i) {
            DocletTag docletTag = entity.getTags()[i];
            if (isJavaMethod) {
                JavaMethod javaMethod = (JavaMethod)entity;
                String[] params = docletTag.getParameters();
                if (params.length < 1) continue;
                if (docletTag.getName().equals(PARAM_TAG)) {
                    this.writeParamTag(sb, javaMethod, javaEntityTags, params);
                } else if (docletTag.getName().equals(RETURN_TAG)) {
                    this.writeReturnTag(sb, javaMethod, javaEntityTags);
                } else if (docletTag.getName().equals(THROWS_TAG)) {
                    this.writeThrowsTag(sb, javaMethod, javaEntityTags, params);
                } else {
                    Iterator<String> it = javaEntityTags.getUnknownTags().iterator();
                    while (it.hasNext()) {
                        String originalJavadocTag = it.next();
                        if (!StringUtils.removeDuplicateWhitespace((String)originalJavadocTag).trim().contains("@" + docletTag.getName())) continue;
                        it.remove();
                        sb.append(originalJavadocTag);
                        sb.append(EOL);
                    }
                }
            } else {
                Iterator<String> it = javaEntityTags.getUnknownTags().iterator();
                while (it.hasNext()) {
                    String originalJavadocTag = it.next();
                    if (!StringUtils.removeDuplicateWhitespace((String)originalJavadocTag).trim().contains("@" + docletTag.getName())) continue;
                    it.remove();
                    sb.append(originalJavadocTag);
                    sb.append(EOL);
                }
            }
            if (sb.toString().endsWith(EOL)) {
                sb.delete(sb.toString().lastIndexOf(EOL), sb.toString().length());
            }
            sb.append(EOL);
        }
    }

    private void writeParamTag(StringBuilder sb, JavaMethod javaMethod, JavaEntityTags javaEntityTags, String[] params) {
        params = AbstractFixJavadocMojo.fixQdox173(params);
        String paramName = params[0];
        if (!this.fixTag(PARAM_TAG)) {
            String originalJavadocTag = javaEntityTags.getJavadocParamTag(paramName);
            if (originalJavadocTag != null) {
                sb.append(originalJavadocTag);
            }
            return;
        }
        boolean found = false;
        JavaParameter javaParam = javaMethod.getParameterByName(paramName);
        if (javaParam == null) {
            TypeVariable[] typeParams;
            for (TypeVariable typeParam : typeParams = javaMethod.getTypeParameters()) {
                if (!typeParam.getGenericValue().equals(paramName)) continue;
                found = true;
            }
        } else {
            found = true;
        }
        if (!found) {
            if (this.getLog().isWarnEnabled()) {
                this.getLog().warn((CharSequence)("Fixed unknown param '" + paramName + "' defined in " + AbstractFixJavadocMojo.getJavaMethodAsString(javaMethod)));
            }
            if (sb.toString().endsWith(EOL)) {
                sb.delete(sb.toString().lastIndexOf(EOL), sb.toString().length());
            }
        } else {
            String originalJavadocTag = javaEntityTags.getJavadocParamTag(paramName);
            if (originalJavadocTag != null) {
                sb.append(originalJavadocTag);
                String s = "@param " + paramName;
                if (StringUtils.removeDuplicateWhitespace((String)originalJavadocTag).trim().endsWith(s)) {
                    sb.append(" ");
                    sb.append(this.getDefaultJavadocForType(javaParam.getType()));
                }
            }
        }
    }

    private void writeReturnTag(StringBuilder sb, JavaMethod javaMethod, JavaEntityTags javaEntityTags) {
        String originalJavadocTag = javaEntityTags.getJavadocReturnTag();
        if (originalJavadocTag == null) {
            return;
        }
        if (!this.fixTag(RETURN_TAG)) {
            sb.append(originalJavadocTag);
            return;
        }
        if (StringUtils.isNotEmpty((String)originalJavadocTag) && javaMethod.getReturns() != null && !javaMethod.getReturns().isVoid()) {
            sb.append(originalJavadocTag);
            if (originalJavadocTag.trim().endsWith("@return")) {
                sb.append(" ");
                sb.append(this.getDefaultJavadocForType(javaMethod.getReturns()));
            }
        }
    }

    private void writeThrowsTag(StringBuilder sb, JavaMethod javaMethod, JavaEntityTags javaEntityTags, String[] params) {
        Class<?> clazz;
        String exceptionClassName = params[0];
        String originalJavadocTag = javaEntityTags.getJavadocThrowsTag(exceptionClassName);
        if (originalJavadocTag == null) {
            return;
        }
        if (!this.fixTag(THROWS_TAG)) {
            sb.append(originalJavadocTag);
            return;
        }
        if (javaMethod.getExceptions() != null) {
            for (int j = 0; j < javaMethod.getExceptions().length; ++j) {
                Type exception = javaMethod.getExceptions()[j];
                if (!exception.getValue().endsWith(exceptionClassName)) continue;
                if (StringUtils.removeDuplicateWhitespace((String)(originalJavadocTag = StringUtils.replace((String)originalJavadocTag, (String)exceptionClassName, (String)exception.getValue()))).trim().endsWith("@throws " + exception.getValue())) {
                    originalJavadocTag = originalJavadocTag + " if any.";
                }
                sb.append(originalJavadocTag);
                javaEntityTags.putJavadocThrowsTag(exception.getValue(), originalJavadocTag);
                return;
            }
        }
        if ((clazz = this.getRuntimeExceptionClass(javaMethod.getParentClass(), exceptionClassName)) != null) {
            sb.append(StringUtils.replace((String)originalJavadocTag, (String)exceptionClassName, (String)clazz.getName()));
            javaEntityTags.putJavadocThrowsTag(clazz.getName(), originalJavadocTag);
            return;
        }
        if (this.getLog().isWarnEnabled()) {
            this.getLog().warn((CharSequence)("Unknown throws exception '" + exceptionClassName + "' defined in " + AbstractFixJavadocMojo.getJavaMethodAsString(javaMethod)));
        }
        sb.append(originalJavadocTag);
        if (params.length == 1) {
            sb.append(" if any.");
        }
    }

    private void addMissingJavadocTags(StringBuilder sb, AbstractInheritableJavaEntity entity, String indent, boolean isJavaMethod, JavaEntityTags javaEntityTags) throws MojoExecutionException {
        if (isJavaMethod) {
            int i;
            JavaMethod javaMethod = (JavaMethod)entity;
            if (this.fixTag(PARAM_TAG)) {
                if (javaMethod.getParameters() != null) {
                    for (i = 0; i < javaMethod.getParameters().length; ++i) {
                        JavaParameter javaParameter = javaMethod.getParameters()[i];
                        if (javaEntityTags.getJavadocParamTag(javaParameter.getName(), true) != null) continue;
                        this.appendDefaultParamTag(sb, indent, javaParameter);
                    }
                }
                if (javaMethod.getTypeParameters() != null) {
                    for (i = 0; i < javaMethod.getTypeParameters().length; ++i) {
                        TypeVariable typeParam = javaMethod.getTypeParameters()[i];
                        if (javaEntityTags.getJavadocParamTag("<" + typeParam.getName() + ">", true) != null) continue;
                        this.appendDefaultParamTag(sb, indent, typeParam);
                    }
                }
            }
            if (this.fixTag(RETURN_TAG) && StringUtils.isEmpty((String)javaEntityTags.getJavadocReturnTag()) && javaMethod.getReturns() != null && !javaMethod.getReturns().isVoid()) {
                this.appendDefaultReturnTag(sb, indent, javaMethod);
            }
            if (this.fixTag(THROWS_TAG) && javaMethod.getExceptions() != null) {
                for (i = 0; i < javaMethod.getExceptions().length; ++i) {
                    Type exception = javaMethod.getExceptions()[i];
                    if (javaEntityTags.getJavadocThrowsTag(exception.getValue(), true) != null) continue;
                    this.appendDefaultThrowsTag(sb, indent, exception);
                }
            }
        } else {
            if (!javaEntityTags.getNamesTags().contains(AUTHOR_TAG)) {
                this.appendDefaultAuthorTag(sb, indent);
            }
            if (!javaEntityTags.getNamesTags().contains(VERSION_TAG)) {
                this.appendDefaultVersionTag(sb, indent);
            }
        }
        if (this.fixTag(SINCE_TAG) && !javaEntityTags.getNamesTags().contains(SINCE_TAG)) {
            if (!isJavaMethod) {
                if (!this.ignoreClirr) {
                    if (this.isNewClassFromLastVersion((JavaClass)entity)) {
                        this.appendDefaultSinceTag(sb, indent);
                    }
                } else {
                    this.appendDefaultSinceTag(sb, indent);
                    this.addSinceClasses((JavaClass)entity);
                }
            } else if (!this.ignoreClirr) {
                if (this.isNewMethodFromLastRevision((JavaMethod)entity)) {
                    this.appendDefaultSinceTag(sb, indent);
                }
            } else if (this.sinceClasses != null && !this.sinceClassesContains(entity.getParentClass())) {
                this.appendDefaultSinceTag(sb, indent);
            }
        }
    }

    private void addDefaultJavadocTags(StringBuilder sb, AbstractInheritableJavaEntity entity, String indent, boolean isJavaMethod) throws MojoExecutionException {
        JavaMethod javaMethod;
        boolean separatorAdded = false;
        if (isJavaMethod) {
            int i;
            javaMethod = (JavaMethod)entity;
            if (this.fixTag(PARAM_TAG) && javaMethod.getParameters() != null) {
                for (i = 0; i < javaMethod.getParameters().length; ++i) {
                    JavaParameter javaParameter = javaMethod.getParameters()[i];
                    separatorAdded = this.appendDefaultParamTag(sb, indent, separatorAdded, javaParameter);
                }
            }
            if (this.fixTag(RETURN_TAG) && javaMethod.getReturns() != null && !javaMethod.getReturns().isVoid()) {
                separatorAdded = this.appendDefaultReturnTag(sb, indent, separatorAdded, javaMethod);
            }
            if (this.fixTag(THROWS_TAG) && javaMethod.getExceptions() != null) {
                for (i = 0; i < javaMethod.getExceptions().length; ++i) {
                    Type exception = javaMethod.getExceptions()[i];
                    separatorAdded = this.appendDefaultThrowsTag(sb, indent, separatorAdded, exception);
                }
            }
        } else {
            separatorAdded = this.appendDefaultAuthorTag(sb, indent, separatorAdded);
            separatorAdded = this.appendDefaultVersionTag(sb, indent, separatorAdded);
        }
        if (this.fixTag(SINCE_TAG)) {
            if (!isJavaMethod) {
                JavaClass javaClass = (JavaClass)entity;
                if (!this.ignoreClirr) {
                    if (this.isNewClassFromLastVersion(javaClass)) {
                        separatorAdded = this.appendDefaultSinceTag(sb, indent, separatorAdded);
                    }
                } else {
                    separatorAdded = this.appendDefaultSinceTag(sb, indent, separatorAdded);
                    this.addSinceClasses(javaClass);
                }
            } else {
                javaMethod = (JavaMethod)entity;
                if (!this.ignoreClirr) {
                    if (this.isNewMethodFromLastRevision(javaMethod)) {
                        separatorAdded = this.appendDefaultSinceTag(sb, indent, separatorAdded);
                    }
                } else if (this.sinceClasses != null && !this.sinceClassesContains(javaMethod.getParentClass())) {
                    separatorAdded = this.appendDefaultSinceTag(sb, indent, separatorAdded);
                }
            }
        }
    }

    private boolean appendDefaultAuthorTag(StringBuilder sb, String indent, boolean separatorAdded) {
        if (!this.fixTag(AUTHOR_TAG)) {
            return separatorAdded;
        }
        if (!separatorAdded) {
            this.appendSeparator(sb, indent);
            separatorAdded = true;
        }
        this.appendDefaultAuthorTag(sb, indent);
        return separatorAdded;
    }

    private void appendDefaultAuthorTag(StringBuilder sb, String indent) {
        if (!this.fixTag(AUTHOR_TAG)) {
            return;
        }
        sb.append(indent).append(" * @").append(AUTHOR_TAG).append(" ");
        sb.append(this.defaultAuthor);
        sb.append(EOL);
    }

    private boolean appendDefaultSinceTag(StringBuilder sb, String indent, boolean separatorAdded) {
        if (!this.fixTag(SINCE_TAG)) {
            return separatorAdded;
        }
        if (!separatorAdded) {
            this.appendSeparator(sb, indent);
            separatorAdded = true;
        }
        this.appendDefaultSinceTag(sb, indent);
        return separatorAdded;
    }

    private void appendDefaultSinceTag(StringBuilder sb, String indent) {
        if (!this.fixTag(SINCE_TAG)) {
            return;
        }
        sb.append(indent).append(" * @").append(SINCE_TAG).append(" ");
        sb.append(this.defaultSince);
        sb.append(EOL);
    }

    private boolean appendDefaultVersionTag(StringBuilder sb, String indent, boolean separatorAdded) {
        if (!this.fixTag(VERSION_TAG)) {
            return separatorAdded;
        }
        if (!separatorAdded) {
            this.appendSeparator(sb, indent);
            separatorAdded = true;
        }
        this.appendDefaultVersionTag(sb, indent);
        return separatorAdded;
    }

    private void appendDefaultVersionTag(StringBuilder sb, String indent) {
        if (!this.fixTag(VERSION_TAG)) {
            return;
        }
        sb.append(indent).append(" * @").append(VERSION_TAG).append(" ");
        sb.append(this.defaultVersion);
        sb.append(EOL);
    }

    private boolean appendDefaultParamTag(StringBuilder sb, String indent, boolean separatorAdded, JavaParameter javaParameter) {
        if (!this.fixTag(PARAM_TAG)) {
            return separatorAdded;
        }
        if (!separatorAdded) {
            this.appendSeparator(sb, indent);
            separatorAdded = true;
        }
        this.appendDefaultParamTag(sb, indent, javaParameter);
        return separatorAdded;
    }

    private boolean appendDefaultParamTag(StringBuilder sb, String indent, boolean separatorAdded, TypeVariable typeParameter) {
        if (!this.fixTag(PARAM_TAG)) {
            return separatorAdded;
        }
        if (!separatorAdded) {
            this.appendSeparator(sb, indent);
            separatorAdded = true;
        }
        this.appendDefaultParamTag(sb, indent, typeParameter);
        return separatorAdded;
    }

    private void appendDefaultParamTag(StringBuilder sb, String indent, JavaParameter javaParameter) {
        if (!this.fixTag(PARAM_TAG)) {
            return;
        }
        sb.append(indent).append(" * @").append(PARAM_TAG).append(" ");
        sb.append(javaParameter.getName());
        sb.append(" ");
        sb.append(this.getDefaultJavadocForType(javaParameter.getType()));
        sb.append(EOL);
    }

    private void appendDefaultParamTag(StringBuilder sb, String indent, TypeVariable typeParameter) {
        if (!this.fixTag(PARAM_TAG)) {
            return;
        }
        sb.append(indent).append(" * @").append(PARAM_TAG).append(" ");
        sb.append("<").append(typeParameter.getName()).append(">");
        sb.append(" ");
        sb.append(this.getDefaultJavadocForType((Type)typeParameter));
        sb.append(EOL);
    }

    private boolean appendDefaultReturnTag(StringBuilder sb, String indent, boolean separatorAdded, JavaMethod javaMethod) {
        if (!this.fixTag(RETURN_TAG)) {
            return separatorAdded;
        }
        if (!separatorAdded) {
            this.appendSeparator(sb, indent);
            separatorAdded = true;
        }
        this.appendDefaultReturnTag(sb, indent, javaMethod);
        return separatorAdded;
    }

    private void appendDefaultReturnTag(StringBuilder sb, String indent, JavaMethod javaMethod) {
        if (!this.fixTag(RETURN_TAG)) {
            return;
        }
        sb.append(indent).append(" * @").append(RETURN_TAG).append(" ");
        sb.append(this.getDefaultJavadocForType(javaMethod.getReturns()));
        sb.append(EOL);
    }

    private boolean appendDefaultThrowsTag(StringBuilder sb, String indent, boolean separatorAdded, Type exception) {
        if (!this.fixTag(THROWS_TAG)) {
            return separatorAdded;
        }
        if (!separatorAdded) {
            this.appendSeparator(sb, indent);
            separatorAdded = true;
        }
        this.appendDefaultThrowsTag(sb, indent, exception);
        return separatorAdded;
    }

    private void appendDefaultThrowsTag(StringBuilder sb, String indent, Type exception) {
        if (!this.fixTag(THROWS_TAG)) {
            return;
        }
        sb.append(indent).append(" * @").append(THROWS_TAG).append(" ");
        sb.append(exception.getJavaClass().getFullyQualifiedName());
        sb.append(" if any.");
        sb.append(EOL);
    }

    private void appendSeparator(StringBuilder sb, String indent) {
        sb.append(indent).append(" *");
        sb.append(EOL);
    }

    private boolean isInherited(JavaMethod javaMethod) throws MojoExecutionException, SecurityException {
        if (javaMethod.getAnnotations() != null) {
            for (int i = 0; i < javaMethod.getAnnotations().length; ++i) {
                Annotation annotation = javaMethod.getAnnotations()[i];
                if (!annotation.toString().equals("@java.lang.Override()")) continue;
                return true;
            }
        }
        Class<?> clazz = this.getClass(javaMethod.getParentClass().getFullyQualifiedName());
        List interfaces = ClassUtils.getAllInterfaces(clazz);
        for (Class intface : interfaces) {
            if (!this.isInherited(intface, javaMethod)) continue;
            return true;
        }
        List classes = ClassUtils.getAllSuperclasses(clazz);
        for (Class superClass : classes) {
            if (!this.isInherited(superClass, javaMethod)) continue;
            return true;
        }
        return false;
    }

    private boolean isInherited(Class<?> clazz, JavaMethod javaMethod) {
        for (Method method : clazz.getDeclaredMethods()) {
            if (!method.getName().equals(javaMethod.getName()) || method.getParameterTypes().length != javaMethod.getParameters().length) continue;
            boolean found = false;
            int j = 0;
            for (Class<?> paramType : method.getParameterTypes()) {
                String name1 = paramType.getName();
                String name2 = javaMethod.getParameters()[j++].getType().getFullQualifiedName();
                found = name1.equals(name2);
            }
            return found;
        }
        return false;
    }

    private String getDefaultJavadocForType(Type type) {
        StringBuilder sb = new StringBuilder();
        if (!TypeVariable.class.isAssignableFrom(type.getClass()) && type.isPrimitive()) {
            if (type.isArray()) {
                sb.append("an array of ");
            } else {
                sb.append("a ");
            }
            return sb.append(type.getJavaClass().getFullyQualifiedName()).append(".").toString();
        }
        StringBuilder javadocLink = new StringBuilder();
        try {
            this.getClass(type.getJavaClass().getFullyQualifiedName());
            String s = type.getJavaClass().getFullyQualifiedName();
            s = StringUtils.replace((String)s, (String)"$", (String)".");
            javadocLink.append("{@link ").append(s).append("}");
        }
        catch (Exception e) {
            javadocLink.append(type.getJavaClass().getFullyQualifiedName());
        }
        if (type.isArray()) {
            sb.append("an array of ").append(javadocLink.toString()).append(" objects.");
        } else {
            sb.append("a ").append(javadocLink.toString()).append(" object.");
        }
        return sb.toString();
    }

    private boolean isNewClassFromLastVersion(JavaClass javaClass) {
        return this.clirrNewClasses != null && this.clirrNewClasses.contains(javaClass.getFullyQualifiedName());
    }

    private boolean isNewMethodFromLastRevision(JavaMethod javaMethod) throws MojoExecutionException {
        if (this.clirrNewMethods == null) {
            return false;
        }
        List<String> clirrMethods = this.clirrNewMethods.get(javaMethod.getParentClass().getFullyQualifiedName());
        if (clirrMethods == null) {
            return false;
        }
        for (String clirrMethod : clirrMethods) {
            String retrn = "";
            if (javaMethod.getReturns() != null) {
                retrn = javaMethod.getReturns().getFullQualifiedName();
            }
            StringBuilder params = new StringBuilder();
            for (JavaParameter parameter : javaMethod.getParameters()) {
                if (params.length() > 0) {
                    params.append(", ");
                }
                params.append(parameter.getResolvedValue());
            }
            if (!clirrMethod.contains(retrn + " ") || !clirrMethod.contains(javaMethod.getName() + "(") || !clirrMethod.contains("(" + params.toString() + ")")) continue;
            return true;
        }
        return false;
    }

    private Class<?> getClass(String className) throws MojoExecutionException {
        try {
            return ClassUtils.getClass((ClassLoader)this.getProjectClassLoader(), (String)className, (boolean)false);
        }
        catch (ClassNotFoundException e) {
            throw new MojoExecutionException("ClassNotFoundException: " + e.getMessage(), (Exception)e);
        }
    }

    private Class<?> getRuntimeExceptionClass(JavaClass currentClass, String exceptionClassName) {
        String[] potentialClassNames = new String[]{exceptionClassName, currentClass.getPackage().getName() + "." + exceptionClassName, currentClass.getPackage().getName() + "." + currentClass.getName() + "$" + exceptionClassName, "java.lang." + exceptionClassName};
        Class<?> clazz = null;
        for (String potentialClassName : potentialClassNames) {
            try {
                clazz = this.getClass(potentialClassName);
            }
            catch (MojoExecutionException e) {
                // empty catch block
            }
            if (clazz == null || !ClassUtils.isAssignable(clazz, RuntimeException.class)) continue;
            return clazz;
        }
        return null;
    }

    private void addSinceClasses(JavaClass javaClass) {
        if (this.sinceClasses == null) {
            this.sinceClasses = new ArrayList<String>();
        }
        this.sinceClasses.add(javaClass.getFullyQualifiedName());
    }

    private boolean sinceClassesContains(JavaClass javaClass) {
        return this.sinceClasses.contains(javaClass.getFullyQualifiedName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeFile(File javaFile, String encoding, String content) throws IOException {
        Writer writer = null;
        try {
            writer = WriterFactory.newWriter((File)javaFile, (String)encoding);
            writer.write(StringUtils.unifyLineSeparators((String)content));
        }
        finally {
            IOUtil.close((Writer)writer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static String getFullClirrGoal() {
        InputStream resourceAsStream;
        String clirrVersion;
        StringBuilder sb;
        block4: {
            sb = new StringBuilder();
            sb.append(CLIRR_MAVEN_PLUGIN_GROUPID).append(":").append(CLIRR_MAVEN_PLUGIN_ARTIFACTID).append(":");
            clirrVersion = CLIRR_MAVEN_PLUGIN_VERSION;
            resourceAsStream = null;
            try {
                String resource = "META-INF/maven/org.codehaus.mojo/clirr-maven-plugin/pom.properties";
                resourceAsStream = AbstractFixJavadocMojo.class.getClassLoader().getResourceAsStream(resource);
                if (resourceAsStream == null) break block4;
                Properties properties = new Properties();
                properties.load(resourceAsStream);
                if (!StringUtils.isNotEmpty((String)properties.getProperty(VERSION_TAG))) break block4;
                clirrVersion = properties.getProperty(VERSION_TAG);
            }
            catch (IOException iOException) {
                IOUtil.close(resourceAsStream);
                catch (Throwable throwable) {
                    IOUtil.close(resourceAsStream);
                    throw throwable;
                }
            }
        }
        IOUtil.close((InputStream)resourceAsStream);
        sb.append(clirrVersion).append(":").append(CLIRR_MAVEN_PLUGIN_GOAL);
        return sb.toString();
    }

    private static String getDefaultClassJavadocComment(JavaClass javaClass) {
        StringBuilder sb = new StringBuilder();
        sb.append("<p>");
        if (Arrays.asList(javaClass.getModifiers()).contains("abstract")) {
            sb.append("Abstract ");
        }
        sb.append(javaClass.getName());
        if (!javaClass.isInterface()) {
            sb.append(" class.");
        } else {
            sb.append(" interface.");
        }
        sb.append("</p>");
        return sb.toString();
    }

    private static String getDefaultMethodJavadocComment(JavaMethod javaMethod) {
        if (javaMethod.isConstructor()) {
            return "<p>Constructor for " + javaMethod.getName() + ".</p>";
        }
        if (javaMethod.getName().length() > 3 && (javaMethod.getName().startsWith("get") || javaMethod.getName().startsWith("set"))) {
            String field = StringUtils.lowercaseFirstLetter((String)javaMethod.getName().substring(3));
            JavaClass clazz = javaMethod.getParentClass();
            if (clazz.getFieldByName(field) == null) {
                return "<p>" + javaMethod.getName() + ".</p>";
            }
            StringBuilder sb = new StringBuilder();
            sb.append("<p>");
            if (javaMethod.getName().startsWith("get")) {
                sb.append("Getter ");
            } else if (javaMethod.getName().startsWith("set")) {
                sb.append("Setter ");
            }
            sb.append("for the field <code>").append(field).append("</code>.</p>");
            return sb.toString();
        }
        return "<p>" + javaMethod.getName() + ".</p>";
    }

    private static boolean hasInheritedTag(String content) {
        String inheritedTagPattern = "^\\s*(\\/\\*\\*)?(\\s*(\\*)?)*(\\{)@inheritDoc\\s*(\\})(\\s*(\\*)?)*(\\*\\/)?$";
        return Pattern.matches("^\\s*(\\/\\*\\*)?(\\s*(\\*)?)*(\\{)@inheritDoc\\s*(\\})(\\s*(\\*)?)*(\\*\\/)?$", StringUtils.removeDuplicateWhitespace((String)content));
    }

    private static String getJavadocComment(String javaClassContent, AbstractJavaEntity entity) throws IOException {
        String l;
        String line;
        if (entity.getComment() == null) {
            return "";
        }
        String originalJavadoc = AbstractFixJavadocMojo.extractOriginalJavadocContent(javaClassContent, entity);
        StringBuilder sb = new StringBuilder();
        BufferedReader lr = new BufferedReader(new StringReader(originalJavadoc));
        while ((line = lr.readLine()) != null && !(l = StringUtils.removeDuplicateWhitespace((String)line.trim())).startsWith("* @") && !l.startsWith("*@")) {
            sb.append(line).append(EOL);
        }
        return AbstractFixJavadocMojo.trimRight(sb.toString());
    }

    private String getJavadocComment(String javaClassContent, AbstractInheritableJavaEntity entity, DocletTag docletTag) throws IOException {
        String line;
        if (docletTag.getValue() == null || docletTag.getParameters().length == 0) {
            return "";
        }
        String originalJavadoc = AbstractFixJavadocMojo.extractOriginalJavadocContent(javaClassContent, (AbstractJavaEntity)entity);
        String[] params = AbstractFixJavadocMojo.fixQdox173(docletTag.getParameters());
        String paramValue = params[0];
        StringBuilder sb = new StringBuilder();
        BufferedReader lr = new BufferedReader(new StringReader(originalJavadoc));
        boolean found = false;
        while ((line = lr.readLine()) != null) {
            String l = StringUtils.removeDuplicateWhitespace((String)line.trim());
            if (l.startsWith("* @" + docletTag.getName() + " " + paramValue) || l.startsWith("*@" + docletTag.getName() + " " + paramValue)) {
                if (this.fixTag(LINK_TAG)) {
                    line = AbstractFixJavadocMojo.replaceLinkTags(line, entity);
                }
                sb.append(line).append(EOL);
                found = true;
                continue;
            }
            if (l.startsWith("* @") || l.startsWith("*@")) {
                found = false;
            }
            if (!found) continue;
            if (this.fixTag(LINK_TAG)) {
                line = AbstractFixJavadocMojo.replaceLinkTags(line, entity);
            }
            sb.append(line).append(EOL);
        }
        return AbstractFixJavadocMojo.trimRight(sb.toString());
    }

    private static String extractOriginalJavadoc(String javaClassContent, AbstractJavaEntity entity) throws IOException {
        if (entity.getComment() == null) {
            return "";
        }
        String[] javaClassContentLines = AbstractFixJavadocMojo.getLines(javaClassContent);
        LinkedList<String> list = new LinkedList<String>();
        for (int i = entity.getLineNumber() - 2; i >= 0; --i) {
            String line = javaClassContentLines[i];
            list.add(AbstractFixJavadocMojo.trimRight(line));
            if (line.trim().startsWith(START_JAVADOC)) break;
        }
        Collections.reverse(list);
        return StringUtils.join(list.iterator(), (String)EOL);
    }

    private static String extractOriginalJavadocContent(String javaClassContent, AbstractJavaEntity entity) throws IOException {
        if (entity.getComment() == null) {
            return "";
        }
        String originalJavadoc = AbstractFixJavadocMojo.extractOriginalJavadoc(javaClassContent, entity);
        int index = originalJavadoc.indexOf(START_JAVADOC);
        if (index != -1) {
            originalJavadoc = originalJavadoc.substring(index + START_JAVADOC.length());
        }
        if ((index = originalJavadoc.indexOf(END_JAVADOC)) != -1) {
            originalJavadoc = originalJavadoc.substring(0, index);
        }
        if (originalJavadoc.startsWith("\r\n")) {
            originalJavadoc = originalJavadoc.substring(2);
        } else if (originalJavadoc.startsWith("\n") || originalJavadoc.startsWith("\r")) {
            originalJavadoc = originalJavadoc.substring(1);
        }
        return AbstractFixJavadocMojo.trimRight(originalJavadoc);
    }

    private static String removeLastEmptyJavadocLines(String content) throws IOException {
        String line;
        if (!content.contains(EOL)) {
            return content;
        }
        String[] lines = AbstractFixJavadocMojo.getLines(content);
        if (lines.length == 1) {
            return content;
        }
        LinkedList<String> linesList = new LinkedList<String>(Arrays.asList(lines));
        Collections.reverse(linesList);
        Iterator it = linesList.iterator();
        while (it.hasNext() && (line = (String)it.next()).trim().equals("*")) {
            it.remove();
        }
        Collections.reverse(linesList);
        return StringUtils.join(linesList.iterator(), (String)EOL);
    }

    private static String alignIndentationJavadocLines(String content, String indent) throws IOException {
        StringBuilder sb = new StringBuilder();
        for (String line : AbstractFixJavadocMojo.getLines(content)) {
            if (sb.length() > 0) {
                sb.append(EOL);
            }
            if (!line.trim().startsWith("*")) {
                line = "*" + line;
            }
            sb.append(indent).append(" ").append(AbstractFixJavadocMojo.trimLeft(line));
        }
        return sb.toString();
    }

    private static String autodetectIndentation(String line) {
        if (StringUtils.isEmpty((String)line)) {
            return "";
        }
        return line.substring(0, line.indexOf(AbstractFixJavadocMojo.trimLeft(line)));
    }

    private static String[] getLines(String content) throws IOException {
        LinkedList<String> lines = new LinkedList<String>();
        BufferedReader reader = new BufferedReader(new StringReader(content));
        String line = reader.readLine();
        while (line != null) {
            lines.add(line);
            line = reader.readLine();
        }
        return lines.toArray(new String[lines.size()]);
    }

    private static String trimLeft(String text) {
        if (StringUtils.isEmpty((String)text) || StringUtils.isEmpty((String)text.trim())) {
            return "";
        }
        String textTrimmed = text.trim();
        return text.substring(text.indexOf(textTrimmed), text.length());
    }

    private static String trimRight(String text) {
        if (StringUtils.isEmpty((String)text) || StringUtils.isEmpty((String)text.trim())) {
            return "";
        }
        String textTrimmed = text.trim();
        return text.substring(0, text.indexOf(textTrimmed) + textTrimmed.length());
    }

    private static String[] fixQdox173(String[] params) {
        if (params == null || params.length == 0 || params.length < 3) {
            return params;
        }
        if (params[0].trim().equals("<") && params[2].trim().equals(">")) {
            String param = params[1];
            ArrayList<String> l = new ArrayList<String>(Arrays.asList(params));
            l.set(1, "<" + param + ">");
            l.remove(0);
            l.remove(1);
            return l.toArray(new String[l.size()]);
        }
        return params;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class JavaEntityTags {
        private final AbstractInheritableJavaEntity entity;
        private final boolean isJavaMethod;
        private List<String> namesTags;
        private Map<String, String> tagParams;
        private String tagReturn;
        private Map<String, String> tagThrows;
        private List<String> unknownsTags;

        public JavaEntityTags(AbstractInheritableJavaEntity entity, boolean isJavaMethod) {
            this.entity = entity;
            this.isJavaMethod = isJavaMethod;
            this.namesTags = new LinkedList<String>();
            this.tagParams = new LinkedHashMap<String, String>();
            this.tagThrows = new LinkedHashMap<String, String>();
            this.unknownsTags = new LinkedList<String>();
        }

        public List<String> getNamesTags() {
            return this.namesTags;
        }

        public String getJavadocReturnTag() {
            return this.tagReturn;
        }

        public void setJavadocReturnTag(String s) {
            this.tagReturn = s;
        }

        public List<String> getUnknownTags() {
            return this.unknownsTags;
        }

        public void putJavadocParamTag(String paramName, String originalJavadocTag) {
            this.tagParams.put(paramName, originalJavadocTag);
        }

        public String getJavadocParamTag(String paramName) {
            return this.getJavadocParamTag(paramName, false);
        }

        public String getJavadocParamTag(String paramName, boolean nullable) {
            String originalJavadocTag = this.tagParams.get(paramName);
            if (!nullable && originalJavadocTag == null && AbstractFixJavadocMojo.this.getLog().isWarnEnabled()) {
                AbstractFixJavadocMojo.this.getLog().warn((CharSequence)this.getMessage(paramName, "javaEntityTags.tagParams"));
            }
            return originalJavadocTag;
        }

        public void putJavadocThrowsTag(String paramName, String originalJavadocTag) {
            this.tagThrows.put(paramName, originalJavadocTag);
        }

        public String getJavadocThrowsTag(String paramName) {
            return this.getJavadocThrowsTag(paramName, false);
        }

        public String getJavadocThrowsTag(String paramName, boolean nullable) {
            String originalJavadocTag = this.tagThrows.get(paramName);
            if (!nullable && originalJavadocTag == null && AbstractFixJavadocMojo.this.getLog().isWarnEnabled()) {
                AbstractFixJavadocMojo.this.getLog().warn((CharSequence)this.getMessage(paramName, "javaEntityTags.tagThrows"));
            }
            return originalJavadocTag;
        }

        private String getMessage(String paramName, String mapName) {
            StringBuilder msg = new StringBuilder();
            msg.append("No param '").append(paramName).append("' key found in ").append(mapName).append(" for the entity: ");
            if (this.isJavaMethod) {
                JavaMethod javaMethod = (JavaMethod)this.entity;
                msg.append(AbstractFixJavadocMojo.getJavaMethodAsString(javaMethod));
            } else {
                JavaClass javaClass = (JavaClass)this.entity;
                msg.append(javaClass.getFullyQualifiedName());
            }
            return msg.toString();
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("namesTags=").append(this.namesTags).append("\n");
            sb.append("tagParams=").append(this.tagParams).append("\n");
            sb.append("tagReturn=").append(this.tagReturn).append("\n");
            sb.append("tagThrows=").append(this.tagThrows).append("\n");
            sb.append("unknownsTags=").append(this.unknownsTags).append("\n");
            return sb.toString();
        }
    }
}

