/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.install;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.regex.Pattern;
import java.util.zip.ZipFile;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Model;
import org.apache.maven.model.Parent;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.apache.maven.model.io.xpp3.MavenXpp3Writer;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.xml.XmlStreamReader;
import org.codehaus.plexus.util.xml.XmlStreamWriter;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.eclipse.aether.DefaultRepositoryCache;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositoryCache;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.ArtifactType;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.installation.InstallRequest;
import org.eclipse.aether.installation.InstallationException;
import org.eclipse.aether.repository.LocalRepository;
import org.eclipse.aether.repository.LocalRepositoryManager;
import org.eclipse.aether.util.artifact.SubArtifact;

@Mojo(name="install-file", requiresProject=false, aggregator=true, threadSafe=true)
public class InstallFileMojo
extends AbstractMojo {
    private static final String LS = System.getProperty("line.separator");
    @Component
    private RepositorySystem repositorySystem;
    @Parameter(defaultValue="${session}", required=true, readonly=true)
    private MavenSession session;
    @Parameter(property="groupId")
    private String groupId;
    @Parameter(property="artifactId")
    private String artifactId;
    @Parameter(property="version")
    private String version;
    @Parameter(property="packaging")
    private String packaging;
    @Parameter(property="classifier")
    private String classifier;
    @Parameter(property="file", required=true)
    private File file;
    @Parameter(property="javadoc")
    private File javadoc;
    @Parameter(property="sources")
    private File sources;
    @Parameter(property="pomFile")
    private File pomFile;
    @Parameter(property="generatePom")
    private Boolean generatePom;
    @Parameter(property="localRepositoryPath")
    private File localRepositoryPath;
    private static final String ILLEGAL_VERSION_CHARS = "\\/:\"<>|?*[](){},";

    public void execute() throws MojoExecutionException, MojoFailureException {
        ArtifactType artifactType;
        boolean isFilePom;
        if (!this.file.exists()) {
            String message = "The specified file '" + this.file.getPath() + "' does not exist";
            this.getLog().error((CharSequence)message);
            throw new MojoFailureException(message);
        }
        RepositorySystemSession repositorySystemSession = this.session.getRepositorySession();
        if (this.localRepositoryPath != null) {
            DefaultRepositorySystemSession newSession = new DefaultRepositorySystemSession(this.session.getRepositorySession());
            newSession.setCache((RepositoryCache)new DefaultRepositoryCache());
            String contentType = newSession.getLocalRepository().getContentType();
            if ("enhanced".equals(contentType)) {
                contentType = "default";
            }
            LocalRepositoryManager localRepositoryManager = this.repositorySystem.newLocalRepositoryManager((RepositorySystemSession)newSession, new LocalRepository(this.localRepositoryPath, contentType));
            newSession.setLocalRepositoryManager(localRepositoryManager);
            repositorySystemSession = newSession;
            this.getLog().debug((CharSequence)("localRepoPath: " + localRepositoryManager.getRepository().getBasedir()));
        }
        File temporaryPom = null;
        if (this.pomFile != null) {
            this.processModel(this.readModel(this.pomFile));
        } else {
            temporaryPom = this.readingPomFromJarFile();
            if (!Boolean.TRUE.equals(this.generatePom)) {
                this.pomFile = temporaryPom;
                this.getLog().debug((CharSequence)"Using JAR embedded POM as pomFile");
            }
        }
        if (this.groupId == null || this.artifactId == null || this.version == null || this.packaging == null) {
            throw new MojoExecutionException("The artifact information is incomplete: 'groupId', 'artifactId', 'version' and 'packaging' are required.");
        }
        if (!(this.isValidId(this.groupId) && this.isValidId(this.artifactId) && this.isValidVersion(this.version))) {
            throw new MojoExecutionException("The artifact information is not valid: uses invalid characters.");
        }
        InstallRequest installRequest = new InstallRequest();
        boolean bl = isFilePom = this.classifier == null && "pom".equals(this.packaging);
        if (!isFilePom && (artifactType = repositorySystemSession.getArtifactTypeRegistry().get(this.packaging)) != null && StringUtils.isEmpty((String)this.classifier) && !StringUtils.isEmpty((String)artifactType.getClassifier())) {
            this.classifier = artifactType.getClassifier();
        }
        Artifact mainArtifact = new DefaultArtifact(this.groupId, this.artifactId, this.classifier, isFilePom ? "pom" : this.getExtension(this.file), this.version).setFile(this.file);
        installRequest.addArtifact(mainArtifact);
        File artifactLocalFile = this.getLocalRepositoryFile(this.session.getRepositorySession(), mainArtifact);
        File pomLocalFile = this.getPomLocalRepositoryFile(this.session.getRepositorySession(), mainArtifact);
        if (this.file.equals(artifactLocalFile)) {
            throw new MojoFailureException("Cannot install artifact. Artifact is already in the local repository." + LS + LS + "File in question is: " + this.file + LS);
        }
        if (!"pom".equals(this.packaging)) {
            if (this.pomFile != null) {
                installRequest.addArtifact((Artifact)new SubArtifact(mainArtifact, "", "pom", this.pomFile));
            } else if (Boolean.TRUE.equals(this.generatePom) || this.generatePom == null && !pomLocalFile.exists()) {
                temporaryPom = this.generatePomFile();
                this.getLog().debug((CharSequence)"Installing generated POM");
                installRequest.addArtifact((Artifact)new SubArtifact(mainArtifact, "", "pom", temporaryPom));
            } else if (this.generatePom == null) {
                this.getLog().debug((CharSequence)"Skipping installation of generated POM, already present in local repository");
            }
        }
        if (this.sources != null) {
            installRequest.addArtifact((Artifact)new SubArtifact(mainArtifact, "sources", "jar", this.sources));
        }
        if (this.javadoc != null) {
            installRequest.addArtifact((Artifact)new SubArtifact(mainArtifact, "javadoc", "jar", this.javadoc));
        }
        try {
            this.repositorySystem.install(repositorySystemSession, installRequest);
        }
        catch (InstallationException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
        finally {
            if (temporaryPom != null) {
                temporaryPom.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File readingPomFromJarFile() throws MojoExecutionException {
        File pomFile = null;
        ZipFile jarFile = null;
        try {
            Pattern pomEntry = Pattern.compile("META-INF/maven/.*/pom\\.xml");
            jarFile = new JarFile(this.file);
            Enumeration<JarEntry> jarEntries = ((JarFile)jarFile).entries();
            while (jarEntries.hasMoreElements()) {
                JarEntry entry = jarEntries.nextElement();
                if (!pomEntry.matcher(entry.getName()).matches()) continue;
                this.getLog().debug((CharSequence)("Loading " + entry.getName()));
                InputStream pomInputStream = null;
                OutputStream pomOutputStream = null;
                try {
                    pomInputStream = ((JarFile)jarFile).getInputStream(entry);
                    String base = this.file.getName();
                    if (base.indexOf(46) > 0) {
                        base = base.substring(0, base.lastIndexOf(46));
                    }
                    pomFile = File.createTempFile(base, ".pom");
                    pomOutputStream = Files.newOutputStream(pomFile.toPath(), new OpenOption[0]);
                    IOUtil.copy((InputStream)pomInputStream, (OutputStream)pomOutputStream);
                    pomOutputStream.close();
                    pomOutputStream = null;
                    pomInputStream.close();
                    pomInputStream = null;
                    this.processModel(this.readModel(pomFile));
                }
                catch (Throwable throwable) {
                    IOUtil.close((InputStream)pomInputStream);
                    IOUtil.close(pomOutputStream);
                    throw throwable;
                }
                IOUtil.close((InputStream)pomInputStream);
                IOUtil.close((OutputStream)pomOutputStream);
                break;
            }
            if (pomFile == null) {
                this.getLog().info((CharSequence)("pom.xml not found in " + this.file.getName()));
            }
        }
        catch (IOException iOException) {
        }
        finally {
            if (jarFile != null) {
                try {
                    jarFile.close();
                }
                catch (IOException iOException) {}
            }
        }
        return pomFile;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Model readModel(File pomFile) throws MojoExecutionException {
        Model model;
        XmlStreamReader reader = null;
        try {
            reader = new XmlStreamReader(pomFile);
            Model model2 = new MavenXpp3Reader().read((Reader)reader);
            reader.close();
            reader = null;
            model = model2;
        }
        catch (FileNotFoundException e) {
            try {
                throw new MojoExecutionException("File not found " + pomFile, (Exception)e);
                catch (IOException e2) {
                    throw new MojoExecutionException("Error reading POM " + pomFile, (Exception)e2);
                }
                catch (XmlPullParserException e3) {
                    throw new MojoExecutionException("Error parsing POM " + pomFile, (Exception)((Object)e3));
                }
            }
            catch (Throwable throwable) {
                IOUtil.close(reader);
                throw throwable;
            }
        }
        IOUtil.close((Reader)reader);
        return model;
    }

    private void processModel(Model model) {
        Parent parent = model.getParent();
        if (this.groupId == null) {
            this.groupId = model.getGroupId();
            if (this.groupId == null && parent != null) {
                this.groupId = parent.getGroupId();
            }
        }
        if (this.artifactId == null) {
            this.artifactId = model.getArtifactId();
        }
        if (this.version == null) {
            this.version = model.getVersion();
            if (this.version == null && parent != null) {
                this.version = parent.getVersion();
            }
        }
        if (this.packaging == null) {
            this.packaging = model.getPackaging();
        }
    }

    private Model generateModel() {
        Model model = new Model();
        model.setModelVersion("4.0.0");
        model.setGroupId(this.groupId);
        model.setArtifactId(this.artifactId);
        model.setVersion(this.version);
        model.setPackaging(this.packaging);
        model.setDescription("POM was created from install:install-file");
        return model;
    }

    private File generatePomFile() throws MojoExecutionException {
        File file;
        Model model = this.generateModel();
        XmlStreamWriter writer = null;
        try {
            File pomFile = File.createTempFile("mvninstall", ".pom");
            writer = new XmlStreamWriter(pomFile);
            new MavenXpp3Writer().write((Writer)writer, model);
            writer.close();
            writer = null;
            file = pomFile;
        }
        catch (IOException e) {
            try {
                throw new MojoExecutionException("Error writing temporary POM file: " + e.getMessage(), (Exception)e);
            }
            catch (Throwable throwable) {
                IOUtil.close(writer);
                throw throwable;
            }
        }
        IOUtil.close((Writer)writer);
        return file;
    }

    private File getLocalRepositoryFile(RepositorySystemSession session, Artifact artifact) {
        String path = session.getLocalRepositoryManager().getPathForLocalArtifact(artifact);
        return new File(session.getLocalRepository().getBasedir(), path);
    }

    private File getPomLocalRepositoryFile(RepositorySystemSession session, Artifact artifact) {
        SubArtifact pomArtifact = new SubArtifact(artifact, "", "pom");
        String path = session.getLocalRepositoryManager().getPathForLocalArtifact((Artifact)pomArtifact);
        return new File(session.getLocalRepository().getBasedir(), path);
    }

    private String getExtension(File file) {
        String filename = file.getName();
        if (filename.contains(".tar.")) {
            return "tar." + FileUtils.getExtension((String)filename);
        }
        return FileUtils.getExtension((String)filename);
    }

    private boolean isValidId(String id) {
        if (id == null) {
            return false;
        }
        for (int i = 0; i < id.length(); ++i) {
            char c = id.charAt(i);
            if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c == '-' || c == '_' || c == '.') continue;
            return false;
        }
        return true;
    }

    private boolean isValidVersion(String version) {
        if (version == null) {
            return false;
        }
        for (int i = version.length() - 1; i >= 0; --i) {
            if (ILLEGAL_VERSION_CHARS.indexOf(version.charAt(i)) < 0) continue;
            return false;
        }
        return true;
    }
}

