/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.compiler;

import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticListener;
import javax.tools.JavaFileObject;
import org.apache.maven.api.plugin.Log;
import org.apache.maven.api.services.MessageBuilder;
import org.apache.maven.api.services.MessageBuilderFactory;

final class DiagnosticLogger
implements DiagnosticListener<JavaFileObject> {
    private final Log logger;
    private final MessageBuilderFactory messageBuilderFactory;
    private final Locale locale;
    private int numErrors;
    private int numWarnings;
    private final Map<String, Integer> codeCount;
    private String firstError;

    DiagnosticLogger(Log logger, MessageBuilderFactory messageBuilderFactory, Locale locale) {
        this.logger = logger;
        this.messageBuilderFactory = messageBuilderFactory;
        this.locale = locale;
        this.codeCount = new LinkedHashMap<String, Integer>();
    }

    @Override
    public void report(Diagnostic<? extends JavaFileObject> diagnostic) {
        MessageBuilder record = this.messageBuilderFactory.builder();
        String message = diagnostic.getMessage(this.locale);
        record.a((CharSequence)message);
        Diagnostic.Kind kind = diagnostic.getKind();
        String style = switch (kind) {
            case Diagnostic.Kind.ERROR -> ".error:-bold,f:red";
            case Diagnostic.Kind.MANDATORY_WARNING, Diagnostic.Kind.WARNING -> ".warning:-bold,f:yellow";
            default -> ".info:-bold,f:blue";
        };
        JavaFileObject source = diagnostic.getSource();
        if (source != null) {
            record.newline().a((CharSequence)"    at ").a((CharSequence)source.getName());
            long line = diagnostic.getLineNumber();
            long column = diagnostic.getColumnNumber();
            if (line != -1L || column != -1L) {
                record.style(style).a((Object)Character.valueOf('['));
                if (line != -1L) {
                    record.a((Object)line);
                }
                if (column != -1L) {
                    record.a((Object)Character.valueOf(',')).a((Object)column);
                }
                record.a((Object)Character.valueOf(']')).resetStyle();
            }
        }
        String log = record.toString();
        switch (kind) {
            case ERROR: {
                if (this.firstError == null) {
                    this.firstError = message;
                }
                this.logger.error((CharSequence)log);
                ++this.numErrors;
                break;
            }
            case MANDATORY_WARNING: 
            case WARNING: {
                this.logger.warn((CharSequence)log);
                ++this.numWarnings;
                break;
            }
            default: {
                this.logger.info((CharSequence)log);
            }
        }
        String code = diagnostic.getCode();
        if (code != null) {
            this.codeCount.merge(code, 1, (old, initial) -> old + 1);
        }
    }

    Optional<String> firstError(Exception cause) {
        return Optional.ofNullable(cause != null && this.firstError == null ? cause.getMessage() : this.firstError);
    }

    void logSummary() {
        String patternForCount;
        MessageBuilder message = this.messageBuilderFactory.builder();
        if (!this.codeCount.isEmpty()) {
            Map.Entry[] entries = (Map.Entry[])this.codeCount.entrySet().toArray(Map.Entry[]::new);
            Arrays.sort(entries, (a, b) -> Integer.compare((Integer)b.getValue(), (Integer)a.getValue()));
            patternForCount = DiagnosticLogger.patternForCount(Math.max((Integer)entries[0].getValue(), Math.max(this.numWarnings, this.numErrors)));
            message.strong((Object)"Summary of compiler messages:").newline();
            for (Map.Entry entry : entries) {
                int count = (Integer)entry.getValue();
                message.format(patternForCount, new Object[]{count, entry.getKey()}).newline();
            }
        } else {
            patternForCount = DiagnosticLogger.patternForCount(Math.max(this.numWarnings, this.numErrors));
        }
        if ((this.numWarnings | this.numErrors) != 0) {
            message.strong((Object)"Total:").newline();
        }
        if (this.numWarnings != 0) {
            DiagnosticLogger.writeCount(message, patternForCount, this.numWarnings, "warning");
        }
        if (this.numErrors != 0) {
            DiagnosticLogger.writeCount(message, patternForCount, this.numErrors, "error");
        }
        this.logger.info((CharSequence)message.toString());
    }

    private static String patternForCount(int n) {
        return "    %" + Integer.toString(n).length() + "d %s";
    }

    private static void writeCount(MessageBuilder message, String patternForCount, int count, String name) {
        message.format(patternForCount, new Object[]{count, name});
        if (count > 1) {
            message.append('s');
        }
        message.newline();
    }
}

