/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.assembly.artifact;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DefaultArtifact;
import org.apache.maven.artifact.handler.manager.ArtifactHandlerManager;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.plugins.assembly.AssemblerConfigurationSource;
import org.apache.maven.plugins.assembly.archive.ArchiveCreationException;
import org.apache.maven.plugins.assembly.archive.phase.ModuleSetAssemblyPhase;
import org.apache.maven.plugins.assembly.artifact.DependencyResolutionException;
import org.apache.maven.plugins.assembly.artifact.DependencyResolver;
import org.apache.maven.plugins.assembly.artifact.ResolutionManagementInfo;
import org.apache.maven.plugins.assembly.model.Assembly;
import org.apache.maven.plugins.assembly.model.DependencySet;
import org.apache.maven.plugins.assembly.model.ModuleBinaries;
import org.apache.maven.plugins.assembly.model.ModuleSet;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@Named
public class DefaultDependencyResolver
implements DependencyResolver {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultDependencyResolver.class);
    private final ArtifactHandlerManager artifactHandlerManager;

    @Inject
    public DefaultDependencyResolver(ArtifactHandlerManager artifactHandlerManager) {
        this.artifactHandlerManager = Objects.requireNonNull(artifactHandlerManager);
    }

    @Override
    public Map<DependencySet, Set<Artifact>> resolveDependencySets(Assembly assembly, ModuleSet moduleSet, AssemblerConfigurationSource configSource, List<DependencySet> dependencySets) throws DependencyResolutionException {
        LinkedHashMap<DependencySet, Set<Artifact>> result = new LinkedHashMap<DependencySet, Set<Artifact>>();
        for (DependencySet dependencySet : dependencySets) {
            MavenProject currentProject = configSource.getProject();
            ResolutionManagementInfo info = new ResolutionManagementInfo();
            this.updateDependencySetResolutionRequirements(dependencySet, info, currentProject);
            this.updateModuleSetResolutionRequirements(moduleSet, dependencySet, info, configSource);
            result.put(dependencySet, info.getArtifacts());
        }
        return result;
    }

    @Override
    public Map<DependencySet, Set<Artifact>> resolveDependencySets(Assembly assembly, AssemblerConfigurationSource configSource, List<DependencySet> dependencySets) throws DependencyResolutionException {
        LinkedHashMap<DependencySet, Set<Artifact>> result = new LinkedHashMap<DependencySet, Set<Artifact>>();
        for (DependencySet dependencySet : dependencySets) {
            MavenProject currentProject = configSource.getProject();
            ResolutionManagementInfo info = new ResolutionManagementInfo();
            this.updateDependencySetResolutionRequirements(dependencySet, info, currentProject);
            result.put(dependencySet, info.getArtifacts());
        }
        return result;
    }

    void updateModuleSetResolutionRequirements(ModuleSet set, DependencySet dependencySet, ResolutionManagementInfo requirements, AssemblerConfigurationSource configSource) throws DependencyResolutionException {
        ModuleBinaries binaries = set.getBinaries();
        if (binaries != null) {
            Set<MavenProject> projects;
            try {
                projects = ModuleSetAssemblyPhase.getModuleProjects(set, configSource, LOGGER);
            }
            catch (ArchiveCreationException e) {
                throw new DependencyResolutionException("Error determining project-set for moduleSet with binaries.", e);
            }
            for (MavenProject p : projects) {
                if (p.getArtifact() != null) continue;
                p.setArtifact(this.createArtifact(p.getGroupId(), p.getArtifactId(), p.getVersion(), p.getPackaging()));
            }
            if (binaries.isIncludeDependencies()) {
                this.updateDependencySetResolutionRequirements(dependencySet, requirements, projects.toArray(new MavenProject[0]));
            }
        }
    }

    private Artifact createArtifact(String groupId, String artifactId, String version, String type) {
        VersionRange versionRange = null;
        if (version != null) {
            versionRange = VersionRange.createFromVersion((String)version);
        }
        return new DefaultArtifact(groupId, artifactId, versionRange, null, type, null, this.artifactHandlerManager.getArtifactHandler(type), false);
    }

    void updateDependencySetResolutionRequirements(DependencySet set, ResolutionManagementInfo requirements, MavenProject ... projects) throws DependencyResolutionException {
        for (MavenProject project : projects) {
            if (project == null) continue;
            Set dependencyArtifacts = null;
            dependencyArtifacts = set.isUseTransitiveDependencies() ? project.getArtifacts() : project.getDependencyArtifacts();
            requirements.addArtifacts(dependencyArtifacts);
            LOGGER.debug("Dependencies for project: " + project.getId() + " are:\n" + StringUtils.join(dependencyArtifacts.iterator(), (String)"\n"));
        }
    }
}

