/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.assembly.utils;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.RandomAccessFile;
import org.apache.maven.plugins.assembly.format.AssemblyFormattingException;
import org.apache.maven.plugins.assembly.utils.LineEndings;
import org.apache.maven.plugins.assembly.utils.LinuxLineFeedInputStream;
import org.apache.maven.plugins.assembly.utils.WindowsLineFeedInputStream;

public final class LineEndingsUtils {
    private LineEndingsUtils() {
    }

    /*
     * Unable to fully structure code
     */
    public static void convertLineEndings(File source, File dest, LineEndings lineEndings, Boolean atEndOfFile, String encoding) throws IOException {
        eofChars = "";
        if (atEndOfFile == null) {
            if (source.length() >= 1L) {
                raf = new RandomAccessFile(source, "r");
                var7_7 = null;
                try {
                    raf.seek(source.length() - 1L);
                    last = raf.readByte();
                    if (last != 10) ** GOTO lbl29
                    eofChars = lineEndings.getLineEndingCharacters();
                }
                catch (Throwable last) {
                    var7_7 = last;
                    throw last;
                }
                finally {
                    if (raf != null) {
                        if (var7_7 != null) {
                            try {
                                raf.close();
                            }
                            catch (Throwable last) {
                                var7_7.addSuppressed(last);
                            }
                        } else {
                            raf.close();
                        }
                    }
                }
            }
        } else if (atEndOfFile.booleanValue()) {
            eofChars = lineEndings.getLineEndingCharacters();
        }
lbl29:
        // 6 sources

        in = LineEndingsUtils.getBufferedReader(source, encoding);
        var7_7 = null;
        try {
            out = LineEndingsUtils.getBufferedWriter(dest, encoding);
            var9_15 = null;
            try {
                line = in.readLine();
                while (line != null) {
                    out.write(line);
                    line = in.readLine();
                    if (line != null) {
                        out.write(lineEndings.getLineEndingCharacters());
                        continue;
                    }
                    out.write(eofChars);
                }
            }
            catch (Throwable var10_19) {
                var9_15 = var10_19;
                throw var10_19;
            }
            finally {
                if (out != null) {
                    if (var9_15 != null) {
                        try {
                            out.close();
                        }
                        catch (Throwable var10_18) {
                            var9_15.addSuppressed(var10_18);
                        }
                    } else {
                        out.close();
                    }
                }
            }
        }
        catch (Throwable var8_13) {
            var7_7 = var8_13;
            throw var8_13;
        }
        finally {
            if (in != null) {
                if (var7_7 != null) {
                    try {
                        in.close();
                    }
                    catch (Throwable var8_12) {
                        var7_7.addSuppressed(var8_12);
                    }
                } else {
                    in.close();
                }
            }
        }
    }

    private static BufferedReader getBufferedReader(File source, String encoding) throws IOException {
        if (encoding == null) {
            return new BufferedReader(new InputStreamReader(new FileInputStream(source)));
        }
        return new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(source), encoding));
    }

    private static BufferedWriter getBufferedWriter(File dest, String encoding) throws IOException {
        if (encoding == null) {
            return new BufferedWriter(new OutputStreamWriter(new FileOutputStream(dest)));
        }
        return new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(dest), encoding));
    }

    public static InputStream lineEndingConverter(InputStream in, LineEndings lineEndings) throws IOException {
        return lineEndings.isNewLine() ? new LinuxLineFeedInputStream(in, false) : (lineEndings.isCrLF() ? new WindowsLineFeedInputStream(in, false) : in);
    }

    public static LineEndings getLineEnding(String lineEnding) throws AssemblyFormattingException {
        LineEndings result = LineEndings.keep;
        if (lineEnding != null) {
            try {
                result = LineEndings.valueOf(lineEnding);
            }
            catch (IllegalArgumentException e) {
                throw new AssemblyFormattingException("Illegal lineEnding specified: '" + lineEnding + "'", e);
            }
        }
        return result;
    }

    public static String getLineEndingCharacters(String lineEnding) throws AssemblyFormattingException {
        String value = lineEnding;
        if (lineEnding != null) {
            try {
                value = LineEndings.valueOf(lineEnding).getLineEndingCharacters();
            }
            catch (IllegalArgumentException e) {
                throw new AssemblyFormattingException("Illegal lineEnding specified: '" + lineEnding + "'", e);
            }
        }
        return value;
    }
}

