/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.assembly.artifact;

import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.maven.artifact.Artifact;

class ResolutionManagementInfo {
    private final LinkedHashSet<Artifact> artifacts = new LinkedHashSet();

    ResolutionManagementInfo() {
    }

    Set<Artifact> getArtifacts() {
        return this.artifacts;
    }

    void addArtifacts(Set<Artifact> a) {
        for (Artifact artifact : a) {
            this.addOneArtifact(artifact);
        }
        this.artifacts.addAll(a);
    }

    private void addOneArtifact(Artifact artifact) {
        for (Artifact existing : this.artifacts) {
            if (!existing.equals(artifact) || !this.isScopeUpgrade(artifact, existing)) continue;
            this.artifacts.remove(existing);
            this.artifacts.add(artifact);
            return;
        }
    }

    private boolean isScopeUpgrade(Artifact a, Artifact existing) {
        return this.scopeValue(a.getScope()) > this.scopeValue(existing.getScope());
    }

    private int scopeValue(String scope) {
        if ("compile".equals(scope)) {
            return 5;
        }
        if ("provided".equals(scope)) {
            return 4;
        }
        if ("runtime".equals(scope)) {
            return 3;
        }
        if ("system".equals(scope)) {
            return 2;
        }
        if ("test".equals(scope)) {
            return 1;
        }
        return 0;
    }
}

