/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.buildcache.xml.report.io.xpp3;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import org.apache.maven.buildcache.xml.report.CacheReport;
import org.apache.maven.buildcache.xml.report.ProjectReport;
import org.codehaus.plexus.util.xml.pull.MXSerializer;
import org.codehaus.plexus.util.xml.pull.XmlSerializer;

public class BuildCacheReportXpp3Writer {
    private static final String NAMESPACE = null;
    private String fileComment = null;

    public void setFileComment(String fileComment) {
        this.fileComment = fileComment;
    }

    public void write(Writer writer, CacheReport cacheReport) throws IOException {
        MXSerializer serializer = new MXSerializer();
        serializer.setProperty("http://xmlpull.org/v1/doc/properties.html#serializer-indentation", (Object)"  ");
        serializer.setProperty("http://xmlpull.org/v1/doc/properties.html#serializer-line-separator", (Object)"\n");
        serializer.setOutput(writer);
        serializer.startDocument(cacheReport.getModelEncoding(), null);
        this.writeCacheReport(cacheReport, "cacheReport", (XmlSerializer)serializer);
        serializer.endDocument();
    }

    public void write(OutputStream stream, CacheReport cacheReport) throws IOException {
        MXSerializer serializer = new MXSerializer();
        serializer.setProperty("http://xmlpull.org/v1/doc/properties.html#serializer-indentation", (Object)"  ");
        serializer.setProperty("http://xmlpull.org/v1/doc/properties.html#serializer-line-separator", (Object)"\n");
        serializer.setOutput(stream, cacheReport.getModelEncoding());
        serializer.startDocument(cacheReport.getModelEncoding(), null);
        this.writeCacheReport(cacheReport, "cacheReport", (XmlSerializer)serializer);
        serializer.endDocument();
    }

    private void writeCacheReport(CacheReport cacheReport, String tagName, XmlSerializer serializer) throws IOException {
        if (this.fileComment != null) {
            serializer.comment(this.fileComment);
        }
        serializer.setPrefix("", "http://maven.apache.org/BUILD-CACHE-REPORT/1.0.0");
        serializer.setPrefix("xsi", "http://www.w3.org/2001/XMLSchema-instance");
        serializer.startTag(NAMESPACE, tagName);
        serializer.attribute("", "xsi:schemaLocation", "http://maven.apache.org/BUILD-CACHE-REPORT/1.0.0 https://maven.apache.org/xsd/build-cache-report-1.0.0.xsd");
        if (cacheReport.getProjects() != null && cacheReport.getProjects().size() > 0) {
            serializer.startTag(NAMESPACE, "projects");
            for (ProjectReport o : cacheReport.getProjects()) {
                this.writeProjectReport(o, "project", serializer);
            }
            serializer.endTag(NAMESPACE, "projects");
        }
        serializer.endTag(NAMESPACE, tagName);
    }

    private void writeProjectReport(ProjectReport projectReport, String tagName, XmlSerializer serializer) throws IOException {
        serializer.startTag(NAMESPACE, tagName);
        if (projectReport.getGroupId() != null) {
            serializer.startTag(NAMESPACE, "groupId").text(projectReport.getGroupId()).endTag(NAMESPACE, "groupId");
        }
        if (projectReport.getArtifactId() != null) {
            serializer.startTag(NAMESPACE, "artifactId").text(projectReport.getArtifactId()).endTag(NAMESPACE, "artifactId");
        }
        if (projectReport.getChecksum() != null) {
            serializer.startTag(NAMESPACE, "checksum").text(projectReport.getChecksum()).endTag(NAMESPACE, "checksum");
        }
        if (projectReport.isChecksumMatched() != null) {
            serializer.startTag(NAMESPACE, "checksumMatched").text(String.valueOf(projectReport.isChecksumMatched())).endTag(NAMESPACE, "checksumMatched");
        }
        if (projectReport.isLifecycleMatched() != null) {
            serializer.startTag(NAMESPACE, "lifecycleMatched").text(String.valueOf(projectReport.isLifecycleMatched())).endTag(NAMESPACE, "lifecycleMatched");
        }
        if (projectReport.isPluginsMatched() != null) {
            serializer.startTag(NAMESPACE, "pluginsMatched").text(String.valueOf(projectReport.isPluginsMatched())).endTag(NAMESPACE, "pluginsMatched");
        }
        if (projectReport.getSource() != null) {
            serializer.startTag(NAMESPACE, "source").text(projectReport.getSource()).endTag(NAMESPACE, "source");
        }
        if (projectReport.isSharedToRemote() != null) {
            serializer.startTag(NAMESPACE, "sharedToRemote").text(String.valueOf(projectReport.isSharedToRemote())).endTag(NAMESPACE, "sharedToRemote");
        }
        if (projectReport.getUrl() != null) {
            serializer.startTag(NAMESPACE, "url").text(projectReport.getUrl()).endTag(NAMESPACE, "url");
        }
        serializer.endTag(NAMESPACE, tagName);
    }
}

