/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.buildcache;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Enumeration;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.maven.buildcache.CacheUtils;
import org.apache.maven.buildcache.RestoredArtifactHandler;
import org.apache.maven.buildcache.xml.CacheConfig;
import org.apache.maven.project.MavenProject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@Named
public class DefaultRestoredArtifactHandler
implements RestoredArtifactHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultRestoredArtifactHandler.class);
    private static final String DIR_NAME = "cache-build-tmp";
    private final boolean adjustMetaInfVersion;

    @Inject
    public DefaultRestoredArtifactHandler(CacheConfig cacheConfig) {
        this.adjustMetaInfVersion = cacheConfig.adjustMetaInfVersion();
    }

    @Override
    public Path adjustArchiveArtifactVersion(MavenProject project, String originalArtifactVersion, Path artifactFile) throws IOException {
        if (!this.adjustMetaInfVersion) {
            return artifactFile;
        }
        File file = artifactFile.toFile();
        if (project.getVersion().equals(originalArtifactVersion) || !CacheUtils.isArchive(file)) {
            return artifactFile;
        }
        File tempDirName = Paths.get(project.getBuild().getDirectory(), new String[0]).normalize().resolve(DIR_NAME).toFile();
        if (tempDirName.mkdirs()) {
            LOGGER.debug("Temporary directory to restore artifact was created [artifactFile={}, originalVersion={}, tempDir={}]", new Object[]{artifactFile, originalArtifactVersion, tempDirName});
        }
        String currentVersion = project.getVersion();
        File tmpJarFile = File.createTempFile(artifactFile.toFile().getName(), '.' + FilenameUtils.getExtension((String)file.getName()), tempDirName);
        tmpJarFile.deleteOnExit();
        String originalImplVersion = Attributes.Name.IMPLEMENTATION_VERSION + ": " + originalArtifactVersion;
        String implVersion = Attributes.Name.IMPLEMENTATION_VERSION + ": " + currentVersion;
        String commonXmlOriginalVersion = "<version>" + originalArtifactVersion + "</version>";
        String commonXmlVersion = "<version>" + currentVersion + "</version>";
        String originalPomPropsVersion = "version=" + originalArtifactVersion;
        String pomPropsVersion = "version=" + currentVersion;
        try (JarFile jarFile = new JarFile(artifactFile.toFile());
             JarOutputStream jos = new JarOutputStream(new BufferedOutputStream(new FileOutputStream(tmpJarFile)));){
            Enumeration<JarEntry> jarEntries = jarFile.entries();
            byte[] buffer = new byte[1024];
            while (jarEntries.hasMoreElements()) {
                JarEntry entry = jarEntries.nextElement();
                String entryName = entry.getName();
                if (entryName.startsWith("META-INF/maven") && (entryName.endsWith("plugin.xml") || entryName.endsWith("plugin-help.xml"))) {
                    DefaultRestoredArtifactHandler.replaceEntry(jarFile, entry, commonXmlOriginalVersion, commonXmlVersion, jos);
                    continue;
                }
                if (entryName.endsWith("pom.xml")) {
                    DefaultRestoredArtifactHandler.replaceEntry(jarFile, entry, commonXmlOriginalVersion, commonXmlVersion, jos);
                    continue;
                }
                if (entryName.endsWith("pom.properties")) {
                    DefaultRestoredArtifactHandler.replaceEntry(jarFile, entry, originalPomPropsVersion, pomPropsVersion, jos);
                    continue;
                }
                if ("META-INF/MANIFEST.MF".equals(entryName)) {
                    DefaultRestoredArtifactHandler.replaceEntry(jarFile, entry, originalImplVersion, implVersion, jos);
                    continue;
                }
                jos.putNextEntry(entry);
                InputStream entryInputStream = jarFile.getInputStream(entry);
                try {
                    int bytesRead;
                    while ((bytesRead = entryInputStream.read(buffer)) != -1) {
                        jos.write(buffer, 0, bytesRead);
                    }
                }
                finally {
                    if (entryInputStream == null) continue;
                    entryInputStream.close();
                }
            }
        }
        return tmpJarFile.toPath();
    }

    private static void replaceEntry(JarFile jarFile, JarEntry entry, String toReplace, String replacement, JarOutputStream jos) throws IOException {
        String fullManifest = IOUtils.toString((InputStream)jarFile.getInputStream(entry), (String)StandardCharsets.UTF_8.name());
        String modified = fullManifest.replaceAll(toReplace, replacement);
        byte[] bytes = modified.getBytes(StandardCharsets.UTF_8);
        JarEntry newEntry = new JarEntry(entry.getName());
        jos.putNextEntry(newEntry);
        jos.write(bytes);
    }
}

