/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.buildcache;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeSet;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.apache.maven.SessionScoped;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.artifact.handler.manager.ArtifactHandlerManager;
import org.apache.maven.buildcache.CacheContext;
import org.apache.maven.buildcache.CacheController;
import org.apache.maven.buildcache.CacheDiff;
import org.apache.maven.buildcache.CacheResult;
import org.apache.maven.buildcache.CacheUtils;
import org.apache.maven.buildcache.LifecyclePhasesHelper;
import org.apache.maven.buildcache.LocalCacheRepository;
import org.apache.maven.buildcache.ProjectInputCalculator;
import org.apache.maven.buildcache.RemoteCacheRepository;
import org.apache.maven.buildcache.RestoreStatus;
import org.apache.maven.buildcache.RestoredArtifactHandler;
import org.apache.maven.buildcache.artifact.ArtifactRestorationReport;
import org.apache.maven.buildcache.artifact.OutputType;
import org.apache.maven.buildcache.artifact.RestoredArtifact;
import org.apache.maven.buildcache.checksum.KeyUtils;
import org.apache.maven.buildcache.checksum.MavenProjectInput;
import org.apache.maven.buildcache.hash.HashAlgorithm;
import org.apache.maven.buildcache.hash.HashFactory;
import org.apache.maven.buildcache.xml.Build;
import org.apache.maven.buildcache.xml.CacheConfig;
import org.apache.maven.buildcache.xml.CacheSource;
import org.apache.maven.buildcache.xml.DtoUtils;
import org.apache.maven.buildcache.xml.XmlService;
import org.apache.maven.buildcache.xml.build.Artifact;
import org.apache.maven.buildcache.xml.build.CompletedExecution;
import org.apache.maven.buildcache.xml.build.DigestItem;
import org.apache.maven.buildcache.xml.build.ProjectsInputInfo;
import org.apache.maven.buildcache.xml.build.Scm;
import org.apache.maven.buildcache.xml.config.DirName;
import org.apache.maven.buildcache.xml.config.PropertyName;
import org.apache.maven.buildcache.xml.config.TrackedProperty;
import org.apache.maven.buildcache.xml.diff.Diff;
import org.apache.maven.buildcache.xml.report.CacheReport;
import org.apache.maven.buildcache.xml.report.ProjectReport;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.execution.MojoExecutionEvent;
import org.apache.maven.plugin.Mojo;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.descriptor.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.apache.maven.repository.RepositorySystem;
import org.codehaus.plexus.util.ReflectionUtils;
import org.codehaus.plexus.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SessionScoped
@Named
public class CacheControllerImpl
implements CacheController {
    private static final Logger LOGGER = LoggerFactory.getLogger(CacheControllerImpl.class);
    private static final String DEFAULT_FILE_GLOB = "*";
    public static final String ERROR_MSG_RESTORATION_OUTSIDE_PROJECT = "Blocked an attempt to restore files outside of a project directory: ";
    private final MavenProjectHelper projectHelper;
    private final ArtifactHandlerManager artifactHandlerManager;
    private final XmlService xmlService;
    private final CacheConfig cacheConfig;
    private final LocalCacheRepository localCache;
    private final RemoteCacheRepository remoteCache;
    private final ConcurrentMap<String, CacheResult> cacheResults = new ConcurrentHashMap<String, CacheResult>();
    private final LifecyclePhasesHelper lifecyclePhasesHelper;
    private volatile Map<String, MavenProject> projectIndex;
    private final ProjectInputCalculator projectInputCalculator;
    private final RestoredArtifactHandler restoreArtifactHandler;
    private volatile Scm scm;
    private Map<String, Path> attachedResourcesPathsById = new HashMap<String, Path>();
    private int attachedResourceCounter = 0;

    @Inject
    public CacheControllerImpl(MavenProjectHelper projectHelper, RepositorySystem repoSystem, ArtifactHandlerManager artifactHandlerManager, XmlService xmlService, LocalCacheRepository localCache, RemoteCacheRepository remoteCache, CacheConfig cacheConfig, ProjectInputCalculator projectInputCalculator, RestoredArtifactHandler restoreArtifactHandler, LifecyclePhasesHelper lifecyclePhasesHelper, MavenSession session) {
        this.projectHelper = projectHelper;
        this.localCache = localCache;
        this.remoteCache = remoteCache;
        this.cacheConfig = cacheConfig;
        this.artifactHandlerManager = artifactHandlerManager;
        this.xmlService = xmlService;
        this.lifecyclePhasesHelper = lifecyclePhasesHelper;
        this.projectInputCalculator = projectInputCalculator;
        this.restoreArtifactHandler = restoreArtifactHandler;
    }

    @Override
    @Nonnull
    public CacheResult findCachedBuild(MavenSession session, MavenProject project, List<MojoExecution> mojoExecutions, boolean skipCache) {
        String highestPhase = this.lifecyclePhasesHelper.resolveHighestLifecyclePhase(project, mojoExecutions);
        if (!this.lifecyclePhasesHelper.isLaterPhaseThanClean(highestPhase)) {
            return CacheResult.empty();
        }
        String projectName = KeyUtils.getVersionlessProjectKey(project);
        ProjectsInputInfo inputInfo = this.projectInputCalculator.calculateInput(project);
        CacheContext context = new CacheContext(project, inputInfo, session);
        CacheResult result = CacheResult.empty(context);
        if (!skipCache) {
            LOGGER.info("Attempting to restore project {} from build cache", (Object)projectName);
            if (this.cacheConfig.isRemoteCacheEnabled() && !(result = this.findCachedBuild(mojoExecutions, context)).isSuccess() && result.getContext() != null) {
                LOGGER.info("Remote cache is incomplete or missing, trying local build for {}", (Object)projectName);
            }
            if (!result.isSuccess() && result.getContext() != null) {
                CacheResult localBuild = this.findLocalBuild(mojoExecutions, context);
                if (localBuild.isSuccess() || localBuild.isPartialSuccess() && !result.isPartialSuccess()) {
                    result = localBuild;
                } else {
                    LOGGER.info("Local build was not found by checksum {} for {}", (Object)inputInfo.getChecksum(), (Object)projectName);
                }
            }
        } else {
            LOGGER.info("Project {} is marked as requiring force rebuild, will skip lookup in build cache", (Object)projectName);
        }
        this.cacheResults.put(KeyUtils.getVersionlessProjectKey(project), result);
        return result;
    }

    private CacheResult findCachedBuild(List<MojoExecution> mojoExecutions, CacheContext context) {
        Optional<Object> cachedBuild = Optional.empty();
        try {
            cachedBuild = this.localCache.findBuild(context);
            if (cachedBuild.isPresent()) {
                return this.analyzeResult(context, mojoExecutions, (Build)cachedBuild.get());
            }
        }
        catch (Exception e) {
            LOGGER.error("Cannot read cached remote build", (Throwable)e);
        }
        return cachedBuild.map(build -> CacheResult.failure(build, context)).orElseGet(() -> CacheResult.empty(context));
    }

    private CacheResult findLocalBuild(List<MojoExecution> mojoExecutions, CacheContext context) {
        Optional<Object> localBuild = Optional.empty();
        try {
            localBuild = this.localCache.findLocalBuild(context);
            if (localBuild.isPresent()) {
                return this.analyzeResult(context, mojoExecutions, (Build)localBuild.get());
            }
        }
        catch (Exception e) {
            LOGGER.error("Cannot read local build", (Throwable)e);
        }
        return localBuild.map(build -> CacheResult.failure(build, context)).orElseGet(() -> CacheResult.empty(context));
    }

    private CacheResult analyzeResult(CacheContext context, List<MojoExecution> mojoExecutions, Build build) {
        try {
            List<MojoExecution> cachedSegment;
            List<MojoExecution> missingMojos;
            ProjectsInputInfo inputInfo = context.getInputInfo();
            String projectName = KeyUtils.getVersionlessProjectKey(context.getProject());
            LOGGER.info("Found cached build, restoring {} from cache by checksum {}", (Object)projectName, (Object)inputInfo.getChecksum());
            LOGGER.debug("Cached build details: {}", (Object)build);
            String cacheImplementationVersion = build.getCacheImplementationVersion();
            if (!"v1.1".equals(cacheImplementationVersion)) {
                LOGGER.warn("Maven and cached build implementations mismatch, caching might not work correctly. Implementation version: v1.1, cached build: {}", (Object)build.getCacheImplementationVersion());
            }
            if (!(missingMojos = build.getMissingExecutions(cachedSegment = this.lifecyclePhasesHelper.getCachedSegment(context.getProject(), mojoExecutions, build))).isEmpty()) {
                LOGGER.warn("Cached build doesn't contains all requested plugin executions (missing: {}), cannot restore", missingMojos);
                return CacheResult.failure(build, context);
            }
            if (!this.isCachedSegmentPropertiesPresent(context.getProject(), build, cachedSegment)) {
                LOGGER.info("Cached build violates cache rules, cannot restore");
                return CacheResult.failure(build, context);
            }
            String highestRequestPhase = this.lifecyclePhasesHelper.resolveHighestLifecyclePhase(context.getProject(), mojoExecutions);
            if (this.lifecyclePhasesHelper.isLaterPhaseThanBuild(highestRequestPhase, build) && !this.canIgnoreMissingSegment(context.getProject(), build, mojoExecutions)) {
                LOGGER.info("Project {} restored partially. Highest cached goal: {}, requested: {}", new Object[]{projectName, build.getHighestCompletedGoal(), highestRequestPhase});
                return CacheResult.partialSuccess(build, context);
            }
            return CacheResult.success(build, context);
        }
        catch (Exception e) {
            LOGGER.error("Failed to restore project", (Throwable)e);
            this.localCache.clearCache(context);
            return CacheResult.failure(build, context);
        }
    }

    private boolean canIgnoreMissingSegment(MavenProject project, Build info, List<MojoExecution> mojoExecutions) {
        List<MojoExecution> postCachedSegment = this.lifecyclePhasesHelper.getPostCachedSegment(project, mojoExecutions, info);
        for (MojoExecution mojoExecution : postCachedSegment) {
            if (this.cacheConfig.canIgnore(mojoExecution)) continue;
            return false;
        }
        return true;
    }

    private Function<File, File> createRestorationToDiskConsumer(MavenProject project, Artifact artifact) {
        if (this.cacheConfig.isRestoreOnDiskArtifacts() && MavenProjectInput.isRestoreOnDiskArtifacts(project)) {
            Path restorationPath = project.getBasedir().toPath().resolve(artifact.getFilePath());
            AtomicBoolean restored = new AtomicBoolean(false);
            return file -> {
                if (restored.compareAndSet(false, true)) {
                    this.verifyRestorationInsideProject(project, restorationPath);
                    try {
                        Files.createDirectories(restorationPath.getParent(), new FileAttribute[0]);
                        Files.copy(file.toPath(), restorationPath, StandardCopyOption.REPLACE_EXISTING);
                    }
                    catch (IOException e) {
                        LOGGER.error("Cannot restore file " + artifact.getFileName(), (Throwable)e);
                        throw new RuntimeException(e);
                    }
                    LOGGER.debug("Restored file on disk ({} to {})", (Object)artifact.getFileName(), (Object)restorationPath);
                }
                return restorationPath.toFile();
            };
        }
        return file -> file;
    }

    private boolean isPathInsideProject(MavenProject project, Path path) {
        Path restorationPath = path.toAbsolutePath().normalize();
        return restorationPath.startsWith(project.getBasedir().toPath());
    }

    private void verifyRestorationInsideProject(MavenProject project, Path path) {
        if (!this.isPathInsideProject(project, path)) {
            Path normalized = path.toAbsolutePath().normalize();
            LOGGER.error(ERROR_MSG_RESTORATION_OUTSIDE_PROJECT + normalized);
            throw new RuntimeException(ERROR_MSG_RESTORATION_OUTSIDE_PROJECT + normalized);
        }
    }

    @Override
    public ArtifactRestorationReport restoreProjectArtifacts(CacheResult cacheResult) {
        LOGGER.debug("Restore project artifacts");
        Build build = cacheResult.getBuildInfo();
        CacheContext context = cacheResult.getContext();
        MavenProject project = context.getProject();
        ArtifactRestorationReport restorationReport = new ArtifactRestorationReport();
        try {
            RestoredArtifact restoredProjectArtifact = null;
            ArrayList<RestoredArtifact> restoredAttachedArtifacts = new ArrayList<RestoredArtifact>();
            if (build.getArtifact() != null && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)build.getArtifact().getFileName())) {
                Artifact artifactInfo = build.getArtifact();
                String originalVersion = artifactInfo.getVersion();
                artifactInfo.setVersion(project.getVersion());
                Future<File> downloadTask = this.createDownloadTask(cacheResult, context, project, artifactInfo, originalVersion);
                restoredProjectArtifact = this.restoredArtifact(project.getArtifact(), artifactInfo.getType(), artifactInfo.getClassifier(), downloadTask, this.createRestorationToDiskConsumer(project, artifactInfo));
                if (!this.cacheConfig.isLazyRestore()) {
                    restoredProjectArtifact.getFile();
                }
            }
            for (Artifact attachedArtifactInfo : build.getAttachedArtifacts()) {
                String originalVersion = attachedArtifactInfo.getVersion();
                attachedArtifactInfo.setVersion(project.getVersion());
                if (!org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)attachedArtifactInfo.getFileName())) continue;
                OutputType outputType = OutputType.fromClassifier(attachedArtifactInfo.getClassifier());
                if (OutputType.ARTIFACT != outputType) {
                    if (!this.cacheConfig.isRestoreGeneratedSources() || !MavenProjectInput.isRestoreGeneratedSources(project)) continue;
                    restorationReport.setRestoredFilesInProjectDirectory(true);
                    Path attachedArtifactFile = this.localCache.getArtifactFile(context, cacheResult.getSource(), attachedArtifactInfo);
                    this.restoreGeneratedSources(attachedArtifactInfo, attachedArtifactFile, project);
                    continue;
                }
                Future<File> downloadTask = this.createDownloadTask(cacheResult, context, project, attachedArtifactInfo, originalVersion);
                RestoredArtifact restoredAttachedArtifact = this.restoredArtifact((org.apache.maven.artifact.Artifact)(restoredProjectArtifact == null ? project.getArtifact() : restoredProjectArtifact), attachedArtifactInfo.getType(), attachedArtifactInfo.getClassifier(), downloadTask, this.createRestorationToDiskConsumer(project, attachedArtifactInfo));
                if (!this.cacheConfig.isLazyRestore()) {
                    restoredAttachedArtifact.getFile();
                }
                restoredAttachedArtifacts.add(restoredAttachedArtifact);
            }
            if (restoredProjectArtifact != null) {
                project.setArtifact(restoredProjectArtifact);
                if (!project.hasLifecyclePhase("package")) {
                    project.addLifecyclePhase("package");
                }
            }
            restoredAttachedArtifacts.forEach(arg_0 -> ((MavenProject)project).addAttachedArtifact(arg_0));
            restorationReport.setSuccess(true);
        }
        catch (Exception e) {
            LOGGER.debug("Cannot restore cache, continuing with normal build.", (Throwable)e);
        }
        return restorationReport;
    }

    private RestoredArtifact restoredArtifact(org.apache.maven.artifact.Artifact parent, String artifactType, String artifactClassifier, Future<File> artifactFile, Function<File, File> restoreToDiskConsumer) {
        ArtifactHandler handler = null;
        if (artifactType != null) {
            handler = this.artifactHandlerManager.getArtifactHandler(artifactType);
        }
        if (handler == null) {
            handler = this.artifactHandlerManager.getArtifactHandler("jar");
        }
        RestoredArtifact artifact = new RestoredArtifact(parent, artifactFile, artifactType, artifactClassifier, handler, restoreToDiskConsumer);
        artifact.setResolved(true);
        return artifact;
    }

    private Future<File> createDownloadTask(CacheResult cacheResult, CacheContext context, MavenProject project, Artifact artifact, String originalVersion) {
        FutureTask<File> downloadTask = new FutureTask<File>(() -> {
            LOGGER.debug("Downloading artifact {}", (Object)artifact.getArtifactId());
            Path artifactFile = this.localCache.getArtifactFile(context, cacheResult.getSource(), artifact);
            if (!Files.exists(artifactFile, new LinkOption[0])) {
                throw new FileNotFoundException("Missing file for cached build, cannot restore. File: " + artifactFile);
            }
            LOGGER.debug("Downloaded artifact " + artifact.getArtifactId() + " to: " + artifactFile);
            return this.restoreArtifactHandler.adjustArchiveArtifactVersion(project, originalVersion, artifactFile).toFile();
        });
        if (!this.cacheConfig.isLazyRestore()) {
            downloadTask.run();
        }
        return downloadTask;
    }

    @Override
    public void save(CacheResult cacheResult, List<MojoExecution> mojoExecutions, Map<String, MojoExecutionEvent> executionEvents) {
        CacheContext context = cacheResult.getContext();
        if (context == null || context.getInputInfo() == null) {
            LOGGER.info("Cannot save project in cache, skipping");
            return;
        }
        MavenProject project = context.getProject();
        MavenSession session = context.getSession();
        try {
            Artifact projectArtifactDto;
            List<Artifact> attachedArtifactDtos;
            List attachedArtifacts;
            HashFactory hashFactory = this.cacheConfig.getHashFactory();
            org.apache.maven.artifact.Artifact projectArtifact = project.getArtifact();
            if (project.hasLifecyclePhase("package")) {
                HashAlgorithm algorithm = hashFactory.createAlgorithm();
                this.attachGeneratedSources(project);
                this.attachOutputs(project);
                attachedArtifacts = project.getAttachedArtifacts() != null ? project.getAttachedArtifacts() : Collections.emptyList();
                attachedArtifactDtos = this.artifactDtos(attachedArtifacts, algorithm, project);
                projectArtifactDto = this.artifactDto(project.getArtifact(), algorithm, project);
            } else {
                attachedArtifacts = Collections.emptyList();
                attachedArtifactDtos = new ArrayList<Artifact>();
                projectArtifactDto = null;
            }
            List<CompletedExecution> completedExecution = this.buildExecutionInfo(mojoExecutions, executionEvents);
            Build build = new Build(session.getGoals(), projectArtifactDto, attachedArtifactDtos, context.getInputInfo(), completedExecution, hashFactory.getAlgorithm());
            this.populateGitInfo(build, session);
            build.getDto().set_final(this.cacheConfig.isSaveToRemoteFinal());
            this.cacheResults.put(KeyUtils.getVersionlessProjectKey(project), CacheResult.rebuilded(cacheResult, build));
            this.localCache.beforeSave(context);
            if (project.hasLifecyclePhase("package")) {
                if (projectArtifact.getFile() != null) {
                    this.localCache.saveArtifactFile(cacheResult, projectArtifact);
                }
                for (org.apache.maven.artifact.Artifact attachedArtifact : attachedArtifacts) {
                    if (attachedArtifact.getFile() == null) continue;
                    boolean storeArtifact = this.isOutputArtifact(attachedArtifact.getFile().getName());
                    if (storeArtifact) {
                        this.localCache.saveArtifactFile(cacheResult, attachedArtifact);
                        continue;
                    }
                    LOGGER.debug("Skipping attached project artifact '{}' =  it is marked for exclusion from caching", (Object)attachedArtifact.getFile().getName());
                }
            }
            this.localCache.saveBuildInfo(cacheResult, build);
            if (this.cacheConfig.isBaselineDiffEnabled()) {
                this.produceDiffReport(cacheResult, build);
            }
        }
        catch (Exception e) {
            LOGGER.error("Failed to save project, cleaning cache. Project: {}", (Object)project, (Object)e);
            try {
                this.localCache.clearCache(context);
            }
            catch (Exception ex) {
                LOGGER.error("Failed to clean cache due to unexpected error:", (Throwable)ex);
            }
        }
    }

    public void produceDiffReport(CacheResult cacheResult, Build build) {
        MavenProject project = cacheResult.getContext().getProject();
        Optional<Build> baselineHolder = this.remoteCache.findBaselineBuild(project);
        if (baselineHolder.isPresent()) {
            Build baseline = baselineHolder.get();
            String outputDirectory = project.getBuild().getDirectory();
            Path reportOutputDir = Paths.get(outputDirectory, "incremental-maven");
            LOGGER.info("Saving cache builds diff to: {}", (Object)reportOutputDir);
            Diff diff = new CacheDiff(build.getDto(), baseline.getDto(), this.cacheConfig).compare();
            try {
                Optional<DigestItem> baselinePom;
                Files.createDirectories(reportOutputDir, new FileAttribute[0]);
                ProjectsInputInfo baselineInputs = baseline.getDto().getProjectsInputInfo();
                String checksum = baselineInputs.getChecksum();
                Files.write(reportOutputDir.resolve("buildinfo-baseline-" + checksum + ".xml"), this.xmlService.toBytes(baseline.getDto()), StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.CREATE);
                Files.write(reportOutputDir.resolve("buildinfo-" + checksum + ".xml"), this.xmlService.toBytes(build.getDto()), StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.CREATE);
                Files.write(reportOutputDir.resolve("buildsdiff-" + checksum + ".xml"), this.xmlService.toBytes(diff), StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.CREATE);
                Optional<DigestItem> pom = CacheDiff.findPom(build.getDto().getProjectsInputInfo());
                if (pom.isPresent()) {
                    Files.write(reportOutputDir.resolve("effective-pom-" + checksum + ".xml"), pom.get().getValue().getBytes(StandardCharsets.UTF_8), StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.CREATE);
                }
                if ((baselinePom = CacheDiff.findPom(baselineInputs)).isPresent()) {
                    Files.write(reportOutputDir.resolve("effective-pom-baseline-" + baselineInputs.getChecksum() + ".xml"), baselinePom.get().getValue().getBytes(StandardCharsets.UTF_8), StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.CREATE);
                }
            }
            catch (IOException e) {
                LOGGER.error("Cannot produce build diff for project", (Throwable)e);
            }
        } else {
            LOGGER.info("Cannot find project in baseline build, skipping diff");
        }
    }

    private List<Artifact> artifactDtos(List<org.apache.maven.artifact.Artifact> attachedArtifacts, HashAlgorithm digest, MavenProject project) throws IOException {
        ArrayList<Artifact> result = new ArrayList<Artifact>();
        for (org.apache.maven.artifact.Artifact attachedArtifact : attachedArtifacts) {
            if (attachedArtifact.getFile() == null || !this.isOutputArtifact(attachedArtifact.getFile().getName())) continue;
            result.add(this.artifactDto(attachedArtifact, digest, project));
        }
        return result;
    }

    private Artifact artifactDto(org.apache.maven.artifact.Artifact projectArtifact, HashAlgorithm algorithm, MavenProject project) throws IOException {
        Artifact dto = DtoUtils.createDto(projectArtifact);
        if (projectArtifact.getFile() != null && projectArtifact.getFile().isFile()) {
            Path file = projectArtifact.getFile().toPath();
            dto.setFileHash(algorithm.hash(file));
            dto.setFileSize(Files.size(file));
            Path relativePath = this.attachedResourcesPathsById.get(projectArtifact.getClassifier());
            if (relativePath == null) {
                relativePath = project.getBasedir().toPath().relativize(file.toAbsolutePath());
            }
            dto.setFilePath(FilenameUtils.separatorsToUnix((String)relativePath.toString()));
        }
        return dto;
    }

    private List<CompletedExecution> buildExecutionInfo(List<MojoExecution> mojoExecutions, Map<String, MojoExecutionEvent> executionEvents) {
        ArrayList<CompletedExecution> list = new ArrayList<CompletedExecution>();
        for (MojoExecution mojoExecution : mojoExecutions) {
            String executionKey = CacheUtils.mojoExecutionKey(mojoExecution);
            MojoExecutionEvent executionEvent = executionEvents != null ? executionEvents.get(executionKey) : null;
            CompletedExecution executionInfo = new CompletedExecution();
            executionInfo.setExecutionKey(executionKey);
            executionInfo.setMojoClassName(mojoExecution.getMojoDescriptor().getImplementation());
            if (executionEvent != null) {
                this.recordMojoProperties(executionInfo, executionEvent);
            }
            list.add(executionInfo);
        }
        return list;
    }

    private void recordMojoProperties(CompletedExecution execution, MojoExecutionEvent executionEvent) {
        MojoExecution mojoExecution = executionEvent.getExecution();
        boolean logAll = this.cacheConfig.isLogAllProperties(mojoExecution);
        List<TrackedProperty> trackedProperties = this.cacheConfig.getTrackedProperties(mojoExecution);
        List<PropertyName> noLogProperties = this.cacheConfig.getNologProperties(mojoExecution);
        List<PropertyName> forceLogProperties = this.cacheConfig.getLoggedProperties(mojoExecution);
        Mojo mojo = executionEvent.getMojo();
        File baseDir = executionEvent.getProject().getBasedir();
        String baseDirPath = FilenameUtils.normalizeNoEndSeparator((String)baseDir.getAbsolutePath()) + File.separator;
        List parameters = mojoExecution.getMojoDescriptor().getParameters();
        for (Parameter parameter : parameters) {
            String propertyName;
            boolean tracked;
            if (!parameter.isEditable() || !(tracked = this.isTracked(propertyName = parameter.getName(), trackedProperties)) && this.isExcluded(propertyName, logAll, noLogProperties, forceLogProperties)) continue;
            try {
                Field field = ReflectionUtils.getFieldByNameIncludingSuperclasses((String)propertyName, mojo.getClass());
                if (field != null) {
                    Object value = ReflectionUtils.getValueIncludingSuperclasses((String)propertyName, (Object)mojo);
                    DtoUtils.addProperty(execution, propertyName, value, baseDirPath, tracked);
                    continue;
                }
                Method getter = CacheControllerImpl.getGetter(propertyName, mojo.getClass());
                if (getter != null) {
                    Object value = getter.invoke((Object)mojo, new Object[0]);
                    DtoUtils.addProperty(execution, propertyName, value, baseDirPath, tracked);
                    continue;
                }
                if (!LOGGER.isWarnEnabled()) continue;
                LOGGER.warn("Cannot find a Mojo parameter '{}' to read for Mojo {}. This parameter should be ignored.", (Object)propertyName, (Object)mojoExecution);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                LOGGER.info("Cannot get property {} value from {}: {}", new Object[]{propertyName, mojo, e.getMessage()});
                if (!tracked) continue;
                throw new IllegalArgumentException("Property configured in cache introspection config for " + mojo + " is not accessible: " + propertyName);
            }
        }
    }

    private static Method getGetter(String fieldName, Class<?> clazz) {
        Method[] methods;
        String getterMethodName = "get" + StringUtils.capitalizeFirstLetter((String)fieldName);
        for (Method method : methods = clazz.getMethods()) {
            if (!method.getName().equals(getterMethodName) || method.getReturnType().equals(Void.TYPE) || method.getParameterCount() != 0) continue;
            return method;
        }
        return null;
    }

    private boolean isExcluded(String propertyName, boolean logAll, List<PropertyName> excludedProperties, List<PropertyName> forceLogProperties) {
        if (!forceLogProperties.isEmpty()) {
            for (PropertyName logProperty : forceLogProperties) {
                if (!org.apache.commons.lang3.StringUtils.equals((CharSequence)propertyName, (CharSequence)logProperty.getPropertyName())) continue;
                return false;
            }
            return true;
        }
        if (!excludedProperties.isEmpty()) {
            for (PropertyName excludedProperty : excludedProperties) {
                if (!org.apache.commons.lang3.StringUtils.equals((CharSequence)propertyName, (CharSequence)excludedProperty.getPropertyName())) continue;
                return true;
            }
            return false;
        }
        return !logAll;
    }

    private boolean isTracked(String propertyName, List<TrackedProperty> trackedProperties) {
        for (TrackedProperty trackedProperty : trackedProperties) {
            if (!org.apache.commons.lang3.StringUtils.equals((CharSequence)propertyName, (CharSequence)trackedProperty.getPropertyName())) continue;
            return true;
        }
        return false;
    }

    private boolean isCachedSegmentPropertiesPresent(MavenProject project, Build build, List<MojoExecution> mojoExecutions) {
        for (MojoExecution mojoExecution : mojoExecutions) {
            List<TrackedProperty> trackedProperties = this.cacheConfig.getTrackedProperties(mojoExecution);
            CompletedExecution cachedExecution = build.findMojoExecutionInfo(mojoExecution);
            if (cachedExecution == null) {
                LOGGER.info("Execution is not cached. Plugin: {}, goal {}, executionId: {}", new Object[]{mojoExecution.getPlugin(), mojoExecution.getGoal(), mojoExecution.getExecutionId()});
                return false;
            }
            if (DtoUtils.containsAllProperties(cachedExecution, trackedProperties)) continue;
            LOGGER.warn("Cached build record doesn't contain all tracked properties. Plugin: {}, goal: {}, executionId: {}", new Object[]{mojoExecution.getPlugin(), mojoExecution.getGoal(), mojoExecution.getExecutionId()});
            return false;
        }
        return true;
    }

    @Override
    public boolean isForcedExecution(MavenProject project, MojoExecution execution) {
        if (this.cacheConfig.isForcedExecution(execution)) {
            return true;
        }
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)this.cacheConfig.getAlwaysRunPlugins())) {
            String[] alwaysRunPluginsList;
            for (String pluginAndGoal : alwaysRunPluginsList = org.apache.commons.lang3.StringUtils.split((String)this.cacheConfig.getAlwaysRunPlugins(), (String)",")) {
                String alwaysRunGoal;
                String[] tokens = pluginAndGoal.split(":");
                String alwaysRunPlugin = tokens[0];
                String string = alwaysRunGoal = tokens.length == 1 ? DEFAULT_FILE_GLOB : tokens[1];
                if (!Objects.equals(execution.getPlugin().getArtifactId(), alwaysRunPlugin) || !DEFAULT_FILE_GLOB.equals(alwaysRunGoal) && !Objects.equals(execution.getGoal(), alwaysRunGoal)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void saveCacheReport(MavenSession session) {
        try {
            CacheReport cacheReport = new CacheReport();
            for (CacheResult result : this.cacheResults.values()) {
                ProjectReport projectReport = new ProjectReport();
                CacheContext context = result.getContext();
                MavenProject project = context.getProject();
                projectReport.setGroupId(project.getGroupId());
                projectReport.setArtifactId(project.getArtifactId());
                projectReport.setChecksum(context.getInputInfo().getChecksum());
                boolean checksumMatched = result.getStatus() != RestoreStatus.EMPTY;
                projectReport.setChecksumMatched(checksumMatched);
                projectReport.setLifecycleMatched(checksumMatched && result.isSuccess());
                projectReport.setSource(String.valueOf((Object)result.getSource()));
                if (result.getSource() == CacheSource.REMOTE) {
                    projectReport.setUrl(this.remoteCache.getResourceUrl(context, "buildinfo.xml"));
                } else if (result.getSource() == CacheSource.BUILD && this.cacheConfig.isSaveToRemote()) {
                    projectReport.setSharedToRemote(true);
                    projectReport.setUrl(this.remoteCache.getResourceUrl(context, "buildinfo.xml"));
                }
                cacheReport.addProject(projectReport);
            }
            String buildId = UUID.randomUUID().toString();
            this.localCache.saveCacheReport(buildId, session, cacheReport);
        }
        catch (Exception e) {
            LOGGER.error("Cannot save incremental build aggregated report", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void populateGitInfo(Build build, MavenSession session) {
        if (this.scm == null) {
            CacheControllerImpl cacheControllerImpl = this;
            synchronized (cacheControllerImpl) {
                if (this.scm == null) {
                    try {
                        this.scm = CacheUtils.readGitInfo(session);
                    }
                    catch (IOException e) {
                        this.scm = new Scm();
                        LOGGER.error("Cannot populate git info", (Throwable)e);
                    }
                }
            }
        }
        build.getDto().setScm(this.scm);
    }

    private boolean zipAndAttachArtifact(MavenProject project, Path dir, String classifier, String glob) throws IOException {
        Path temp = Files.createTempFile("maven-incremental-", project.getArtifactId(), new FileAttribute[0]);
        temp.toFile().deleteOnExit();
        boolean hasFile = CacheUtils.zip(dir, temp, glob);
        if (hasFile) {
            this.projectHelper.attachArtifact(project, "zip", classifier, temp.toFile());
        }
        return hasFile;
    }

    private void restoreGeneratedSources(Artifact artifact, Path artifactFilePath, MavenProject project) throws IOException {
        Path baseDir = project.getBasedir().toPath();
        Path outputDir = baseDir.resolve(FilenameUtils.separatorsToSystem((String)artifact.getFilePath()));
        this.verifyRestorationInsideProject(project, outputDir);
        if (!Files.exists(outputDir, new LinkOption[0])) {
            Files.createDirectories(outputDir, new FileAttribute[0]);
        }
        CacheUtils.unzip(artifactFilePath, outputDir);
    }

    public void attachGeneratedSources(MavenProject project) throws IOException {
        Path targetDir = Paths.get(project.getBuild().getDirectory(), new String[0]);
        Path generatedSourcesDir = targetDir.resolve("generated-sources");
        this.attachDirIfNotEmpty(generatedSourcesDir, targetDir, project, OutputType.GENERATED_SOURCE, DEFAULT_FILE_GLOB);
        Path generatedTestSourcesDir = targetDir.resolve("generated-test-sources");
        this.attachDirIfNotEmpty(generatedTestSourcesDir, targetDir, project, OutputType.GENERATED_SOURCE, DEFAULT_FILE_GLOB);
        TreeSet sourceRoots = new TreeSet();
        if (project.getCompileSourceRoots() != null) {
            sourceRoots.addAll(project.getCompileSourceRoots());
        }
        if (project.getTestCompileSourceRoots() != null) {
            sourceRoots.addAll(project.getTestCompileSourceRoots());
        }
        for (String sourceRoot : sourceRoots) {
            Path sourceRootPath = Paths.get(sourceRoot, new String[0]);
            if (!Files.isDirectory(sourceRootPath, new LinkOption[0]) || !sourceRootPath.startsWith(targetDir) || sourceRootPath.startsWith(generatedSourcesDir) || sourceRootPath.startsWith(generatedTestSourcesDir)) continue;
            this.attachDirIfNotEmpty(sourceRootPath, targetDir, project, OutputType.GENERATED_SOURCE, DEFAULT_FILE_GLOB);
        }
    }

    private void attachOutputs(MavenProject project) throws IOException {
        List<DirName> attachedDirs = this.cacheConfig.getAttachedOutputs();
        for (DirName dir : attachedDirs) {
            Path targetDir = Paths.get(project.getBuild().getDirectory(), new String[0]);
            Path outputDir = targetDir.resolve(dir.getValue());
            if (this.isPathInsideProject(project, outputDir)) {
                this.attachDirIfNotEmpty(outputDir, targetDir, project, OutputType.EXTRA_OUTPUT, dir.getGlob());
                continue;
            }
            LOGGER.warn("Outside project output candidate directory discarded ({})", (Object)outputDir.normalize());
        }
    }

    private void attachDirIfNotEmpty(Path candidateSubDir, Path parentDir, MavenProject project, OutputType attachedOutputType, String glob) throws IOException {
        if (Files.isDirectory(candidateSubDir, new LinkOption[0]) && this.hasFiles(candidateSubDir)) {
            Path relativePath = project.getBasedir().toPath().relativize(candidateSubDir);
            ++this.attachedResourceCounter;
            String classifier = attachedOutputType.getClassifierPrefix() + this.attachedResourceCounter;
            boolean success = this.zipAndAttachArtifact(project, candidateSubDir, classifier, glob);
            if (success) {
                this.attachedResourcesPathsById.put(classifier, relativePath);
                LOGGER.debug("Attached directory: {}", (Object)candidateSubDir);
            }
        }
    }

    private boolean hasFiles(Path candidateSubDir) throws IOException {
        final MutableBoolean hasFiles = new MutableBoolean();
        Files.walkFileTree(candidateSubDir, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path path, BasicFileAttributes basicFileAttributes) {
                hasFiles.setTrue();
                return FileVisitResult.TERMINATE;
            }
        });
        return hasFiles.booleanValue();
    }

    private boolean isOutputArtifact(String name) {
        List<Pattern> excludePatterns = this.cacheConfig.getExcludePatterns();
        for (Pattern pattern : excludePatterns) {
            if (!pattern.matcher(name).matches()) continue;
            return false;
        }
        return true;
    }
}

