/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util;

import java.io.IOException;
import java.util.BitSet;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.LuceneTestCase;
import org.apache.lucene.util.RamUsageTester;
import org.apache.lucene.util.TestUtil;

public abstract class BaseDocIdSetTestCase<T extends DocIdSet>
extends LuceneTestCase {
    public abstract T copyOf(BitSet var1, int var2) throws IOException;

    protected static BitSet randomSet(int numBits, int numBitsSet) {
        assert (numBitsSet <= numBits);
        BitSet set = new BitSet(numBits);
        if (numBitsSet == numBits) {
            set.set(0, numBits);
        } else {
            for (int i = 0; i < numBitsSet; ++i) {
                int o;
                while (set.get(o = BaseDocIdSetTestCase.random().nextInt(numBits))) {
                }
                set.set(o);
            }
        }
        return set;
    }

    protected static BitSet randomSet(int numBits, float percentSet) {
        return BaseDocIdSetTestCase.randomSet(numBits, (int)(percentSet * (float)numBits));
    }

    public void testNoBit() throws IOException {
        BitSet bs = new BitSet(1);
        T copy = this.copyOf(bs, 0);
        this.assertEquals(0, bs, copy);
    }

    public void test1Bit() throws IOException {
        BitSet bs = new BitSet(1);
        if (BaseDocIdSetTestCase.random().nextBoolean()) {
            bs.set(0);
        }
        T copy = this.copyOf(bs, 1);
        this.assertEquals(1, bs, copy);
    }

    public void test2Bits() throws IOException {
        BitSet bs = new BitSet(2);
        if (BaseDocIdSetTestCase.random().nextBoolean()) {
            bs.set(0);
        }
        if (BaseDocIdSetTestCase.random().nextBoolean()) {
            bs.set(1);
        }
        T copy = this.copyOf(bs, 2);
        this.assertEquals(2, bs, copy);
    }

    public void testAgainstBitSet() throws IOException {
        int numBits = TestUtil.nextInt(BaseDocIdSetTestCase.random(), 100, 0x100000);
        for (float percentSet : new float[]{0.0f, 1.0E-4f, BaseDocIdSetTestCase.random().nextFloat() / 2.0f, 0.9f, 1.0f}) {
            BitSet set = BaseDocIdSetTestCase.randomSet(numBits, percentSet);
            T copy = this.copyOf(set, numBits);
            this.assertEquals(numBits, set, copy);
        }
        BitSet set = new BitSet(numBits);
        set.set(0);
        T copy = this.copyOf(set, numBits);
        this.assertEquals(numBits, set, copy);
        set.clear(0);
        set.set(BaseDocIdSetTestCase.random().nextInt(numBits));
        copy = this.copyOf(set, numBits);
        this.assertEquals(numBits, set, copy);
        for (int inc = 2; inc < 1000; inc += TestUtil.nextInt(BaseDocIdSetTestCase.random(), 1, 100)) {
            set = new BitSet(numBits);
            for (int d = BaseDocIdSetTestCase.random().nextInt(10); d < numBits; d += inc) {
                set.set(d);
            }
            copy = this.copyOf(set, numBits);
            this.assertEquals(numBits, set, copy);
        }
    }

    public void testRamBytesUsed() throws IOException {
        int iters = 100;
        for (int i = 0; i < 100; ++i) {
            int pow = BaseDocIdSetTestCase.random().nextInt(20);
            int maxDoc = TestUtil.nextInt(BaseDocIdSetTestCase.random(), 1, 1 << pow);
            int numDocs = TestUtil.nextInt(BaseDocIdSetTestCase.random(), 0, Math.min(maxDoc, 1 << TestUtil.nextInt(BaseDocIdSetTestCase.random(), 0, pow)));
            BitSet set = BaseDocIdSetTestCase.randomSet(maxDoc, numDocs);
            T copy = this.copyOf(set, maxDoc);
            long actualBytes = this.ramBytesUsed((DocIdSet)copy, maxDoc);
            long expectedBytes = copy.ramBytesUsed();
            BaseDocIdSetTestCase.assertEquals((long)expectedBytes, (long)actualBytes);
        }
    }

    public void assertEquals(int numBits, BitSet ds1, T ds2) throws IOException {
        int doc;
        DocIdSetIterator it2 = ds2.iterator();
        if (it2 == null) {
            BaseDocIdSetTestCase.assertEquals((long)-1L, (long)ds1.nextSetBit(0));
        } else {
            BaseDocIdSetTestCase.assertEquals((long)-1L, (long)it2.docID());
            doc = ds1.nextSetBit(0);
            while (doc != -1) {
                BaseDocIdSetTestCase.assertEquals((long)doc, (long)it2.nextDoc());
                BaseDocIdSetTestCase.assertEquals((long)doc, (long)it2.docID());
                doc = ds1.nextSetBit(doc + 1);
            }
            BaseDocIdSetTestCase.assertEquals((long)Integer.MAX_VALUE, (long)it2.nextDoc());
            BaseDocIdSetTestCase.assertEquals((long)Integer.MAX_VALUE, (long)it2.docID());
        }
        it2 = ds2.iterator();
        if (it2 == null) {
            BaseDocIdSetTestCase.assertEquals((long)-1L, (long)ds1.nextSetBit(0));
        } else {
            doc = -1;
            while (doc != Integer.MAX_VALUE) {
                if (BaseDocIdSetTestCase.random().nextBoolean()) {
                    if ((doc = ds1.nextSetBit(doc + 1)) == -1) {
                        doc = Integer.MAX_VALUE;
                    }
                    BaseDocIdSetTestCase.assertEquals((long)doc, (long)it2.nextDoc());
                    BaseDocIdSetTestCase.assertEquals((long)doc, (long)it2.docID());
                    continue;
                }
                int target = doc + 1 + BaseDocIdSetTestCase.random().nextInt(BaseDocIdSetTestCase.random().nextBoolean() ? 64 : Math.max(numBits / 8, 1));
                if ((doc = ds1.nextSetBit(target)) == -1) {
                    doc = Integer.MAX_VALUE;
                }
                BaseDocIdSetTestCase.assertEquals((long)doc, (long)it2.advance(target));
                BaseDocIdSetTestCase.assertEquals((long)doc, (long)it2.docID());
            }
        }
        Bits bits = ds2.bits();
        if (bits != null) {
            it2 = ds2.iterator();
            int previousDoc = -1;
            int doc2 = it2.nextDoc();
            while (true) {
                int max = doc2 == Integer.MAX_VALUE ? bits.length() : doc2;
                for (int i = previousDoc + 1; i < max; ++i) {
                    BaseDocIdSetTestCase.assertEquals((Object)false, (Object)bits.get(i));
                }
                if (doc2 == Integer.MAX_VALUE) break;
                BaseDocIdSetTestCase.assertEquals((Object)true, (Object)bits.get(doc2));
                previousDoc = doc2;
                doc2 = it2.nextDoc();
            }
        }
    }

    private long ramBytesUsed(DocIdSet set, int length) throws IOException {
        Dummy dummy = new Dummy();
        dummy.o1 = this.copyOf(new BitSet(length), length);
        dummy.o2 = set;
        long bytes1 = RamUsageTester.sizeOf(dummy);
        dummy.o2 = null;
        long bytes2 = RamUsageTester.sizeOf(dummy);
        return bytes1 - bytes2;
    }

    private static class Dummy {
        Object o1;
        Object o2;

        private Dummy() {
        }
    }
}

