/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.Random;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.FakeScorer;
import org.apache.lucene.search.Scorer;

final class RandomOrderCollector
extends Collector {
    final Random random;
    final Collector in;
    Scorer scorer;
    FakeScorer fakeScorer;
    int buffered;
    final int bufferSize;
    final int[] docIDs;
    final float[] scores;
    final int[] freqs;

    RandomOrderCollector(Random random, Collector in) {
        if (!in.acceptsDocsOutOfOrder()) {
            throw new IllegalArgumentException();
        }
        this.in = in;
        this.random = random;
        this.bufferSize = 1 + random.nextInt(100);
        this.docIDs = new int[this.bufferSize];
        this.scores = new float[this.bufferSize];
        this.freqs = new int[this.bufferSize];
        this.buffered = 0;
    }

    public void setScorer(Scorer scorer) throws IOException {
        this.scorer = scorer;
        this.fakeScorer = new FakeScorer();
        this.in.setScorer((Scorer)this.fakeScorer);
    }

    private void shuffle() {
        for (int i = this.buffered - 1; i > 0; --i) {
            int other = this.random.nextInt(i + 1);
            int tmpDoc = this.docIDs[i];
            this.docIDs[i] = this.docIDs[other];
            this.docIDs[other] = tmpDoc;
            float tmpScore = this.scores[i];
            this.scores[i] = this.scores[other];
            this.scores[other] = tmpScore;
            int tmpFreq = this.freqs[i];
            this.freqs[i] = this.freqs[other];
            this.freqs[other] = tmpFreq;
        }
    }

    public void flush() throws IOException {
        this.shuffle();
        for (int i = 0; i < this.buffered; ++i) {
            this.fakeScorer.doc = this.docIDs[i];
            this.fakeScorer.freq = this.freqs[i];
            this.fakeScorer.score = this.scores[i];
            this.in.collect(this.fakeScorer.doc);
        }
        this.buffered = 0;
    }

    public void collect(int doc) throws IOException {
        this.docIDs[this.buffered] = doc;
        this.scores[this.buffered] = this.scorer.score();
        try {
            this.freqs[this.buffered] = this.scorer.freq();
        }
        catch (UnsupportedOperationException e) {
            this.freqs[this.buffered] = -1;
        }
        if (++this.buffered == this.bufferSize) {
            this.flush();
        }
    }

    public boolean acceptsDocsOutOfOrder() {
        return this.in.acceptsDocsOutOfOrder();
    }

    public void setNextReader(AtomicReaderContext context) throws IOException {
        throw new UnsupportedOperationException();
    }
}

