/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.lucene3x;

import java.io.IOException;
import org.apache.lucene.codecs.TermVectorsReader;
import org.apache.lucene.codecs.TermVectorsWriter;
import org.apache.lucene.codecs.lucene3x.Lucene3xTermVectorsFormat;
import org.apache.lucene.codecs.lucene3x.Lucene3xTermVectorsReader;
import org.apache.lucene.codecs.lucene3x.PreFlexRWTermVectorsWriter;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.SegmentInfo;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.util.LuceneTestCase;

class PreFlexRWTermVectorsFormat
extends Lucene3xTermVectorsFormat {
    PreFlexRWTermVectorsFormat() {
    }

    public TermVectorsWriter vectorsWriter(Directory directory, SegmentInfo segmentInfo, IOContext context) throws IOException {
        return new PreFlexRWTermVectorsWriter(directory, segmentInfo.name, context);
    }

    public TermVectorsReader vectorsReader(Directory directory, SegmentInfo segmentInfo, FieldInfos fieldInfos, IOContext context) throws IOException {
        return new Lucene3xTermVectorsReader(directory, segmentInfo, fieldInfos, context){

            protected boolean sortTermsByUnicode() {
                boolean unicodeSortOrder = true;
                StackTraceElement[] trace = new Exception().getStackTrace();
                for (int i = 0; i < trace.length; ++i) {
                    if (!"merge".equals(trace[i].getMethodName())) continue;
                    unicodeSortOrder = false;
                    if (!LuceneTestCase.VERBOSE) break;
                    System.out.println("NOTE: PreFlexRW codec: forcing legacy UTF16 vector term sort order");
                    break;
                }
                return unicodeSortOrder;
            }
        };
    }
}

