/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.lucene3x;

import java.io.IOException;
import org.apache.lucene.codecs.FieldsConsumer;
import org.apache.lucene.codecs.FieldsProducer;
import org.apache.lucene.codecs.lucene3x.Lucene3xFields;
import org.apache.lucene.codecs.lucene3x.Lucene3xPostingsFormat;
import org.apache.lucene.codecs.lucene3x.PreFlexRWFieldsWriter;
import org.apache.lucene.codecs.lucene3x.PreflexRWSegmentTermEnum;
import org.apache.lucene.codecs.lucene3x.SegmentTermEnum;
import org.apache.lucene.codecs.lucene3x.TermInfosReader;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.index.SegmentWriteState;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.util.LuceneTestCase;

class PreFlexRWPostingsFormat
extends Lucene3xPostingsFormat {
    public FieldsConsumer fieldsConsumer(SegmentWriteState state) throws IOException {
        return new PreFlexRWFieldsWriter(state);
    }

    public FieldsProducer fieldsProducer(SegmentReadState state) throws IOException {
        return new Lucene3xFields(state.directory, state.fieldInfos, state.segmentInfo, state.context, state.termsIndexDivisor){

            protected boolean sortTermsByUnicode() {
                boolean unicodeSortOrder = true;
                StackTraceElement[] trace = new Exception().getStackTrace();
                for (int i = 0; i < trace.length; ++i) {
                    if (!"merge".equals(trace[i].getMethodName())) continue;
                    unicodeSortOrder = false;
                    if (!LuceneTestCase.VERBOSE) break;
                    System.out.println("NOTE: PreFlexRW codec: forcing legacy UTF16 term sort order");
                    break;
                }
                return unicodeSortOrder;
            }

            protected TermInfosReader newTermInfosReader(Directory dir, String name, FieldInfos fieldInfos, IOContext context, int indexDivisor) throws IOException {
                return new TermInfosReader(dir, name, fieldInfos, context, indexDivisor){

                    protected SegmentTermEnum newSegmentTermEnum(IndexInput input, FieldInfos fieldInfos, boolean isIndex) throws IOException {
                        return new PreflexRWSegmentTermEnum(input, fieldInfos, isIndex);
                    }
                };
            }
        };
    }
}

