/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.cranky;

import java.io.IOException;
import java.util.Random;
import org.apache.lucene.codecs.SegmentInfoFormat;
import org.apache.lucene.codecs.SegmentInfoReader;
import org.apache.lucene.codecs.SegmentInfoWriter;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.SegmentInfo;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IOContext;

class CrankySegmentInfoFormat
extends SegmentInfoFormat {
    final SegmentInfoFormat delegate;
    final Random random;

    CrankySegmentInfoFormat(SegmentInfoFormat delegate, Random random) {
        this.delegate = delegate;
        this.random = random;
    }

    public SegmentInfoReader getSegmentInfoReader() {
        return this.delegate.getSegmentInfoReader();
    }

    public SegmentInfoWriter getSegmentInfoWriter() {
        return new CrankySegmentInfoWriter(this.delegate.getSegmentInfoWriter(), this.random);
    }

    static class CrankySegmentInfoWriter
    extends SegmentInfoWriter {
        final SegmentInfoWriter delegate;
        final Random random;

        CrankySegmentInfoWriter(SegmentInfoWriter delegate, Random random) {
            this.delegate = delegate;
            this.random = random;
        }

        public void write(Directory dir, SegmentInfo info, FieldInfos fis, IOContext ioContext) throws IOException {
            if (this.random.nextInt(100) == 0) {
                throw new IOException("Fake IOException from SegmentInfoWriter.write()");
            }
            this.delegate.write(dir, info, fis, ioContext);
        }
    }
}

