/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.cranky;

import java.io.IOException;
import java.util.Comparator;
import java.util.Random;
import org.apache.lucene.codecs.FieldsConsumer;
import org.apache.lucene.codecs.FieldsProducer;
import org.apache.lucene.codecs.PostingsConsumer;
import org.apache.lucene.codecs.PostingsFormat;
import org.apache.lucene.codecs.TermStats;
import org.apache.lucene.codecs.TermsConsumer;
import org.apache.lucene.index.DocsEnum;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.Fields;
import org.apache.lucene.index.MergeState;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.index.SegmentWriteState;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.FixedBitSet;

class CrankyPostingsFormat
extends PostingsFormat {
    final PostingsFormat delegate;
    final Random random;

    CrankyPostingsFormat(PostingsFormat delegate, Random random) {
        super(delegate.getName());
        this.delegate = delegate;
        this.random = random;
    }

    public FieldsConsumer fieldsConsumer(SegmentWriteState state) throws IOException {
        if (this.random.nextInt(100) == 0) {
            throw new IOException("Fake IOException from PostingsFormat.fieldsConsumer()");
        }
        return new CrankyFieldsConsumer(this.delegate.fieldsConsumer(state), this.random);
    }

    public FieldsProducer fieldsProducer(SegmentReadState state) throws IOException {
        return this.delegate.fieldsProducer(state);
    }

    static class CrankyPostingsConsumer
    extends PostingsConsumer {
        final PostingsConsumer delegate;
        final Random random;

        CrankyPostingsConsumer(PostingsConsumer delegate, Random random) {
            this.delegate = delegate;
            this.random = random;
        }

        public void startDoc(int docID, int freq) throws IOException {
            if (this.random.nextInt(10000) == 0) {
                throw new IOException("Fake IOException from PostingsConsumer.startDoc()");
            }
            this.delegate.startDoc(docID, freq);
        }

        public void finishDoc() throws IOException {
            if (this.random.nextInt(10000) == 0) {
                throw new IOException("Fake IOException from PostingsConsumer.finishDoc()");
            }
            this.delegate.finishDoc();
        }

        public void addPosition(int position, BytesRef payload, int startOffset, int endOffset) throws IOException {
            if (this.random.nextInt(10000) == 0) {
                throw new IOException("Fake IOException from PostingsConsumer.addPosition()");
            }
            this.delegate.addPosition(position, payload, startOffset, endOffset);
        }

        public TermStats merge(MergeState mergeState, FieldInfo.IndexOptions indexOptions, DocsEnum postings, FixedBitSet visitedDocs) throws IOException {
            if (this.random.nextInt(10000) == 0) {
                throw new IOException("Fake IOException from PostingsConsumer.merge()");
            }
            return super.merge(mergeState, indexOptions, postings, visitedDocs);
        }
    }

    static class CrankyTermsConsumer
    extends TermsConsumer {
        final TermsConsumer delegate;
        final Random random;

        CrankyTermsConsumer(TermsConsumer delegate, Random random) {
            this.delegate = delegate;
            this.random = random;
        }

        public PostingsConsumer startTerm(BytesRef text) throws IOException {
            if (this.random.nextInt(10000) == 0) {
                throw new IOException("Fake IOException from TermsConsumer.startTerm()");
            }
            return new CrankyPostingsConsumer(this.delegate.startTerm(text), this.random);
        }

        public void finishTerm(BytesRef text, TermStats stats) throws IOException {
            if (this.random.nextInt(10000) == 0) {
                throw new IOException("Fake IOException from TermsConsumer.finishTerm()");
            }
            this.delegate.finishTerm(text, stats);
        }

        public void finish(long sumTotalTermFreq, long sumDocFreq, int docCount) throws IOException {
            if (this.random.nextInt(100) == 0) {
                throw new IOException("Fake IOException from TermsConsumer.finish()");
            }
            this.delegate.finish(sumTotalTermFreq, sumDocFreq, docCount);
        }

        public Comparator<BytesRef> getComparator() throws IOException {
            if (this.random.nextInt(100) == 0) {
                throw new IOException("Fake IOException from TermsConsumer.getComparator()");
            }
            return this.delegate.getComparator();
        }

        public void merge(MergeState mergeState, FieldInfo.IndexOptions indexOptions, TermsEnum termsEnum) throws IOException {
            if (this.random.nextInt(100) == 0) {
                throw new IOException("Fake IOException from TermsConsumer.merge()");
            }
            super.merge(mergeState, indexOptions, termsEnum);
        }
    }

    static class CrankyFieldsConsumer
    extends FieldsConsumer {
        final FieldsConsumer delegate;
        final Random random;

        CrankyFieldsConsumer(FieldsConsumer delegate, Random random) {
            this.delegate = delegate;
            this.random = random;
        }

        public TermsConsumer addField(FieldInfo field) throws IOException {
            if (this.random.nextInt(100) == 0) {
                throw new IOException("Fake IOException from FieldsConsumer.addField()");
            }
            return new CrankyTermsConsumer(this.delegate.addField(field), this.random);
        }

        public void merge(MergeState mergeState, Fields fields) throws IOException {
            if (this.random.nextInt(100) == 0) {
                throw new IOException("Fake IOException from FieldsConsumer.merge()");
            }
            super.merge(mergeState, fields);
        }

        public void close() throws IOException {
            this.delegate.close();
            if (this.random.nextInt(100) == 0) {
                throw new IOException("Fake IOException from FieldsConsumer.close()");
            }
        }
    }
}

