/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.join;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.TreeSet;
import java.util.function.BiConsumer;
import java.util.function.LongFunction;
import org.apache.lucene.document.DoublePoint;
import org.apache.lucene.document.FloatPoint;
import org.apache.lucene.document.IntPoint;
import org.apache.lucene.document.LongPoint;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.OrdinalMap;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.MatchNoDocsQuery;
import org.apache.lucene.search.PointInSetQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorable;
import org.apache.lucene.search.SimpleCollector;
import org.apache.lucene.search.join.DocValuesTermsCollector;
import org.apache.lucene.search.join.GenericTermsCollector;
import org.apache.lucene.search.join.GlobalOrdinalsCollector;
import org.apache.lucene.search.join.GlobalOrdinalsQuery;
import org.apache.lucene.search.join.GlobalOrdinalsWithScoreCollector;
import org.apache.lucene.search.join.GlobalOrdinalsWithScoreQuery;
import org.apache.lucene.search.join.PointInSetIncludingScoreQuery;
import org.apache.lucene.search.join.ScoreMode;
import org.apache.lucene.search.join.TermsIncludingScoreQuery;
import org.apache.lucene.search.join.TermsQuery;
import org.apache.lucene.util.BytesRef;

public final class JoinUtil {
    private JoinUtil() {
    }

    public static Query createJoinQuery(String fromField, boolean multipleValuesPerDocument, String toField, Query fromQuery, IndexSearcher fromSearcher, ScoreMode scoreMode) throws IOException {
        GenericTermsCollector termsWithScoreCollector;
        if (multipleValuesPerDocument) {
            DocValuesTermsCollector.Function<SortedSetDocValues> mvFunction = DocValuesTermsCollector.sortedSetDocValues(fromField);
            termsWithScoreCollector = GenericTermsCollector.createCollectorMV(mvFunction, scoreMode);
        } else {
            DocValuesTermsCollector.Function<BinaryDocValues> svFunction = DocValuesTermsCollector.binaryDocValues(fromField);
            termsWithScoreCollector = GenericTermsCollector.createCollectorSV(svFunction, scoreMode);
        }
        return JoinUtil.createJoinQuery(multipleValuesPerDocument, toField, fromQuery, fromField, fromSearcher, scoreMode, termsWithScoreCollector);
    }

    public static Query createJoinQuery(final String fromField, boolean multipleValuesPerDocument, String toField, final Class<? extends Number> numericType, Query fromQuery, IndexSearcher fromSearcher, ScoreMode scoreMode) throws IOException {
        PointInSetIncludingScoreQuery.Stream stream;
        int bytesPerDim;
        boolean needsScore;
        final TreeSet joinValues = new TreeSet();
        HashMap aggregatedScores = new HashMap();
        HashMap occurrences = new HashMap();
        boolean bl = needsScore = scoreMode != ScoreMode.None;
        final BiConsumer<Long, Float> scoreAggregator = scoreMode == ScoreMode.Max ? (key, score) -> {
            Float currentValue = aggregatedScores.putIfAbsent(key, score);
            if (currentValue != null) {
                aggregatedScores.put(key, Float.valueOf(Math.max(currentValue.floatValue(), score.floatValue())));
            }
        } : (scoreMode == ScoreMode.Min ? (key, score) -> {
            Float currentValue = aggregatedScores.putIfAbsent(key, score);
            if (currentValue != null) {
                aggregatedScores.put(key, Float.valueOf(Math.min(currentValue.floatValue(), score.floatValue())));
            }
        } : (scoreMode == ScoreMode.Total ? (key, score) -> {
            Float currentValue = aggregatedScores.putIfAbsent(key, score);
            if (currentValue != null) {
                aggregatedScores.put(key, Float.valueOf(currentValue.floatValue() + score.floatValue()));
            }
        } : (scoreMode == ScoreMode.Avg ? (key, score) -> {
            Integer currentOccurrence;
            Float currentSore = aggregatedScores.putIfAbsent(key, score);
            if (currentSore != null) {
                aggregatedScores.put(key, Float.valueOf(currentSore.floatValue() + score.floatValue()));
            }
            if ((currentOccurrence = occurrences.putIfAbsent(key, 1)) != null) {
                currentOccurrence = currentOccurrence + 1;
                occurrences.put(key, currentOccurrence);
            }
        } : (key, score) -> {
            throw new UnsupportedOperationException();
        })));
        final LongFunction<Float> joinScorer = scoreMode == ScoreMode.Avg ? joinValue -> {
            Float aggregatedScore = (Float)aggregatedScores.get(joinValue);
            Integer occurrence = (Integer)occurrences.get(joinValue);
            return Float.valueOf(aggregatedScore.floatValue() / (float)occurrence.intValue());
        } : aggregatedScores::get;
        SimpleCollector collector = multipleValuesPerDocument ? new SimpleCollector(){
            SortedNumericDocValues sortedNumericDocValues;
            Scorable scorer;

            public void collect(int doc) throws IOException {
                if (this.sortedNumericDocValues.advanceExact(doc)) {
                    for (int i = 0; i < this.sortedNumericDocValues.docValueCount(); ++i) {
                        long value = this.sortedNumericDocValues.nextValue();
                        joinValues.add(value);
                        if (!needsScore) continue;
                        scoreAggregator.accept(value, Float.valueOf(this.scorer.score()));
                    }
                }
            }

            protected void doSetNextReader(LeafReaderContext context) throws IOException {
                this.sortedNumericDocValues = DocValues.getSortedNumeric((LeafReader)context.reader(), (String)fromField);
            }

            public void setScorer(Scorable scorer) throws IOException {
                this.scorer = scorer;
            }

            public org.apache.lucene.search.ScoreMode scoreMode() {
                return needsScore ? org.apache.lucene.search.ScoreMode.COMPLETE : org.apache.lucene.search.ScoreMode.COMPLETE_NO_SCORES;
            }
        } : new SimpleCollector(){
            NumericDocValues numericDocValues;
            Scorable scorer;
            private int lastDocID = -1;

            private boolean docsInOrder(int docID) {
                if (docID < this.lastDocID) {
                    throw new AssertionError((Object)("docs out of order: lastDocID=" + this.lastDocID + " vs docID=" + docID));
                }
                this.lastDocID = docID;
                return true;
            }

            public void collect(int doc) throws IOException {
                assert (this.docsInOrder(doc));
                long value = 0L;
                if (this.numericDocValues.advanceExact(doc)) {
                    value = this.numericDocValues.longValue();
                }
                joinValues.add(value);
                if (needsScore) {
                    scoreAggregator.accept(value, Float.valueOf(this.scorer.score()));
                }
            }

            protected void doSetNextReader(LeafReaderContext context) throws IOException {
                this.numericDocValues = DocValues.getNumeric((LeafReader)context.reader(), (String)fromField);
                this.lastDocID = -1;
            }

            public void setScorer(Scorable scorer) throws IOException {
                this.scorer = scorer;
            }

            public org.apache.lucene.search.ScoreMode scoreMode() {
                return needsScore ? org.apache.lucene.search.ScoreMode.COMPLETE : org.apache.lucene.search.ScoreMode.COMPLETE_NO_SCORES;
            }
        };
        fromSearcher.search(fromQuery, (Collector)collector);
        final Iterator iterator = joinValues.iterator();
        final BytesRef encoded = new BytesRef();
        if (Integer.class.equals(numericType)) {
            bytesPerDim = 4;
            stream = new PointInSetIncludingScoreQuery.Stream(){

                public BytesRef next() {
                    if (iterator.hasNext()) {
                        long value = (Long)iterator.next();
                        IntPoint.encodeDimension((int)((int)value), (byte[])encoded.bytes, (int)0);
                        if (needsScore) {
                            this.score = ((Float)joinScorer.apply(value)).floatValue();
                        }
                        return encoded;
                    }
                    return null;
                }
            };
        } else if (Long.class.equals(numericType)) {
            bytesPerDim = 8;
            stream = new PointInSetIncludingScoreQuery.Stream(){

                public BytesRef next() {
                    if (iterator.hasNext()) {
                        long value = (Long)iterator.next();
                        LongPoint.encodeDimension((long)value, (byte[])encoded.bytes, (int)0);
                        if (needsScore) {
                            this.score = ((Float)joinScorer.apply(value)).floatValue();
                        }
                        return encoded;
                    }
                    return null;
                }
            };
        } else if (Float.class.equals(numericType)) {
            bytesPerDim = 4;
            stream = new PointInSetIncludingScoreQuery.Stream(){

                public BytesRef next() {
                    if (iterator.hasNext()) {
                        long value = (Long)iterator.next();
                        FloatPoint.encodeDimension((float)Float.intBitsToFloat((int)value), (byte[])encoded.bytes, (int)0);
                        if (needsScore) {
                            this.score = ((Float)joinScorer.apply(value)).floatValue();
                        }
                        return encoded;
                    }
                    return null;
                }
            };
        } else if (Double.class.equals(numericType)) {
            bytesPerDim = 8;
            stream = new PointInSetIncludingScoreQuery.Stream(){

                public BytesRef next() {
                    if (iterator.hasNext()) {
                        long value = (Long)iterator.next();
                        DoublePoint.encodeDimension((double)Double.longBitsToDouble(value), (byte[])encoded.bytes, (int)0);
                        if (needsScore) {
                            this.score = ((Float)joinScorer.apply(value)).floatValue();
                        }
                        return encoded;
                    }
                    return null;
                }
            };
        } else {
            throw new IllegalArgumentException("unsupported numeric type, only Integer, Long, Float and Double are supported");
        }
        encoded.bytes = new byte[bytesPerDim];
        encoded.length = bytesPerDim;
        if (needsScore) {
            return new PointInSetIncludingScoreQuery(scoreMode, fromQuery, multipleValuesPerDocument, toField, bytesPerDim, stream){

                @Override
                protected String toString(byte[] value) {
                    return (String)toString.apply(value, numericType);
                }
            };
        }
        return new PointInSetQuery(toField, 1, bytesPerDim, stream){

            protected String toString(byte[] value) {
                return PointInSetIncludingScoreQuery.toString.apply(value, numericType);
            }
        };
    }

    private static Query createJoinQuery(boolean multipleValuesPerDocument, String toField, Query fromQuery, String fromField, IndexSearcher fromSearcher, ScoreMode scoreMode, GenericTermsCollector collector) throws IOException {
        fromSearcher.search(fromQuery, (Collector)collector);
        switch (scoreMode) {
            case None: {
                return new TermsQuery(toField, collector.getCollectedTerms(), fromField, fromQuery, fromSearcher.getTopReaderContext().id());
            }
            case Total: 
            case Max: 
            case Min: 
            case Avg: {
                return new TermsIncludingScoreQuery(scoreMode, toField, multipleValuesPerDocument, collector.getCollectedTerms(), collector.getScoresPerTerm(), fromField, fromQuery, fromSearcher.getTopReaderContext().id());
            }
        }
        throw new IllegalArgumentException(String.format(Locale.ROOT, "Score mode %s isn't supported.", new Object[]{scoreMode}));
    }

    public static Query createJoinQuery(String joinField, Query fromQuery, Query toQuery, IndexSearcher searcher, ScoreMode scoreMode, OrdinalMap ordinalMap) throws IOException {
        return JoinUtil.createJoinQuery(joinField, fromQuery, toQuery, searcher, scoreMode, ordinalMap, 0, Integer.MAX_VALUE);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Query createJoinQuery(String joinField, Query fromQuery, Query toQuery, IndexSearcher searcher, ScoreMode scoreMode, OrdinalMap ordinalMap, int min, int max) throws IOException {
        void var13_17;
        long valueCount;
        int numSegments = searcher.getIndexReader().leaves().size();
        if (numSegments == 0) {
            return new MatchNoDocsQuery("JoinUtil.createJoinQuery with no segments");
        }
        if (numSegments == 1) {
            ordinalMap = null;
            LeafReader leafReader = ((LeafReaderContext)searcher.getIndexReader().leaves().get(0)).reader();
            SortedDocValues joinSortedDocValues = leafReader.getSortedDocValues(joinField);
            if (joinSortedDocValues == null) return new MatchNoDocsQuery("JoinUtil.createJoinQuery: no join values");
            valueCount = joinSortedDocValues.getValueCount();
        } else {
            if (ordinalMap == null) {
                throw new IllegalArgumentException("OrdinalMap is required, because there is more than 1 segment");
            }
            valueCount = ordinalMap.getValueCount();
        }
        Query rewrittenFromQuery = searcher.rewrite(fromQuery);
        Query rewrittenToQuery = searcher.rewrite(toQuery);
        switch (scoreMode) {
            case Total: {
                GlobalOrdinalsWithScoreCollector.Sum sum = new GlobalOrdinalsWithScoreCollector.Sum(joinField, ordinalMap, valueCount, min, max);
                break;
            }
            case Min: {
                GlobalOrdinalsWithScoreCollector.Min min2 = new GlobalOrdinalsWithScoreCollector.Min(joinField, ordinalMap, valueCount, min, max);
                break;
            }
            case Max: {
                GlobalOrdinalsWithScoreCollector.Max max2 = new GlobalOrdinalsWithScoreCollector.Max(joinField, ordinalMap, valueCount, min, max);
                break;
            }
            case Avg: {
                GlobalOrdinalsWithScoreCollector.Avg avg = new GlobalOrdinalsWithScoreCollector.Avg(joinField, ordinalMap, valueCount, min, max);
                break;
            }
            case None: {
                if (min <= 0 && max == Integer.MAX_VALUE) {
                    GlobalOrdinalsCollector globalOrdinalsCollector = new GlobalOrdinalsCollector(joinField, ordinalMap, valueCount);
                    searcher.search(rewrittenFromQuery, (Collector)globalOrdinalsCollector);
                    return new GlobalOrdinalsQuery(globalOrdinalsCollector.getCollectorOrdinals(), joinField, ordinalMap, rewrittenToQuery, rewrittenFromQuery, searcher.getTopReaderContext().id());
                }
                GlobalOrdinalsWithScoreCollector.NoScore noScore = new GlobalOrdinalsWithScoreCollector.NoScore(joinField, ordinalMap, valueCount, min, max);
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format(Locale.ROOT, "Score mode %s isn't supported.", new Object[]{scoreMode}));
            }
        }
        searcher.search(rewrittenFromQuery, (Collector)var13_17);
        return new GlobalOrdinalsWithScoreQuery((GlobalOrdinalsWithScoreCollector)var13_17, scoreMode, joinField, ordinalMap, rewrittenToQuery, rewrittenFromQuery, min, max, searcher.getTopReaderContext().id());
    }
}

