/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.highlight;

import java.io.IOException;
import java.util.HashSet;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.MultiReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.BoostQuery;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.highlight.WeightedTerm;

public final class QueryTermExtractor {
    private static final IndexSearcher EMPTY_INDEXSEARCHER;

    public static final WeightedTerm[] getTerms(Query query) {
        return QueryTermExtractor.getTerms(query, false);
    }

    public static final WeightedTerm[] getIdfWeightedTerms(Query query, IndexReader reader, String fieldName) {
        WeightedTerm[] terms = QueryTermExtractor.getTerms(query, false, fieldName);
        int totalNumDocs = reader.maxDoc();
        for (int i = 0; i < terms.length; ++i) {
            try {
                int docFreq = reader.docFreq(new Term(fieldName, terms[i].term));
                float idf = (float)(Math.log((double)totalNumDocs / (double)(docFreq + 1)) + 1.0);
                terms[i].weight *= idf;
                continue;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return terms;
    }

    public static final WeightedTerm[] getTerms(Query query, boolean prohibited, String fieldName) {
        HashSet<WeightedTerm> terms = new HashSet<WeightedTerm>();
        QueryTermExtractor.getTerms(query, 1.0f, terms, prohibited, fieldName);
        return terms.toArray(new WeightedTerm[0]);
    }

    public static final WeightedTerm[] getTerms(Query query, boolean prohibited) {
        return QueryTermExtractor.getTerms(query, prohibited, null);
    }

    private static final void getTerms(Query query, float boost, HashSet<WeightedTerm> terms, boolean prohibited, String fieldName) {
        block7: {
            try {
                if (query instanceof BoostQuery) {
                    BoostQuery boostQuery = (BoostQuery)query;
                    QueryTermExtractor.getTerms(boostQuery.getQuery(), boost * boostQuery.getBoost(), terms, prohibited, fieldName);
                    break block7;
                }
                if (query instanceof BooleanQuery) {
                    QueryTermExtractor.getTermsFromBooleanQuery((BooleanQuery)query, boost, terms, prohibited, fieldName);
                    break block7;
                }
                HashSet nonWeightedTerms = new HashSet();
                try {
                    EMPTY_INDEXSEARCHER.createWeight(EMPTY_INDEXSEARCHER.rewrite(query), ScoreMode.COMPLETE_NO_SCORES, 1.0f).extractTerms(nonWeightedTerms);
                }
                catch (IOException bogus) {
                    throw new RuntimeException("Should not happen on an empty index", bogus);
                }
                for (Term term : nonWeightedTerms) {
                    if (fieldName != null && !term.field().equals(fieldName)) continue;
                    terms.add(new WeightedTerm(boost, term.text()));
                }
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
        }
    }

    private static final void getTermsFromBooleanQuery(BooleanQuery query, float boost, HashSet<WeightedTerm> terms, boolean prohibited, String fieldName) {
        for (BooleanClause clause : query) {
            if (!prohibited && clause.getOccur() == BooleanClause.Occur.MUST_NOT) continue;
            QueryTermExtractor.getTerms(clause.getQuery(), boost, terms, prohibited, fieldName);
        }
    }

    static {
        try {
            MultiReader emptyReader = new MultiReader(new IndexReader[0]);
            EMPTY_INDEXSEARCHER = new IndexSearcher((IndexReader)emptyReader);
            EMPTY_INDEXSEARCHER.setQueryCache(null);
        }
        catch (IOException bogus) {
            throw new RuntimeException(bogus);
        }
    }
}

