/*
 * Decompiled with CFR 0.152.
 */
package kafka.coordinator.group;

import java.io.Serializable;
import java.util.UUID;
import java.util.concurrent.locks.ReentrantLock;
import kafka.common.OffsetAndMetadata;
import kafka.coordinator.group.AwaitingSync$;
import kafka.coordinator.group.CommitRecordMetadataAndOffset;
import kafka.coordinator.group.Dead$;
import kafka.coordinator.group.Empty$;
import kafka.coordinator.group.GroupCoordinator$;
import kafka.coordinator.group.GroupMetadata$;
import kafka.coordinator.group.GroupOverview;
import kafka.coordinator.group.GroupState;
import kafka.coordinator.group.GroupSummary;
import kafka.coordinator.group.MemberMetadata;
import kafka.coordinator.group.MemberSummary;
import kafka.coordinator.group.PreparingRebalance$;
import kafka.coordinator.group.Stable$;
import kafka.utils.CoreUtils$;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import org.apache.kafka.common.TopicPartition;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenSet;
import scala.collection.Iterable$;
import scala.collection.LinearSeqOptimized;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.SetLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.collection.mutable.Map$;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\r\rv!B\u0001\u0003\u0011\u0013I\u0011!D$s_V\u0004X*\u001a;bI\u0006$\u0018M\u0003\u0002\u0004\t\u0005)qM]8va*\u0011QAB\u0001\fG>|'\u000fZ5oCR|'OC\u0001\b\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0001\"AC\u0006\u000e\u0003\t1Q\u0001\u0004\u0002\t\n5\u0011Qb\u0012:pkBlU\r^1eCR\f7CA\u0006\u000f!\ty!#D\u0001\u0011\u0015\u0005\t\u0012!B:dC2\f\u0017BA\n\u0011\u0005\u0019\te.\u001f*fM\")Qc\u0003C\u0001-\u00051A(\u001b8jiz\"\u0012!\u0003\u0005\b1-\u0011\r\u0011\"\u0003\u001a\u0003M1\u0018\r\\5e!J,g/[8vgN#\u0018\r^3t+\u0005Q\u0002\u0003B\u000e#K!r!\u0001\b\u0011\u0011\u0005u\u0001R\"\u0001\u0010\u000b\u0005}A\u0011A\u0002\u001fs_>$h(\u0003\u0002\"!\u00051\u0001K]3eK\u001aL!a\t\u0013\u0003\u00075\u000b\u0007O\u0003\u0002\"!A\u0011!BJ\u0005\u0003O\t\u0011!b\u0012:pkB\u001cF/\u0019;f!\rY\u0012&J\u0005\u0003U\u0011\u00121aU3u\u0011\u0019a3\u0002)A\u00055\u0005!b/\u00197jIB\u0013XM^5pkN\u001cF/\u0019;fg\u0002BqAL\u0006\u0012\u0002\u0013\u0005q&A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$HEM\u000b\u0002a)\u0012Q%M\u0016\u0002eA\u00111\u0007O\u0007\u0002i)\u0011QGN\u0001\nk:\u001c\u0007.Z2lK\u0012T!a\u000e\t\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0002:i\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0007\u000b1\u0011\u0001AA\u001e\u0014\u0007irA\b\u0005\u0002>\u00016\taH\u0003\u0002@\r\u0005)Q\u000f^5mg&\u0011\u0011I\u0010\u0002\b\u0019><w-\u001b8h\u0011!\u0019%H!b\u0001\n\u0003!\u0015aB4s_V\u0004\u0018\nZ\u000b\u0002\u000bB\u00111DR\u0005\u0003\u000f\u0012\u0012aa\u0015;sS:<\u0007\u0002C%;\u0005\u0003\u0005\u000b\u0011B#\u0002\u0011\u001d\u0014x.\u001e9JI\u0002B\u0001b\u0013\u001e\u0003\u0002\u0003\u0006I!J\u0001\rS:LG/[1m'R\fG/\u001a\u0005\u0006+i\"\t!\u0014\u000b\u0004\u001d>\u0003\u0006C\u0001\u0006;\u0011\u0015\u0019E\n1\u0001F\u0011\u001dYE\n%AA\u0002\u0015BqA\u0015\u001eA\u0002\u0013%1+A\u0003ti\u0006$X-F\u0001&\u0011\u001d)&\b1A\u0005\nY\u000b\u0011b\u001d;bi\u0016|F%Z9\u0015\u0005]S\u0006CA\bY\u0013\tI\u0006C\u0001\u0003V]&$\bbB.U\u0003\u0003\u0005\r!J\u0001\u0004q\u0012\n\u0004BB/;A\u0003&Q%\u0001\u0004ti\u0006$X\r\t\u0005\t?j\u0012\r\u0011\"\u0001\u0003A\u0006!An\\2l+\u0005\t\u0007C\u00012l\u001b\u0005\u0019'B\u00013f\u0003\u0015awnY6t\u0015\t1w-\u0001\u0006d_:\u001cWO\u001d:f]RT!\u0001[5\u0002\tU$\u0018\u000e\u001c\u0006\u0002U\u0006!!.\u0019<b\u0013\ta7MA\u0007SK\u0016tGO]1oi2{7m\u001b\u0005\u0007]j\u0002\u000b\u0011B1\u0002\u000b1|7m\u001b\u0011\t\u000fAT$\u0019!C\u0005c\u00069Q.Z7cKJ\u001cX#\u0001:\u0011\tMDXI_\u0007\u0002i*\u0011QO^\u0001\b[V$\u0018M\u00197f\u0015\t9\b#\u0001\u0006d_2dWm\u0019;j_:L!!\u001f;\u0003\u000f!\u000b7\u000f['baB\u0011!b_\u0005\u0003y\n\u0011a\"T3nE\u0016\u0014X*\u001a;bI\u0006$\u0018\r\u0003\u0004\u007fu\u0001\u0006IA]\u0001\t[\u0016l'-\u001a:tA!I\u0011\u0011\u0001\u001eC\u0002\u0013%\u00111A\u0001\b_\u001a47/\u001a;t+\t\t)\u0001\u0005\u0004tq\u0006\u001d\u0011Q\u0004\t\u0005\u0003\u0013\tI\"\u0004\u0002\u0002\f)!\u0011QBA\b\u0003\u0019\u0019w.\\7p]*\u0019q!!\u0005\u000b\t\u0005M\u0011QC\u0001\u0007CB\f7\r[3\u000b\u0005\u0005]\u0011aA8sO&!\u00111DA\u0006\u00059!v\u000e]5d!\u0006\u0014H/\u001b;j_:\u00042ACA\u0010\u0013\r\t\tC\u0001\u0002\u001e\u0007>lW.\u001b;SK\u000e|'\u000fZ'fi\u0006$\u0017\r^1B]\u0012|eMZ:fi\"A\u0011Q\u0005\u001e!\u0002\u0013\t)!\u0001\u0005pM\u001a\u001cX\r^:!\u0011%\tIC\u000fb\u0001\n\u0013\tY#\u0001\u000bqK:$\u0017N\\4PM\u001a\u001cX\r^\"p[6LGo]\u000b\u0003\u0003[\u0001ba\u001d=\u0002\b\u0005=\u0002\u0003BA\u0019\u0003ki!!a\r\u000b\u0007\u00055a!\u0003\u0003\u00028\u0005M\"!E(gMN,G/\u00118e\u001b\u0016$\u0018\rZ1uC\"A\u00111\b\u001e!\u0002\u0013\ti#A\u000bqK:$\u0017N\\4PM\u001a\u001cX\r^\"p[6LGo\u001d\u0011\t\u0013\u0005}\"H1A\u0005\n\u0005\u0005\u0013!\t9f]\u0012Lgn\u001a+sC:\u001c\u0018m\u0019;j_:\fGn\u00144gg\u0016$8i\\7nSR\u001cXCAA\"!\u0019\u0019\b0!\u0012\u0002LA\u0019q\"a\u0012\n\u0007\u0005%\u0003C\u0001\u0003M_:<\u0007cB:\u0002N\u0005\u001d\u0011QD\u0005\u0003GQD\u0001\"!\u0015;A\u0003%\u00111I\u0001#a\u0016tG-\u001b8h)J\fgn]1di&|g.\u00197PM\u001a\u001cX\r^\"p[6LGo\u001d\u0011\t\u0013\u0005U#\b1A\u0005\n\u0005]\u0013A\t:fG\u0016Lg/\u001a3Ue\u0006t7/Y2uS>t\u0017\r\\(gMN,GoQ8n[&$8/\u0006\u0002\u0002ZA\u0019q\"a\u0017\n\u0007\u0005u\u0003CA\u0004C_>dW-\u00198\t\u0013\u0005\u0005$\b1A\u0005\n\u0005\r\u0014A\n:fG\u0016Lg/\u001a3Ue\u0006t7/Y2uS>t\u0017\r\\(gMN,GoQ8n[&$8o\u0018\u0013fcR\u0019q+!\u001a\t\u0013m\u000by&!AA\u0002\u0005e\u0003\u0002CA5u\u0001\u0006K!!\u0017\u0002GI,7-Z5wK\u0012$&/\u00198tC\u000e$\u0018n\u001c8bY>3gm]3u\u0007>lW.\u001b;tA!I\u0011Q\u000e\u001eA\u0002\u0013%\u0011qK\u0001\u001ee\u0016\u001cW-\u001b<fI\u000e{gn];nKJ|eMZ:fi\u000e{W.\\5ug\"I\u0011\u0011\u000f\u001eA\u0002\u0013%\u00111O\u0001\"e\u0016\u001cW-\u001b<fI\u000e{gn];nKJ|eMZ:fi\u000e{W.\\5ug~#S-\u001d\u000b\u0004/\u0006U\u0004\"C.\u0002p\u0005\u0005\t\u0019AA-\u0011!\tIH\u000fQ!\n\u0005e\u0013A\b:fG\u0016Lg/\u001a3D_:\u001cX/\\3s\u001f\u001a47/\u001a;D_6l\u0017\u000e^:!\u0011%\tiH\u000fa\u0001\n\u0003\ty(\u0001\u0007qe>$xnY8m)f\u0004X-\u0006\u0002\u0002\u0002B!q\"a!F\u0013\r\t)\t\u0005\u0002\u0007\u001fB$\u0018n\u001c8\t\u0013\u0005%%\b1A\u0005\u0002\u0005-\u0015\u0001\u00059s_R|7m\u001c7UsB,w\fJ3r)\r9\u0016Q\u0012\u0005\n7\u0006\u001d\u0015\u0011!a\u0001\u0003\u0003C\u0001\"!%;A\u0003&\u0011\u0011Q\u0001\u000eaJ|Go\\2pYRK\b/\u001a\u0011\t\u0013\u0005U%\b1A\u0005\u0002\u0005]\u0015\u0001D4f]\u0016\u0014\u0018\r^5p]&#WCAAM!\ry\u00111T\u0005\u0004\u0003;\u0003\"aA%oi\"I\u0011\u0011\u0015\u001eA\u0002\u0013\u0005\u00111U\u0001\u0011O\u0016tWM]1uS>t\u0017\nZ0%KF$2aVAS\u0011%Y\u0016qTA\u0001\u0002\u0004\tI\n\u0003\u0005\u0002*j\u0002\u000b\u0015BAM\u000359WM\\3sCRLwN\\%eA!A\u0011Q\u0016\u001eA\u0002\u0013\u0005A)\u0001\u0005mK\u0006$WM]%e\u0011%\t\tL\u000fa\u0001\n\u0003\t\u0019,\u0001\u0007mK\u0006$WM]%e?\u0012*\u0017\u000fF\u0002X\u0003kC\u0001bWAX\u0003\u0003\u0005\r!\u0012\u0005\b\u0003sS\u0004\u0015)\u0003F\u0003%aW-\u00193fe&#\u0007\u0005\u0003\u0005\u0002>j\u0002\r\u0011\"\u0001E\u0003!\u0001(o\u001c;pG>d\u0007\"CAau\u0001\u0007I\u0011AAb\u00031\u0001(o\u001c;pG>dw\fJ3r)\r9\u0016Q\u0019\u0005\t7\u0006}\u0016\u0011!a\u0001\u000b\"9\u0011\u0011\u001a\u001e!B\u0013)\u0015!\u00039s_R|7m\u001c7!\u0011%\tiM\u000fa\u0001\n\u0003\t9&\u0001\boK^lU-\u001c2fe\u0006#G-\u001a3\t\u0013\u0005E'\b1A\u0005\u0002\u0005M\u0017A\u00058fo6+WNY3s\u0003\u0012$W\rZ0%KF$2aVAk\u0011%Y\u0016qZA\u0001\u0002\u0004\tI\u0006\u0003\u0005\u0002Zj\u0002\u000b\u0015BA-\u0003=qWm^'f[\n,'/\u00113eK\u0012\u0004\u0003bBAou\u0011\u0005\u0011q\\\u0001\u0007S:dunY6\u0016\t\u0005\u0005\u0018q\u001d\u000b\u0005\u0003G\fI\u0010\u0005\u0003\u0002f\u0006\u001dH\u0002\u0001\u0003\t\u0003S\fYN1\u0001\u0002l\n\tA+\u0005\u0003\u0002n\u0006M\bcA\b\u0002p&\u0019\u0011\u0011\u001f\t\u0003\u000f9{G\u000f[5oOB\u0019q\"!>\n\u0007\u0005]\bCA\u0002B]fD\u0011\"a?\u0002\\\u0012\u0005\r!!@\u0002\u0007\u0019,h\u000eE\u0003\u0010\u0003\u007f\f\u0019/C\u0002\u0003\u0002A\u0011\u0001\u0002\u00102z]\u0006lWM\u0010\u0005\b\u0005\u000bQD\u0011\u0001B\u0004\u0003\tI7\u000f\u0006\u0003\u0002Z\t%\u0001b\u0002B\u0006\u0005\u0007\u0001\r!J\u0001\u000bOJ|W\u000f]*uCR,\u0007b\u0002B\bu\u0011\u0005!\u0011C\u0001\u0004]>$H\u0003BA-\u0005'AqAa\u0003\u0003\u000e\u0001\u0007Q\u0005C\u0004\u0003\u0018i\"\tA!\u0007\u0002\u0007!\f7\u000f\u0006\u0003\u0002Z\tm\u0001b\u0002B\u000f\u0005+\u0001\r!R\u0001\t[\u0016l'-\u001a:JI\"9!\u0011\u0005\u001e\u0005\u0002\t\r\u0012aA4fiR\u0019!P!\n\t\u000f\tu!q\u0004a\u0001\u000b\"9!\u0011\u0006\u001e\u0005\u0002\t-\u0012aA1eIR\u0019qK!\f\t\u000f\t=\"q\u0005a\u0001u\u00061Q.Z7cKJDqAa\r;\t\u0003\u0011)$\u0001\u0004sK6|g/\u001a\u000b\u0004/\n]\u0002b\u0002B\u000f\u0005c\u0001\r!\u0012\u0005\u0007\u0005wQD\u0011A*\u0002\u0019\r,(O]3oiN#\u0018\r^3\t\u000f\t}\"\b\"\u0001\u0003B\u0005)bn\u001c;ZKR\u0014VM[8j]\u0016$W*Z7cKJ\u001cXC\u0001B\"!\u0015\u0011)Ea\u0013{\u001d\ry!qI\u0005\u0004\u0005\u0013\u0002\u0012a\u00029bG.\fw-Z\u0005\u0005\u0005\u001b\u0012yE\u0001\u0003MSN$(b\u0001B%!!9!1\u000b\u001e\u0005\u0002\tU\u0013AC1mY6+WNY3sgV\u0011!q\u000b\t\u0006\u00053\u0012Y&R\u0007\u0002m&\u0011!F\u001e\u0005\b\u0005?RD\u0011\u0001B!\u0003E\tG\u000e\\'f[\n,'/T3uC\u0012\fG/\u0019\u0005\b\u0005GRD\u0011AAL\u0003I\u0011XMY1mC:\u001cW\rV5nK>,H/T:\t\u000f\t\u001d$\b\"\u0001\u0003j\u00051r-\u001a8fe\u0006$X-T3nE\u0016\u0014\u0018\nZ*vM\u001aL\u00070\u0006\u0002\u0003lA!!Q\u000eB:\u001b\t\u0011yGC\u0002\u0003r%\fA\u0001\\1oO&\u0019qIa\u001c\t\u000f\t]$\b\"\u0001\u0002X\u0005a1-\u00198SK\n\fG.\u00198dK\"9!1\u0010\u001e\u0005\u0002\tu\u0014\u0001\u0004;sC:\u001c\u0018\u000e^5p]R{GcA,\u0003\u0000!9!1\u0002B=\u0001\u0004)\u0003B\u0002BBu\u0011\u0005A)\u0001\btK2,7\r\u001e)s_R|7m\u001c7\t\u000f\t\u001d%\b\"\u0003\u0003\n\u0006\u00112-\u00198eS\u0012\fG/\u001a)s_R|7m\u001c7t+\t\u0011Y\tE\u0003\u0003\u000e\nMU)\u0004\u0002\u0003\u0010*\u0019!\u0011\u0013<\u0002\u0013%lW.\u001e;bE2,\u0017b\u0001\u0016\u0003\u0010\"9!q\u0013\u001e\u0005\u0002\te\u0015!E:vaB|'\u000f^:Qe>$xnY8mgR!\u0011\u0011\fBN\u0011!\u0011iJ!&A\u0002\t}\u0015aD7f[\n,'\u000f\u0015:pi>\u001cw\u000e\\:\u0011\u0007mIS\tC\u0004\u0003$j\"\tA!*\u0002%%t\u0017\u000e\u001e(fqR<UM\\3sCRLwN\u001c\u000b\u0002/\"9!\u0011\u0016\u001e\u0005\u0002\t-\u0016!F2veJ,g\u000e^'f[\n,'/T3uC\u0012\fG/Y\u000b\u0003\u0005[\u0003Ra\u0007\u0012F\u0005_\u0003Ra\u0004BY\u0005kK1Aa-\u0011\u0005\u0015\t%O]1z!\ry!qW\u0005\u0004\u0005s\u0003\"\u0001\u0002\"zi\u0016DqA!0;\t\u0003\u0011y,A\u0004tk6l\u0017M]=\u0016\u0005\t\u0005\u0007c\u0001\u0006\u0003D&\u0019!Q\u0019\u0002\u0003\u0019\u001d\u0013x.\u001e9Tk6l\u0017M]=\t\u000f\t%'\b\"\u0001\u0003L\u0006AqN^3sm&,w/\u0006\u0002\u0003NB\u0019!Ba4\n\u0007\tE'AA\u0007He>,\bo\u0014<feZLWm\u001e\u0005\b\u0005+TD\u0011\u0001Bl\u0003EIg.\u001b;jC2L'0Z(gMN,Go\u001d\u000b\u0006/\ne'q\u001c\u0005\t\u0003\u0003\u0011\u0019\u000e1\u0001\u0003\\BA!\u0011\fBo\u0003\u000f\ti\"\u0003\u0002$m\"A!\u0011\u001dBj\u0001\u0004\u0011\u0019/A\tqK:$\u0017N\\4Uq:|eMZ:fiN\u0004ba\u0007\u0012\u0002F\u0005-\u0003b\u0002Btu\u0011\u0005!\u0011^\u0001\u0015_:|eMZ:fi\u000e{W.\\5u\u0003B\u0004XM\u001c3\u0015\u000b]\u0013YOa<\t\u0011\t5(Q\u001da\u0001\u0003\u000f\ta\u0002^8qS\u000e\u0004\u0016M\u001d;ji&|g\u000e\u0003\u0005\u0003r\n\u0015\b\u0019AA\u000f\u0003yygMZ:fi^KG\u000f[\"p[6LGOU3d_J$W*\u001a;bI\u0006$\u0018\rC\u0004\u0003vj\"\tAa>\u0002-\u0019\f\u0017\u000e\u001c)f]\u0012LgnZ(gMN,Go\u0016:ji\u0016$Ra\u0016B}\u0005wD\u0001B!<\u0003t\u0002\u0007\u0011q\u0001\u0005\t\u0005{\u0014\u0019\u00101\u0001\u00020\u00051qN\u001a4tKRDqa!\u0001;\t\u0003\u0019\u0019!A\nqe\u0016\u0004\u0018M]3PM\u001a\u001cX\r^\"p[6LG\u000fF\u0002X\u0007\u000bA\u0001\"!\u0001\u0003\u0000\u0002\u00071q\u0001\t\u00077\t\n9!a\f\t\u000f\r-!\b\"\u0001\u0004\u000e\u00051\u0002O]3qCJ,G\u000b\u001f8PM\u001a\u001cX\r^\"p[6LG\u000fF\u0003X\u0007\u001f\u0019\u0019\u0002\u0003\u0005\u0004\u0012\r%\u0001\u0019AA#\u0003)\u0001(o\u001c3vG\u0016\u0014\u0018\n\u001a\u0005\t\u0003\u0003\u0019I\u00011\u0001\u0004\b!91q\u0003\u001e\u0005\u0002\u0005]\u0013A\t5bgJ+7-Z5wK\u0012\u001cuN\\:jgR,g\u000e^(gMN,GoQ8n[&$8\u000fC\u0004\u0004\u001ci\"\ta!\b\u00025\u0019\f\u0017\u000e\u001c)f]\u0012Lgn\u001a+y]>3gm]3u\u0007>lW.\u001b;\u0015\u000b]\u001byb!\t\t\u0011\rE1\u0011\u0004a\u0001\u0003\u000bB\u0001B!<\u0004\u001a\u0001\u0007\u0011q\u0001\u0005\b\u0007KQD\u0011AB\u0014\u0003]yg\u000e\u0016=o\u001f\u001a47/\u001a;D_6l\u0017\u000e^!qa\u0016tG\rF\u0004X\u0007S\u0019Yc!\f\t\u0011\rE11\u0005a\u0001\u0003\u000bB\u0001B!<\u0004$\u0001\u0007\u0011q\u0001\u0005\t\u0007_\u0019\u0019\u00031\u0001\u0002\u001e\u0005i2m\\7nSR\u0014VmY8sI6+G/\u00193bi\u0006\fe\u000eZ(gMN,G\u000fC\u0004\u00044i\"\ta!\u000e\u0002=\r|W\u000e\u001d7fi\u0016\u0004VM\u001c3j]\u001e$\u0006P\\(gMN,GoQ8n[&$H#B,\u00048\re\u0002\u0002CB\t\u0007c\u0001\r!!\u0012\t\u0011\rm2\u0011\u0007a\u0001\u00033\n\u0001\"[:D_6l\u0017\u000e\u001e\u0005\b\u0007\u007fQD\u0011AB!\u0003=\t7\r^5wKB\u0013x\u000eZ;dKJ\u001cXCAB\"!\u0019\u0011IFa\u0017\u0002F!91q\t\u001e\u0005\u0002\r%\u0013a\t5bgB+g\u000eZ5oO>3gm]3u\u0007>lW.\u001b;t\rJ|W\u000e\u0015:pIV\u001cWM\u001d\u000b\u0005\u00033\u001aY\u0005\u0003\u0005\u0004\u0012\r\u0015\u0003\u0019AA#\u0011\u001d\u0019yE\u000fC\u0001\u0007#\nQB]3n_Z,wJ\u001a4tKR\u001cH\u0003BB*\u0007/\u0002\u0002B!$\u0004V\u0005\u001d\u0011qF\u0005\u0004G\t=\u0005\u0002CB-\u0007\u001b\u0002\raa\u0017\u0002\u001fQ|\u0007/[2QCJ$\u0018\u000e^5p]N\u0004bA!\u0017\u0004^\u0005\u001d\u0011bAB0m\n\u00191+Z9\t\u000f\r\r$\b\"\u0001\u0004f\u0005!\"/Z7pm\u0016,\u0005\u0010]5sK\u0012|eMZ:fiN$Baa\u0002\u0004h!A1\u0011NB1\u0001\u0004\t)%A\u0004ti\u0006\u0014H/T:\t\u000f\r5$\b\"\u0001\u0004p\u0005Q\u0011\r\u001c7PM\u001a\u001cX\r^:\u0016\u0005\rM\u0003b\u0002B\u007fu\u0011\u000511\u000f\u000b\u0005\u0007k\u001a9\bE\u0003\u0010\u0003\u0007\u000by\u0003\u0003\u0005\u0003n\u000eE\u0004\u0019AA\u0004\u0011!\u0019YH\u000fC\u0001\u0005\ru\u0014\u0001G8gMN,GoV5uQJ+7m\u001c:e\u001b\u0016$\u0018\rZ1uCR!1qPBA!\u0015y\u00111QA\u000f\u0011!\u0011io!\u001fA\u0002\u0005\u001d\u0001bBBCu\u0011\u0005\u0011qS\u0001\u000b]VlwJ\u001a4tKR\u001c\bbBBEu\u0011\u0005\u0011qK\u0001\u000bQ\u0006\u001cxJ\u001a4tKR\u001c\bbBBGu\u0011%1qR\u0001\u0016CN\u001cXM\u001d;WC2LG\r\u0016:b]NLG/[8o)\r96\u0011\u0013\u0005\b\u0007'\u001bY\t1\u0001&\u0003-!\u0018M]4fiN#\u0018\r^3\t\u000f\r]%\b\"\u0011\u0004\u001a\u0006AAo\\*ue&tw\rF\u0001FQ\rQ4Q\u0014\t\u0004{\r}\u0015bABQ}\tian\u001c8uQJ,\u0017\rZ:bM\u0016\u0004")
public class GroupMetadata
implements Logging {
    private final String groupId;
    private GroupState state;
    private final ReentrantLock lock;
    private final HashMap<String, MemberMetadata> members;
    private final HashMap<TopicPartition, CommitRecordMetadataAndOffset> offsets;
    private final HashMap<TopicPartition, OffsetAndMetadata> pendingOffsetCommits;
    private final HashMap<Object, scala.collection.mutable.Map<TopicPartition, CommitRecordMetadataAndOffset>> pendingTransactionalOffsetCommits;
    private boolean receivedTransactionalOffsetCommits;
    private boolean receivedConsumerOffsetCommits;
    private Option<String> protocolType;
    private int generationId;
    private String leaderId;
    private String protocol;
    private boolean newMemberAdded;
    private final String loggerName;
    private Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    public static GroupState $lessinit$greater$default$2() {
        return GroupMetadata$.MODULE$.$lessinit$greater$default$2();
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public Object trace(Function0<Throwable> e) {
        return Logging.trace$(this, e);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging.swallowTrace$(this, action);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public Object debug(Function0<Throwable> e) {
        return Logging.debug$(this, e);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging.swallowDebug$(this, action);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public Object info(Function0<Throwable> e) {
        return Logging.info$(this, e);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging.swallowInfo$(this, action);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public Object warn(Function0<Throwable> e) {
        return Logging.warn$(this, e);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging.swallowWarn$(this, action);
    }

    @Override
    public void swallow(Function0<BoxedUnit> action) {
        Logging.swallow$(this, action);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public Object error(Function0<Throwable> e) {
        return Logging.error$(this, e);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> action) {
        Logging.swallowError$(this, action);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public Object fatal(Function0<Throwable> e) {
        return Logging.fatal$(this, e);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        GroupMetadata groupMetadata = this;
        synchronized (groupMetadata) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    @Override
    public final void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    public String groupId() {
        return this.groupId;
    }

    private GroupState state() {
        return this.state;
    }

    private void state_$eq(GroupState x$1) {
        this.state = x$1;
    }

    public ReentrantLock lock() {
        return this.lock;
    }

    private HashMap<String, MemberMetadata> members() {
        return this.members;
    }

    private HashMap<TopicPartition, CommitRecordMetadataAndOffset> offsets() {
        return this.offsets;
    }

    private HashMap<TopicPartition, OffsetAndMetadata> pendingOffsetCommits() {
        return this.pendingOffsetCommits;
    }

    private HashMap<Object, scala.collection.mutable.Map<TopicPartition, CommitRecordMetadataAndOffset>> pendingTransactionalOffsetCommits() {
        return this.pendingTransactionalOffsetCommits;
    }

    private boolean receivedTransactionalOffsetCommits() {
        return this.receivedTransactionalOffsetCommits;
    }

    private void receivedTransactionalOffsetCommits_$eq(boolean x$1) {
        this.receivedTransactionalOffsetCommits = x$1;
    }

    private boolean receivedConsumerOffsetCommits() {
        return this.receivedConsumerOffsetCommits;
    }

    private void receivedConsumerOffsetCommits_$eq(boolean x$1) {
        this.receivedConsumerOffsetCommits = x$1;
    }

    public Option<String> protocolType() {
        return this.protocolType;
    }

    public void protocolType_$eq(Option<String> x$1) {
        this.protocolType = x$1;
    }

    public int generationId() {
        return this.generationId;
    }

    public void generationId_$eq(int x$1) {
        this.generationId = x$1;
    }

    public String leaderId() {
        return this.leaderId;
    }

    public void leaderId_$eq(String x$1) {
        this.leaderId = x$1;
    }

    public String protocol() {
        return this.protocol;
    }

    public void protocol_$eq(String x$1) {
        this.protocol = x$1;
    }

    public boolean newMemberAdded() {
        return this.newMemberAdded;
    }

    public void newMemberAdded_$eq(boolean x$1) {
        this.newMemberAdded = x$1;
    }

    public <T> T inLock(Function0<T> fun) {
        return CoreUtils$.MODULE$.inLock(this.lock(), fun);
    }

    public boolean is(GroupState groupState) {
        GroupState groupState2 = this.state();
        GroupState groupState3 = groupState;
        return !(groupState2 != null ? !groupState2.equals(groupState3) : groupState3 != null);
    }

    public boolean not(GroupState groupState) {
        GroupState groupState2 = this.state();
        GroupState groupState3 = groupState;
        return groupState2 == null ? groupState3 != null : !groupState2.equals(groupState3);
    }

    public boolean has(String memberId) {
        return this.members().contains((Object)memberId);
    }

    public MemberMetadata get(String memberId) {
        return (MemberMetadata)this.members().apply((Object)memberId);
    }

    public void add(MemberMetadata member) {
        if (this.members().isEmpty()) {
            this.protocolType_$eq((Option<String>)new Some((Object)member.protocolType()));
        }
        String string = this.groupId();
        String string2 = member.groupId();
        Predef$.MODULE$.assert(!(string != null ? !string.equals(string2) : string2 != null));
        Object object = this.protocolType().orNull(Predef$.MODULE$.$conforms());
        String string3 = member.protocolType();
        Predef$.MODULE$.assert(!(object != null ? !object.equals(string3) : string3 != null));
        Predef$.MODULE$.assert(this.supportsProtocols(member.protocols()));
        if (this.leaderId() == null) {
            this.leaderId_$eq(member.memberId());
        }
        this.members().put((Object)member.memberId(), (Object)member);
    }

    public void remove(String memberId) {
        block0: {
            this.members().remove((Object)memberId);
            String string = memberId;
            String string2 = this.leaderId();
            if (string != null ? !string.equals(string2) : string2 != null) break block0;
            this.leaderId_$eq(this.members().isEmpty() ? null : (String)this.members().keys().head());
        }
    }

    public GroupState currentState() {
        return this.state();
    }

    public List<MemberMetadata> notYetRejoinedMembers() {
        return ((TraversableOnce)this.members().values().filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)GroupMetadata.$anonfun$notYetRejoinedMembers$1(x$1)))).toList();
    }

    public Set<String> allMembers() {
        return this.members().keySet();
    }

    public List<MemberMetadata> allMemberMetadata() {
        return this.members().values().toList();
    }

    public int rebalanceTimeoutMs() {
        return BoxesRunTime.unboxToInt((Object)this.members().values().foldLeft((Object)BoxesRunTime.boxToInteger((int)0), (Function2 & Serializable & scala.Serializable)(timeout, member) -> BoxesRunTime.boxToInteger((int)RichInt$.MODULE$.max$extension(Predef$.MODULE$.intWrapper(BoxesRunTime.unboxToInt((Object)timeout)), member.rebalanceTimeoutMs()))));
    }

    public String generateMemberIdSuffix() {
        return UUID.randomUUID().toString();
    }

    public boolean canRebalance() {
        return ((SetLike)GroupMetadata$.MODULE$.kafka$coordinator$group$GroupMetadata$$validPreviousStates().apply((Object)PreparingRebalance$.MODULE$)).contains((Object)this.state());
    }

    public void transitionTo(GroupState groupState) {
        this.assertValidTransition(groupState);
        this.state_$eq(groupState);
    }

    public String selectProtocol() {
        if (this.members().isEmpty()) {
            throw new IllegalStateException("Cannot select protocol for empty group");
        }
        scala.collection.immutable.Set<String> candidates = this.candidateProtocols();
        List votes = ((TraversableLike)this.allMemberMetadata().map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.vote(candidates), List$.MODULE$.canBuildFrom())).groupBy((Function1 & Serializable & scala.Serializable)x -> (String)Predef$.MODULE$.identity(x)).mapValues((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToInteger((int)x$3.size())).toList();
        return (String)((Tuple2)votes.maxBy((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToInteger((int)x$4._2$mcI$sp()), (Ordering)Ordering.Int$.MODULE$))._1();
    }

    private scala.collection.immutable.Set<String> candidateProtocols() {
        return (scala.collection.immutable.Set)((LinearSeqOptimized)this.allMemberMetadata().map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.protocols(), List$.MODULE$.canBuildFrom())).reduceLeft((Function2 & Serializable & scala.Serializable)(commonProtocols, protocols) -> (scala.collection.immutable.Set)commonProtocols.$amp((GenSet)protocols));
    }

    public boolean supportsProtocols(scala.collection.immutable.Set<String> memberProtocols) {
        return this.members().isEmpty() || ((TraversableOnce)memberProtocols.$amp(this.candidateProtocols())).nonEmpty();
    }

    public void initNextGeneration() {
        List<MemberMetadata> list = this.notYetRejoinedMembers();
        List list2 = List$.MODULE$.empty();
        Predef$.MODULE$.assert(!(list != null ? !list.equals((Object)list2) : list2 != null));
        if (this.members().nonEmpty()) {
            this.generationId_$eq(this.generationId() + 1);
            this.protocol_$eq(this.selectProtocol());
            this.transitionTo(AwaitingSync$.MODULE$);
        } else {
            this.generationId_$eq(this.generationId() + 1);
            this.protocol_$eq(null);
            this.transitionTo(Empty$.MODULE$);
        }
        this.receivedConsumerOffsetCommits_$eq(false);
        this.receivedTransactionalOffsetCommits_$eq(false);
    }

    public scala.collection.immutable.Map<String, byte[]> currentMemberMetadata() {
        if (this.is(Dead$.MODULE$) || this.is(PreparingRebalance$.MODULE$)) {
            throw new IllegalStateException(new StringOps(Predef$.MODULE$.augmentString("Cannot obtain member metadata for group in state %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.state()})));
        }
        return ((TraversableOnce)this.members().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String memberId = (String)tuple2._1();
            MemberMetadata memberMetadata = (MemberMetadata)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)memberId, (Object)memberMetadata.metadata(this.protocol()));
            return tuple22;
        }, HashMap$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    public GroupSummary summary() {
        GroupSummary groupSummary;
        if (this.is(Stable$.MODULE$)) {
            List members = ((TraversableOnce)this.members().values().map((Function1 & Serializable & scala.Serializable)member -> member.summary(this.protocol()), Iterable$.MODULE$.canBuildFrom())).toList();
            groupSummary = new GroupSummary(this.state().toString(), (String)this.protocolType().getOrElse((Function0 & Serializable & scala.Serializable)() -> ""), this.protocol(), (List<MemberSummary>)members);
        } else {
            List members = ((TraversableOnce)this.members().values().map((Function1 & Serializable & scala.Serializable)member -> member.summaryNoMetadata(), Iterable$.MODULE$.canBuildFrom())).toList();
            groupSummary = new GroupSummary(this.state().toString(), (String)this.protocolType().getOrElse((Function0 & Serializable & scala.Serializable)() -> ""), GroupCoordinator$.MODULE$.NoProtocol(), (List<MemberSummary>)members);
        }
        return groupSummary;
    }

    public GroupOverview overview() {
        return new GroupOverview(this.groupId(), (String)this.protocolType().getOrElse((Function0 & Serializable & scala.Serializable)() -> ""));
    }

    public void initializeOffsets(Map<TopicPartition, CommitRecordMetadataAndOffset> offsets, scala.collection.immutable.Map<Object, scala.collection.mutable.Map<TopicPartition, CommitRecordMetadataAndOffset>> pendingTxnOffsets) {
        this.offsets().$plus$plus$eq(offsets);
        this.pendingTransactionalOffsetCommits().$plus$plus$eq(pendingTxnOffsets);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void onOffsetCommitAppend(TopicPartition topicPartition, CommitRecordMetadataAndOffset offsetWithCommitRecordMetadata) {
        Object object;
        if (this.pendingOffsetCommits().contains((Object)topicPartition)) {
            if (offsetWithCommitRecordMetadata.appendedBatchOffset().isEmpty()) {
                throw new IllegalStateException("Cannot complete offset commit write without providing the metadata of the record in the log.");
            }
            object = !this.offsets().contains((Object)topicPartition) || ((CommitRecordMetadataAndOffset)this.offsets().apply((Object)topicPartition)).olderThan(offsetWithCommitRecordMetadata) ? this.offsets().put((Object)topicPartition, (Object)offsetWithCommitRecordMetadata) : BoxedUnit.UNIT;
        } else {
            object = BoxedUnit.UNIT;
        }
        Option option = this.pendingOffsetCommits().get((Object)topicPartition);
        if (option instanceof Some) {
            Some some = (Some)option;
            OffsetAndMetadata stagedOffset = (OffsetAndMetadata)some.value();
            OffsetAndMetadata offsetAndMetadata = offsetWithCommitRecordMetadata.offsetAndMetadata();
            OffsetAndMetadata offsetAndMetadata2 = stagedOffset;
            if (!(offsetAndMetadata != null ? !((Object)offsetAndMetadata).equals(offsetAndMetadata2) : offsetAndMetadata2 != null)) {
                this.pendingOffsetCommits().remove((Object)topicPartition);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return;
            }
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void failPendingOffsetWrite(TopicPartition topicPartition, OffsetAndMetadata offset) {
        Option option = this.pendingOffsetCommits().get((Object)topicPartition);
        if (option instanceof Some) {
            Some some = (Some)option;
            OffsetAndMetadata pendingOffset = (OffsetAndMetadata)some.value();
            OffsetAndMetadata offsetAndMetadata = offset;
            OffsetAndMetadata offsetAndMetadata2 = pendingOffset;
            if (!(offsetAndMetadata != null ? !((Object)offsetAndMetadata).equals(offsetAndMetadata2) : offsetAndMetadata2 != null)) {
                this.pendingOffsetCommits().remove((Object)topicPartition);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return;
            }
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public void prepareOffsetCommit(scala.collection.immutable.Map<TopicPartition, OffsetAndMetadata> offsets) {
        this.receivedConsumerOffsetCommits_$eq(true);
        this.pendingOffsetCommits().$plus$plus$eq(offsets);
    }

    public void prepareTxnOffsetCommit(long producerId, scala.collection.immutable.Map<TopicPartition, OffsetAndMetadata> offsets) {
        this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"TxnOffsetCommit for producer ", " and group ", " with offsets ", " is pending"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)producerId), this.groupId(), offsets})));
        this.receivedTransactionalOffsetCommits_$eq(true);
        scala.collection.mutable.Map producerOffsets = (scala.collection.mutable.Map)this.pendingTransactionalOffsetCommits().getOrElseUpdate((Object)BoxesRunTime.boxToLong((long)producerId), (Function0 & Serializable & scala.Serializable)() -> Map$.MODULE$.empty());
        offsets.foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            TopicPartition topicPartition = (TopicPartition)tuple2._1();
            OffsetAndMetadata offsetAndMetadata = (OffsetAndMetadata)tuple2._2();
            Option option = producerOffsets.put((Object)topicPartition, (Object)new CommitRecordMetadataAndOffset((Option<Object>)None$.MODULE$, offsetAndMetadata));
            return option;
        });
    }

    public boolean hasReceivedConsistentOffsetCommits() {
        return !this.receivedConsumerOffsetCommits() || !this.receivedTransactionalOffsetCommits();
    }

    public void failPendingTxnOffsetCommit(long producerId, TopicPartition topicPartition) {
        Option option = this.pendingTransactionalOffsetCommits().get((Object)BoxesRunTime.boxToLong((long)producerId));
        if (option instanceof Some) {
            BoxedUnit boxedUnit;
            Some some = (Some)option;
            scala.collection.mutable.Map pendingOffsets = (scala.collection.mutable.Map)some.value();
            Option pendingOffsetCommit = pendingOffsets.remove((Object)topicPartition);
            this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"TxnOffsetCommit for producer ", " and group ", " with offsets ", " failed "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)producerId), this.groupId(), pendingOffsetCommit})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"to be appended to the log"})).s((Seq)Nil$.MODULE$));
            if (pendingOffsets.isEmpty()) {
                this.pendingTransactionalOffsetCommits().remove((Object)BoxesRunTime.boxToLong((long)producerId));
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit2 = boxedUnit;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    /*
     * Unable to fully structure code
     */
    public void onTxnOffsetCommitAppend(long producerId, TopicPartition topicPartition, CommitRecordMetadataAndOffset commitRecordMetadataAndOffset) {
        block3: {
            block2: {
                var6_4 = this.pendingTransactionalOffsetCommits().get((Object)BoxesRunTime.boxToLong((long)producerId));
                if (!(var6_4 instanceof Some)) break block2;
                var7_5 = (Some)var6_4;
                pendingOffset = (scala.collection.mutable.Map)var7_5.value();
                if (!pendingOffset.contains((Object)topicPartition)) ** GOTO lbl-1000
                v0 = ((CommitRecordMetadataAndOffset)pendingOffset.apply((Object)topicPartition)).offsetAndMetadata();
                var9_7 = commitRecordMetadataAndOffset.offsetAndMetadata();
                if (!(v0 != null ? v0.equals(var9_7) == false : var9_7 != null)) {
                    pendingOffset.update((Object)topicPartition, (Object)commitRecordMetadataAndOffset);
                    v1 = BoxedUnit.UNIT;
                } else lbl-1000:
                // 2 sources

                {
                    v1 = BoxedUnit.UNIT;
                }
                var5_8 = v1;
                break block3;
            }
            var5_9 = BoxedUnit.UNIT;
        }
    }

    public void completePendingTxnOffsetCommit(long producerId, boolean isCommit) {
        Option pendingOffsetsOpt = this.pendingTransactionalOffsetCommits().remove((Object)BoxesRunTime.boxToLong((long)producerId));
        if (isCommit) {
            pendingOffsetsOpt.foreach((Function1 & Serializable & scala.Serializable)pendingOffsets -> {
                pendingOffsets.foreach((Function1 & Serializable & scala.Serializable)x0$3 -> {
                    BoxedUnit boxedUnit;
                    Tuple2 tuple2 = x0$3;
                    if (tuple2 != null) {
                        TopicPartition topicPartition = (TopicPartition)tuple2._1();
                        CommitRecordMetadataAndOffset commitRecordMetadataAndOffset = (CommitRecordMetadataAndOffset)tuple2._2();
                        if (commitRecordMetadataAndOffset.appendedBatchOffset().isEmpty()) {
                            throw new IllegalStateException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Trying to complete a transactional offset commit for producerId ", " "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)producerId$3)})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"and groupId ", " even though the the offset commit record itself hasn't been appended to the log."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{$this.groupId()})));
                        }
                        Option currentOffsetOpt = $this.offsets().get((Object)topicPartition);
                        if (currentOffsetOpt.forall((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)x$6.olderThan(commitRecordMetadataAndOffset)))) {
                            $this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"TxnOffsetCommit for producer ", " and group ", " with offset ", " "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)producerId$3), $this.groupId(), commitRecordMetadataAndOffset})) + "committed and loaded into the cache.");
                            boxedUnit = $this.offsets().put((Object)topicPartition, (Object)commitRecordMetadataAndOffset);
                        } else {
                            $this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"TxnOffsetCommit for producer ", " and group ", " with offset ", " "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)producerId$3), $this.groupId(), commitRecordMetadataAndOffset})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"committed, but not loaded since its offset is older than current offset ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{currentOffsetOpt})));
                            boxedUnit = BoxedUnit.UNIT;
                        }
                    } else {
                        throw new MatchError((Object)tuple2);
                    }
                    BoxedUnit boxedUnit2 = boxedUnit;
                    return boxedUnit2;
                });
                return BoxedUnit.UNIT;
            });
        } else {
            this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"TxnOffsetCommit for producer ", " and group ", " with offsets ", " aborted"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)producerId), this.groupId(), pendingOffsetsOpt})));
        }
    }

    public Set<Object> activeProducers() {
        return this.pendingTransactionalOffsetCommits().keySet();
    }

    public boolean hasPendingOffsetCommitsFromProducer(long producerId) {
        return this.pendingTransactionalOffsetCommits().contains((Object)BoxesRunTime.boxToLong((long)producerId));
    }

    public scala.collection.immutable.Map<TopicPartition, OffsetAndMetadata> removeOffsets(Seq<TopicPartition> topicPartitions) {
        return ((TraversableOnce)topicPartitions.flatMap((Function1 & Serializable & scala.Serializable)topicPartition -> {
            this.pendingOffsetCommits().remove(topicPartition);
            this.pendingTransactionalOffsetCommits().foreach((Function1 & Serializable & scala.Serializable)x0$4 -> {
                Tuple2 tuple2 = x0$4;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                scala.collection.mutable.Map pendingOffsets = (scala.collection.mutable.Map)tuple2._2();
                Option option = pendingOffsets.remove(topicPartition);
                return option;
            });
            Option removedOffset = this.offsets().remove(topicPartition);
            return Option$.MODULE$.option2Iterable(removedOffset.map((Function1 & Serializable & scala.Serializable)x$7 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(topicPartition), (Object)x$7.offsetAndMetadata())));
        }, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    public scala.collection.immutable.Map<TopicPartition, OffsetAndMetadata> removeExpiredOffsets(long startMs) {
        HashMap expiredOffsets = (HashMap)((TraversableLike)this.offsets().filter((Function1 & Serializable & scala.Serializable)x0$5 -> BoxesRunTime.boxToBoolean((boolean)GroupMetadata.$anonfun$removeExpiredOffsets$1(this, startMs, x0$5)))).map((Function1 & Serializable & scala.Serializable)x0$6 -> {
            Tuple2 tuple2 = x0$6;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            TopicPartition topicPartition = (TopicPartition)tuple2._1();
            CommitRecordMetadataAndOffset commitRecordOffsetAndMetadata = (CommitRecordMetadataAndOffset)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)topicPartition, (Object)commitRecordOffsetAndMetadata.offsetAndMetadata());
            return tuple22;
        }, HashMap$.MODULE$.canBuildFrom());
        this.offsets().$minus$minus$eq((TraversableOnce)expiredOffsets.keySet());
        return expiredOffsets.toMap(Predef$.MODULE$.$conforms());
    }

    public scala.collection.immutable.Map<TopicPartition, OffsetAndMetadata> allOffsets() {
        return ((TraversableOnce)this.offsets().map((Function1 & Serializable & scala.Serializable)x0$7 -> {
            Tuple2 tuple2 = x0$7;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            TopicPartition topicPartition = (TopicPartition)tuple2._1();
            CommitRecordMetadataAndOffset commitRecordMetadataAndOffset = (CommitRecordMetadataAndOffset)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)topicPartition, (Object)commitRecordMetadataAndOffset.offsetAndMetadata());
            return tuple22;
        }, HashMap$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    public Option<OffsetAndMetadata> offset(TopicPartition topicPartition) {
        return this.offsets().get((Object)topicPartition).map((Function1 & Serializable & scala.Serializable)x$8 -> x$8.offsetAndMetadata());
    }

    public Option<CommitRecordMetadataAndOffset> offsetWithRecordMetadata(TopicPartition topicPartition) {
        return this.offsets().get((Object)topicPartition);
    }

    public int numOffsets() {
        return this.offsets().size();
    }

    public boolean hasOffsets() {
        return this.offsets().nonEmpty() || this.pendingOffsetCommits().nonEmpty() || this.pendingTransactionalOffsetCommits().nonEmpty();
    }

    private void assertValidTransition(GroupState targetState) {
        if (!((SetLike)GroupMetadata$.MODULE$.kafka$coordinator$group$GroupMetadata$$validPreviousStates().apply((Object)targetState)).contains((Object)this.state())) {
            throw new IllegalStateException(new StringOps(Predef$.MODULE$.augmentString("Group %s should be in the %s states before moving to %s state. Instead it is in %s state")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.groupId(), ((TraversableOnce)GroupMetadata$.MODULE$.kafka$coordinator$group$GroupMetadata$$validPreviousStates().apply((Object)targetState)).mkString(","), targetState, this.state()})));
        }
    }

    public String toString() {
        return "GroupMetadata(" + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"groupId=", ", "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.groupId()})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"generation=", ", "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.generationId())})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"protocolType=", ", "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.protocolType()})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"currentState=", ", "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.currentState()})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"members=", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.members()}));
    }

    public static final /* synthetic */ boolean $anonfun$notYetRejoinedMembers$1(MemberMetadata x$1) {
        return x$1.awaitingJoinCallback() == null;
    }

    public static final /* synthetic */ boolean $anonfun$removeExpiredOffsets$1(GroupMetadata $this, long startMs$1, Tuple2 x0$5) {
        Tuple2 tuple2 = x0$5;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        TopicPartition topicPartition = (TopicPartition)tuple2._1();
        CommitRecordMetadataAndOffset commitRecordMetadataAndOffset = (CommitRecordMetadataAndOffset)tuple2._2();
        boolean bl = commitRecordMetadataAndOffset.offsetAndMetadata().expireTimestamp() < startMs$1 && !$this.pendingOffsetCommits().contains((Object)topicPartition);
        return bl;
    }

    public GroupMetadata(String groupId, GroupState initialState) {
        this.groupId = groupId;
        Logging.$init$(this);
        this.state = initialState;
        this.lock = new ReentrantLock();
        this.members = new HashMap();
        this.offsets = new HashMap();
        this.pendingOffsetCommits = new HashMap();
        this.pendingTransactionalOffsetCommits = new HashMap();
        this.receivedTransactionalOffsetCommits = false;
        this.receivedConsumerOffsetCommits = false;
        this.protocolType = None$.MODULE$;
        this.generationId = 0;
        this.leaderId = null;
        this.protocol = null;
        this.newMemberAdded = false;
    }
}

