/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.trogdor.fault;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.util.ArrayList;
import org.apache.kafka.common.internals.KafkaFutureImpl;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.trogdor.common.Platform;
import org.apache.kafka.trogdor.task.TaskWorker;
import org.apache.kafka.trogdor.task.WorkerStatusTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessStopFaultWorker
implements TaskWorker {
    private static final Logger log = LoggerFactory.getLogger(ProcessStopFaultWorker.class);
    private final String id;
    private final String javaProcessName;
    private WorkerStatusTracker status;

    public ProcessStopFaultWorker(String id, String javaProcessName) {
        this.id = id;
        this.javaProcessName = javaProcessName;
    }

    @Override
    public void start(Platform platform, WorkerStatusTracker status, KafkaFutureImpl<String> errorFuture) throws Exception {
        this.status = status;
        log.info("Activating ProcessStopFault {}.", (Object)this.id);
        this.status.update((JsonNode)new TextNode("stopping " + this.javaProcessName));
        this.sendSignals(platform, "SIGSTOP");
        this.status.update((JsonNode)new TextNode("stopped " + this.javaProcessName));
    }

    @Override
    public void stop(Platform platform) throws Exception {
        log.info("Deactivating ProcessStopFault {}.", (Object)this.id);
        this.status.update((JsonNode)new TextNode("resuming " + this.javaProcessName));
        this.sendSignals(platform, "SIGCONT");
        this.status.update((JsonNode)new TextNode("resumed " + this.javaProcessName));
    }

    private void sendSignals(Platform platform, String signalName) throws Exception {
        String jcmdOutput = platform.runCommand(new String[]{"jcmd"});
        String[] lines = jcmdOutput.split("\n");
        ArrayList<Integer> pids = new ArrayList<Integer>();
        for (String line : lines) {
            if (!line.contains(this.javaProcessName)) continue;
            String[] components = line.split(" ");
            try {
                pids.add(Integer.parseInt(components[0]));
            }
            catch (NumberFormatException e) {
                log.error("Failed to parse process ID from line {}", (Throwable)e);
            }
        }
        if (pids.isEmpty()) {
            log.error("{}: no processes containing {} found to send {} to.", new Object[]{this.id, this.javaProcessName, signalName});
        } else {
            log.info("{}: sending {} to {} pid(s) {}", new Object[]{this.id, signalName, this.javaProcessName, Utils.join(pids, (String)", ")});
            for (Integer pid : pids) {
                platform.runCommand(new String[]{"kill", "-" + signalName, pid.toString()});
            }
        }
    }
}

