/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.trogdor.coordinator;

import java.util.concurrent.ThreadLocalRandom;
import net.sourceforge.argparse4j.ArgumentParsers;
import net.sourceforge.argparse4j.impl.Arguments;
import net.sourceforge.argparse4j.inf.ArgumentAction;
import net.sourceforge.argparse4j.inf.ArgumentParser;
import net.sourceforge.argparse4j.inf.ArgumentParserException;
import net.sourceforge.argparse4j.inf.Namespace;
import org.apache.kafka.common.utils.Exit;
import org.apache.kafka.common.utils.Scheduler;
import org.apache.kafka.trogdor.common.Node;
import org.apache.kafka.trogdor.common.Platform;
import org.apache.kafka.trogdor.coordinator.CoordinatorRestResource;
import org.apache.kafka.trogdor.coordinator.TaskManager;
import org.apache.kafka.trogdor.rest.CoordinatorStatusResponse;
import org.apache.kafka.trogdor.rest.CreateTaskRequest;
import org.apache.kafka.trogdor.rest.DestroyTaskRequest;
import org.apache.kafka.trogdor.rest.JsonRestServer;
import org.apache.kafka.trogdor.rest.StopTaskRequest;
import org.apache.kafka.trogdor.rest.TasksRequest;
import org.apache.kafka.trogdor.rest.TasksResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Coordinator {
    private static final Logger log = LoggerFactory.getLogger(Coordinator.class);
    public static final int DEFAULT_PORT = 8889;
    private final long startTimeMs;
    private final TaskManager taskManager;
    private final JsonRestServer restServer;

    public Coordinator(Platform platform, Scheduler scheduler, JsonRestServer restServer, CoordinatorRestResource resource, long firstWorkerId) {
        this.startTimeMs = scheduler.time().milliseconds();
        this.taskManager = new TaskManager(platform, scheduler, firstWorkerId);
        this.restServer = restServer;
        resource.setCoordinator(this);
    }

    public int port() {
        return this.restServer.port();
    }

    public CoordinatorStatusResponse status() throws Exception {
        return new CoordinatorStatusResponse(this.startTimeMs);
    }

    public void createTask(CreateTaskRequest request) throws Throwable {
        this.taskManager.createTask(request.id(), request.spec());
    }

    public void stopTask(StopTaskRequest request) throws Throwable {
        this.taskManager.stopTask(request.id());
    }

    public void destroyTask(DestroyTaskRequest request) throws Throwable {
        this.taskManager.destroyTask(request.id());
    }

    public TasksResponse tasks(TasksRequest request) throws Exception {
        return this.taskManager.tasks(request);
    }

    public void beginShutdown(boolean stopAgents) throws Exception {
        this.restServer.beginShutdown();
        this.taskManager.beginShutdown(stopAgents);
    }

    public void waitForShutdown() throws Exception {
        this.restServer.waitForShutdown();
        this.taskManager.waitForShutdown();
    }

    public static void main(String[] args) throws Exception {
        ArgumentParser parser = ArgumentParsers.newArgumentParser((String)"trogdor-coordinator").defaultHelp(true).description("The Trogdor fault injection coordinator");
        parser.addArgument(new String[]{"--coordinator.config", "-c"}).action((ArgumentAction)Arguments.store()).required(true).type(String.class).dest("config").metavar(new String[]{"CONFIG"}).help("The configuration file to use.");
        parser.addArgument(new String[]{"--node-name", "-n"}).action((ArgumentAction)Arguments.store()).required(true).type(String.class).dest("node_name").metavar(new String[]{"NODE_NAME"}).help("The name of this node.");
        Namespace res = null;
        try {
            res = parser.parseArgs(args);
        }
        catch (ArgumentParserException e) {
            if (args.length == 0) {
                parser.printHelp();
                Exit.exit((int)0);
            }
            parser.handleError(e);
            Exit.exit((int)1);
        }
        String configPath = res.getString("config");
        String nodeName = res.getString("node_name");
        Platform platform = Platform.Config.parse(nodeName, configPath);
        JsonRestServer restServer = new JsonRestServer(Node.Util.getTrogdorCoordinatorPort(platform.curNode()));
        CoordinatorRestResource resource = new CoordinatorRestResource();
        log.info("Starting coordinator process.");
        final Coordinator coordinator = new Coordinator(platform, Scheduler.SYSTEM, restServer, resource, ThreadLocalRandom.current().nextLong(0L, 0x3FFFFFFFFFFFFFFFL));
        restServer.start(resource);
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                log.warn("Running coordinator shutdown hook.");
                try {
                    coordinator.beginShutdown(false);
                    coordinator.waitForShutdown();
                }
                catch (Exception e) {
                    log.error("Got exception while running coordinator shutdown hook.", (Throwable)e);
                }
            }
        });
        coordinator.waitForShutdown();
    }
}

