/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.log.remote.metadata.storage;

import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.server.log.remote.metadata.storage.RemoteLogLeaderEpochState;
import org.apache.kafka.server.log.remote.metadata.storage.RemoteLogMetadataCache;
import org.apache.kafka.server.log.remote.metadata.storage.RemoteLogMetadataSnapshotFile;
import org.apache.kafka.server.log.remote.metadata.storage.RemoteLogSegmentMetadataSnapshot;
import org.apache.kafka.server.log.remote.storage.RemoteLogSegmentId;
import org.apache.kafka.server.log.remote.storage.RemoteLogSegmentMetadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileBasedRemoteLogMetadataCache
extends RemoteLogMetadataCache {
    private static final Logger log = LoggerFactory.getLogger(FileBasedRemoteLogMetadataCache.class);
    private final RemoteLogMetadataSnapshotFile snapshotFile;
    private final TopicIdPartition topicIdPartition;

    public FileBasedRemoteLogMetadataCache(TopicIdPartition topicIdPartition, Path partitionDir) {
        if (!partitionDir.toFile().exists() || !partitionDir.toFile().isDirectory()) {
            throw new KafkaException("Given partition directory:" + partitionDir + " must be an existing directory.");
        }
        this.topicIdPartition = topicIdPartition;
        this.snapshotFile = new RemoteLogMetadataSnapshotFile(partitionDir);
        try {
            this.snapshotFile.read().ifPresent(snapshot -> this.loadRemoteLogSegmentMetadata((RemoteLogMetadataSnapshotFile.Snapshot)snapshot));
        }
        catch (IOException e) {
            throw new KafkaException((Throwable)e);
        }
    }

    protected void loadRemoteLogSegmentMetadata(RemoteLogMetadataSnapshotFile.Snapshot snapshot) {
        log.info("Loading snapshot for partition {} is: {}", (Object)this.topicIdPartition, (Object)snapshot);
        block5: for (RemoteLogSegmentMetadataSnapshot metadataSnapshot : snapshot.remoteLogSegmentMetadataSnapshots()) {
            switch (metadataSnapshot.state()) {
                case COPY_SEGMENT_STARTED: {
                    this.addCopyInProgressSegment(this.createRemoteLogSegmentMetadata(metadataSnapshot));
                    continue block5;
                }
                case COPY_SEGMENT_FINISHED: {
                    this.handleSegmentWithCopySegmentFinishedState(this.createRemoteLogSegmentMetadata(metadataSnapshot));
                    continue block5;
                }
                case DELETE_SEGMENT_STARTED: {
                    this.handleSegmentWithDeleteSegmentStartedState(this.createRemoteLogSegmentMetadata(metadataSnapshot));
                    continue block5;
                }
            }
            throw new IllegalArgumentException("Given remoteLogSegmentMetadata has invalid state: " + (Object)((Object)metadataSnapshot));
        }
    }

    private RemoteLogSegmentMetadata createRemoteLogSegmentMetadata(RemoteLogSegmentMetadataSnapshot snapshot) {
        return new RemoteLogSegmentMetadata(new RemoteLogSegmentId(this.topicIdPartition, snapshot.segmentId()), snapshot.startOffset(), snapshot.endOffset(), snapshot.maxTimestampMs(), snapshot.brokerId(), snapshot.eventTimestampMs(), snapshot.segmentSizeInBytes(), snapshot.state(), snapshot.segmentLeaderEpochs());
    }

    public void flushToFile(int metadataPartition, Long metadataPartitionOffset) throws IOException {
        ArrayList<RemoteLogSegmentMetadataSnapshot> snapshots = new ArrayList<RemoteLogSegmentMetadataSnapshot>(this.idToSegmentMetadata.size());
        for (RemoteLogLeaderEpochState state : this.leaderEpochEntries.values()) {
            for (RemoteLogSegmentId id : state.unreferencedSegmentIds()) {
                snapshots.add(RemoteLogSegmentMetadataSnapshot.create((RemoteLogSegmentMetadata)this.idToSegmentMetadata.get(id)));
            }
            for (RemoteLogSegmentId id : state.referencedSegmentIds()) {
                snapshots.add(RemoteLogSegmentMetadataSnapshot.create((RemoteLogSegmentMetadata)this.idToSegmentMetadata.get(id)));
            }
        }
        this.snapshotFile.write(new RemoteLogMetadataSnapshotFile.Snapshot(metadataPartition, metadataPartitionOffset, snapshots));
    }
}

