/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.compress;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import net.jpountz.lz4.LZ4Compressor;
import net.jpountz.lz4.LZ4Exception;
import net.jpountz.lz4.LZ4Factory;
import net.jpountz.lz4.LZ4SafeDecompressor;
import net.jpountz.util.SafeUtils;
import net.jpountz.xxhash.XXHash32;
import net.jpountz.xxhash.XXHashFactory;
import org.apache.kafka.common.compress.KafkaLZ4BlockOutputStream;
import org.apache.kafka.common.utils.BufferSupplier;

public final class KafkaLZ4BlockInputStream
extends InputStream {
    public static final String PREMATURE_EOS = "Stream ended prematurely";
    public static final String NOT_SUPPORTED = "Stream unsupported (invalid magic bytes)";
    public static final String BLOCK_HASH_MISMATCH = "Block checksum mismatch";
    public static final String DESCRIPTOR_HASH_MISMATCH = "Stream frame descriptor corrupted";
    private static final LZ4SafeDecompressor DECOMPRESSOR = LZ4Factory.fastestInstance().safeDecompressor();
    private static final XXHash32 CHECKSUM = XXHashFactory.fastestInstance().hash32();
    private static final RuntimeException BROKEN_LZ4_EXCEPTION;
    private final ByteBuffer in;
    private final boolean ignoreFlagDescriptorChecksum;
    private final BufferSupplier bufferSupplier;
    private final ByteBuffer decompressionBuffer;
    private KafkaLZ4BlockOutputStream.FLG flg;
    private int maxBlockSize;
    private ByteBuffer decompressedBuffer;
    private boolean finished;

    public KafkaLZ4BlockInputStream(ByteBuffer in, BufferSupplier bufferSupplier, boolean ignoreFlagDescriptorChecksum) throws IOException {
        if (BROKEN_LZ4_EXCEPTION != null) {
            throw BROKEN_LZ4_EXCEPTION;
        }
        this.ignoreFlagDescriptorChecksum = ignoreFlagDescriptorChecksum;
        this.in = in.duplicate().order(ByteOrder.LITTLE_ENDIAN);
        this.bufferSupplier = bufferSupplier;
        this.readHeader();
        this.decompressionBuffer = bufferSupplier.get(this.maxBlockSize);
        this.finished = false;
    }

    public boolean ignoreFlagDescriptorChecksum() {
        return this.ignoreFlagDescriptorChecksum;
    }

    private void readHeader() throws IOException {
        if (this.in.remaining() < 6) {
            throw new IOException(PREMATURE_EOS);
        }
        if (407708164 != this.in.getInt()) {
            throw new IOException(NOT_SUPPORTED);
        }
        this.in.mark();
        this.flg = KafkaLZ4BlockOutputStream.FLG.fromByte(this.in.get());
        this.maxBlockSize = KafkaLZ4BlockOutputStream.BD.fromByte(this.in.get()).getBlockMaximumSize();
        if (this.flg.isContentSizeSet()) {
            if (this.in.remaining() < 8) {
                throw new IOException(PREMATURE_EOS);
            }
            this.in.position(this.in.position() + 8);
        }
        if (this.ignoreFlagDescriptorChecksum) {
            this.in.position(this.in.position() + 1);
            return;
        }
        int len = this.in.position() - this.in.reset().position();
        int hash = CHECKSUM.hash(this.in, this.in.position(), len, 0);
        this.in.position(this.in.position() + len);
        if (this.in.get() != (byte)(hash >> 8 & 0xFF)) {
            throw new IOException(DESCRIPTOR_HASH_MISMATCH);
        }
    }

    private void readBlock() throws IOException {
        boolean compressed;
        if (this.in.remaining() < 4) {
            throw new IOException(PREMATURE_EOS);
        }
        int blockSize = this.in.getInt();
        boolean bl = compressed = (blockSize & Integer.MIN_VALUE) == 0;
        if ((blockSize &= Integer.MAX_VALUE) == 0) {
            this.finished = true;
            if (this.flg.isContentChecksumSet()) {
                this.in.getInt();
            }
            return;
        }
        if (blockSize > this.maxBlockSize) {
            throw new IOException(String.format("Block size %s exceeded max: %s", blockSize, this.maxBlockSize));
        }
        if (this.in.remaining() < blockSize) {
            throw new IOException(PREMATURE_EOS);
        }
        if (compressed) {
            try {
                int bufferSize = DECOMPRESSOR.decompress(this.in, this.in.position(), blockSize, this.decompressionBuffer, 0, this.maxBlockSize);
                this.decompressionBuffer.position(0);
                this.decompressionBuffer.limit(bufferSize);
                this.decompressedBuffer = this.decompressionBuffer;
            }
            catch (LZ4Exception e) {
                throw new IOException(e);
            }
        } else {
            this.decompressedBuffer = this.in.slice();
            this.decompressedBuffer.limit(blockSize);
        }
        if (this.flg.isBlockChecksumSet()) {
            int hash = CHECKSUM.hash(this.in, this.in.position(), blockSize, 0);
            this.in.position(this.in.position() + blockSize);
            if (hash != this.in.getInt()) {
                throw new IOException(BLOCK_HASH_MISMATCH);
            }
        } else {
            this.in.position(this.in.position() + blockSize);
        }
    }

    @Override
    public int read() throws IOException {
        if (this.finished) {
            return -1;
        }
        if (this.available() == 0) {
            this.readBlock();
        }
        if (this.finished) {
            return -1;
        }
        return this.decompressedBuffer.get() & 0xFF;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        SafeUtils.checkRange((byte[])b, (int)off, (int)len);
        if (this.finished) {
            return -1;
        }
        if (this.available() == 0) {
            this.readBlock();
        }
        if (this.finished) {
            return -1;
        }
        len = Math.min(len, this.available());
        this.decompressedBuffer.get(b, off, len);
        return len;
    }

    @Override
    public long skip(long n) throws IOException {
        if (this.finished) {
            return 0L;
        }
        if (this.available() == 0) {
            this.readBlock();
        }
        if (this.finished) {
            return 0L;
        }
        int skipped = (int)Math.min(n, (long)this.available());
        this.decompressedBuffer.position(this.decompressedBuffer.position() + skipped);
        return skipped;
    }

    @Override
    public int available() {
        return this.decompressedBuffer == null ? 0 : this.decompressedBuffer.remaining();
    }

    @Override
    public void close() {
        this.bufferSupplier.release(this.decompressionBuffer);
    }

    @Override
    public void mark(int readlimit) {
        throw new RuntimeException("mark not supported");
    }

    @Override
    public void reset() {
        throw new RuntimeException("reset not supported");
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    static void detectBrokenLz4Version() {
        byte[] source = new byte[]{1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3};
        LZ4Compressor compressor = LZ4Factory.fastestInstance().fastCompressor();
        byte[] compressed = new byte[compressor.maxCompressedLength(source.length)];
        int compressedLength = compressor.compress(source, 0, source.length, compressed, 0, compressed.length);
        byte[] zeroes = new byte[]{0, 0, 0, 0, 0};
        ByteBuffer nonZeroOffsetBuffer = ByteBuffer.allocate(zeroes.length + compressed.length).put(zeroes).slice().put(compressed);
        ByteBuffer dest = ByteBuffer.allocate(source.length);
        try {
            DECOMPRESSOR.decompress(nonZeroOffsetBuffer, 0, compressedLength, dest, 0, source.length);
        }
        catch (Exception e) {
            throw new RuntimeException("Kafka has detected detected a buggy lz4-java library (< 1.4.x) on the classpath. If you are using Kafka client libraries, make sure your application does not accidentally override the version provided by Kafka or include multiple versions of the library on the classpath. The lz4-java version on the classpath should match the version the Kafka client libraries depend on. Adding -verbose:class to your JVM arguments may help understand which lz4-java version is getting loaded.", e);
        }
    }

    static {
        RuntimeException exception = null;
        try {
            KafkaLZ4BlockInputStream.detectBrokenLz4Version();
        }
        catch (RuntimeException e) {
            exception = e;
        }
        BROKEN_LZ4_EXCEPTION = exception;
    }
}

