/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.Collections;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.ProtoUtils;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AbstractRequestResponse;
import org.apache.kafka.common.requests.ControlledShutdownResponse;

public class ControlledShutdownRequest
extends AbstractRequest {
    private static final Schema CURRENT_SCHEMA = ProtoUtils.currentRequestSchema(ApiKeys.CONTROLLED_SHUTDOWN_KEY.id);
    private static final String BROKER_ID_KEY_NAME = "broker_id";
    private int brokerId;

    public ControlledShutdownRequest(int brokerId) {
        super(new Struct(CURRENT_SCHEMA));
        this.struct.set(BROKER_ID_KEY_NAME, (Object)brokerId);
        this.brokerId = brokerId;
    }

    public ControlledShutdownRequest(Struct struct) {
        super(struct);
        this.brokerId = struct.getInt(BROKER_ID_KEY_NAME);
    }

    @Override
    public AbstractRequestResponse getErrorResponse(int versionId, Throwable e) {
        switch (versionId) {
            case 0: {
                throw new IllegalArgumentException(String.format("Version 0 is not supported. It is only supported by the Scala request class for controlled shutdown", new Object[0]));
            }
            case 1: {
                return new ControlledShutdownResponse(Errors.forException(e).code(), Collections.emptySet());
            }
        }
        throw new IllegalArgumentException(String.format("Version %d is not valid. Valid versions for %s are 0 to %d", versionId, this.getClass().getSimpleName(), ProtoUtils.latestVersion(ApiKeys.CONTROLLED_SHUTDOWN_KEY.id)));
    }

    public int brokerId() {
        return this.brokerId;
    }

    public static ControlledShutdownRequest parse(ByteBuffer buffer, int versionId) {
        return new ControlledShutdownRequest(ProtoUtils.parseRequest(ApiKeys.CONTROLLED_SHUTDOWN_KEY.id, versionId, buffer));
    }

    public static ControlledShutdownRequest parse(ByteBuffer buffer) {
        return new ControlledShutdownRequest((Struct)CURRENT_SCHEMA.read(buffer));
    }
}

