/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.record;

import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Iterator;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.record.ByteBufferInputStream;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.Compressor;
import org.apache.kafka.common.record.LogEntry;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.record.Records;
import org.apache.kafka.common.utils.AbstractIterator;

public class MemoryRecords
implements Records {
    private static final int WRITE_LIMIT_FOR_READABLE_ONLY = -1;
    private final Compressor compressor;
    private final int writeLimit;
    private final int initialCapacity;
    private ByteBuffer buffer;
    private boolean writable;

    private MemoryRecords(ByteBuffer buffer, CompressionType type, boolean writable, int writeLimit) {
        this.writable = writable;
        this.writeLimit = writeLimit;
        this.initialCapacity = buffer.capacity();
        if (this.writable) {
            this.buffer = null;
            this.compressor = new Compressor(buffer, type);
        } else {
            this.buffer = buffer;
            this.compressor = null;
        }
    }

    public static MemoryRecords emptyRecords(ByteBuffer buffer, CompressionType type, int writeLimit) {
        return new MemoryRecords(buffer, type, true, writeLimit);
    }

    public static MemoryRecords emptyRecords(ByteBuffer buffer, CompressionType type) {
        return MemoryRecords.emptyRecords(buffer, type, buffer.capacity());
    }

    public static MemoryRecords readableRecords(ByteBuffer buffer) {
        return new MemoryRecords(buffer, CompressionType.NONE, false, -1);
    }

    public void append(long offset, Record record) {
        if (!this.writable) {
            throw new IllegalStateException("Memory records is not writable");
        }
        int size = record.size();
        this.compressor.putLong(offset);
        this.compressor.putInt(size);
        this.compressor.put(record.buffer());
        this.compressor.recordWritten(size + 12);
        record.buffer().rewind();
    }

    public void append(long offset, byte[] key, byte[] value) {
        if (!this.writable) {
            throw new IllegalStateException("Memory records is not writable");
        }
        int size = Record.recordSize(key, value);
        this.compressor.putLong(offset);
        this.compressor.putInt(size);
        this.compressor.putRecord(key, value);
        this.compressor.recordWritten(size + 12);
    }

    public boolean hasRoomFor(byte[] key, byte[] value) {
        return this.writable && this.compressor.numRecordsWritten() == 0L ? this.initialCapacity >= 12 + Record.recordSize(key, value) : (long)this.writeLimit >= this.compressor.estimatedBytesWritten() + 12L + (long)Record.recordSize(key, value);
    }

    public boolean isFull() {
        return !this.writable || (long)this.writeLimit <= this.compressor.estimatedBytesWritten();
    }

    public void close() {
        if (this.writable) {
            this.compressor.close();
            this.buffer = this.compressor.buffer();
            this.buffer.flip();
            this.writable = false;
        }
    }

    @Override
    public int sizeInBytes() {
        if (this.writable) {
            return this.compressor.buffer().position();
        }
        return this.buffer.limit();
    }

    public double compressionRate() {
        if (this.compressor == null) {
            return 1.0;
        }
        return this.compressor.compressionRate();
    }

    public int initialCapacity() {
        return this.initialCapacity;
    }

    public ByteBuffer buffer() {
        if (this.writable) {
            throw new IllegalStateException("The memory records must not be writable any more before getting its underlying buffer");
        }
        return this.buffer.duplicate();
    }

    @Override
    public Iterator<LogEntry> iterator() {
        if (this.writable) {
            return new RecordsIterator((ByteBuffer)this.buffer.duplicate().flip(), CompressionType.NONE, false);
        }
        return new RecordsIterator(this.buffer.duplicate(), CompressionType.NONE, false);
    }

    public String toString() {
        Iterator<LogEntry> iter = this.iterator();
        StringBuilder builder = new StringBuilder();
        builder.append('[');
        while (iter.hasNext()) {
            LogEntry entry = iter.next();
            builder.append('(');
            builder.append("offset=");
            builder.append(entry.offset());
            builder.append(",");
            builder.append("record=");
            builder.append(entry.record());
            builder.append(")");
        }
        builder.append(']');
        return builder.toString();
    }

    public static class RecordsIterator
    extends AbstractIterator<LogEntry> {
        private final ByteBuffer buffer;
        private final DataInputStream stream;
        private final CompressionType type;
        private final boolean shallow;
        private RecordsIterator innerIter;

        public RecordsIterator(ByteBuffer buffer, CompressionType type, boolean shallow) {
            this.type = type;
            this.buffer = buffer;
            this.shallow = shallow;
            this.stream = Compressor.wrapForInput(new ByteBufferInputStream(this.buffer), type);
        }

        @Override
        protected LogEntry makeNext() {
            if (this.innerDone()) {
                try {
                    ByteBuffer rec;
                    long offset = this.stream.readLong();
                    int size = this.stream.readInt();
                    if (size < 0) {
                        throw new IllegalStateException("Record with size " + size);
                    }
                    if (this.type == CompressionType.NONE) {
                        rec = this.buffer.slice();
                        int newPos = this.buffer.position() + size;
                        if (newPos > this.buffer.limit()) {
                            return (LogEntry)this.allDone();
                        }
                        this.buffer.position(newPos);
                        rec.limit(size);
                    } else {
                        byte[] recordBuffer = new byte[size];
                        this.stream.readFully(recordBuffer, 0, size);
                        rec = ByteBuffer.wrap(recordBuffer);
                    }
                    LogEntry entry = new LogEntry(offset, new Record(rec));
                    CompressionType compression = entry.record().compressionType();
                    if (compression == CompressionType.NONE || this.shallow) {
                        return entry;
                    }
                    ByteBuffer value = entry.record().value();
                    this.innerIter = new RecordsIterator(value, compression, true);
                    return (LogEntry)this.innerIter.next();
                }
                catch (EOFException e) {
                    return (LogEntry)this.allDone();
                }
                catch (IOException e) {
                    throw new KafkaException(e);
                }
            }
            return (LogEntry)this.innerIter.next();
        }

        private boolean innerDone() {
            return this.innerIter == null || !this.innerIter.hasNext();
        }
    }
}

