/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.encoding.decoder;

import java.nio.ByteBuffer;
import org.apache.iotdb.tsfile.encoding.decoder.GorillaDecoderV2;

public class LongGorillaDecoder
extends GorillaDecoderV2 {
    protected long storedValue = 0L;

    @Override
    public void reset() {
        super.reset();
        this.storedValue = 0L;
    }

    @Override
    public final long readLong(ByteBuffer in) {
        long returnValue = this.storedValue;
        if (!this.firstValueWasRead) {
            this.flipByte(in);
            this.storedValue = this.readLong(64, in);
            this.firstValueWasRead = true;
            returnValue = this.storedValue;
        }
        this.cacheNext(in);
        return returnValue;
    }

    protected long cacheNext(ByteBuffer in) {
        this.readNext(in);
        if (this.storedValue == Long.MIN_VALUE) {
            this.hasNext = false;
        }
        return this.storedValue;
    }

    protected long readNext(ByteBuffer in) {
        byte controlBits = this.readNextClearBit(2, in);
        switch (controlBits) {
            case 3: {
                this.storedLeadingZeros = (int)this.readLong(6, in);
                byte significantBits = (byte)this.readLong(6, in);
                significantBits = (byte)(significantBits + 1);
                this.storedTrailingZeros = 64 - significantBits - this.storedLeadingZeros;
            }
            case 2: {
                long xor = this.readLong(64 - this.storedLeadingZeros - this.storedTrailingZeros, in);
                this.storedValue ^= (xor <<= this.storedTrailingZeros);
            }
        }
        return this.storedValue;
    }
}

