/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.hive;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.IntStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.HiveMetaStoreClient;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.api.EnvironmentContext;
import org.apache.hadoop.hive.metastore.api.LockRequest;
import org.apache.hadoop.hive.metastore.api.LockResponse;
import org.apache.hadoop.hive.metastore.api.LockState;
import org.apache.hadoop.hive.metastore.api.ShowLocksRequest;
import org.apache.hadoop.hive.metastore.api.ShowLocksResponse;
import org.apache.hadoop.hive.metastore.api.ShowLocksResponseElement;
import org.apache.iceberg.CatalogUtil;
import org.apache.iceberg.ClientPool;
import org.apache.iceberg.HasTableOperations;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.Table;
import org.apache.iceberg.TableMetadata;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.exceptions.CommitFailedException;
import org.apache.iceberg.hive.CachedClientPool;
import org.apache.iceberg.hive.HiveCatalog;
import org.apache.iceberg.hive.HiveClientPool;
import org.apache.iceberg.hive.HiveMetastoreExtension;
import org.apache.iceberg.hive.HiveTableOperations;
import org.apache.iceberg.hive.HiveVersion;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.apache.thrift.TException;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;
import org.mockito.AdditionalAnswers;
import org.mockito.ArgumentCaptor;
import org.mockito.MockedStatic;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;

public class TestHiveCommitLocks {
    private static HiveTableOperations spyOps = null;
    private static HiveClientPool spyClientPool = null;
    private static CachedClientPool spyCachedClientPool = null;
    private static Configuration overriddenHiveConf;
    private static final AtomicReference<IMetaStoreClient> SPY_CLIENT_REF;
    private static IMetaStoreClient spyClient;
    HiveTableOperations ops = null;
    TableMetadata metadataV1 = null;
    TableMetadata metadataV2 = null;
    long dummyLockId = 500L;
    LockResponse waitLockResponse = new LockResponse(this.dummyLockId, LockState.WAITING);
    LockResponse acquiredLockResponse = new LockResponse(this.dummyLockId, LockState.ACQUIRED);
    LockResponse notAcquiredLockResponse = new LockResponse(this.dummyLockId, LockState.NOT_ACQUIRED);
    ShowLocksResponse emptyLocks = new ShowLocksResponse((List)Lists.newArrayList());
    private static final String DB_NAME = "hivedb";
    private static final String TABLE_NAME = "tbl";
    private static final Schema SCHEMA;
    private static final PartitionSpec PARTITION_SPEC;
    static final TableIdentifier TABLE_IDENTIFIER;
    @RegisterExtension
    private static final HiveMetastoreExtension HIVE_METASTORE_EXTENSION;
    private static HiveCatalog catalog;
    private Path tableLocation;

    @BeforeAll
    public static void initCatalog() throws Exception {
        catalog = (HiveCatalog)CatalogUtil.loadCatalog((String)HiveCatalog.class.getName(), (String)"hive", (Map)ImmutableMap.of((Object)"client.pool.cache.eviction-interval-ms", (Object)String.valueOf(TimeUnit.SECONDS.toMillis(10L))), (Object)HIVE_METASTORE_EXTENSION.hiveConf());
        overriddenHiveConf = new Configuration((Configuration)HIVE_METASTORE_EXTENSION.hiveConf());
        overriddenHiveConf.setLong("iceberg.hive.lock-timeout-ms", 6000L);
        overriddenHiveConf.setLong("iceberg.hive.lock-check-min-wait-ms", 50L);
        overriddenHiveConf.setLong("iceberg.hive.lock-check-max-wait-ms", 5000L);
        overriddenHiveConf.setLong("iceberg.hive.lock-heartbeat-interval-ms", 100L);
        spyClientPool = (HiveClientPool)Mockito.spy((Object)new HiveClientPool(1, overriddenHiveConf));
        Mockito.when((Object)spyClientPool.newClient()).thenAnswer(invocation -> {
            IMetaStoreClient client = (IMetaStoreClient)Mockito.spy((Object)new HiveMetaStoreClient(HIVE_METASTORE_EXTENSION.hiveConf()));
            SPY_CLIENT_REF.set(client);
            return SPY_CLIENT_REF.get();
        });
        spyClientPool.run(IMetaStoreClient::isLocalMetaStore);
        spyCachedClientPool = (CachedClientPool)Mockito.spy((Object)new CachedClientPool((Configuration)HIVE_METASTORE_EXTENSION.hiveConf(), Collections.emptyMap()));
        Mockito.when((Object)spyCachedClientPool.clientPool()).thenAnswer(invocation -> spyClientPool);
        Assertions.assertThat((Object)SPY_CLIENT_REF.get()).isNotNull();
        spyClient = SPY_CLIENT_REF.get();
    }

    @BeforeEach
    public void before() throws Exception {
        this.tableLocation = new Path(catalog.createTable(TABLE_IDENTIFIER, SCHEMA, PARTITION_SPEC).location());
        Table table = catalog.loadTable(TABLE_IDENTIFIER);
        this.ops = (HiveTableOperations)((HasTableOperations)table).operations();
        String dbName = TABLE_IDENTIFIER.namespace().level(0);
        String tableName = TABLE_IDENTIFIER.name();
        this.metadataV1 = this.ops.current();
        table.updateSchema().addColumn("n", (Type)Types.IntegerType.get()).commit();
        this.ops.refresh();
        this.metadataV2 = this.ops.current();
        Assertions.assertThat((List)this.ops.current().schema().columns()).hasSize(2);
        spyOps = (HiveTableOperations)Mockito.spy((Object)new HiveTableOperations(overriddenHiveConf, (ClientPool)spyCachedClientPool, this.ops.io(), catalog.name(), dbName, tableName));
        Mockito.reset((Object[])new IMetaStoreClient[]{spyClient});
    }

    @AfterEach
    public void dropTestTable() throws Exception {
        this.tableLocation.getFileSystem((Configuration)HIVE_METASTORE_EXTENSION.hiveConf()).delete(this.tableLocation, true);
        catalog.dropTable(TABLE_IDENTIFIER, false);
    }

    @AfterAll
    public static void cleanup() {
        try {
            spyClientPool.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Test
    public void testLockAcquisitionAtFirstTime() throws TException, InterruptedException {
        ((IMetaStoreClient)Mockito.doReturn((Object)this.acquiredLockResponse).when((Object)spyClient)).lock((LockRequest)Mockito.any());
        ((IMetaStoreClient)Mockito.doNothing().when((Object)spyClient)).unlock(Mockito.eq((long)this.dummyLockId));
        ((IMetaStoreClient)Mockito.doNothing().when((Object)spyClient)).heartbeat(Mockito.eq((long)0L), Mockito.eq((long)this.dummyLockId));
        spyOps.doCommit(this.metadataV2, this.metadataV1);
        Assertions.assertThat((List)spyOps.current().schema().columns()).hasSize(1);
    }

    @Test
    public void testLockAcquisitionAfterRetries() throws TException, InterruptedException {
        ((IMetaStoreClient)Mockito.doReturn((Object)this.waitLockResponse).when((Object)spyClient)).lock((LockRequest)Mockito.any());
        ((IMetaStoreClient)Mockito.doReturn((Object)this.waitLockResponse).doReturn((Object)this.waitLockResponse).doReturn((Object)this.waitLockResponse).doReturn((Object)this.waitLockResponse).doReturn((Object)this.acquiredLockResponse).when((Object)spyClient)).checkLock(Mockito.eq((long)this.dummyLockId));
        ((IMetaStoreClient)Mockito.doNothing().when((Object)spyClient)).unlock(Mockito.eq((long)this.dummyLockId));
        ((IMetaStoreClient)Mockito.doNothing().when((Object)spyClient)).heartbeat(Mockito.eq((long)0L), Mockito.eq((long)this.dummyLockId));
        spyOps.doCommit(this.metadataV2, this.metadataV1);
        Assertions.assertThat((List)spyOps.current().schema().columns()).hasSize(1);
    }

    @Test
    public void testLockAcquisitionAfterFailedNotFoundLock() throws TException, InterruptedException {
        ((IMetaStoreClient)Mockito.doReturn((Object)this.emptyLocks).when((Object)spyClient)).showLocks((ShowLocksRequest)Mockito.any());
        ((IMetaStoreClient)Mockito.doThrow((Throwable[])new Throwable[]{new TException("Failed to connect to HMS")}).doReturn((Object)this.waitLockResponse).when((Object)spyClient)).lock((LockRequest)Mockito.any());
        ((IMetaStoreClient)Mockito.doReturn((Object)this.waitLockResponse).doReturn((Object)this.acquiredLockResponse).when((Object)spyClient)).checkLock(Mockito.eq((long)this.dummyLockId));
        ((IMetaStoreClient)Mockito.doNothing().when((Object)spyClient)).heartbeat(Mockito.eq((long)0L), Mockito.eq((long)this.dummyLockId));
        spyOps.doCommit(this.metadataV2, this.metadataV1);
        ((IMetaStoreClient)Mockito.verify((Object)spyClient, (VerificationMode)Mockito.times((int)1))).showLocks((ShowLocksRequest)Mockito.any());
        Assertions.assertThat((List)spyOps.current().schema().columns()).hasSize(1);
    }

    @Test
    public void testLockAcquisitionAfterFailedAndFoundLock() throws TException, InterruptedException {
        ArgumentCaptor lockRequestCaptor = ArgumentCaptor.forClass(LockRequest.class);
        ((IMetaStoreClient)Mockito.doReturn((Object)this.emptyLocks).when((Object)spyClient)).showLocks((ShowLocksRequest)Mockito.any());
        ((IMetaStoreClient)Mockito.doThrow((Throwable[])new Throwable[]{new TException("Failed to connect to HMS")}).doReturn((Object)this.waitLockResponse).when((Object)spyClient)).lock((LockRequest)lockRequestCaptor.capture());
        ShowLocksResponse showLocksResponse = new ShowLocksResponse((List)Lists.newArrayList());
        ShowLocksResponseElementWrapper showLocksElement = new ShowLocksResponseElementWrapper(lockRequestCaptor);
        showLocksResponse.getLocks().add(showLocksElement);
        ((IMetaStoreClient)Mockito.doReturn((Object)showLocksResponse).when((Object)spyClient)).showLocks((ShowLocksRequest)Mockito.any());
        ((IMetaStoreClient)Mockito.doReturn((Object)this.acquiredLockResponse).when((Object)spyClient)).checkLock(Mockito.eq((long)this.dummyLockId));
        ((IMetaStoreClient)Mockito.doNothing().when((Object)spyClient)).heartbeat(Mockito.eq((long)0L), Mockito.eq((long)this.dummyLockId));
        spyOps.doCommit(this.metadataV2, this.metadataV1);
        ((IMetaStoreClient)Mockito.verify((Object)spyClient, (VerificationMode)Mockito.times((int)1))).showLocks((ShowLocksRequest)Mockito.any());
        Assertions.assertThat((List)spyOps.current().schema().columns()).hasSize(1);
    }

    @Test
    public void testUnLock() throws TException {
        ((IMetaStoreClient)Mockito.doReturn((Object)this.waitLockResponse).when((Object)spyClient)).lock((LockRequest)Mockito.any());
        ((IMetaStoreClient)Mockito.doReturn((Object)this.acquiredLockResponse).when((Object)spyClient)).checkLock(Mockito.eq((long)this.dummyLockId));
        ((IMetaStoreClient)Mockito.doNothing().when((Object)spyClient)).unlock(Mockito.eq((long)this.dummyLockId));
        ((IMetaStoreClient)Mockito.doNothing().when((Object)spyClient)).heartbeat(Mockito.eq((long)0L), Mockito.eq((long)this.dummyLockId));
        spyOps.doCommit(this.metadataV2, this.metadataV1);
        ((IMetaStoreClient)Mockito.verify((Object)spyClient, (VerificationMode)Mockito.times((int)1))).unlock(Mockito.eq((long)this.dummyLockId));
    }

    @Test
    public void testUnLockInterruptedUnLock() throws TException {
        ((IMetaStoreClient)Mockito.doReturn((Object)this.waitLockResponse).when((Object)spyClient)).lock((LockRequest)Mockito.any());
        ((IMetaStoreClient)Mockito.doReturn((Object)this.acquiredLockResponse).when((Object)spyClient)).checkLock(Mockito.eq((long)this.dummyLockId));
        ((IMetaStoreClient)Mockito.doAnswer(invocation -> {
            throw new InterruptedException("Interrupt test");
        }).doNothing().when((Object)spyClient)).unlock(Mockito.eq((long)this.dummyLockId));
        ((IMetaStoreClient)Mockito.doNothing().when((Object)spyClient)).heartbeat(Mockito.eq((long)0L), Mockito.eq((long)this.dummyLockId));
        spyOps.doCommit(this.metadataV2, this.metadataV1);
        ((IMetaStoreClient)Mockito.verify((Object)spyClient, (VerificationMode)Mockito.times((int)2))).unlock(Mockito.eq((long)this.dummyLockId));
    }

    @Test
    public void testUnLockAfterInterruptedLock() throws TException {
        ArgumentCaptor lockRequestCaptor = ArgumentCaptor.forClass(LockRequest.class);
        ((IMetaStoreClient)Mockito.doAnswer(invocation -> {
            throw new InterruptedException("Interrupt test");
        }).when((Object)spyClient)).lock((LockRequest)lockRequestCaptor.capture());
        ShowLocksResponse showLocksResponse = new ShowLocksResponse((List)Lists.newArrayList());
        ShowLocksResponseElementWrapper showLocksElement = new ShowLocksResponseElementWrapper(lockRequestCaptor);
        showLocksResponse.getLocks().add(showLocksElement);
        ((IMetaStoreClient)Mockito.doReturn((Object)showLocksResponse).when((Object)spyClient)).showLocks((ShowLocksRequest)Mockito.any());
        ((IMetaStoreClient)Mockito.doReturn((Object)this.acquiredLockResponse).when((Object)spyClient)).checkLock(Mockito.eq((long)this.dummyLockId));
        ((IMetaStoreClient)Mockito.doNothing().when((Object)spyClient)).unlock(Mockito.eq((long)this.dummyLockId));
        ((IMetaStoreClient)Mockito.doNothing().when((Object)spyClient)).heartbeat(Mockito.eq((long)0L), Mockito.eq((long)this.dummyLockId));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> spyOps.doCommit(this.metadataV2, this.metadataV1)).isInstanceOf(RuntimeException.class)).hasMessage("org.apache.iceberg.hive.LockException: Interrupted while creating lock on table hivedb.tbl");
        ((IMetaStoreClient)Mockito.verify((Object)spyClient, (VerificationMode)Mockito.times((int)1))).unlock(Mockito.eq((long)this.dummyLockId));
        ((IMetaStoreClient)Mockito.verify((Object)spyClient, (VerificationMode)Mockito.times((int)1))).lock((LockRequest)Mockito.any());
    }

    @Test
    public void testUnLockAfterInterruptedLockCheck() throws TException {
        ((IMetaStoreClient)Mockito.doReturn((Object)this.waitLockResponse).when((Object)spyClient)).lock((LockRequest)Mockito.any());
        ((IMetaStoreClient)Mockito.doAnswer(invocation -> {
            throw new InterruptedException("Interrupt test");
        }).when((Object)spyClient)).checkLock(Mockito.eq((long)this.dummyLockId));
        ((IMetaStoreClient)Mockito.doNothing().when((Object)spyClient)).unlock(Mockito.eq((long)this.dummyLockId));
        ((IMetaStoreClient)Mockito.doNothing().when((Object)spyClient)).heartbeat(Mockito.eq((long)0L), Mockito.eq((long)this.dummyLockId));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> spyOps.doCommit(this.metadataV2, this.metadataV1)).isInstanceOf(RuntimeException.class)).hasMessage("org.apache.iceberg.hive.LockException: Could not acquire the lock on hivedb.tbl, lock request ended in state WAITING");
        ((IMetaStoreClient)Mockito.verify((Object)spyClient, (VerificationMode)Mockito.times((int)1))).unlock(Mockito.eq((long)this.dummyLockId));
        ((IMetaStoreClient)Mockito.verify((Object)spyClient, (VerificationMode)Mockito.times((int)1))).checkLock(Mockito.eq((long)this.dummyLockId));
    }

    @Test
    public void testUnLockAfterInterruptedGetTable() throws TException {
        ((IMetaStoreClient)Mockito.doReturn((Object)this.acquiredLockResponse).when((Object)spyClient)).lock((LockRequest)Mockito.any());
        ((IMetaStoreClient)Mockito.doAnswer(invocation -> {
            throw new InterruptedException("Interrupt test");
        }).when((Object)spyClient)).getTable((String)Mockito.any(), (String)Mockito.any());
        ((IMetaStoreClient)Mockito.doNothing().when((Object)spyClient)).unlock(Mockito.eq((long)this.dummyLockId));
        ((IMetaStoreClient)Mockito.doNothing().when((Object)spyClient)).heartbeat(Mockito.eq((long)0L), Mockito.eq((long)this.dummyLockId));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> spyOps.doCommit(this.metadataV2, this.metadataV1)).isInstanceOf(RuntimeException.class)).hasMessage("Interrupted during commit");
        ((IMetaStoreClient)Mockito.verify((Object)spyClient, (VerificationMode)Mockito.times((int)1))).unlock(Mockito.eq((long)this.dummyLockId));
    }

    @Test
    public void testLockFailureAtFirstTime() throws TException {
        ((IMetaStoreClient)Mockito.doReturn((Object)this.notAcquiredLockResponse).when((Object)spyClient)).lock((LockRequest)Mockito.any());
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> spyOps.doCommit(this.metadataV2, this.metadataV1)).isInstanceOf(CommitFailedException.class)).hasMessage("org.apache.iceberg.hive.LockException: Could not acquire the lock on hivedb.tbl, lock request ended in state NOT_ACQUIRED");
    }

    @Test
    public void testLockFailureAfterRetries() throws TException {
        ((IMetaStoreClient)Mockito.doReturn((Object)this.waitLockResponse).when((Object)spyClient)).lock((LockRequest)Mockito.any());
        ((IMetaStoreClient)Mockito.doReturn((Object)this.waitLockResponse).doReturn((Object)this.waitLockResponse).doReturn((Object)this.waitLockResponse).doReturn((Object)this.waitLockResponse).doReturn((Object)this.notAcquiredLockResponse).when((Object)spyClient)).checkLock(Mockito.eq((long)this.dummyLockId));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> spyOps.doCommit(this.metadataV2, this.metadataV1)).isInstanceOf(CommitFailedException.class)).hasMessage("org.apache.iceberg.hive.LockException: Could not acquire the lock on hivedb.tbl, lock request ended in state NOT_ACQUIRED");
    }

    @Test
    public void testLockTimeoutAfterRetries() throws TException {
        ((IMetaStoreClient)Mockito.doReturn((Object)this.waitLockResponse).when((Object)spyClient)).lock((LockRequest)Mockito.any());
        ((IMetaStoreClient)Mockito.doReturn((Object)this.waitLockResponse).when((Object)spyClient)).checkLock(Mockito.eq((long)this.dummyLockId));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> spyOps.doCommit(this.metadataV2, this.metadataV1)).isInstanceOf(CommitFailedException.class)).hasMessageStartingWith("org.apache.iceberg.hive.LockException").hasMessageContaining("Timed out after").hasMessageEndingWith("waiting for lock on hivedb.tbl");
    }

    @Test
    public void testPassThroughThriftExceptions() throws TException {
        ((IMetaStoreClient)Mockito.doReturn((Object)this.waitLockResponse).when((Object)spyClient)).lock((LockRequest)Mockito.any());
        ((IMetaStoreClient)Mockito.doReturn((Object)this.waitLockResponse).doThrow(new Throwable[]{new TException("Test Thrift Exception")}).when((Object)spyClient)).checkLock(Mockito.eq((long)this.dummyLockId));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> spyOps.doCommit(this.metadataV2, this.metadataV1)).isInstanceOf(RuntimeException.class)).hasMessage("org.apache.iceberg.hive.LockException: Metastore operation failed for hivedb.tbl");
    }

    @Test
    public void testPassThroughThriftExceptionsForHiveVersion_1() throws TException, InterruptedException {
        try (MockedStatic ignore = Mockito.mockStatic(HiveVersion.class);){
            HiveVersion version = (HiveVersion)Mockito.mock(HiveVersion.class);
            Mockito.when((Object)HiveVersion.current()).thenReturn((Object)version);
            ((IMetaStoreClient)Mockito.doReturn((Object)this.emptyLocks).when((Object)spyClient)).showLocks((ShowLocksRequest)Mockito.any());
            ((IMetaStoreClient)Mockito.doThrow((Throwable[])new Throwable[]{new TException("Failed to connect to HMS")}).doReturn((Object)this.waitLockResponse).when((Object)spyClient)).lock((LockRequest)Mockito.any());
            ((IMetaStoreClient)Mockito.doReturn((Object)this.waitLockResponse).doReturn((Object)this.acquiredLockResponse).when((Object)spyClient)).checkLock(Mockito.eq((long)this.dummyLockId));
            ((IMetaStoreClient)Mockito.doNothing().when((Object)spyClient)).heartbeat(Mockito.eq((long)0L), Mockito.eq((long)this.dummyLockId));
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> spyOps.doCommit(this.metadataV2, this.metadataV1)).isInstanceOf(CommitFailedException.class)).hasMessage("org.apache.iceberg.hive.LockException: Failed to find lock for table hivedb.tbl");
        }
    }

    @Test
    public void testPassThroughInterruptions() throws TException {
        ((IMetaStoreClient)Mockito.doReturn((Object)this.waitLockResponse).when((Object)spyClient)).lock((LockRequest)Mockito.any());
        ((IMetaStoreClient)Mockito.doReturn((Object)this.waitLockResponse).doAnswer(invocation -> {
            Thread.currentThread().interrupt();
            Thread.sleep(10L);
            return this.waitLockResponse;
        }).when((Object)spyClient)).checkLock(Mockito.eq((long)this.dummyLockId));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> spyOps.doCommit(this.metadataV2, this.metadataV1)).isInstanceOf(CommitFailedException.class)).hasMessage("org.apache.iceberg.hive.LockException: Could not acquire the lock on hivedb.tbl, lock request ended in state WAITING");
    }

    @Test
    public void testTableLevelProcessLockBlocksConcurrentHMSRequestsForSameTable() throws Exception {
        int numConcurrentCommits = 10;
        Mockito.reset((Object[])new IMetaStoreClient[]{spyClient});
        ExecutorService executor = Executors.newFixedThreadPool(numConcurrentCommits);
        IntStream.range(0, numConcurrentCommits).forEach(i -> executor.submit(() -> {
            try {
                spyOps.doCommit(this.metadataV2, this.metadataV1);
            }
            catch (CommitFailedException commitFailedException) {
                // empty catch block
            }
        }));
        executor.shutdown();
        executor.awaitTermination(30L, TimeUnit.SECONDS);
        ((IMetaStoreClient)Mockito.verify((Object)spyClient, (VerificationMode)Mockito.never())).checkLock(((Long)Mockito.any(Long.class)).longValue());
        ((IMetaStoreClient)Mockito.verify((Object)spyClient, (VerificationMode)Mockito.times((int)numConcurrentCommits))).lock((LockRequest)Mockito.any(LockRequest.class));
    }

    @Test
    public void testLockHeartbeat() throws TException, InterruptedException {
        ((IMetaStoreClient)Mockito.doReturn((Object)this.acquiredLockResponse).when((Object)spyClient)).lock((LockRequest)Mockito.any());
        ((HiveTableOperations)Mockito.doAnswer((Answer)AdditionalAnswers.answersWithDelay((long)2000L, InvocationOnMock::callRealMethod)).when((Object)spyOps)).loadHmsTable();
        ((IMetaStoreClient)Mockito.doNothing().when((Object)spyClient)).heartbeat(Mockito.eq((long)0L), Mockito.eq((long)this.dummyLockId));
        spyOps.doCommit(this.metadataV2, this.metadataV1);
        ((IMetaStoreClient)Mockito.verify((Object)spyClient, (VerificationMode)Mockito.atLeastOnce())).heartbeat(Mockito.eq((long)0L), Mockito.eq((long)this.dummyLockId));
    }

    @Test
    public void testLockHeartbeatFailureDuringCommit() throws TException, InterruptedException {
        ((IMetaStoreClient)Mockito.doReturn((Object)this.acquiredLockResponse).when((Object)spyClient)).lock((LockRequest)Mockito.any());
        ((HiveTableOperations)Mockito.doAnswer((Answer)AdditionalAnswers.answersWithDelay((long)2000L, InvocationOnMock::callRealMethod)).when((Object)spyOps)).loadHmsTable();
        ((IMetaStoreClient)Mockito.doThrow((Throwable[])new Throwable[]{new TException("Failed to heart beat.")}).when((Object)spyClient)).heartbeat(Mockito.eq((long)0L), Mockito.eq((long)this.dummyLockId));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> spyOps.doCommit(this.metadataV2, this.metadataV1)).isInstanceOf(CommitFailedException.class)).hasMessage("org.apache.iceberg.hive.LockException: Failed to heartbeat for hive lock. Failed to heart beat.");
    }

    @Test
    public void testNoLockCallsWithNoLock() throws TException {
        Configuration confWithLock = new Configuration(overriddenHiveConf);
        confWithLock.setBoolean("iceberg.engine.hive.lock-enabled", false);
        HiveTableOperations noLockSpyOps = (HiveTableOperations)Mockito.spy((Object)new HiveTableOperations(confWithLock, (ClientPool)spyCachedClientPool, this.ops.io(), catalog.name(), TABLE_IDENTIFIER.namespace().level(0), TABLE_IDENTIFIER.name()));
        ArgumentCaptor contextCaptor = ArgumentCaptor.forClass(EnvironmentContext.class);
        ((IMetaStoreClient)Mockito.doNothing().when((Object)spyClient)).alter_table_with_environmentContext((String)Mockito.any(), (String)Mockito.any(), (org.apache.hadoop.hive.metastore.api.Table)Mockito.any(), (EnvironmentContext)contextCaptor.capture());
        noLockSpyOps.doCommit(this.metadataV2, this.metadataV1);
        ((IMetaStoreClient)Mockito.verify((Object)spyClient, (VerificationMode)Mockito.never())).lock((LockRequest)Mockito.any(LockRequest.class));
        ((IMetaStoreClient)Mockito.verify((Object)spyClient, (VerificationMode)Mockito.never())).checkLock(((Long)Mockito.any(Long.class)).longValue());
        ((IMetaStoreClient)Mockito.verify((Object)spyClient, (VerificationMode)Mockito.never())).heartbeat(((Long)Mockito.any(Long.class)).longValue(), ((Long)Mockito.any(Long.class)).longValue());
        ((IMetaStoreClient)Mockito.verify((Object)spyClient, (VerificationMode)Mockito.never())).unlock(((Long)Mockito.any(Long.class)).longValue());
        Map context = ((EnvironmentContext)contextCaptor.getValue()).getProperties();
        Assertions.assertThat((Map)context).hasSize(3);
        Assertions.assertThat((String)"metadata_location").isEqualTo((String)context.get("expected_parameter_key"));
        Assertions.assertThat((String)this.metadataV2.metadataFileLocation()).isEqualTo((String)context.get("expected_parameter_value"));
    }

    static {
        SPY_CLIENT_REF = new AtomicReference();
        spyClient = null;
        SCHEMA = new Schema(Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)1, (String)"id", (Type)Types.LongType.get())}).fields());
        PARTITION_SPEC = PartitionSpec.builderFor((Schema)SCHEMA).identity("id").build();
        TABLE_IDENTIFIER = TableIdentifier.of((String[])new String[]{DB_NAME, TABLE_NAME});
        HIVE_METASTORE_EXTENSION = HiveMetastoreExtension.builder().withDatabase(DB_NAME).withConfig((Map<String, String>)ImmutableMap.of((Object)HiveConf.ConfVars.HIVE_TXN_TIMEOUT.varname, (Object)"1s")).build();
    }

    private class ShowLocksResponseElementWrapper
    extends ShowLocksResponseElement {
        private final ArgumentCaptor<LockRequest> wrapped;

        private ShowLocksResponseElementWrapper(ArgumentCaptor<LockRequest> wrapped) {
            this.wrapped = wrapped;
        }

        public String getAgentInfo() {
            return ((LockRequest)this.wrapped.getValue()).getAgentInfo();
        }

        public LockState getState() {
            return LockState.WAITING;
        }

        public long getLockid() {
            return TestHiveCommitLocks.this.dummyLockId;
        }
    }
}

